/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer;

import chemaxon.alchemist.AlchemistProfile;
import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanelFactory;
import chemaxon.alchemist.configbuilder.ConfigElementFactory;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationReader;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationWriter;
import chemaxon.alchemist.utils.AboutDialogFactory;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.alchemist.utils.filefilters.XMLFileFilter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.DotfileUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class StandardizerConfigBuilderAlchemist
extends MarvinBasedAlchemistApplication
implements AlchemistLaunchable {
    private static final String APPLICATION_TITLE = "Standardizer Editor " + VersionInfo.JCHEM_VERSION;
    private static final String SAVE_FILE_CHOOSER_TITLE = "Save Standardizer Configuration File";
    private static final String OPEN_FILE_CHOOSER_TITLE = "Open Standardizer Configuration File";
    private static final FileFilter[] FILE_FILTERS = new FileFilter[]{new XMLFileFilter()};
    private static final String MENU_CONFIGURATION_PATH = "chemaxon/alchemist/configbuilder/standardizer/StandardizerConfigBuilderAlchemistMenuConfiguration.xml";
    private static final String DEFAULT_PROFILE_PATH = DotfileUtil.getDotFile("/alchemist/standardizer_configbuilder.profile").getAbsolutePath();
    private static final String DEFAULT_PROPERTIES_PATH = DotfileUtil.getDotFile("/alchemist/standardizer_configbuilder_properties.xml").getAbsolutePath();
    private static final String MAIN_TOOLBAR_ID = "mainToolBar";
    private ConfigBuilderPanel configBuilderPanel = null;
    private JToolBar toolBar = null;

    public StandardizerConfigBuilderAlchemist() {
        super(APPLICATION_TITLE, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/standardizer.png"));
        this.initialize();
    }

    private void initialize() {
        this.setDocumentPathInFrameTitle(true);
        this.setMenuResources(MENU_CONFIGURATION_PATH);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getConfigBuilderPanel(), "Center");
        this.getContentPane().add((Component)this.getToolBar(), "North");
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.getToolbar(MAIN_TOOLBAR_ID);
            this.toolBar.setFloatable(false);
        }
        return this.toolBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JComponent getConfigBuilderPanel() {
        if (this.configBuilderPanel == null) {
            try {
                AlchemistProfile profile = new AlchemistProfile();
                try {
                    FileInputStream inputStream = new FileInputStream(DEFAULT_PROFILE_PATH);
                    try {
                        profile.read(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.configBuilderPanel = ConfigBuilderPanelFactory.createStandardizerPanel(profile);
                this.configBuilderPanel.setProfile(profile);
                this.configBuilderPanel.setFileSupportEnabled(false);
            }
            catch (MarshalException e) {
                e.printStackTrace();
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (this.configBuilderPanel == null) {
                return new JPanel();
            }
        }
        return this.configBuilderPanel;
    }

    protected static void createAndShowGUI() {
        try {
            StandardizerConfigBuilderAlchemist.setLookAndFeel();
            StandardizerConfigBuilderAlchemist configBuilder = new StandardizerConfigBuilderAlchemist();
            configBuilder.show();
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError(e);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StandardizerConfigBuilderAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    protected Dimension getDefaultWindowSize() {
        return new Dimension(800, 600);
    }

    @Override
    protected String getOpenFileChooserTitle() {
        return OPEN_FILE_CHOOSER_TITLE;
    }

    @Override
    protected String getSaveFileChooserTitle() {
        return SAVE_FILE_CHOOSER_TITLE;
    }

    @Override
    protected FileFilter[] getOpenFileFilters() {
        return FILE_FILTERS;
    }

    @Override
    protected FileFilter[] getSaveFileFilters() {
        return FILE_FILTERS;
    }

    @Override
    protected String getPropertyFilePath() {
        return DEFAULT_PROPERTIES_PATH;
    }

    @Override
    protected void newDocumentActionHandler() {
        super.newDocumentActionHandler();
        this.configBuilderPanel.clear();
    }

    @Override
    protected void openDocumentActionHandler(final String path) {
        Thread loadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StandardizerConfigBuilderAlchemist.this.disableContent(true);
                try {
                    StandardizerConfigurationReader reader = new StandardizerConfigurationReader(new ConfigElementFactory("/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml"), new FileInputStream(path));
                    StandardizerConfigBuilderAlchemist.this.configBuilderPanel.readConfiguration(reader);
                    StandardizerConfigBuilderAlchemist.super.openDocumentActionHandler(path);
                }
                catch (FileNotFoundException e) {
                    StandardizerConfigBuilderAlchemist.this.showError("File not found: " + path, e);
                }
                catch (Exception e) {
                    StandardizerConfigBuilderAlchemist.this.showError("Problem occured while opening file: " + path, e);
                }
                StandardizerConfigBuilderAlchemist.this.enableContent();
            }
        });
        loadThread.setPriority(4);
        loadThread.start();
    }

    @Override
    protected void saveDocumentActionHandler() {
        super.saveDocumentActionHandler();
        if (this.getDocumentPath() != null) {
            Thread saveThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    StandardizerConfigBuilderAlchemist.this.disableContent(true);
                    try {
                        StandardizerConfigurationWriter writer = new StandardizerConfigurationWriter(new FileOutputStream(StandardizerConfigBuilderAlchemist.this.getDocumentPath()));
                        StandardizerConfigBuilderAlchemist.this.configBuilderPanel.writeConfiguration(writer);
                    }
                    catch (IOException e) {
                        StandardizerConfigBuilderAlchemist.this.showError("Can not write file: " + StandardizerConfigBuilderAlchemist.this.getDocumentPath(), e);
                    }
                    catch (Exception e) {
                        StandardizerConfigBuilderAlchemist.this.showError("Problem occured while saving file: " + StandardizerConfigBuilderAlchemist.this.getDocumentPath(), e);
                    }
                    StandardizerConfigBuilderAlchemist.this.enableContent();
                }
            });
            saveThread.setPriority(4);
            saveThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exitProgramActionHandler() {
        if (this.configBuilderPanel != null) {
            this.configBuilderPanel.updateProfile();
            try {
                FileOutputStream outputStream = new FileOutputStream(DEFAULT_PROFILE_PATH);
                try {
                    this.configBuilderPanel.getProfile().write(outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.exitProgramActionHandler();
    }

    @Override
    public void launch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StandardizerConfigBuilderAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    protected void licenseManagerClosed() {
        super.licenseManagerClosed();
        if (this.configBuilderPanel != null) {
            this.configBuilderPanel.refreshLicenses();
        }
    }

    @Override
    protected void aboutActionHandler() {
        AboutDialogFactory.createAboutDialog("Standardizer Editor", "/chemaxon/alchemist/images/about/standardizer-64.png", VersionInfo.JCHEM_VERSION).setVisible(true);
    }
}

