/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.configelements;

import chemaxon.alchemist.configbuilder.AbstractSketchConfigElement;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.dom4j.Element;

public class Clean2DElement
extends AbstractSketchConfigElement {
    private static final int DEFAULT_DISPLAY_OPTS = 478156100;
    public static final String PROPERTY_KEY_TYPE = "Type";
    public static final String PROPERTY_KEY_TEMPLATEMOLECULELISTCHANGED = "TemplateMoleculeListChanged";
    public static final String PROPERTY_VALUE_PARTIAL = "Partial";
    public static final String PROPERTY_VALUE_FULL = "Full";
    public static final String PROPERTY_VALUE_TEMPLATEBASED = "TemplateBased";
    public static final String PROPERTY_VALUE_REMOVE_Z_COORDINATE = "RemoveZCoordinate";
    private static final Collection<String> VALID_TYPE = Arrays.asList("Full".toLowerCase(), "Partial".toLowerCase(), "TemplateBased".toLowerCase(), "RemoveZCoordinate".toLowerCase());
    private String type = "Partial";
    private List<Molecule> templateMoleculeList = new ArrayList<Molecule>();
    private int selectedTemplate = -1;

    @Override
    public boolean isDefault() {
        return this.type.equalsIgnoreCase(PROPERTY_VALUE_PARTIAL);
    }

    @Override
    public void store(Element parent) {
        Element e = super.store(parent, "Clean");
        e.addAttribute("Dim", "2");
        e.addAttribute(PROPERTY_KEY_TYPE, this.type);
        if (this.type.equalsIgnoreCase(PROPERTY_VALUE_TEMPLATEBASED)) {
            StringBuffer buff = new StringBuffer();
            Molecule[] mols = this.templateMoleculeList.toArray(new Molecule[this.templateMoleculeList.size()]);
            for (int i = 0; i < mols.length; ++i) {
                buff.append(mols[i].toFormat("cxsmarts:c"));
                buff.append("\\n");
            }
            e.addAttribute("Templates", buff.toString());
        }
    }

    @Override
    protected void validate() {
        boolean valid = VALID_TYPE.contains(this.type.toLowerCase());
        if (this.type.equalsIgnoreCase(PROPERTY_VALUE_TEMPLATEBASED)) {
            valid = !this.templateMoleculeList.isEmpty();
        }
        this.setValid(valid);
    }

    @Override
    public Clean2DElement clone() throws CloneNotSupportedException {
        Clean2DElement element = (Clean2DElement)super.clone();
        element.templateMoleculeList = new ArrayList<Molecule>(this.templateMoleculeList.size());
        for (Molecule molecule : this.templateMoleculeList) {
            element.templateMoleculeList.add(molecule.cloneMolecule());
        }
        return element;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!VALID_TYPE.contains(type.toLowerCase())) {
            throw new IllegalArgumentException("Invalid value '" + type + "'\nAllowed values: " + VALID_TYPE.toString());
        }
        String oldType = this.type;
        this.type = type;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TYPE, oldType, type);
        this.validate();
    }

    public List<Molecule> getTemplateMoleculeList() {
        return this.templateMoleculeList;
    }

    public void addTemplateMolecule() {
        this.selectedTemplate = -1;
        this.setMolecule(new Molecule());
        this.setEditorMode("external");
    }

    public void addTemplateMolecule(Molecule molecule) {
        this.templateMoleculeList.add(molecule);
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TEMPLATEMOLECULELISTCHANGED, false, true);
        this.validate();
    }

    public void editTemplateMolecule(int index) {
        this.selectedTemplate = index;
        this.setMolecule(this.templateMoleculeList.get(index));
        this.setEditorMode("external");
    }

    public void setTemplateMolecule(int index, Molecule molecule) {
        this.templateMoleculeList.set(index, molecule);
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TEMPLATEMOLECULELISTCHANGED, false, true);
        this.validate();
    }

    public void removeTemplateMolecule(int index) {
        this.templateMoleculeList.remove(index);
        this.selectedTemplate = -1;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TEMPLATEMOLECULELISTCHANGED, false, true);
        this.validate();
    }

    public int getTemplateMoleculeCount() {
        return this.templateMoleculeList.size();
    }

    @Override
    protected void accepted(Molecule molecule) {
        super.accepted(molecule);
        if (this.selectedTemplate == -1) {
            this.templateMoleculeList.add(molecule.cloneMolecule());
        } else {
            this.templateMoleculeList.set(this.selectedTemplate, molecule.cloneMolecule());
        }
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TEMPLATEMOLECULELISTCHANGED, false, true);
        this.validate();
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TEMPLATEMOLECULELISTCHANGED, false, true);
    }

    @Override
    protected int getDefaultDispOpts() {
        return 478156100;
    }
}

