/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.configelements;

import chemaxon.alchemist.configbuilder.ConfigElement;
import org.dom4j.Element;

public class ClearStereoElement
extends ConfigElement {
    private static final String PROPERTY_KEY_TYPE = "Type";
    public static final String PROPERTY_KEY_TETRAHEDRAL = "Chirality";
    public static final String PROPERTY_KEY_DOUBLEBOND = "DoubleBond";
    public static final String PROPERTY_KEY_SINGLEUPORDOWNBOND = "SingleUpOrDownBond";
    private boolean tetrahedral = true;
    private boolean doubleBond = true;
    private boolean singleUpOrDownBond = false;

    @Override
    public boolean isDefault() {
        return this.tetrahedral && this.doubleBond;
    }

    @Override
    public void store(Element parent) {
        Element e = super.store(parent, "ClearStereo");
        if (!(this.tetrahedral && this.doubleBond && this.singleUpOrDownBond)) {
            StringBuffer buffer = new StringBuffer();
            if (this.tetrahedral) {
                buffer.append(PROPERTY_KEY_TETRAHEDRAL);
            }
            if (this.doubleBond) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(PROPERTY_KEY_DOUBLEBOND);
            }
            if (this.singleUpOrDownBond) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(PROPERTY_KEY_SINGLEUPORDOWNBOND);
            }
            e.addAttribute(PROPERTY_KEY_TYPE, buffer.toString());
        }
    }

    @Override
    protected void validate() {
        this.setValid(this.tetrahedral || this.doubleBond || this.singleUpOrDownBond);
    }

    public boolean isTetrahedral() {
        return this.tetrahedral;
    }

    public void setTetrahedral(boolean tetrahedral) {
        boolean oldTetrahedral = this.tetrahedral;
        this.tetrahedral = tetrahedral;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TETRAHEDRAL, oldTetrahedral, tetrahedral);
        this.validate();
    }

    public boolean isDoubleBond() {
        return this.doubleBond;
    }

    public void setDoubleBond(boolean doubleBond) {
        boolean oldDoubleBond = this.doubleBond;
        this.doubleBond = doubleBond;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_DOUBLEBOND, oldDoubleBond, doubleBond);
        this.validate();
    }

    public boolean isSingleUpOrDownBond() {
        return this.singleUpOrDownBond;
    }

    public void setSingleUpOrDownBond(boolean singleUpOrDownBond) {
        boolean oldSingleUpOrDownBond = this.singleUpOrDownBond;
        this.singleUpOrDownBond = singleUpOrDownBond;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_SINGLEUPORDOWNBOND, oldSingleUpOrDownBond, singleUpOrDownBond);
        this.validate();
    }

    @Override
    public ClearStereoElement clone() throws CloneNotSupportedException {
        return (ClearStereoElement)super.clone();
    }
}

