/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.configelements;

import chemaxon.alchemist.configbuilder.ConfigElement;
import java.util.Arrays;
import java.util.Collection;
import org.dom4j.Element;

public class ConvertDoubleBondsElement
extends ConfigElement {
    public static final String PROPERTY_KEY_TYPE = "Type";
    public static final String PROPERTY_VALUE_WIGGLY = "Wiggly";
    public static final String PROPERTY_VALUE_CROSSED = "Crossed";
    private static final Collection<String> VALID_TYPE = Arrays.asList("Wiggly".toLowerCase(), "Crossed".toLowerCase());
    private String type = "Wiggly";

    @Override
    public boolean isDefault() {
        return this.type.equals(PROPERTY_VALUE_WIGGLY);
    }

    @Override
    public void store(Element parent) {
        Element e = super.store(parent, "ConvertDoubleBonds");
        e.addAttribute(PROPERTY_KEY_TYPE, this.type);
    }

    @Override
    protected void validate() {
        this.setValid(true);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws IllegalArgumentException {
        if (!VALID_TYPE.contains(type.toLowerCase())) {
            throw new IllegalArgumentException("Invalid value '" + type + "'\nAllowed values: " + VALID_TYPE.toString());
        }
        String oldType = this.type;
        this.type = type;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TYPE, oldType, type);
        this.validate();
    }

    @Override
    public ConvertDoubleBondsElement clone() throws CloneNotSupportedException {
        return (ConvertDoubleBondsElement)super.clone();
    }
}

