/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.configelements;

import chemaxon.alchemist.configbuilder.ConfigElement;
import java.util.Arrays;
import java.util.Collection;
import org.dom4j.Element;

public class ConvertToEnhancedStereoElement
extends ConfigElement {
    public static final String PROPERTY_KEY_ABSOLUTE_STEREO = "AbsStereo";
    public static final String PROPERTY_KEY_DEFAULT_NON_ABSOLUTE_STEREO_GROUP = "DefaultNonAbsStereoGroup";
    public static final String PROPERTY_VALUE_AND = "and";
    public static final String PROPERTY_VALUE_OR = "or";
    private static final Collection<String> VALID_DEFAULT_NON_ABSOLUTE_STEREO_GROUP = Arrays.asList("and", "or");
    private boolean absStereo = false;
    private String defaultNonAbsStereoGroup = "and";

    @Override
    public ConvertToEnhancedStereoElement clone() throws CloneNotSupportedException {
        return (ConvertToEnhancedStereoElement)super.clone();
    }

    @Override
    public void store(Element parent) {
        Element e = super.store(parent, "ConvertToEnhancedStereo ");
        e.addAttribute(PROPERTY_KEY_ABSOLUTE_STEREO, this.absStereo ? "true" : "false");
        e.addAttribute(PROPERTY_KEY_DEFAULT_NON_ABSOLUTE_STEREO_GROUP, this.defaultNonAbsStereoGroup);
    }

    @Override
    public boolean isDefault() {
        return !this.absStereo && PROPERTY_VALUE_AND.equalsIgnoreCase(this.defaultNonAbsStereoGroup);
    }

    @Override
    protected void validate() {
        this.setValid(VALID_DEFAULT_NON_ABSOLUTE_STEREO_GROUP.contains(this.defaultNonAbsStereoGroup));
    }

    public boolean isAbstoluteStereo() {
        return this.absStereo;
    }

    public void setAbsoluteStereo(boolean absoluteStereo) {
        boolean oldAbsStereo = this.absStereo;
        this.absStereo = absoluteStereo;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_ABSOLUTE_STEREO, oldAbsStereo, this.absStereo);
    }

    public String getDefaultNonAbsoluteStereoGroup() {
        return this.defaultNonAbsStereoGroup;
    }

    public void setDefaultNonAbsoluteStereoGroup(String defaultNonAbsStereoGroup) throws IllegalArgumentException {
        if (!VALID_DEFAULT_NON_ABSOLUTE_STEREO_GROUP.contains(defaultNonAbsStereoGroup.toLowerCase())) {
            throw new IllegalArgumentException("Allowed values: " + VALID_DEFAULT_NON_ABSOLUTE_STEREO_GROUP.toString());
        }
        String oldDefaultNonAbsStereoGroup = this.defaultNonAbsStereoGroup;
        this.defaultNonAbsStereoGroup = defaultNonAbsStereoGroup.toLowerCase();
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_DEFAULT_NON_ABSOLUTE_STEREO_GROUP, oldDefaultNonAbsStereoGroup.toLowerCase(), (Object)this.absStereo);
        this.validate();
    }
}

