/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.configelements;

import chemaxon.alchemist.configbuilder.AbstractSketchConfigElement;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import org.dom4j.Element;

public class TransformElement
extends AbstractSketchConfigElement {
    private static final int DEFAULT_DISPLAY_OPTS = 478156100;
    public static final String PROPERTY_KEY_STRUCTURE = "Structure";
    public static final String PROPERTY_KEY_SEARCHOPTIONS = "SearchOptions";
    public static final String ENCODE_FORMAT = "cxsmarts:+c";
    private String structure = "";
    private MolSearchOptions searchOptions = new MolSearchOptions(2);
    private boolean locked = false;

    @Override
    public boolean isDefault() {
        return "".equals(this.structure) && this.searchOptions.toString().equals(new MolSearchOptions(2).toString());
    }

    @Override
    public void store(Element parent) {
        Element e = super.store(parent, "Transformation");
        e.addAttribute("ID", this.getName());
        e.addAttribute(PROPERTY_KEY_STRUCTURE, this.structure);
        String searchOptionsString = this.searchOptions.toString();
        if (searchOptionsString != null && !"".equalsIgnoreCase(searchOptionsString)) {
            e.addAttribute(PROPERTY_KEY_SEARCHOPTIONS, searchOptionsString.trim());
        }
    }

    @Override
    protected void validate() {
        RxnMolecule reaction = null;
        try {
            Molecule mol = MolImporter.importMol(this.structure);
            if (mol.isReaction()) {
                reaction = RxnMolecule.getReaction(mol);
            }
        }
        catch (MolFormatException molFormatException) {
            // empty catch block
        }
        this.setValid(reaction != null);
    }

    public String getStructure() {
        return this.structure;
    }

    public void setStructure(String structure) {
        String oldStructure = this.structure;
        this.structure = structure;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_STRUCTURE, oldStructure, structure);
        this.validate();
    }

    public MolSearchOptions getSearchOptions() {
        return this.searchOptions;
    }

    public void setSearchOptions(MolSearchOptions searchOptions) {
        MolSearchOptions oldOptions = this.searchOptions;
        this.searchOptions = searchOptions;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_SEARCHOPTIONS, oldOptions, searchOptions);
        this.validate();
    }

    @Override
    public TransformElement clone() throws CloneNotSupportedException {
        TransformElement element = (TransformElement)super.clone();
        element.searchOptions = new MolSearchOptions(2);
        element.searchOptions.setOptions(this.searchOptions.toString());
        return element;
    }

    @Override
    protected void accepted(Molecule molecule) {
        String encodedMolecule = molecule.toFormat(ENCODE_FORMAT);
        this.setStructure(encodedMolecule);
        super.accepted(molecule);
    }

    @Override
    protected int getDefaultDispOpts() {
        return 478156100;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }
}

