/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.editors;

import chemaxon.alchemist.configbuilder.AbstractConfigElementEditor;
import chemaxon.alchemist.configbuilder.standardizer.configelements.Clean2DElement;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistLinearMoleculeView;
import chemaxon.formats.MolImporter;
import chemaxon.struc.MDocument;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Clean2DElementEditor
extends AbstractConfigElementEditor {
    private AlchemistLinearMoleculeView moleculeView = null;
    AlchemistFileChooserForJChem fileChooser = null;
    private JRadioButton partialRadio = null;
    private JRadioButton fullRadio = null;
    private JRadioButton removeZCoordinateRadio = null;
    private JRadioButton templateRadio = null;
    private JButton addTemplateButton = null;
    private JButton editTemplateButton = null;
    private JButton removeTemplateButton = null;
    private JButton importTemplateButton = null;
    private final Action ADD_TEMPLATE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 3334683589101360417L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Clean2DElementEditor.this.getElement().addPropertyChangeListener("TemplateMoleculeListChanged", Clean2DElementEditor.this.getTemplateListener());
            ((Clean2DElement)Clean2DElementEditor.this.getElement()).addTemplateMolecule();
        }
    };
    private Action editTemplateAction = new AbstractAction(){
        private static final long serialVersionUID = 6160498074771294902L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Clean2DElementEditor.this.getElement().addPropertyChangeListener("TemplateMoleculeListChanged", Clean2DElementEditor.this.getTemplateListener());
            ((Clean2DElement)Clean2DElementEditor.this.getElement()).editTemplateMolecule(Clean2DElementEditor.this.getMoleculeView().getSelectedIndexes()[0]);
        }
    };
    private Action removeTemplateAction = new AbstractAction(){
        private static final long serialVersionUID = -7691730729275539743L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Clean2DElementEditor.this.getElement().addPropertyChangeListener("TemplateMoleculeListChanged", Clean2DElementEditor.this.getTemplateListener());
            ((Clean2DElement)Clean2DElementEditor.this.getElement()).removeTemplateMolecule(Clean2DElementEditor.this.getMoleculeView().getSelectedIndexes()[0]);
            Clean2DElementEditor.this.getMoleculeView().setSelectedIndex(-1);
        }
    };
    private final Action IMPORT_TEMPLATE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 1183287970518202572L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (Clean2DElementEditor.this.fileChooser != null && Clean2DElementEditor.this.fileChooser.showOpenDialog(null) == 0) {
                MolImporter importer = null;
                try {
                    importer = new MolImporter(Clean2DElementEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                    MDocument doc = importer.nextDoc();
                    while (doc != null) {
                        Clean2DElementEditor.this.getElement().addPropertyChangeListener("TemplateMoleculeListChanged", Clean2DElementEditor.this.getTemplateListener());
                        ((Clean2DElement)Clean2DElementEditor.this.getElement()).addTemplateMolecule(doc.getPrimaryMolecule());
                        doc = importer.nextDoc();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                finally {
                    try {
                        if (importer != null) {
                            importer.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    };
    private final Action SELECT_OPTION = new AbstractAction(){
        private static final long serialVersionUID = 3334683589101360417L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Clean2DElementEditor.this.getPartialRadio().isSelected()) {
                ((Clean2DElement)Clean2DElementEditor.this.getElement()).setType("Partial");
            } else if (Clean2DElementEditor.this.getFullRadio().isSelected()) {
                ((Clean2DElement)Clean2DElementEditor.this.getElement()).setType("Full");
            } else if (Clean2DElementEditor.this.getRemoveZCoordinateRadio().isSelected()) {
                ((Clean2DElement)Clean2DElementEditor.this.getElement()).setType("RemoveZCoordinate");
            } else {
                ((Clean2DElement)Clean2DElementEditor.this.getElement()).setType("TemplateBased");
            }
            Clean2DElementEditor.this.updateActions();
            Clean2DElementEditor.this.getMoleculeView().setEnabled(Clean2DElementEditor.this.getTemplateRadio().isSelected());
        }
    };
    private PropertyChangeListener templateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == Clean2DElementEditor.this.getElement()) {
                Clean2DElementEditor.this.getElement().removePropertyChangeListener("TemplateMoleculeListChanged", Clean2DElementEditor.this.getTemplateListener());
                Clean2DElementEditor.this.getMoleculeView().redoLayout();
                Clean2DElementEditor.this.updateActions();
                Clean2DElementEditor.this.getMainPanel().requestFocus();
            }
        }
    };

    @Override
    protected void initialize() {
        super.initialize();
        try {
            this.fileChooser = new AlchemistFileChooserForJChem();
            this.fileChooser.addDefaultOpenFileFilters();
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (((Clean2DElement)this.getElement()).getType().equalsIgnoreCase("Partial")) {
            this.getPartialRadio().setSelected(true);
        } else if (((Clean2DElement)this.getElement()).getType().equalsIgnoreCase("Full")) {
            this.getFullRadio().setSelected(true);
        } else if (((Clean2DElement)this.getElement()).getType().equalsIgnoreCase("RemoveZCoordinate")) {
            this.getRemoveZCoordinateRadio().setSelected(true);
        } else {
            this.getTemplateRadio().setSelected(true);
        }
        this.getMoleculeView().setMoleculeList(((Clean2DElement)this.getElement()).getTemplateMoleculeList());
        this.updateActions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Clean2DElementEditor.this.getMoleculeView().setEnabled(Clean2DElementEditor.this.getTemplateRadio().isSelected());
            }
        });
    }

    @Override
    protected void addComponents() {
        this.ADD_TEMPLATE_ACTION.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/addmolecule.gif"));
        this.getEditTemplateAction().putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/editmolecule.gif"));
        this.getRemoveTemplateAction().putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/removemolecule.gif"));
        this.IMPORT_TEMPLATE_ACTION.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/importreaction.gif"));
        CellConstraints cc = new CellConstraints();
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this.getPartialRadio());
        radioButtonGroup.add(this.getFullRadio());
        radioButtonGroup.add(this.getRemoveZCoordinateRadio());
        radioButtonGroup.add(this.getTemplateRadio());
        this.mainPanel.add((Component)this.getTitle("Specify 2D Clean options"), cc.xyw(2, 2, 5));
        this.mainPanel.add((Component)this.getPartialRadio(), cc.xyw(2, 4, 5));
        this.mainPanel.add((Component)this.getFullRadio(), cc.xyw(2, 6, 5));
        this.mainPanel.add((Component)this.getRemoveZCoordinateRadio(), cc.xyw(2, 8, 5));
        this.mainPanel.add((Component)this.getTemplateRadio(), cc.xy(2, 10));
        this.mainPanel.add((Component)this.getMoleculeView(), cc.xywh(4, 11, 1, 8));
        this.mainPanel.add((Component)this.getAddTemplateButton(), cc.xy(6, 12));
        this.mainPanel.add((Component)this.getEditTemplateButton(), cc.xy(6, 14));
        this.mainPanel.add((Component)this.getRemoveTemplateButton(), cc.xy(6, 16));
        this.mainPanel.add((Component)this.getImportTemplateButton(), cc.xy(6, 18));
        this.getMoleculeView().addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Clean2DElementEditor.this.getMoleculeView().redoLayout();
                    }
                });
            }
        });
    }

    @Override
    protected LayoutManager getMainLayout() {
        return new FormLayout("4dlu, pref, 2dlu, pref:grow, 2dlu, pref, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 2dlu, min, 2dlu, min, 2dlu, top:default, 2dlu, top:default, 2dlu, top:default, 2dlu, top:default:grow, 4dlu");
    }

    protected AlchemistLinearMoleculeView getMoleculeView() {
        if (this.moleculeView == null) {
            this.moleculeView = new AlchemistLinearMoleculeView(0);
            this.moleculeView.setShowArrows(false);
            this.moleculeView.setSelectable(true);
            this.moleculeView.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
            this.moleculeView.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        Clean2DElementEditor.this.getEditTemplateAction().setEnabled(Clean2DElementEditor.this.getMoleculeView().getSelectedIndexes().length > 0);
                        Clean2DElementEditor.this.getRemoveTemplateAction().setEnabled(Clean2DElementEditor.this.getMoleculeView().getSelectedIndexes().length > 0);
                    }
                }
            });
        }
        return this.moleculeView;
    }

    protected JRadioButton getPartialRadio() {
        if (this.partialRadio == null) {
            this.partialRadio = new JRadioButton(this.SELECT_OPTION);
            this.partialRadio.setText("Partial, preserve original atom coordinates wherever possible.");
        }
        return this.partialRadio;
    }

    protected JRadioButton getFullRadio() {
        if (this.fullRadio == null) {
            this.fullRadio = new JRadioButton(this.SELECT_OPTION);
            this.fullRadio.setText("Full, calculate all atom coordinates");
        }
        return this.fullRadio;
    }

    protected JRadioButton getRemoveZCoordinateRadio() {
        if (this.removeZCoordinateRadio == null) {
            this.removeZCoordinateRadio = new JRadioButton(this.SELECT_OPTION);
            this.removeZCoordinateRadio.setText("Remove Z-Coordinate, sets the z-coordinate to zero.");
        }
        return this.removeZCoordinateRadio;
    }

    protected JRadioButton getTemplateRadio() {
        if (this.templateRadio == null) {
            this.templateRadio = new JRadioButton(this.SELECT_OPTION);
            this.templateRadio.setText("Template based");
        }
        return this.templateRadio;
    }

    private JButton getAddTemplateButton() {
        if (this.addTemplateButton == null) {
            this.addTemplateButton = new JButton(this.ADD_TEMPLATE_ACTION);
            this.addTemplateButton.setPreferredSize(new Dimension(23, 23));
        }
        return this.addTemplateButton;
    }

    private JButton getEditTemplateButton() {
        if (this.editTemplateButton == null) {
            this.editTemplateButton = new JButton(this.getEditTemplateAction());
            this.editTemplateButton.setPreferredSize(new Dimension(23, 23));
        }
        return this.editTemplateButton;
    }

    private JButton getRemoveTemplateButton() {
        if (this.removeTemplateButton == null) {
            this.removeTemplateButton = new JButton(this.getRemoveTemplateAction());
            this.removeTemplateButton.setPreferredSize(new Dimension(23, 23));
        }
        return this.removeTemplateButton;
    }

    private JButton getImportTemplateButton() {
        if (this.importTemplateButton == null) {
            this.importTemplateButton = new JButton(this.IMPORT_TEMPLATE_ACTION);
            this.importTemplateButton.setPreferredSize(new Dimension(23, 23));
        }
        return this.importTemplateButton;
    }

    protected void updateActions() {
        this.ADD_TEMPLATE_ACTION.setEnabled(this.getTemplateRadio().isSelected());
        this.getEditTemplateAction().setEnabled(this.getTemplateRadio().isSelected() && this.moleculeView.getSelectedIndexes().length > 0);
        this.getRemoveTemplateAction().setEnabled(this.getTemplateRadio().isSelected() && this.moleculeView.getSelectedIndexes().length > 0);
        this.IMPORT_TEMPLATE_ACTION.setEnabled(this.getTemplateRadio().isSelected());
    }

    protected void setTemplateListener(PropertyChangeListener templateListener) {
        this.templateListener = templateListener;
    }

    protected PropertyChangeListener getTemplateListener() {
        return this.templateListener;
    }

    protected void setEditTemplateAction(Action eDIT_TEMPLATE_ACTION) {
        this.editTemplateAction = eDIT_TEMPLATE_ACTION;
    }

    protected Action getEditTemplateAction() {
        return this.editTemplateAction;
    }

    protected void setRemoveTemplateAction(Action rEMOVE_TEMPLATE_ACTION) {
        this.removeTemplateAction = rEMOVE_TEMPLATE_ACTION;
    }

    protected Action getRemoveTemplateAction() {
        return this.removeTemplateAction;
    }
}

