/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.editors;

import chemaxon.alchemist.AlchemistProfile;
import chemaxon.alchemist.configbuilder.AbstractConfigElementEditor;
import chemaxon.alchemist.configbuilder.AlchemistProfileSupport;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ExternalEditorSupport;
import chemaxon.alchemist.configbuilder.standardizer.configelements.TransformElement;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.alchemist.utils.SimpleAlchemistMoleculeView;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.struc.Molecule;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class TransformElementEditor
extends AbstractConfigElementEditor
implements AlchemistProfileSupport {
    private static final String PROPERTY_KEY_SERIAL = "serial";
    private static final String PROFILE_KEY_TEMPLATELIST = "alchemist.configbuilder.standardizer.editor.transform.templates";
    private JComboBox transformNameCombo = null;
    private JLabel transformNameLabel = null;
    private JLabel title = null;
    private boolean updatingOptions = false;
    private JButton removeTemplateButton = null;
    private JButton saveTemplateButton = null;
    private SimpleAlchemistMoleculeView moleculeView = null;
    private JLabel moleculeViewLabel = null;
    private boolean transformTemplatesLoading = false;
    private JTabbedPane tabbedPane = null;
    private JPanel structurePanel = null;
    private JPanel optionsPanel = null;
    private JCheckBox exactMatchQueryAtomCheck = null;
    private JCheckBox exactMatchQueryBondCheck = null;
    private JCheckBox exactMatchFragmentCheck = null;
    private JCheckBox exactMatchUndefinedRAtomsCheck = null;
    private final Action SAVE_TEMPLATE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 3581577743658787153L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)TransformElementEditor.this.getTransformNameCombo().getModel();
            String name = TransformElementEditor.this.getTransformNameCombo().getSelectedItem().toString();
            Info info = new Info(name, TransformElementEditor.this.getMoleculeView().getMolecule(0, 0).toFormat("cxsmarts:+c"), ((TransformElement)TransformElementEditor.this.getElement()).getSearchOptions().toString());
            if (model.getSize() > 0) {
                if (!TransformElementEditor.this.isNameExists(name)) {
                    int insertPos = 0;
                    while (insertPos + 1 < model.getSize() && name.compareTo(model.getElementAt(insertPos).toString()) < 0) {
                        ++insertPos;
                    }
                    model.insertElementAt(info, insertPos + 1);
                } else if (0 == JOptionPane.showConfirmDialog(TransformElementEditor.this.getMainPanel().getRootPane(), "Do you want to overwrite this transform template?", "Overwrite confirmation", 0)) {
                    for (int i = 0; i < model.getSize(); ++i) {
                        if (!((Info)model.getElementAt(i)).getName().equalsIgnoreCase(name)) continue;
                        model.removeElementAt(i);
                        model.insertElementAt(info, i);
                        model.setSelectedItem(info);
                    }
                }
            } else {
                model.addElement(info);
            }
        }
    };
    private final Action REMOVE_TEMPLATE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -2863495397405418796L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)TransformElementEditor.this.getTransformNameCombo().getModel();
            if (TransformElementEditor.this.getTransformNameCombo().getSelectedIndex() != -1) {
                String name = TransformElementEditor.this.getTransformNameCombo().getSelectedItem().toString();
                Info info = new Info(name, TransformElementEditor.this.getMoleculeView().getMolecule(0, 0).toFormat("cxsmarts:+c"), ((TransformElement)TransformElementEditor.this.getElement()).getSearchOptions().toString());
                for (int i = 0; i < model.getSize(); ++i) {
                    if (!model.getElementAt(i).equals(info)) continue;
                    model.removeElementAt(i);
                }
            }
        }
    };
    private PropertyChangeListener editorListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == TransformElementEditor.this.getElement() && evt.getNewValue().equals("default")) {
                TransformElementEditor.this.getElement().removePropertyChangeListener("Editormode", TransformElementEditor.this.getEditorListener());
                Molecule mol = new Molecule();
                String cxs = ((TransformElement)TransformElementEditor.this.getElement()).getStructure();
                if (!"".equals(cxs)) {
                    try {
                        MolImporter importer = new MolImporter(new ByteArrayInputStream(cxs.getBytes()));
                        try {
                            importer.setQueryMode(true);
                            mol = importer.nextDoc().getPrimaryMolecule();
                        }
                        finally {
                            importer.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                TransformElementEditor.this.getMoleculeView().setMolecule(0, 0, mol);
                TransformElementEditor.this.getMainPanel().requestFocus();
            }
        }
    };

    @Override
    protected void addComponents() {
        this.SAVE_TEMPLATE_ACTION.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/savedocument.gif"));
        this.REMOVE_TEMPLATE_ACTION.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/clear.gif"));
        CellConstraints cc = new CellConstraints();
        this.mainPanel.add((Component)this.getTitle(this.getElement().getTooltip()), cc.xyw(2, 2, 9));
        this.mainPanel.add((Component)this.getTransformNameLabel(), cc.xy(2, 4));
        this.mainPanel.add((Component)this.getTransformNameCombo(), cc.xy(4, 4));
        this.mainPanel.add((Component)this.getSaveTemplateButton(), cc.xy(6, 4));
        this.mainPanel.add((Component)this.getRemoveTemplateButton(), cc.xy(8, 4));
        this.mainPanel.add((Component)this.getTabbedPane(), cc.xyw(2, 6, 9));
    }

    @Override
    protected LayoutManager getMainLayout() {
        return new FormLayout("4dlu, default, 2dlu, fill:default:grow, 2dlu, default, 2dlu, default, 2dlu, default, 4dlu", "4dlu, min, 2dlu, default, 2dlu, fill:default:grow, 4dlu");
    }

    @Override
    protected JLabel getTitle(String text) {
        if (this.title == null) {
            this.title = super.getTitle(text);
        } else {
            this.title.setText("<html><b>" + text + "</b></html>");
        }
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        super.initialize();
        Molecule mol = new Molecule();
        String cxs = ((TransformElement)this.getElement()).getStructure();
        if (!"".equals(cxs)) {
            MolImporter importer = null;
            try {
                importer = new MolImporter(new ByteArrayInputStream(cxs.getBytes()));
                importer.setQueryMode(true);
                mol = importer.nextDoc().getPrimaryMolecule();
                importer.close();
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (importer != null) {
                        importer.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        this.setTransformTemplatesLoading(true);
        this.getMoleculeView().setMolecule(0, 0, mol);
        this.getTransformNameCombo().setSelectedItem(((TransformElement)this.getElement()).getName());
        this.updateOptions();
        this.setTransformTemplatesLoading(false);
        this.getTitle(this.getElement().getTooltip());
        this.getMoleculeViewLabel().setVisible(!((TransformElement)this.getElement()).isLocked());
        this.getTransformNameCombo().setEnabled(!((TransformElement)this.getElement()).isLocked());
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add("Scheme", this.getStructurePanel());
            this.tabbedPane.add("Options", this.getOptionsPanel());
        }
        return this.tabbedPane;
    }

    private JPanel getStructurePanel() {
        if (this.structurePanel == null) {
            this.structurePanel = new JPanel();
            this.structurePanel.setLayout((LayoutManager)new FormLayout("4dlu, fill:pref:grow, 4dlu", "4dlu, fill:pref:grow, 2dlu, min, 4dlu"));
            CellConstraints cc = new CellConstraints();
            this.structurePanel.add((Component)this.getMoleculeView(), cc.xy(2, 2));
            this.structurePanel.add((Component)this.getMoleculeViewLabel(), cc.xy(2, 4, "center, center"));
        }
        return this.structurePanel;
    }

    private JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout((LayoutManager)new FormLayout("4dlu, fill:pref:grow, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 2dlu, min, 4dlu"));
            CellConstraints cc = new CellConstraints();
            this.optionsPanel.add((Component)this.getExactMatchQueryAtomCheck(), cc.xy(2, 2));
            this.optionsPanel.add((Component)this.getExactMatchQueryBondCheck(), cc.xy(2, 4));
            this.optionsPanel.add((Component)this.getExactMatchUndefinedRAtomsCheck(), cc.xy(2, 6));
            this.optionsPanel.add((Component)this.getExactMatchFragmentCheck(), cc.xy(2, 8));
        }
        return this.optionsPanel;
    }

    private JCheckBox getExactMatchQueryAtomCheck() {
        if (this.exactMatchQueryAtomCheck == null) {
            this.exactMatchQueryAtomCheck = new JCheckBox(new AbstractAction("Exact Match Query Atom"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformElementEditor.this.saveSearchOptions();
                }
            });
        }
        return this.exactMatchQueryAtomCheck;
    }

    private JCheckBox getExactMatchQueryBondCheck() {
        if (this.exactMatchQueryBondCheck == null) {
            this.exactMatchQueryBondCheck = new JCheckBox(new AbstractAction("Exact Match Query Bond"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformElementEditor.this.saveSearchOptions();
                }
            });
        }
        return this.exactMatchQueryBondCheck;
    }

    private JCheckBox getExactMatchFragmentCheck() {
        if (this.exactMatchFragmentCheck == null) {
            this.exactMatchFragmentCheck = new JCheckBox(new AbstractAction("Exact Match Fragment"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformElementEditor.this.saveSearchOptions();
                }
            });
        }
        return this.exactMatchFragmentCheck;
    }

    private JCheckBox getExactMatchUndefinedRAtomsCheck() {
        if (this.exactMatchUndefinedRAtomsCheck == null) {
            this.exactMatchUndefinedRAtomsCheck = new JCheckBox(new AbstractAction("Exact Match Undefined R-atoms"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformElementEditor.this.saveSearchOptions();
                }
            });
        }
        return this.exactMatchUndefinedRAtomsCheck;
    }

    protected void saveSearchOptions() {
        if (this.updatingOptions) {
            return;
        }
        MolSearchOptions options = ((TransformElement)this.getElement()).getSearchOptions();
        options.setSearchType(this.getExactMatchFragmentCheck().isSelected() ? 7 : 2);
        options.setExactBondMatching(this.getExactMatchQueryBondCheck().isSelected());
        options.setExactQueryAtomMatching(this.getExactMatchQueryAtomCheck().isSelected());
        options.setUndefinedRAtom(this.getExactMatchUndefinedRAtomsCheck().isSelected() ? 1 : 0);
        ((TransformElement)this.getElement()).setSearchOptions(options);
        this.updateOptions();
    }

    protected void updateOptions() {
        this.updatingOptions = true;
        MolSearchOptions options = ((TransformElement)this.getElement()).getSearchOptions();
        this.getExactMatchQueryBondCheck().setSelected(options.isExactBondMatching());
        this.getExactMatchQueryAtomCheck().setSelected(options.isExactQueryAtomMatching());
        this.getExactMatchFragmentCheck().setSelected(options.getSearchType() == 7);
        this.getExactMatchUndefinedRAtomsCheck().setSelected(options.getUndefinedRAtom() == 1);
        this.updatingOptions = false;
    }

    protected JComboBox getTransformNameCombo() {
        if (this.transformNameCombo == null) {
            this.transformNameCombo = new JComboBox();
            this.transformNameCombo.setEditable(true);
            this.transformNameCombo.setModel(new DefaultComboBoxModel());
            this.transformNameCombo.setSelectedItem("Transform");
            this.transformNameCombo.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
            this.transformNameCombo.setAlignmentY(0.5f);
            JTextField field = (JTextField)this.transformNameCombo.getEditor().getEditorComponent();
            field.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    String newValue = "";
                    try {
                        newValue = e.getDocument().getText(0, e.getDocument().getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    if (!TransformElementEditor.this.isTransformTemplatesLoading()) {
                        ((TransformElement)TransformElementEditor.this.getElement()).setName(newValue);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
            this.transformNameCombo.addItemListener(new ItemListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (TransformElementEditor.this.getTransformNameCombo().getSelectedIndex() != -1) {
                        Info info = (Info)TransformElementEditor.this.getTransformNameCombo().getSelectedItem();
                        MolSearchOptions options = new MolSearchOptions(2);
                        options.setOptions(info.getSearchOptions());
                        ((TransformElement)TransformElementEditor.this.getElement()).setSearchOptions(options);
                        TransformElementEditor.this.updateOptions();
                        Molecule mol = new Molecule();
                        MolImporter importer = null;
                        try {
                            importer = new MolImporter(new ByteArrayInputStream(info.getMolecule().getBytes()));
                            importer.setQueryMode(true);
                            mol = importer.nextDoc().getPrimaryMolecule();
                        }
                        catch (Exception e1) {
                        }
                        finally {
                            try {
                                if (importer != null) {
                                    importer.close();
                                }
                            }
                            catch (IOException e2) {}
                        }
                        TransformElementEditor.this.getMoleculeView().setMolecule(0, 0, mol);
                    }
                    if (!TransformElementEditor.this.isTransformTemplatesLoading()) {
                        Object item = TransformElementEditor.this.getTransformNameCombo().getSelectedItem();
                        ((TransformElement)TransformElementEditor.this.getElement()).setName(item == null ? "" : item.toString());
                        ((TransformElement)TransformElementEditor.this.getElement()).setStructure(TransformElementEditor.this.getMoleculeView().getMolecule(0, 0).toFormat("cxsmarts:+c"));
                        ((TransformElement)TransformElementEditor.this.getElement()).setMolecule(TransformElementEditor.this.getMoleculeView().getMolecule(0, 0));
                    }
                }
            });
            this.transformNameCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(final KeyEvent e) {
                    super.keyTyped(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String current = TransformElementEditor.this.getTransformNameCombo().getEditor().getItem().toString();
                            DefaultComboBoxModel model = (DefaultComboBoxModel)TransformElementEditor.this.getTransformNameCombo().getModel();
                            for (int i = 0; i < model.getSize(); ++i) {
                                if (current.length() > model.getElementAt(i).toString().length()) continue;
                                int len = current.length();
                                if (!current.equalsIgnoreCase(model.getElementAt(i).toString().substring(0, len))) continue;
                                if (e.getKeyChar() == '\n') {
                                    TransformElementEditor.this.getTransformNameCombo().setSelectedIndex(i);
                                } else if (e.getKeyChar() != '\u007f' && e.getKeyChar() != '\b') {
                                    ((JTextField)TransformElementEditor.this.getTransformNameCombo().getEditor().getEditorComponent()).setText(model.getElementAt(i).toString());
                                    ((JTextField)TransformElementEditor.this.getTransformNameCombo().getEditor().getEditorComponent()).setSelectionStart(current.length());
                                    ((JTextField)TransformElementEditor.this.getTransformNameCombo().getEditor().getEditorComponent()).setSelectionEnd(model.getElementAt(i).toString().length());
                                }
                                return;
                            }
                        }
                    });
                }
            });
        }
        return this.transformNameCombo;
    }

    protected SimpleAlchemistMoleculeView getMoleculeView() {
        if (this.moleculeView == null) {
            this.moleculeView = new SimpleAlchemistMoleculeView(1, 1){
                private static final long serialVersionUID = 7404632231400676190L;

                @Override
                protected JTable getView() {
                    if (this.view == null) {
                        super.getView();
                        this.view.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (e.getClickCount() == 2 && !((TransformElement)TransformElementEditor.this.getElement()).isLocked()) {
                                    try {
                                        ((TransformElement)TransformElementEditor.this.getElement()).setMolecule(MolImporter.importMol(((TransformElement)TransformElementEditor.this.getElement()).getStructure()));
                                    }
                                    catch (MolFormatException molFormatException) {
                                        // empty catch block
                                    }
                                    TransformElementEditor.this.getElement().addPropertyChangeListener("Editormode", TransformElementEditor.this.getEditorListener());
                                    ((ExternalEditorSupport)((Object)TransformElementEditor.this.getElement())).setEditorMode("external");
                                }
                            }
                        });
                    }
                    return this.view;
                }
            };
            this.moleculeView.setMoleculeLabelVisible(false);
            this.moleculeView.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.moleculeView.setDispOpts(AlchemistMoleculePainter.HIDE_IMPLICIT_HYDROGENS);
        }
        return this.moleculeView;
    }

    private JButton getSaveTemplateButton() {
        if (this.saveTemplateButton == null) {
            this.saveTemplateButton = new JButton(this.SAVE_TEMPLATE_ACTION);
        }
        return this.saveTemplateButton;
    }

    private JButton getRemoveTemplateButton() {
        if (this.removeTemplateButton == null) {
            this.removeTemplateButton = new JButton(this.REMOVE_TEMPLATE_ACTION);
        }
        return this.removeTemplateButton;
    }

    private JLabel getTransformNameLabel() {
        if (this.transformNameLabel == null) {
            this.transformNameLabel = new JLabel("Name:");
        }
        return this.transformNameLabel;
    }

    private JLabel getMoleculeViewLabel() {
        if (this.moleculeViewLabel == null) {
            this.moleculeViewLabel = new JLabel("(Double-click to edit structure)");
        }
        return this.moleculeViewLabel;
    }

    protected boolean isNameExists(String name) {
        DefaultComboBoxModel transformTemplatesModel = (DefaultComboBoxModel)this.getTransformNameCombo().getModel();
        boolean exists = false;
        for (int i = 0; i < transformTemplatesModel.getSize(); ++i) {
            if (!((Info)transformTemplatesModel.getElementAt(i)).getName().equalsIgnoreCase(name)) continue;
            exists = true;
        }
        return exists;
    }

    @Override
    public void loadFromProfile(AlchemistProfile profile) {
        this.setTransformTemplatesLoading(true);
        try {
            ConfigElement oldElement = this.getElement().clone();
            List templateList = (List)profile.get(PROFILE_KEY_TEMPLATELIST);
            if (templateList != null) {
                this.getTransformNameCombo().setModel(new DefaultComboBoxModel<Object>(templateList.toArray()));
            }
            this.setElement(oldElement);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.setTransformTemplatesLoading(false);
    }

    @Override
    public void saveToProfile(AlchemistProfile profile) {
        ArrayList<Info> templateList = new ArrayList<Info>(this.getTransformNameCombo().getItemCount());
        for (int i = 0; i < this.getTransformNameCombo().getItemCount(); ++i) {
            templateList.add((Info)this.getTransformNameCombo().getItemAt(i));
        }
        profile.put(PROFILE_KEY_TEMPLATELIST, templateList);
    }

    protected void setEditorListener(PropertyChangeListener editorListener) {
        this.editorListener = editorListener;
    }

    protected PropertyChangeListener getEditorListener() {
        return this.editorListener;
    }

    protected void setTransformTemplatesLoading(boolean transformTemplatesLoading) {
        this.transformTemplatesLoading = transformTemplatesLoading;
    }

    protected boolean isTransformTemplatesLoading() {
        return this.transformTemplatesLoading;
    }

    public static class Info {
        private String name = null;
        private String molecule = null;
        private String searchOptions = null;

        public Info() {
            this(null, null, false);
        }

        public Info(String name, String molecule) {
            this(name, molecule, null);
        }

        public Info(String name, String molecule, String searchOptions) {
            this.name = name;
            this.molecule = molecule;
            this.searchOptions = searchOptions;
        }

        @Deprecated
        public Info(String name, String molecule, boolean exact) {
            this(name, molecule, null);
            MolSearchOptions options = new MolSearchOptions();
            options.setSubgraphSearch(exact);
            this.searchOptions = options.toString();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMolecule() {
            return this.molecule;
        }

        public void setMolecule(String molecule) {
            this.molecule = molecule;
        }

        public String getSearchOptions() {
            return this.searchOptions;
        }

        public void setSearchOptions(String searchOptions) {
            this.searchOptions = searchOptions;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Info) {
                Info info = (Info)obj;
                return this.name.equals(info.name) && this.molecule.equals(info.molecule) && this.searchOptions.equals(info.searchOptions);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode() * this.searchOptions.hashCode() + this.molecule.hashCode();
        }
    }
}

