/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.structurechecker.configelements;

import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.checkers.FixMode;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerFactory;
import chemaxon.checkers.registry.CheckerFixerRegistry;
import chemaxon.checkers.registry.configuration.reader.DefaultConfigurationReader;
import chemaxon.fixers.StructureFixer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.dom4j.Element;

public class StructureCheckerWrapper
extends ConfigElement {
    protected static final StructureCheckerFactory CHECKER_FACTORY = new StructureCheckerFactory();
    protected static final CheckerFixerRegistry REGISTRY = new CheckerFixerRegistry(new DefaultConfigurationReader());
    protected StructureChecker checker = null;
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            StructureCheckerWrapper.this.getPropertyChangeSupport().firePropertyChange(evt);
        }
    };

    @Override
    public void setId(String id) {
        super.setId(id);
        if (this.checker == null) {
            this.setItem(CHECKER_FACTORY.getChecker(id, null));
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return this.checker == null ? super.getIcon() : this.checker.getDescriptor().getIcon();
    }

    @Override
    public String getTooltip() {
        return this.checker == null ? super.getTooltip() : this.checker.getDescriptor().getName();
    }

    @Override
    public String getName() {
        return this.checker == null ? super.getName() : this.checker.getDescriptor().getName();
    }

    @Override
    public String getHelpText() {
        return this.checker == null ? super.getHelpText() : this.checker.getDescriptor().getDescription();
    }

    @Override
    public StructureCheckerWrapper clone() throws CloneNotSupportedException {
        StructureCheckerWrapper element = (StructureCheckerWrapper)super.clone();
        if (this.checker != null) {
            element.setItem(this.checker.cloneItem());
        }
        return element;
    }

    @Override
    public boolean isDefault() {
        if (this.getFixerClassName() == null) {
            return this.getFixMode() == FixMode.ASK;
        }
        List<StructureFixer> availableFixers = StructureCheckerWrapper.getAvailableFixers(this.checker);
        if (!availableFixers.isEmpty()) {
            return this.getFixerClassName().equals(availableFixers.get(0).getClass().getName()) && this.getFixMode() == FixMode.FIX;
        }
        return false;
    }

    @Override
    protected void validate() {
        boolean valid = true;
        if (this.getFixMode() == FixMode.FIX) {
            if (this.getFixerClassName() == null) {
                valid = false;
            }
            if (valid) {
                valid = false;
                List<StructureFixer> availableFixers = StructureCheckerWrapper.getAvailableFixers(this.checker);
                for (int i = 0; i < availableFixers.size() && !valid; ++i) {
                    if (!this.getFixerClassName().equals(availableFixers.get(i).getClass().getName())) continue;
                    valid = true;
                }
            }
        }
        this.setValid(valid);
    }

    public String getFixerClassName() {
        return this.checker.getDescriptor().getFixerClassName();
    }

    public void setFixerClassName(String className) {
        this.checker.getDescriptor().setFixerClassName(className);
    }

    public FixMode getFixMode() {
        return this.checker.getDescriptor().getFixMode();
    }

    public void setFixMode(FixMode fixMode) {
        this.checker.getDescriptor().setFixMode(fixMode);
    }

    protected void storeCustomProperties(Element element) {
    }

    public StructureChecker getItem() {
        return this.checker;
    }

    public void setItem(StructureChecker checker) {
        if (this.checker != null) {
            this.checker.removePropertyChangeListener(this.listener);
        }
        this.checker = checker;
        if (this.checker != null) {
            this.checker.addPropertyChangeListener(this.listener);
        }
        this.validate();
    }

    public StructureChecker cloneItem() {
        return this.checker == null ? null : this.checker.cloneItem();
    }

    @Deprecated
    public String getCheckerClassName() {
        return this.checker == null ? null : this.checker.getClass().getName();
    }

    public String getDescription() {
        return this.checker == null ? null : this.checker.getDescriptor().getDescription();
    }

    public String getEditorClassName() {
        return this.checker == null ? null : this.checker.getDescriptor().getEditorClassName();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(300);
        buffer.append(this.getId());
        buffer.append("[Name: ");
        buffer.append(this.getName());
        buffer.append(", Editor: ");
        buffer.append(this.getEditorClassName());
        buffer.append(", Fixer: ");
        buffer.append(this.getFixerClassName());
        buffer.append(", FixMode: ");
        buffer.append((Object)this.getFixMode());
        buffer.append(", Item: ");
        buffer.append(this.checker);
        buffer.append(']');
        return buffer.toString();
    }

    public static List<StructureFixer> getAvailableFixers(StructureChecker checker) {
        List<StructureFixer> fixerList = null;
        if (checker != null) {
            fixerList = REGISTRY.getFixer(checker.getErrorType());
        }
        if (fixerList == null) {
            fixerList = Collections.emptyList();
        }
        return fixerList;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.checker.isValid();
    }
}

