/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

import chemaxon.alchemist.markushview.MarkushListCellRenderer;
import chemaxon.alchemist.markushview.MarkushViewComboBoxModel;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.swing.moleculeview.MoleculeViewComponent;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class MarkushMoleculeFullViewPanel
extends JPanel {
    private JComboBox molecules = null;
    private MoleculeViewComponent view = null;
    private List<Set<Integer>> selectedRGroups = null;
    private int selectedIndex = 0;
    private MarkushListCellRenderer renderer;
    private MolPainterCommon common;

    public MarkushMoleculeFullViewPanel(MolPainterCommon common) {
        super(new BorderLayout());
        this.common = common;
        this.createGUI();
    }

    private void createGUI() {
        this.setMinimumSize(new Dimension(100, 100));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                MarkushMoleculeFullViewPanel.this.repaintView();
            }
        });
        JPanel comboPanel = new JPanel(new GridLayout(1, 1));
        JPanel moleculePanel = new JPanel(new GridLayout(1, 1));
        this.molecules = new JComboBox();
        this.renderer = new MarkushListCellRenderer();
        this.molecules.setRenderer(this.renderer);
        this.molecules.setEditable(false);
        this.molecules.setMaximumRowCount(15);
        this.molecules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkushMoleculeFullViewPanel.this.selectedIndex = MarkushMoleculeFullViewPanel.this.molecules.getSelectedIndex();
                MarkushMoleculeFullViewPanel.this.repaintView();
            }
        });
        this.view = new MoleculeViewComponent(this.common);
        this.view.setMinimumSize(new Dimension(50, 50));
        this.view.setResizeOnDoubleClick(true);
        this.view.setTranslateEnabled(true);
        this.view.setZoomEnabled(true);
        this.view.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MarkushMoleculeFullViewPanel.this.repaintView();
            }
        });
        comboPanel.add(this.molecules);
        moleculePanel.add(this.view);
        this.add((Component)comboPanel, "North");
        this.add((Component)moleculePanel, "Center");
        this.validate();
    }

    public void setSelectedRGroups(List<Set<Integer>> selectedRGroups) {
        this.selectedRGroups = selectedRGroups;
        this.repaintView();
    }

    public void setSelectedIndex(Integer index) {
        int newIndex;
        int n = newIndex = index == null ? 0 : index;
        if (index == null) {
            this.centerizeMolecule();
        }
        this.selectedIndex = newIndex;
    }

    private void centerizeMolecule() {
        if (this.view != null && this.view.getMolecule() != null) {
            this.view.centerize();
        }
    }

    public void setMoleculeComboBoxModelContent(List<RgMolecule> moleculeList) {
        if (moleculeList == null) {
            this.molecules.setModel(new DefaultComboBoxModel());
            this.molecules.setRenderer(new DefaultListCellRenderer());
            return;
        }
        Molecule[] mols = new Molecule[moleculeList.size()];
        for (int i = 0; i < moleculeList.size(); ++i) {
            mols[i] = moleculeList.get(i).cloneMoleculeWithDocument();
        }
        this.molecules.setModel(new MarkushViewComboBoxModel(mols));
        this.molecules.setRenderer(this.renderer);
        this.molecules.setSelectedIndex(0);
        this.molecules.setSelectedItem(this.molecules.getModel().getElementAt(0));
        if (moleculeList.size() > 1) {
            this.molecules.setEnabled(true);
        } else {
            this.molecules.setEnabled(false);
        }
    }

    private void repaintView() {
        try {
            this.molecules.setSelectedIndex(this.selectedIndex);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        if (this.view.getMolecule() != null) {
            this.view.getMolecule().setGUIContracted(false);
        }
        Molecule currentMolecule = (Molecule)this.molecules.getModel().getSelectedItem();
        currentMolecule.setGUIContracted(true);
        if (currentMolecule != this.view.getMolecule()) {
            this.view.setMolecule(currentMolecule);
        }
        this.zoom();
    }

    public void zoom() {
        if (this.selectedRGroups != null && !this.selectedRGroups.isEmpty() && !this.selectedRGroups.get(this.molecules.getSelectedIndex()).isEmpty()) {
            this.view.zoomToRGroups(this.selectedRGroups.get(this.molecules.getSelectedIndex()));
        }
    }

    public void setMolPainterCommon(MolPainterCommon common) {
        this.common = common;
        if (this.view != null) {
            this.view.setDisplayOptions(common.getDispopts(), common.getDispoptsExt());
        }
    }
}

