/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

import chemaxon.alchemist.markushview.MarkushLinearViewFactory;
import chemaxon.alchemist.markushview.MarkushMoleculeFullViewPanel;
import chemaxon.alchemist.markushview.MarkushNestingViewPanel;
import chemaxon.alchemist.markushview.MarkushTreePathComparator;
import chemaxon.alchemist.markushview.MoleculeTitleUtils;
import chemaxon.alchemist.markushview.RGroupFragmentView;
import chemaxon.alchemist.markushview.RGroupViewPane;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeCellRenderer;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeView;
import chemaxon.alchemist.utils.AlchemistBrowserLauncher;
import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.alchemist.utils.moleculetree.AlchemistMoleculeTree;
import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.alchemist.utils.moleculetree.TreeDataProvider;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.swing.moleculeview.MoleculeViewComponent;
import chemaxon.marvin.swing.moleculeview.RGMoleculeGraphUtils;
import chemaxon.marvin.swing.moleculeview.RGroupData;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.ExternalFileLoader;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MarkushViewerComponent
extends JPanel {
    public static final String MARKUSH_VIEWER = "/chemaxon/alchemist/images/markushviewer48.png";
    public static final String PROPERTY_KEY_PATHS_VISIBLE = "markush_viewer_pathsVisible";
    public static final String PROPERTY_KEY_ALWAYS_SHOW_SCAFFOLD = "always_show_scaffold";
    public static final String PROPERTY_KEY_AUTO_SIZE_FRAGMENTS = "auto_size_fragments";
    public static final String PROPERTY_KEY_ATOM_PROPERTIES_VISIBLE = "atom_properties_visible";
    public static final String PROPERTY_KEY_LONE_PAIRS_VISIBLE = "lone_pairs_visible";
    public static final String PROPERTY_KEY_VALANCE_ERROR_VISIBLE = "valance_error_visible";
    public static final String PROPERTY_KEY_EZ_LABELS_VISIBLE = "ez_labels_visible";
    public static final String PROPERTY_KEY_RS_LABELS_VISIBLE = "rs_labels_visible";
    private static final String NO_IMPORTED_MOLECULES = "Please open an R-group molecule";
    private static final String NO_SELECTED_NODES = "Please select one or more nodes from the tree.";
    public static final int DEFAULT_SCROLLPANE_WITH_IMAGES_VERTICAL_SCROLLBAR_UNIT_INCREMENT = 30;
    private static final String MARKUSH_TREENODE_MOLECULE_ID_PROPERTY = "molID";
    private static final String MARKUSH_TREENODE_R_GROUP_ID_PROPERTY = "rGroupID";
    private static final long serialVersionUID = 2561953223042733755L;
    private JTabbedPane detailsPane = null;
    private RGroupViewPane fragmentsPane = null;
    private JPanel fullViewPanel = null;
    private final MolPainterCommon common;
    private MarkushMoleculeFullViewPanel fullView = null;
    private MarkushNestingViewPanel nestingViewPanel = null;
    private JScrollPane treeScrollPane = null;
    private JSplitPane splitPane = null;
    private JSplitPane mainSplit = null;
    private AlchemistMoleculeTree moleculeTree = null;
    private boolean showPath = false;
    private boolean alwaysShowScaffold = true;
    private boolean autosizeFragments = true;
    public static final String MARKUSH_VIEWER_TREE_SELECTED_NODES = "selectedNodes";
    public static final String PROPERTY_KEY_IMPLICIT_H_VISIBILITY_TYPE = "implicit_H_visibility";
    private final List<RgMolecule> rootMolecules = new ArrayList<RgMolecule>();
    private Map<Integer, List<NodeColorData>> hitIndexes;
    private boolean cancelled = false;
    private Thread loadingThread;

    private Map<Integer, List<NodeColorData>> getHitIndexes() {
        if (this.hitIndexes == null) {
            this.hitIndexes = new HashMap<Integer, List<NodeColorData>>();
        }
        return this.hitIndexes;
    }

    public MarkushViewerComponent() {
        this.setMinimumSize(new Dimension(250, 250));
        this.common = new MolPainterCommon();
        this.common.setAtomPropertiesVisible(true);
        this.common.setImplicitH("heteroterm");
        this.common.setValencePropertyVisible(true);
        this.common.setErrorVisible(this.common.isValenceErrorVisible());
        this.common.setLigandErrorVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainSplit(), "Center");
        this.setNoFileImportedMessage();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MarkushViewerComponent.this.resetDividers();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MarkushViewerComponent.this.resetDividers();
            }
        });
        this.setNestingViewVisible(this.isNestingViewVisible());
    }

    private JTabbedPane getDetailsPane() {
        if (this.detailsPane == null) {
            this.detailsPane = new JTabbedPane(1, 1);
            this.detailsPane.addTab("Fragments", this.getFragmentsPane());
            this.detailsPane.addTab("Markush", this.getFullViewPanel());
        }
        return this.detailsPane;
    }

    private RGroupViewPane getFragmentsPane() {
        if (this.fragmentsPane == null) {
            this.fragmentsPane = new RGroupViewPane(this.common);
        }
        return this.fragmentsPane;
    }

    private JPanel getFullViewPanel() {
        if (this.fullViewPanel == null) {
            this.fullViewPanel = new JPanel(new GridLayout(1, 1));
        }
        return this.fullViewPanel;
    }

    private MarkushMoleculeFullViewPanel getFullView() {
        if (this.fullView == null) {
            this.fullView = new MarkushMoleculeFullViewPanel(this.common);
        }
        return this.fullView;
    }

    private MarkushNestingViewPanel getNestingViewPanel() {
        if (this.nestingViewPanel == null) {
            this.nestingViewPanel = new MarkushNestingViewPanel();
            this.nestingViewPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "nodesUpdated") {
                        MarkushViewerComponent.this.getMoleculeTree().repaint();
                    }
                }
            });
            this.nestingViewPanel.setVisible(this.isNestingViewVisible());
        }
        return this.nestingViewPanel;
    }

    private JScrollPane getTreeScrollPane() {
        if (this.treeScrollPane == null) {
            this.treeScrollPane = new JScrollPane(this.getMoleculeTree());
            AdjustmentListener listener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    MarkushViewerComponent.this.getMoleculeTree().gatherVisibleNodes();
                }
            };
            this.treeScrollPane.getHorizontalScrollBar().addAdjustmentListener(listener);
            this.treeScrollPane.getVerticalScrollBar().addAdjustmentListener(listener);
            this.treeScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.GRAY));
        }
        return this.treeScrollPane;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane(1, false);
            this.splitPane.setLeftComponent(this.getTreeScrollPane());
            this.splitPane.setRightComponent(this.getDetailsPane());
        }
        return this.splitPane;
    }

    private JSplitPane getMainSplit() {
        if (this.mainSplit == null) {
            this.mainSplit = new JSplitPane(0, false);
            this.mainSplit.setBorder(BorderFactory.createEmptyBorder());
            this.mainSplit.setTopComponent(this.getSplitPane());
            this.mainSplit.setBottomComponent(this.getNestingViewPanel());
            this.mainSplit.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!MarkushViewerComponent.this.showPath) {
                        MarkushViewerComponent.this.mainSplit.setDividerLocation(MarkushViewerComponent.this.getHeight());
                    }
                }
            });
        }
        return this.mainSplit;
    }

    public AlchemistMoleculeTree getMoleculeTree() {
        if (this.moleculeTree == null) {
            this.moleculeTree = new AlchemistMoleculeTree();
            this.moleculeTree.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "nodeLoading") {
                        MarkushViewerComponent.this.loading(evt);
                    }
                }
            });
            this.moleculeTree.setDataProvider(new MarkushProvider());
            this.moleculeTree.setNodeMoleculeVisible(false);
            this.moleculeTree.setNodeLineVisible(true);
            this.moleculeTree.setNodeBorderVisible(true);
            this.moleculeTree.setNodeCaptionVisible(true);
            this.moleculeTree.setStepLineVisible(false);
            this.moleculeTree.putClientProperty("AlchemistTreeView_BorderType", (Object)AlchemistTreeView.BorderType.CUSTOM);
            this.moleculeTree.putClientProperty("bracketOnFocus", true);
            ((AlchemistMoleculeTreeCellRenderer)this.moleculeTree.getCellRenderer()).setDispOpts(this.common.getDispopts());
            ((AlchemistMoleculeTreeCellRenderer)this.moleculeTree.getCellRenderer()).setDispOptsExt(this.common.getDispoptsExt());
            this.moleculeTree.putClientProperty("bracketOnFocus", false);
            this.moleculeTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    MarkushViewerComponent.this.changeTreeNodeSelectionDependentComponents();
                }
            });
        }
        return this.moleculeTree;
    }

    private void resetDividers() {
        this.getSplitPane().setDividerLocation((int)((double)this.getWidth() * 0.5));
        if (this.isNestingViewVisible()) {
            this.mainSplit.setDividerLocation((int)((double)this.getHeight() * 0.75));
        }
    }

    private void addOrWrapMolecule(Molecule molecule) {
        RgMolecule rgMolecule;
        if (MarkushViewerComponent.isRealRGMolecule(molecule)) {
            rgMolecule = (RgMolecule)molecule;
            this.checkMoleculeHits(molecule);
        } else {
            rgMolecule = new RgMolecule();
            rgMolecule.setRoot(molecule);
            if (molecule.getDocument() != null && molecule.getDocument().getAtomSetSize() > 1) {
                rgMolecule.setAtomSetSeqs(0);
            }
        }
        this.rootMolecules.add(rgMolecule);
    }

    private void checkMoleculeHits(Molecule molecule) {
        MDocument document = molecule.getDocument();
        if (document == null || document.getAtomSetSize() < 2) {
            return;
        }
        this.getHitIndexes().put(this.rootMolecules.size(), new ArrayList());
        for (int i = 1; i < document.getAtomSetSize(); ++i) {
            Color color = document.getAtomSetColor(i);
            if (color == null) continue;
            this.getHitIndexes().get(this.rootMolecules.size()).add(new NodeColorData(color));
        }
        this.collectHits((RgMolecule)molecule);
    }

    private void collectHits(RgMolecule markush) {
        List<NodeColorData> current = this.getHitIndexes().get(this.rootMolecules.size());
        for (MolAtom atom : markush.getAtomArray()) {
            int rGroupNumber;
            int index = atom.getSetSeq() - 1;
            if (index < 0 || (rGroupNumber = this.findRGroupIndexOf(atom, markush)) <= -2) continue;
            boolean found = false;
            for (int i = index + 1; i < current.size() && !found; ++i) {
                found = current.get(i).getAtomIndexes().remove(rGroupNumber);
            }
            current.get(index).getAtomIndexes().add(rGroupNumber);
        }
    }

    private int findRGroupIndexOf(MolAtom match, RgMolecule markush) {
        int index = -2;
        for (MolAtom currentAtom : markush.getRootG().getAtomArray()) {
            if (currentAtom != match) continue;
            index = -1;
        }
        if (index == -2) {
            int top = markush.getRgroupCount();
            boolean found = false;
            for (int i = 0; i < top && !found; ++i) {
                block2: for (int j = 0; j < markush.getRgroupMemberCount(i) && !found; ++j) {
                    for (MolAtom atom : markush.getRgroupMember(i, j).getAtomArray()) {
                        if (atom != match) continue;
                        index = markush.getRgroupId(i);
                        found = true;
                        continue block2;
                    }
                }
            }
        }
        return index;
    }

    public void setMolecules(List<Molecule> moleculeList) {
        this.getMoleculeTree().clear();
        this.getMoleculeTree().repaint();
        this.rootMolecules.clear();
        this.getHitIndexes().clear();
        for (Molecule molecule : moleculeList) {
            this.addOrWrapMolecule(molecule);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MarkushViewerComponent.this.setImportedMolecules();
            }
        });
    }

    public void setMolecule(Molecule molecule) {
        ArrayList<Molecule> moleculeList = new ArrayList<Molecule>();
        moleculeList.add(molecule);
        this.setMolecules(moleculeList);
    }

    private void addSelectionAndTagColors(AlchemistTreeNode node) {
        node.setProperty("SelectedBorderColor", "#ffbbbb");
        node.setProperty("TaggedBorderColor", "#ff0000");
    }

    private void setImportedMolecules() {
        ArrayList<AlchemistTreeNode> nodeList = new ArrayList<AlchemistTreeNode>();
        boolean successfulTreeBuild = false;
        for (int i = 0; i < this.rootMolecules.size(); ++i) {
            if (!successfulTreeBuild) {
                successfulTreeBuild = true;
            }
            AlchemistTreeNode node = new AlchemistTreeNode(Integer.toString(i));
            node.setProperty(MARKUSH_TREENODE_MOLECULE_ID_PROPERTY, Integer.toString(i));
            node.setProperty(MARKUSH_TREENODE_R_GROUP_ID_PROPERTY, Integer.toString(-1));
            this.addSelectionAndTagColors(node);
            Molecule nodeRoot = this.rootMolecules.get(i).getRoot().cloneMolecule();
            if (this.setNodeColor(node, i, -1)) {
                MarkushViewerComponent.createDocumentFor(nodeRoot, this.getColorsFor(i));
            }
            nodeRoot.setGUIContracted(true);
            node.setMolecule(nodeRoot);
            node.setProperty("DefaultNodeCaption", MoleculeTitleUtils.createSimpleMarkushTitle(this.rootMolecules.get(i).getName(), i + 1, -1));
            nodeList.add(node);
            if (MarkushViewerComponent.isRealRGMolecule(this.rootMolecules.get(i))) {
                AlchemistTreeNode virtual = new AlchemistTreeNode("virtual" + node.getUniqueID());
                virtual.setParentID(node.getUniqueID());
                nodeList.add(virtual);
                continue;
            }
            node.setAllowsChildren(false);
        }
        if (successfulTreeBuild) {
            this.getMoleculeTree().addNodes(nodeList.toArray(new AlchemistTreeNode[nodeList.size()]));
            this.expandTree();
            this.setupMoleculeFullView();
            this.setNoNodeSelectedMessage();
            this.changeTreeNodeSelectionDependentComponents();
            this.getMoleculeTree().requestFocus();
        } else {
            this.setNoFileImportedMessage();
            this.getMoleculeTree().clear();
        }
    }

    private boolean setNodeColor(AlchemistTreeNode node, int moleculeID, int rGroupNumber) {
        Color color = this.getNodeColor(moleculeID, rGroupNumber);
        if (color != null) {
            node.setProperty("CustomBorderColor", String.valueOf(color.getRGB() & 0xFFFFFF));
            return true;
        }
        return false;
    }

    private Color getNodeColor(int moleculeID, int rGroupID) {
        List<NodeColorData> current = this.getHitIndexes().get(moleculeID);
        if (current == null || current.isEmpty()) {
            return null;
        }
        for (NodeColorData data : current) {
            if (!data.getAtomIndexes().contains(rGroupID)) continue;
            return data.getColor();
        }
        return null;
    }

    private Color[] getColorsFor(int molID) {
        Color[] colors = null;
        List<NodeColorData> current = this.getHitIndexes().get(molID);
        if (current != null && !current.isEmpty()) {
            colors = new Color[current.size()];
            for (int i = 0; i < current.size(); ++i) {
                colors[i] = current.get(i).getColor();
            }
        }
        return colors;
    }

    private Integer getColorIndex(int moleculeID, int rGroupID, Color[] colors) {
        if (colors == null) {
            return null;
        }
        Color match = this.getNodeColor(moleculeID, rGroupID);
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] != match) continue;
            return i;
        }
        return null;
    }

    private void setupMoleculeFullView() {
        this.getFullView().setMoleculeComboBoxModelContent(null);
        this.getFullView().setMoleculeComboBoxModelContent(this.rootMolecules);
        this.getFullViewPanel().removeAll();
        this.getFullViewPanel().add(this.getFullView());
        this.getFullView().repaint();
        this.getFullView().validate();
    }

    private void setNoNodeSelectedMessage() {
        if (!this.isAlwaysShowScaffold()) {
            this.getFragmentsPane().resetContent(new JLabel(NO_SELECTED_NODES, 0));
        } else {
            this.getFragmentsPane().resetContent(null);
        }
        this.getNestingViewPanel().resetLinears(new JLabel(NO_SELECTED_NODES, 0));
    }

    private void setNoFileImportedMessage() {
        this.getFragmentsPane().resetContent(new JLabel(NO_IMPORTED_MOLECULES, 0));
        this.getNestingViewPanel().resetLinears(new JLabel(NO_IMPORTED_MOLECULES, 0));
        this.getFullViewPanel().removeAll();
        this.getFullViewPanel().add(new JLabel(NO_IMPORTED_MOLECULES, 0));
    }

    private void changeTreeNodeSelectionDependentComponents() {
        TreePath[] paths = this.getMoleculeTree().getSelectionPaths();
        this.unTagNodes();
        if (this.rootMolecules.isEmpty()) {
            this.setNoFileImportedMessage();
        } else {
            this.setNoNodeSelectedMessage();
        }
        List<Set<Integer>> rGroupselectionList = this.createRgroupsList();
        ArrayList<JPanel> linears = new ArrayList<JPanel>();
        ArrayList<AlchemistTreeNode> nodes = new ArrayList<AlchemistTreeNode>();
        Integer focusOn = null;
        if (paths != null) {
            Arrays.sort(paths, new MarkushTreePathComparator());
            this.getFragmentsPane().resetContent(null);
            this.getNestingViewPanel().resetLinears(null);
            this.getDetailsPane().repaint();
            this.getDetailsPane().invalidate();
            int molID = -1;
            for (TreePath currentPath : paths) {
                Color[] colors;
                ArrayList<Integer> pathGroupNumbers = new ArrayList<Integer>();
                AlchemistTreeNode node = (AlchemistTreeNode)currentPath.getLastPathComponent();
                nodes.add(node);
                int tempMolID = Integer.parseInt(node.getProperty(MARKUSH_TREENODE_MOLECULE_ID_PROPERTY));
                int rGroupID = Integer.parseInt(node.getProperty(MARKUSH_TREENODE_R_GROUP_ID_PROPERTY));
                if (molID != tempMolID) {
                    molID = tempMolID;
                    if (rGroupID != -1) {
                        colors = this.getColorsFor(molID);
                        this.getFragmentsPane().addScaffold(molID, this.rootMolecules.get(molID), this.isAutosizeFragments(), this.isAlwaysShowScaffold(), colors, this.getColorIndex(molID, -1, colors));
                    }
                }
                if (currentPath.getPath().length > 2) {
                    for (int j = 2; j < currentPath.getPath().length; ++j) {
                        pathGroupNumbers.add(Integer.parseInt(((AlchemistTreeNode)currentPath.getPath()[j]).getProperty(MARKUSH_TREENODE_R_GROUP_ID_PROPERTY)));
                    }
                }
                colors = this.getColorsFor(molID);
                Integer index = this.getColorIndex(molID, rGroupID, colors);
                linears.add(MarkushLinearViewFactory.createMarkushLinearView(molID, this.rootMolecules.get(molID), pathGroupNumbers, this.common.getDispopts(), this.common.getDispoptsExt(), colors));
                pathGroupNumbers.clear();
                this.getFragmentsPane().addDefinitions(molID, rGroupID, this.rootMolecules.get(molID), this.isAutosizeFragments(), colors, index);
                if (focusOn == null) {
                    focusOn = molID;
                }
                rGroupselectionList.get(molID).add(rGroupID);
            }
        } else if (this.rootMolecules != null && !this.rootMolecules.isEmpty()) {
            this.getFragmentsPane().resetContent(null);
            for (int k = 0; k < this.rootMolecules.size(); ++k) {
                Color[] colors = this.getColorsFor(k);
                this.getFragmentsPane().addScaffold(k, this.rootMolecules.get(k), this.isAutosizeFragments(), this.isAlwaysShowScaffold(), colors, this.getColorIndex(k, -1, colors));
            }
            if (!this.isAlwaysShowScaffold()) {
                this.getFragmentsPane().switchLabelWithContent(false, NO_SELECTED_NODES);
            }
        }
        if (!linears.isEmpty() && !nodes.isEmpty() && nodes.size() == linears.size()) {
            this.getNestingViewPanel().setContent(linears, nodes);
        }
        this.getNestingViewPanel().repaint();
        this.getNestingViewPanel().validate();
        this.getFullView().setSelectedIndex(focusOn);
        this.getFullView().setSelectedRGroups(rGroupselectionList);
        this.getFullView().repaint();
        this.getFullView().revalidate();
    }

    private void unTagNodes() {
        if (this.getNestingViewPanel().getNodes() != null && !this.getNestingViewPanel().getNodes().isEmpty()) {
            for (AlchemistTreeNode node : this.getNestingViewPanel().getNodes()) {
                if (node == null) continue;
                node.setTagged(false);
            }
        }
    }

    private List<Set<Integer>> createRgroupsList() {
        if (this.rootMolecules == null || this.rootMolecules.isEmpty()) {
            return null;
        }
        ArrayList<Set<Integer>> selectionList = new ArrayList<Set<Integer>>();
        for (int i = 0; i < this.rootMolecules.size(); ++i) {
            selectionList.add(new HashSet());
        }
        return selectionList;
    }

    public boolean isNestingViewVisible() {
        return this.showPath;
    }

    public static MDocument createDocumentFor(Molecule molecule, Color[] colors) {
        MDocument doc = new MDocument(new Molecule[]{molecule});
        if (colors != null) {
            for (int i = 0; i < colors.length; ++i) {
                if (colors[i] == null) continue;
                doc.setAtomSetRGB(i + 1, colors[i].getRGB());
            }
        }
        return doc;
    }

    public void setNestingViewVisible(boolean visible) {
        boolean oldValue = this.isNestingViewVisible();
        this.showPath = visible;
        this.getNestingViewPanel().setVisible(visible);
        if (visible) {
            if (!oldValue) {
                this.remove(this.getSplitPane());
                this.getMainSplit().setTopComponent(this.getSplitPane());
                this.add(this.getMainSplit());
            }
            this.getMainSplit().setDividerLocation((int)((double)this.getHeight() * 0.75));
            this.repaint();
            this.validate();
        } else {
            this.remove(this.getMainSplit());
            this.add(this.getSplitPane());
            this.repaint();
            this.validate();
        }
        this.getMainSplit().validate();
        this.firePropertyChange(PROPERTY_KEY_PATHS_VISIBLE, oldValue, visible);
    }

    public void setNodeLineVisible(boolean newValue) {
        boolean oldValue = this.isNodeLineVisible();
        this.getMoleculeTree().setNodeLineVisible(newValue);
        this.firePropertyChange("nodeLinesVisible", oldValue, newValue);
    }

    public boolean isNodeLineVisible() {
        return this.getMoleculeTree().isNodeLineVisible();
    }

    public void setStepLineVisible(boolean newValue) {
        boolean oldValue = this.isStepLineVisible();
        this.getMoleculeTree().setStepLineVisible(newValue);
        this.firePropertyChange("stepLinesVisible", oldValue, newValue);
    }

    public boolean isStepLineVisible() {
        return this.getMoleculeTree().isStepLineVisible();
    }

    public void setNodeMoleculeVisible(boolean newValue) {
        boolean oldValue = this.isNodeMoleculeVisible();
        this.getMoleculeTree().setNodeMoleculeVisible(newValue);
        if (newValue) {
            this.getTreeScrollPane().getVerticalScrollBar().setUnitIncrement(30);
        } else {
            this.getTreeScrollPane().getVerticalScrollBar().setUnitIncrement(this.getMoleculeTree().getScrollableUnitIncrement(this.getTreeScrollPane().getBounds(), 1, 0));
        }
        this.getMoleculeTree().repaint();
        this.getMoleculeTree().invalidate();
        this.firePropertyChange("moleculeVisible", oldValue, newValue);
    }

    public boolean isNodeMoleculeVisible() {
        return this.getMoleculeTree().isNodeMoleculeVisible();
    }

    public void setAlwaysShowScaffold(boolean newValue) {
        boolean oldValue = this.isAlwaysShowScaffold();
        this.alwaysShowScaffold = newValue;
        this.firePropertyChange(PROPERTY_KEY_ALWAYS_SHOW_SCAFFOLD, oldValue, newValue);
        if (newValue != oldValue && this.getFragmentsPane().getRViews() != null && !this.getFragmentsPane().getRViews().isEmpty() && this.getFragmentsPane().getAutoScaffoldIndexes() != null && !this.getFragmentsPane().getAutoScaffoldIndexes().isEmpty()) {
            for (int index : this.getFragmentsPane().getAutoScaffoldIndexes()) {
                JPanel panel = this.getFragmentsPane().getRViews().get(index).getPanel();
                panel.setVisible(newValue);
                for (MoleculeViewComponent definition : this.getFragmentsPane().getRViews().get(index).getFragments()) {
                    definition.centerize();
                    definition.repaint();
                    Dimension tempDim = definition.getSize();
                    definition.setSize(100, 100);
                    definition.setSize(tempDim);
                }
                panel.invalidate();
            }
            this.getFragmentsPane().getViewport().validate();
            this.getFragmentsPane().getViewport().repaint();
        }
        if (this.rootMolecules != null && !this.rootMolecules.isEmpty() && this.getMoleculeTree().getSelectionCount() == 0 && oldValue != newValue) {
            this.getFragmentsPane().switchLabelWithContent(newValue, NO_SELECTED_NODES);
        }
    }

    public boolean isAlwaysShowScaffold() {
        return this.alwaysShowScaffold;
    }

    public void setAutosizeFragments(boolean newValue) {
        boolean oldValue = this.isAutosizeFragments();
        this.autosizeFragments = newValue;
        this.firePropertyChange(PROPERTY_KEY_AUTO_SIZE_FRAGMENTS, oldValue, newValue);
        if (newValue != oldValue && this.getFragmentsPane().getRViews() != null && !this.getFragmentsPane().getRViews().isEmpty()) {
            for (RGroupFragmentView view : this.getFragmentsPane().getRViews()) {
                view.getPanel().setPreferredSize(new Dimension(0, newValue ? view.getPreferredHeight() : view.getDefaultHeight()));
                view.getPanel().invalidate();
                view.getPanel().setMaximumSize(new Dimension(Integer.MAX_VALUE, newValue ? view.getPreferredHeight() : view.getDefaultHeight()));
                view.getPanel().invalidate();
            }
            this.getFragmentsPane().getMainPanel().validate();
            this.getFragmentsPane().getMainPanel().repaint();
        }
    }

    public boolean isAutosizeFragments() {
        return this.autosizeFragments;
    }

    public void collapseTree() {
        this.getMoleculeTree().collapseAll();
        this.getMoleculeTree().repaint();
        this.getMoleculeTree().invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandTree() {
        if (this.getMoleculeTree().getRowCount() == 0) {
            return;
        }
        if (this.loadingThread != null) {
            Thread thread = this.loadingThread;
            synchronized (thread) {
                if (this.loadingThread != null && this.loadingThread.isAlive()) {
                    this.cancelled = true;
                    this.loadingThread.notify();
                }
            }
        }
        final AlchemistMoleculeTree tree = this.getMoleculeTree();
        tree.expandAll();
        this.loadingThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object node;
                MarkushViewerComponent.this.cancelled = false;
                ArrayList<TreePath> paths = new ArrayList<TreePath>();
                for (int i = 0; i < tree.getRowCount(); ++i) {
                    final TreePath path = tree.getPathForRow(i);
                    node = (AlchemistTreeNode)path.getLastPathComponent();
                    if (((DefaultMutableTreeNode)node).isLeaf() || ((AlchemistTreeNode)node).isChildrenLoaded()) continue;
                    paths.add(path);
                }
                for (final TreePath path : paths) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            tree.expandPath(path);
                            tree.repaint();
                            tree.invalidate();
                        }
                    });
                    try {
                        node = Thread.currentThread();
                        synchronized (node) {
                            Thread.currentThread().wait();
                        }
                    }
                    catch (InterruptedException e) {
                        if (!MarkushViewerComponent.this.cancelled) continue;
                        break;
                    }
                    finally {
                        if (MarkushViewerComponent.this.cancelled) break;
                    }
                }
            }
        };
        this.loadingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loading(PropertyChangeEvent event) {
        if (event.getNewValue() == Boolean.FALSE && this.loadingThread != null && this.loadingThread.isAlive()) {
            Thread thread = this.loadingThread;
            synchronized (thread) {
                this.loadingThread.notify();
            }
        }
    }

    public static boolean isRealRGMolecule(Molecule molecule) {
        return molecule instanceof RgMolecule && ((RgMolecule)molecule).getRgroupCount() > 0 && RGMoleculeGraphUtils.hasDefinedChildGroups(((RgMolecule)molecule).getRootG(), (RgMolecule)molecule);
    }

    public boolean isAtomPropertiesVisible() {
        return this.common.isAtomPropertiesVisible();
    }

    public boolean isLonePairsVisible() {
        return this.common.areLonePairsVisible();
    }

    public boolean isValanceErrorVisible() {
        return this.common.isValenceErrorVisible();
    }

    public void toggleAtomPropertiesVisible() {
        this.common.setAtomPropertiesVisible(!this.isAtomPropertiesVisible());
        this.refreshDisplaySettings();
        this.firePropertyChange(PROPERTY_KEY_ATOM_PROPERTIES_VISIBLE, !this.isAtomPropertiesVisible(), this.isAtomPropertiesVisible());
    }

    public void toggleLonePairsVisible() {
        this.common.setLonePairsAutoCalc(!this.isLonePairsVisible());
        this.common.setLonePairsVisible(!this.isLonePairsVisible());
        this.refreshDisplaySettings();
        this.firePropertyChange(PROPERTY_KEY_LONE_PAIRS_VISIBLE, !this.isLonePairsVisible(), this.isLonePairsVisible());
    }

    public void toggleValanceErrorVisible() {
        this.common.setErrorVisible(!this.isValanceErrorVisible());
        this.common.setValenceErrorVisible(!this.isValanceErrorVisible());
        this.refreshDisplaySettings();
        this.firePropertyChange(PROPERTY_KEY_VALANCE_ERROR_VISIBLE, !this.isValanceErrorVisible(), this.isValanceErrorVisible());
    }

    public void toggleEZLabelsVisible() {
        this.common.setEzVisible(!this.isEZLabelsVisible());
        this.refreshDisplaySettings();
        this.firePropertyChange(PROPERTY_KEY_EZ_LABELS_VISIBLE, !this.isEZLabelsVisible(), this.isEZLabelsVisible());
    }

    public boolean isEZLabelsVisible() {
        return this.common.isEzVisible();
    }

    public void toggleRSLabelsVisible() {
        this.common.setChiralitySupport(this.isRSLabelsVisible() ? 0 : 2);
        this.refreshDisplaySettings();
        this.firePropertyChange(PROPERTY_KEY_RS_LABELS_VISIBLE, !this.isRSLabelsVisible(), this.isRSLabelsVisible());
    }

    public boolean isRSLabelsVisible() {
        return this.common.getChiralitySupport() == 2;
    }

    private void refreshDisplaySettings() {
        ((AlchemistMoleculeTreeCellRenderer)this.getMoleculeTree().getCellRenderer()).setDispOpts(this.common.getDispopts());
        ((AlchemistMoleculeTreeCellRenderer)this.getMoleculeTree().getCellRenderer()).setDispOptsExt(this.common.getDispoptsExt());
        for (RGroupFragmentView view : this.getFragmentsPane().getRViews()) {
            for (MoleculeViewComponent comp : view.getFragments()) {
                comp.setDisplayOptions(this.common.getDispopts(), this.common.getDispoptsExt());
            }
        }
        this.getFullView().setMolPainterCommon(this.common);
        this.invalidate();
        this.repaint();
    }

    public void setImpliciHVisible(ImplicitHVisibilityType type) {
        String old = this.common.getImplicitH();
        switch (type) {
            case OFF: {
                this.common.setImplicitH("off");
                break;
            }
            case HETERO: {
                this.common.setImplicitH("hetero");
                break;
            }
            case ON: {
                this.common.setImplicitH("all");
                break;
            }
            default: {
                this.common.setImplicitH("heteroterm");
            }
        }
        this.refreshDisplaySettings();
        this.firePropertyChange(PROPERTY_KEY_IMPLICIT_H_VISIBILITY_TYPE, old, this.common.getImplicitH());
    }

    public boolean isImplicitHVisibilityEquals(ImplicitHVisibilityType type) {
        switch (type) {
            case OFF: {
                return this.common.getImplicitH() == "off";
            }
            case HETERO: {
                return this.common.getImplicitH() == "hetero";
            }
            case ON: {
                return this.common.getImplicitH() == "all";
            }
        }
        return this.common.getImplicitH() == "heteroterm";
    }

    public void showHelp() {
        try {
            ExternalFileLoader loader = new ExternalFileLoader("doc/user/markush_viewer.html");
            if (loader.getFileOutJar() != null) {
                AlchemistBrowserLauncher.launchBrowser(new File(loader.getFileOutJar()).toURI().toURL().toString());
            } else {
                loader = new ExternalFileLoader("../../jchem/jchemsite/doc/user/markush_viewer.html");
                if (loader.getFileOutJar() != null) {
                    AlchemistBrowserLauncher.launchBrowser(new File(loader.getFileOutJar()).toURI().toURL().toString());
                } else {
                    AlchemistBrowserLauncher.launchBrowser("http://www.chemaxon.com/jchem/doc/user/markush_viewer.html");
                }
            }
        }
        catch (Exception e) {
            try {
                AlchemistBrowserLauncher.launchBrowser("http://www.chemaxon.com/jchem/doc/user/markush_viewer.html");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class NodeColorData {
        private Color color;
        private Set<Integer> atomIndexes;

        public NodeColorData(Color color, Set<Integer> indexes) {
            if (color == null || indexes == null) {
                throw new IllegalArgumentException();
            }
            this.color = color;
            this.atomIndexes = indexes;
        }

        public NodeColorData(Color color) {
            this(color, new HashSet<Integer>());
        }

        public Color getColor() {
            return this.color;
        }

        public Set<Integer> getAtomIndexes() {
            return this.atomIndexes;
        }
    }

    public static enum ImplicitHVisibilityType {
        OFF,
        HETERO,
        HETERO_AND_TERMINAL,
        ON;

    }

    private class MarkushProvider
    implements TreeDataProvider<AlchemistTreeNode> {
        private MarkushProvider() {
        }

        public AlchemistTreeNode[] getTreeData(AlchemistTreeNode parentNode, AlchemistProgressMonitor monitor) throws IOException {
            ArrayList<AlchemistTreeNode> nodeList = new ArrayList<AlchemistTreeNode>();
            RgMolecule rootMolecule = this.getRootMolecule(parentNode);
            if (rootMolecule != null) {
                Molecule parentMolecule = parentNode.getMolecule();
                parentMolecule.setGUIContracted(false);
                rootMolecule.setGUIContracted(false);
                List<RGroupData> childGroups = RGMoleculeGraphUtils.getChildGroups(parentMolecule.getGraphUnion(), rootMolecule, true);
                parentMolecule.setGUIContracted(true);
                rootMolecule.setGUIContracted(true);
                if (childGroups == null) {
                    return null;
                }
                for (RGroupData childGroup : childGroups) {
                    if (childGroup.getGraphArray() == null) continue;
                    AlchemistTreeNode node = new AlchemistTreeNode(parentNode.getUniqueID() + ";" + childGroup.getRGroupNumber());
                    node.setParentID(parentNode.getUniqueID());
                    node.setProperty(MarkushViewerComponent.MARKUSH_TREENODE_R_GROUP_ID_PROPERTY, Integer.toString(childGroup.getRGroupNumber()));
                    node.setProperty(MarkushViewerComponent.MARKUSH_TREENODE_MOLECULE_ID_PROPERTY, parentNode.getProperty(MarkushViewerComponent.MARKUSH_TREENODE_MOLECULE_ID_PROPERTY));
                    MarkushViewerComponent.this.addSelectionAndTagColors(node);
                    int molID = Integer.parseInt(parentNode.getProperty(MarkushViewerComponent.MARKUSH_TREENODE_MOLECULE_ID_PROPERTY));
                    Molecule mol = new Molecule();
                    for (int i = 0; i < childGroup.getGraphArray().length; ++i) {
                        mol.fuse(childGroup.getGraphArray()[i], false);
                    }
                    if (MarkushViewerComponent.this.setNodeColor(node, molID, childGroup.getRGroupNumber())) {
                        MarkushViewerComponent.createDocumentFor(mol, MarkushViewerComponent.this.getColorsFor(molID));
                    }
                    mol.setGUIContracted(true);
                    CleanUtil.arrangeComponents(mol, true, true);
                    node.setMolecule(mol.cloneMoleculeWithDocument());
                    node.setProperty("DefaultNodeCaption", "R" + childGroup.getRGroupNumber() + " [" + childGroup.getGraphArray().length + "]");
                    nodeList.add(node);
                    AlchemistTreeNode virtual = new AlchemistTreeNode("virtual" + node.getUniqueID());
                    virtual.setParentID(node.getUniqueID());
                    mol.setGUIContracted(false);
                    if (RGMoleculeGraphUtils.hasDefinedChildGroups(mol.getGraphUnion(), (RgMolecule)MarkushViewerComponent.this.rootMolecules.get(Integer.parseInt(parentNode.getProperty(MarkushViewerComponent.MARKUSH_TREENODE_MOLECULE_ID_PROPERTY))))) {
                        nodeList.add(virtual);
                    } else {
                        node.setAllowsChildren(false);
                    }
                    mol.setGUIContracted(true);
                }
            }
            return nodeList.toArray(new AlchemistTreeNode[nodeList.size()]);
        }

        private RgMolecule getRootMolecule(AlchemistTreeNode node) {
            return (RgMolecule)MarkushViewerComponent.this.rootMolecules.get(Integer.parseInt(node.getProperty(MarkushViewerComponent.MARKUSH_TREENODE_MOLECULE_ID_PROPERTY)));
        }
    }
}

