/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

import chemaxon.alchemist.utils.AlchemistErrorDialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class MarkushViewerPrinter
implements Printable {
    private JComponent componentToBePrinted;
    private PageFormat format;
    private PrinterJob job;

    public static void printComponent(JComponent component) {
        new MarkushViewerPrinter(component).print();
    }

    public MarkushViewerPrinter(JComponent componentToBePrinted) {
        this.setComponentToBePrinted(componentToBePrinted);
    }

    public void print() {
        this.getJob().setPrintable(this, this.getPageFormat());
        if (this.getJob().printDialog()) {
            try {
                this.getJob().print();
            }
            catch (PrinterException pe) {
                AlchemistErrorDialog.showError("Printing failed.", (Exception)pe);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        MarkushViewerPrinter.disableDoubleBuffering(this.getComponentToBePrinted());
        this.getComponentToBePrinted().paint(g2d);
        MarkushViewerPrinter.enableDoubleBuffering(this.getComponentToBePrinted());
        return 0;
    }

    public PageFormat getPageFormat() {
        if (this.format == null) {
            this.format = this.getJob().defaultPage();
        }
        return this.format;
    }

    public void setPageFormat() {
        this.format = this.getJob().pageDialog(this.getPageFormat());
    }

    public static void disableDoubleBuffering(JComponent component) {
        RepaintManager currentManager = RepaintManager.currentManager(component);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(JComponent component) {
        RepaintManager currentManager = RepaintManager.currentManager(component);
        currentManager.setDoubleBufferingEnabled(true);
    }

    private PrinterJob getJob() {
        if (this.job == null) {
            this.job = PrinterJob.getPrinterJob();
        }
        return this.job;
    }

    private JComponent getComponentToBePrinted() {
        return this.componentToBePrinted;
    }

    public void setComponentToBePrinted(JComponent componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }
}

