/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer;

import chemaxon.alchemist.metabolizer.MetabolizerAlchemist;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistInnerDialog;
import chemaxon.alchemist.utils.AlchemistLabel;
import chemaxon.alchemist.utils.AlchemistMoleculeEditor;
import chemaxon.alchemist.utils.HelpTextPanelFactory;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.util.codeassist.CodeAssistFactory;
import chemaxon.metabolizer.LibraryTester;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.TokenMgrError;
import chemaxon.struc.Molecule;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.text.html.HTMLDocument;

public final class MetabolizerPanelHandler {
    private static final String PROPERTY_KEY_CANCEL = "Cancel";
    private static final String PROPERTY_KEY_ACCEPT = "Accept";
    private static final String PROPERTY_KEY_CHANGED = "LibraryChangedByUser";
    public static final String PROPERTY_KEY_STRUCTURE_TO_EDIT = "SketchStructureToEdit";
    public static final String PROPERTY_KEY_SYNTHESISCODE = "Synthesiscode";
    private static final Map<MetabolizerAlchemist, Map<DialogID, AlchemistInnerDialog>> CACHE = new WeakHashMap<MetabolizerAlchemist, Map<DialogID, AlchemistInnerDialog>>();

    private MetabolizerPanelHandler() {
    }

    public static void showTerminationConditionDialog(MetabolizerAlchemist metabolizer) {
        metabolizer.setEnabled(false);
        MetabolizerPanelHandler.getDialog(metabolizer, DialogID.TERMINATION_CONDITION).setVisible(true);
    }

    public static void showRangeOptionsDialog(MetabolizerAlchemist metabolizer) {
        metabolizer.setEnabled(false);
        MetabolizerPanelHandler.getDialog(metabolizer, DialogID.RANGE_OPTIONS).setVisible(true);
    }

    public static void showNewMetabolismDialog(MetabolizerAlchemist metabolizer) {
        metabolizer.setEnabled(false);
        MetabolizerPanelHandler.getDialog(metabolizer, DialogID.NEW_METABOLISM).setVisible(true);
    }

    public static void showMetabolizerOptionsDialog(MetabolizerAlchemist metabolizer) {
        metabolizer.setEnabled(false);
        MetabolizerPanelHandler.getDialog(metabolizer, DialogID.LIBRARY_OPTIONS).setVisible(true);
    }

    public static void showSketchDialog(MetabolizerAlchemist metabolizer) {
        metabolizer.setEnabled(false);
        MetabolizerPanelHandler.getDialog(metabolizer, DialogID.SKETCH_PANEL).setVisible(true);
    }

    private static Map<DialogID, AlchemistInnerDialog> getDialogMap(MetabolizerAlchemist metabolizer) {
        HashMap<DialogID, AlchemistInnerDialog> dialogMap = null;
        if (!CACHE.containsKey(metabolizer)) {
            dialogMap = new HashMap();
            CACHE.put(metabolizer, dialogMap);
        } else {
            dialogMap = CACHE.get(metabolizer);
        }
        return dialogMap;
    }

    static AlchemistInnerDialog getDialog(MetabolizerAlchemist metabolizer, DialogID dialogId) {
        AlchemistInnerDialog dialog = null;
        Map<DialogID, AlchemistInnerDialog> dialogMap = MetabolizerPanelHandler.getDialogMap(metabolizer);
        if (!dialogMap.containsKey((Object)dialogId)) {
            switch (dialogId) {
                case TERMINATION_CONDITION: {
                    dialog = MetabolizerPanelHandler.addTerminationConditionDialog(metabolizer);
                    break;
                }
                case RANGE_OPTIONS: {
                    dialog = MetabolizerPanelHandler.addRangeOptionsDialog(metabolizer);
                    break;
                }
                case NEW_METABOLISM: {
                    dialog = MetabolizerPanelHandler.addNewMetabolismDialog(metabolizer);
                    break;
                }
                case LIBRARY_OPTIONS: {
                    dialog = MetabolizerPanelHandler.addLibraryOptionsDialog(metabolizer);
                    break;
                }
                case SKETCH_PANEL: {
                    dialog = MetabolizerPanelHandler.addSketchDialog(metabolizer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal dialog argument occurred! dialogId=" + (Object)((Object)dialogId));
                }
            }
            dialogMap.put(dialogId, dialog);
        } else {
            dialog = dialogMap.get((Object)dialogId);
        }
        return dialog;
    }

    private static AlchemistInnerDialog addTerminationConditionDialog(final MetabolizerAlchemist metabolizer) {
        JPanel content = new JPanel();
        final AlchemistInnerDialog frame = AlchemistInnerDialog.createCustomBox("Termination Options", content, null);
        JScrollPane scroll = new JScrollPane();
        final JTextPane editor = CodeAssistFactory.createChemicalTermsTextPane();
        final AlchemistLabel errorLabel = new AlchemistLabel("This Chemical Term is not valid.", 4);
        final AbstractAction acceptAction = new AbstractAction(PROPERTY_KEY_ACCEPT){
            private static final long serialVersionUID = 6932705863816480115L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Evaluator evaluator = new Evaluator();
                    evaluator.compile(editor.getText(), MolContext.class);
                    frame.setVisible(false);
                    metabolizer.getTreeView().setTerminationCondition(editor.getText());
                    metabolizer.getApplicationState().setPersistentProperty("AlchemistApplication_TerminationCondition", editor.getText());
                    metabolizer.setEnabled(true);
                }
                catch (ParseException exception) {
                    errorLabel.setVisible(true);
                }
                catch (TokenMgrError mgrError) {
                    errorLabel.setVisible(true);
                }
            }
        };
        AbstractAction cancelAction = new AbstractAction(PROPERTY_KEY_CANCEL){
            private static final long serialVersionUID = -2376994066076575897L;

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
                editor.setText(metabolizer.getTreeView().getTerminationCondition());
                metabolizer.setEnabled(true);
            }
        };
        final Timer evaluateTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread parseThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!editor.getText().equalsIgnoreCase("")) {
                            try {
                                Evaluator evaluator = new Evaluator();
                                evaluator.compile(editor.getText(), MolContext.class);
                                errorLabel.setVisible(false);
                                acceptAction.setEnabled(true);
                            }
                            catch (ParseException exception) {
                                errorLabel.setVisible(true);
                                acceptAction.setEnabled(false);
                            }
                            catch (TokenMgrError mgrError) {
                                errorLabel.setVisible(true);
                                acceptAction.setEnabled(false);
                            }
                        } else {
                            errorLabel.setVisible(false);
                            acceptAction.setEnabled(true);
                        }
                    }
                });
                parseThread.start();
            }
        });
        evaluateTimer.setRepeats(false);
        editor.setText(metabolizer.getTreeView().getTerminationCondition());
        errorLabel.setVisible(false);
        editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                evaluateTimer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                evaluateTimer.restart();
            }
        });
        scroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0), BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY)));
        scroll.setViewportView(editor);
        content.setLayout(new BorderLayout());
        content.add((Component)HelpTextPanelFactory.getNewHelpTextPanel("Specify termination condition", "You can customize the termination condition for metabolite generation process by setting Chemical Terms. When condition evaluated true, metabolism will stop at given molecule. For example, you can set a solubility requirement for your molecules. Note: this condition affects both Batch-mode calculation, and manual node-open."), "North");
        content.add((Component)scroll, "Center");
        content.add((Component)errorLabel, "South");
        frame.setActions(new Action[]{acceptAction, cancelAction});
        frame.setCloseAction(cancelAction);
        frame.setMinimumSize(new Dimension(480, 360));
        frame.setPreferredSize(frame.getMinimumSize());
        frame.pack();
        metabolizer.addInnerDialog(frame);
        AlchemistInnerDialog.setCentered(frame);
        return frame;
    }

    private static AlchemistInnerDialog addRangeOptionsDialog(final MetabolizerAlchemist metabolizer) {
        JPanel holder = new JPanel(new BorderLayout());
        JPanel content = new JPanel((LayoutManager)new FormLayout("4dlu, default:grow, 2dlu, 30dlu, pref, 4dlu", "4dlu, pref, 2dlu, pref, 4dlu, pref, 4dlu"));
        final AlchemistInnerDialog frame = AlchemistInnerDialog.createCustomBox("Range options", holder, null);
        CellConstraints cc = new CellConstraints();
        final JTextField majorText = new JTextField(String.valueOf(metabolizer.getTreeView().getMajorMetaboliteLimit()));
        final JTextField minorText = new JTextField(String.valueOf(metabolizer.getTreeView().getMinorMetaboliteLimit()));
        final AbstractAction acceptAction = new AbstractAction(PROPERTY_KEY_ACCEPT){
            private static final long serialVersionUID = 7293936920972658020L;

            @Override
            public void actionPerformed(ActionEvent e) {
                float val = Float.parseFloat(majorText.getText());
                if (val >= 0.0f && val <= 100.0f) {
                    metabolizer.getTreeView().setMajorMetaboliteLimit(val);
                    metabolizer.getApplicationState().setPersistentProperty("AlchemistApplication_MajorMetaboliteLimit", Float.valueOf(val));
                }
                if ((val = Float.parseFloat(minorText.getText())) >= 0.0f && val <= 100.0f) {
                    metabolizer.getTreeView().setMinorMetaboliteLimit(val);
                    metabolizer.getApplicationState().setPersistentProperty("AlchemistApplication_MinorMetaboliteLimit", Float.valueOf(val));
                }
                frame.setVisible(false);
                metabolizer.setEnabled(true);
            }
        };
        AbstractAction cancelAction = new AbstractAction(PROPERTY_KEY_CANCEL){
            private static final long serialVersionUID = -3244550907100806099L;

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
                majorText.setText(String.valueOf(metabolizer.getTreeView().getMajorMetaboliteLimit()));
                minorText.setText(String.valueOf(metabolizer.getTreeView().getMinorMetaboliteLimit()));
                metabolizer.setEnabled(true);
            }
        };
        majorText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (majorText.hasFocus()) {
                    try {
                        float val = Float.parseFloat(majorText.getText());
                        acceptAction.setEnabled(val >= 0.0f && val <= 100.0f);
                    }
                    catch (NumberFormatException ex) {
                        acceptAction.setEnabled(false);
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }
        });
        majorText.setHorizontalAlignment(4);
        minorText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (minorText.hasFocus()) {
                    try {
                        float val = Float.parseFloat(minorText.getText());
                        acceptAction.setEnabled(val >= 0.0f && val <= 100.0f);
                    }
                    catch (NumberFormatException ex) {
                        acceptAction.setEnabled(false);
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }
        });
        minorText.setHorizontalAlignment(4);
        JEditorPane majorHelpText = new JEditorPane();
        majorHelpText.setContentType("text/html");
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body{ font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)majorHelpText.getDocument()).getStyleSheet().addRule(bodyRule);
        majorHelpText.setFocusable(false);
        majorHelpText.setEditable(false);
        majorHelpText.setOpaque(false);
        majorHelpText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        majorHelpText.setText("Metabolites above the this limit will be considered major metabolites<br>(default: higher than 10% of the highest accumulation or production rate)");
        JEditorPane minorHelpText = new JEditorPane();
        minorHelpText.setContentType("text/html");
        ((HTMLDocument)minorHelpText.getDocument()).getStyleSheet().addRule(bodyRule);
        minorHelpText.setFocusable(false);
        minorHelpText.setEditable(false);
        minorHelpText.setOpaque(false);
        minorHelpText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        minorHelpText.setText("Metabolites below the this limit will be considered minor metabolites<br>(default: lower than 1% of the highest accumulation or production rate)");
        JButton defaultsButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -7563991517812257140L;

            @Override
            public void actionPerformed(ActionEvent e) {
                majorText.setText(String.valueOf(10.0f));
                minorText.setText(String.valueOf(1.0f));
            }
        });
        defaultsButton.setText("Restore defaults");
        content.add((Component)majorHelpText, cc.xy(2, 2));
        content.add((Component)minorHelpText, cc.xy(2, 4));
        content.add((Component)majorText, cc.xy(4, 2));
        content.add((Component)minorText, cc.xy(4, 4));
        content.add((Component)defaultsButton, cc.xy(2, 6, "left, center"));
        content.add((Component)new JLabel("%"), cc.xy(5, 2));
        content.add((Component)new JLabel("%"), cc.xy(5, 4));
        holder.add((Component)HelpTextPanelFactory.getNewHelpTextPanel("Configure Color Ranges", "Metabolites can be colored by their accumulation or production values. In both cases, major metabolites are green, mediums are orange and minor metabolites are red."), "North");
        holder.add((Component)content, "Center");
        frame.setActions(new Action[]{acceptAction, cancelAction});
        frame.setCloseAction(cancelAction);
        frame.setMinimumSize(new Dimension(480, 360));
        frame.setPreferredSize(frame.getMinimumSize());
        frame.pack();
        metabolizer.addInnerDialog(frame);
        AlchemistInnerDialog.setCentered(frame);
        return frame;
    }

    private static AlchemistInnerDialog addNewMetabolismDialog(final MetabolizerAlchemist metabolizer) {
        JPanel content = new JPanel(new BorderLayout());
        final AlchemistInnerDialog frame = AlchemistInnerDialog.createCustomBox("New metabolism", content, null);
        final JCheckBox autoShowCheckBox = new JCheckBox("Show this dialog on startup");
        SwingPropertyChangeSupport notifier = new SwingPropertyChangeSupport(frame);
        final AlchemistMoleculeEditor editor = new AlchemistMoleculeEditor(1, 1, true, notifier);
        final AbstractAction acceptAction = new AbstractAction(PROPERTY_KEY_ACCEPT){
            private static final long serialVersionUID = 5148482093228733527L;

            @Override
            public void actionPerformed(ActionEvent e) {
                metabolizer.createNewMetabolism(editor.getMolecules());
                frame.setVisible(false);
                metabolizer.setEnabled(true);
                editor.clear();
            }
        };
        acceptAction.setEnabled(false);
        final AbstractAction cancelAction = new AbstractAction(PROPERTY_KEY_CANCEL){
            private static final long serialVersionUID = 5591574089040203068L;

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
                metabolizer.setEnabled(true);
                editor.clear();
            }
        };
        final AbstractAction importAction = new AbstractAction(){
            private static final long serialVersionUID = -7775866660281521926L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = metabolizer.showOpenDialog("MetabolizerNewProjectPanel");
                if (path != null) {
                    editor.importMolecules(path);
                }
            }
        };
        importAction.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/opendocument.gif"));
        importAction.putValue("ShortDescription", "Open a molecule file...");
        editor.getToolBar().add(new JButton(importAction));
        notifier.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = true;
                if (evt.getPropertyName().equalsIgnoreCase("Alchemist_Enable")) {
                    enabled = (Boolean)evt.getNewValue();
                }
                acceptAction.setEnabled(editor.getMoleculeCount() > 0 && enabled);
                cancelAction.setEnabled(enabled);
                importAction.setEnabled(enabled);
            }
        });
        boolean value = true;
        try {
            value = (Boolean)metabolizer.getApplicationState().getProperty("AlchemistApplication_autoShowNewPanel");
        }
        catch (Exception e) {
            // empty catch block
        }
        autoShowCheckBox.setSelected(value);
        autoShowCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    metabolizer.getApplicationState().setPersistentProperty("AlchemistApplication_autoShowNewPanel", autoShowCheckBox.isSelected());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        content.add((Component)HelpTextPanelFactory.getNewHelpTextPanel("New Metabolism", "Specify initial substrates."), "North");
        content.add((Component)editor, "Center");
        content.add((Component)autoShowCheckBox, "South");
        frame.setActions(new Action[]{acceptAction, cancelAction});
        frame.setCloseAction(cancelAction);
        frame.setMinimumSize(new Dimension(480, 360));
        frame.setPreferredSize(new Dimension(480, 600));
        frame.pack();
        metabolizer.addInnerDialog(frame);
        AlchemistInnerDialog.setCentered(frame);
        return frame;
    }

    private static AlchemistInnerDialog addLibraryOptionsDialog(final MetabolizerAlchemist metabolizer) {
        JPanel content = new JPanel(new BorderLayout());
        final AlchemistInnerDialog frame = AlchemistInnerDialog.createCustomBox("Library Options", content, null);
        final AbstractAction acceptAction = new AbstractAction(PROPERTY_KEY_ACCEPT){
            private static final long serialVersionUID = 86101325127911199L;

            @Override
            public void actionPerformed(ActionEvent e) {
                metabolizer.getApplicationState().setPersistentProperty("MetabolizerInteractiveViewNewDialog_LibraryFilePath", metabolizer.getLibraryHandler().getReactionFilePath());
                frame.putClientProperty(MetabolizerPanelHandler.PROPERTY_KEY_CHANGED, false);
                frame.setVisible(false);
                metabolizer.setEnabled(true);
            }
        };
        acceptAction.setEnabled(false);
        final AbstractAction cancelAction = new AbstractAction(PROPERTY_KEY_CANCEL){
            private static final long serialVersionUID = -6915439904089675468L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean value = (Boolean)frame.getClientProperty(MetabolizerPanelHandler.PROPERTY_KEY_CHANGED);
                frame.putClientProperty(MetabolizerPanelHandler.PROPERTY_KEY_CHANGED, false);
                if (value != null && value.booleanValue()) {
                    frame.setVisible(false);
                    metabolizer.getLibraryHandler().setReactionFilePath((String)metabolizer.getApplicationState().getProperty("MetabolizerInteractiveViewNewDialog_LibraryFilePath"));
                    metabolizer.setEnabled(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            metabolizer.getApplicationFrame().validate();
                        }
                    });
                } else {
                    File file = new File(metabolizer.getLibraryHandler().getReactionFilePath());
                    if (file.isFile() && file.canRead()) {
                        LibraryTester libraryTester = new LibraryTester();
                        int libraryState = libraryTester.testLibrary(metabolizer.getLibraryHandler().getReactions());
                        switch (libraryState) {
                            case 2: {
                                metabolizer.showMessageBox("Library Error", libraryTester.getMessage(), 0);
                                break;
                            }
                            case 1: {
                                metabolizer.showMessageBox("Library Warning", libraryTester.getMessage(), 2);
                            }
                            default: {
                                frame.setVisible(false);
                                metabolizer.setEnabled(true);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        metabolizer.getApplicationFrame().validate();
                                    }
                                });
                                break;
                            }
                        }
                    } else {
                        metabolizer.showMessageBox("Library Error", "Can not read library file.\nPlease specify a reaction library.", 0);
                    }
                }
            }
        };
        cancelAction.setEnabled(false);
        frame.setCloseAction(cancelAction);
        metabolizer.getLibraryHandler().getNotifier().addPropertyChangeListener("ReactorInputPanel_Initialized", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals("Panel_Normal")) {
                    File file = new File(metabolizer.getLibraryHandler().getReactionFilePath());
                    if (file.isFile() && file.canRead()) {
                        LibraryTester libraryTester = new LibraryTester();
                        int libraryState = libraryTester.testLibrary(metabolizer.getLibraryHandler().getReactions());
                        switch (libraryState) {
                            case 2: {
                                metabolizer.libraryBlocksNewDialog = true;
                                MetabolizerPanelHandler.showMetabolizerOptionsDialog(metabolizer);
                                metabolizer.showMessageBox("Library Error", libraryTester.getMessage(), 0);
                                acceptAction.setEnabled(false);
                                cancelAction.setEnabled(true);
                                break;
                            }
                            case 1: {
                                metabolizer.showMessageBox("Library Warning", libraryTester.getMessage(), 2);
                            }
                            default: {
                                metabolizer.setReactionLibrary(metabolizer.getLibraryHandler().getReactions(), libraryState == 0);
                                acceptAction.setEnabled(libraryState != 2);
                                cancelAction.setEnabled(true);
                                break;
                            }
                        }
                    } else {
                        metabolizer.libraryBlocksNewDialog = true;
                        MetabolizerPanelHandler.showMetabolizerOptionsDialog(metabolizer);
                        acceptAction.setEnabled(false);
                        cancelAction.setEnabled(true);
                    }
                } else {
                    if (evt.getPropertyName().equalsIgnoreCase("ReactorInputPanel_ReactionList") && frame.isVisible()) {
                        frame.putClientProperty(MetabolizerPanelHandler.PROPERTY_KEY_CHANGED, true);
                    }
                    acceptAction.setEnabled(false);
                    cancelAction.setEnabled(false);
                }
            }
        });
        content.add((Component)HelpTextPanelFactory.getNewHelpTextPanel("Metabolizer Library Options", "You have to specify a reaction library to run metabolic processes. The reaction library contains all the possible reactions used to generate metabolites."), "North");
        content.add((Component)metabolizer.getLibraryHandler(), "Center");
        frame.setMaximizable(true);
        frame.setActions(new Action[]{acceptAction, cancelAction});
        frame.setCloseAction(cancelAction);
        frame.setMinimumSize(new Dimension(480, 360));
        frame.setPreferredSize(new Dimension(480, 600));
        frame.pack();
        frame.setVisible(false);
        metabolizer.addInnerDialog(frame);
        AlchemistInnerDialog.setCentered(frame);
        return frame;
    }

    private static AlchemistInnerDialog addSketchDialog(final MetabolizerAlchemist metabolizer) {
        JPanel content = new JPanel(new BorderLayout());
        final AlchemistInnerDialog frame = AlchemistInnerDialog.createCustomBox("Edit structure", content, null);
        final MSketchPane sketch = new MSketchPane();
        AbstractAction acceptAction = new AbstractAction(PROPERTY_KEY_ACCEPT){
            private static final long serialVersionUID = -8030995911134388588L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String code = (String)frame.getClientProperty(MetabolizerPanelHandler.PROPERTY_KEY_SYNTHESISCODE);
                if (code == null) {
                    if (metabolizer.isDocumentCreated()) {
                        metabolizer.getTreeView().addSubstrate(sketch.getMol());
                    } else {
                        metabolizer.createNewMetabolism(new Molecule[]{sketch.getMol()});
                    }
                } else {
                    if (JOptionPane.showConfirmDialog(metabolizer.getApplicationFrame(), "All your calculations of the edited substrate will be lost.\nDo you proceed?", "Edit substrate", 0) != 0) {
                        return;
                    }
                    metabolizer.getTreeView().updateSubstrate(code, sketch.getMol());
                }
                frame.setVisible(false);
            }
        };
        AbstractAction cancelAction = new AbstractAction(PROPERTY_KEY_CANCEL){
            private static final long serialVersionUID = 2880649638729042439L;

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
            }
        };
        frame.addPropertyChangeListener(PROPERTY_KEY_STRUCTURE_TO_EDIT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Molecule) {
                    Molecule mol = (Molecule)evt.getNewValue();
                    if (mol == null) {
                        mol = new Molecule();
                    }
                    sketch.setMol(mol);
                }
            }
        });
        content.add((Component)HelpTextPanelFactory.getNewHelpTextPanel("Draw substrate", "Draw your substrate, and press 'Accept' to update your metabolic tree."), "North");
        content.add((Component)sketch, "Center");
        frame.setMaximizable(true);
        frame.setActions(new Action[]{acceptAction, cancelAction});
        frame.setCloseAction(cancelAction);
        frame.setMinimumSize(new Dimension(640, 480));
        frame.pack();
        frame.setVisible(false);
        metabolizer.addInnerDialog(frame);
        AlchemistInnerDialog.setCentered(frame);
        return frame;
    }

    static enum DialogID {
        TERMINATION_CONDITION,
        RANGE_OPTIONS,
        NEW_METABOLISM,
        LIBRARY_OPTIONS,
        SKETCH_PANEL;

    }
}

