/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer.moleculetree;

import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeNode;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeView;
import chemaxon.alchemist.utils.AlchemistDashedBorder;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.metabolizer.MetabolizerCalculator;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;

public class AlchemistMoleculeTreeCellRenderer
implements TreeCellRenderer {
    private static final String COMPONENT_LABEL = "Label";
    private static final String COMPONENT_PROGRESSBAR = "ProgressBar";
    private static final int DEFAULT_WIDTH = 100;
    private static final int LABEL_HEIGHT = 20;
    private static final int EMPTY_HEIGHT = 20;
    private static final int IMAGE_HEIGHT = 100;
    private static final int TOOL_HEIGHT = 16;
    private static final int DEFAULT_BORDER_WIDTH = 2;
    private static final int SELECTED_BORDER_WIDTH = 2;
    private int dispOpts = -2;
    private int dispOptsExt = -1;
    static final Color[] CATEGORY_COLOR = new Color[]{new Color(255, 0, 0), new Color(255, 200, 0), new Color(255, 255, 0), new Color(200, 255, 0), new Color(0, 255, 0)};
    private AlchemistTreeView.BorderType colorMode;
    private JProgressBar progressBar;
    private JPanel panel;
    private JPanel northPanel;
    private JPanel moleculePanel;
    private JPanel labelPanel;
    private JPanel toolPanel;
    private Molecule molecule;
    private float zoomFactor = 1.0f;
    private BufferedImage labelImage;
    private boolean showMolecule;
    private boolean showNodeCaption;
    private boolean selected;
    private boolean showBorder;
    private boolean isExcluded = false;
    private boolean focused;
    private boolean bracketOnFocus = false;
    private AlchemistTreeNode node = null;
    private float minimumRange = 0.0f;
    private float maximumRange = 1.0f;

    public static Color getNodeColor(JTree tree, AlchemistTreeNode node) {
        AlchemistTreeView.BorderType colorMode = (AlchemistTreeView.BorderType)((Object)tree.getClientProperty("AlchemistTreeView_BorderType"));
        float minimumRange = tree.getClientProperty("AlchemistTreeView_MinorMetaboliteLimit") instanceof Float ? ((Float)tree.getClientProperty("AlchemistTreeView_MinorMetaboliteLimit")).floatValue() : 0.0f;
        float maximumRange = tree.getClientProperty("AlchemistTreeView_MajorMetaboliteLimit") instanceof Float ? ((Float)tree.getClientProperty("AlchemistTreeView_MajorMetaboliteLimit")).floatValue() : 1.0f;
        return AlchemistMoleculeTreeCellRenderer.getNodeColor(node, colorMode, false, minimumRange, maximumRange);
    }

    protected Color getNodeColor(AlchemistTreeNode node) {
        return AlchemistMoleculeTreeCellRenderer.getNodeColor(node, this.colorMode, this.isSelected(), this.minimumRange, this.maximumRange);
    }

    protected Color getNodeColor(AlchemistTreeNode node, boolean selected) {
        return AlchemistMoleculeTreeCellRenderer.getNodeColor(node, this.colorMode, selected, this.minimumRange, this.maximumRange);
    }

    private static Color decodeCustomColor(String encoded) {
        Color color = Color.BLACK;
        if (encoded != null) {
            try {
                color = Color.decode(encoded);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    private static Color getNodeColor(AlchemistTreeNode node, AlchemistTreeView.BorderType colorMode, boolean selected, float minimumRange, float maximumRange) throws IllegalArgumentException {
        Color color;
        block16: {
            block15: {
                color = Color.BLACK;
                if (colorMode == null || !(node instanceof AlchemistMoleculeTreeNode)) break block15;
                switch (colorMode) {
                    case ACCUMULATION: {
                        int value = MetabolizerCalculator.getInstance().calculateAccumulationCategory(((AlchemistMoleculeTreeNode)node).getTreeRootSynthesisCode(), node.getUniqueID(), minimumRange, maximumRange);
                        if (value > 0 && value < 6) {
                            color = CATEGORY_COLOR[value - 1];
                            break;
                        }
                        break block16;
                    }
                    case PRODUCTION: {
                        int value = MetabolizerCalculator.getInstance().calculateProductionCategory(((AlchemistMoleculeTreeNode)node).getProduction(), ((AlchemistMoleculeTreeNode)node).getTreeRootSynthesisCode(), minimumRange, maximumRange);
                        if (value > 0 && value < 6) {
                            color = CATEGORY_COLOR[value - 1];
                            break;
                        }
                        break block16;
                    }
                    case HIGHEST_ACCUMULATION: {
                        int value = MetabolizerCalculator.getInstance().calculateAccumulationByPathCategory(((AlchemistMoleculeTreeNode)node).getTreeRootSynthesisCode(), node.getUniqueID(), minimumRange, maximumRange);
                        if (value > 0 && value < 6) {
                            color = CATEGORY_COLOR[value - 1];
                            break;
                        }
                        break block16;
                    }
                    case CUSTOM: {
                        color = AlchemistMoleculeTreeCellRenderer.decodeCustomColor(node.getProperty("CustomBorderColor"));
                        break;
                    }
                    default: {
                        if (selected) {
                            String selectColor = node.getProperty("SelectedBorderColor");
                            color = selectColor == null ? Color.RED : AlchemistMoleculeTreeCellRenderer.decodeCustomColor(selectColor);
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (node.isTagged()) {
                String tagColor = node.getProperty("TaggedBorderColor");
                color = tagColor == null ? Color.CYAN : AlchemistMoleculeTreeCellRenderer.decodeCustomColor(tagColor);
            } else if (selected) {
                String selectColor = node.getProperty("SelectedBorderColor");
                color = selectColor == null ? Color.RED : AlchemistMoleculeTreeCellRenderer.decodeCustomColor(selectColor);
            } else if (AlchemistTreeView.BorderType.CUSTOM.equals((Object)colorMode)) {
                color = AlchemistMoleculeTreeCellRenderer.decodeCustomColor(node.getProperty("CustomBorderColor"));
            }
        }
        return color;
    }

    public static BufferedImage getFullTextLabelImage(AlchemistTreeNode node, JTree tree, float zoomFactor, boolean selected, boolean limitLength) {
        return AlchemistMoleculeTreeCellRenderer.getFullTextLabelImage(node, tree, zoomFactor, selected, limitLength, false);
    }

    public static BufferedImage getFullTextLabelImage(AlchemistTreeNode node, JTree tree, float zoomFactor, boolean selected, boolean limitLength, boolean magnifier) {
        int countedWidth;
        int imgWidth;
        String text = "";
        if (tree.getClientProperty("AlchemistTreeView_NodeCaptionData") == null) {
            text = node.getProperty("DefaultNodeCaption") != null ? String.valueOf(node.getProperty("DefaultNodeCaption")) : node.getUniqueID();
        } else {
            switch ((AlchemistTreeView.NodeCaptionDataType)((Object)tree.getClientProperty("AlchemistTreeView_NodeCaptionData"))) {
                case EXACTMASS: {
                    text = node.getProperty("EXACT_MASS");
                    break;
                }
                case MOLECULENAME: {
                    if (!(node instanceof AlchemistMoleculeTreeNode)) break;
                    text = ((AlchemistMoleculeTreeNode)node).getMoleculeName();
                    break;
                }
                case SYNTHESISCODE: {
                    text = node.getUniqueID();
                    break;
                }
                default: {
                    text = node.getProperty("DefaultNodeCaption") != null ? String.valueOf(node.getProperty("DefaultNodeCaption")) : node.getUniqueID();
                }
            }
        }
        if (text == null) {
            text = "";
        }
        int borderWidth = magnifier ? 1 : (selected ? 2 : 2);
        float zFactor = zoomFactor;
        if (magnifier) {
            zFactor = 1.6f;
        }
        Font font = tree.getFont().deriveFont(tree.getFont().getSize2D() * zFactor);
        if (selected) {
            font = font.deriveFont(1);
        }
        int n = imgWidth = (float)((countedWidth = SwingUtilities.computeStringWidth(tree.getFontMetrics(font), text)) + 2 * borderWidth) < 100.0f * zFactor ? (int)(100.0f * zFactor + (float)(2 * borderWidth)) : countedWidth + 4 * borderWidth;
        if (magnifier && imgWidth < 201) {
            imgWidth = 201;
        }
        BufferedImage image = new BufferedImage(imgWidth, (int)(20.0f * zFactor + (float)(2 * borderWidth)), 5);
        Graphics2D g2 = image.createGraphics();
        if (AlchemistMoleculeTreeCellRenderer.getBooleanProperty(tree, "nodeBorderVisible")) {
            if (node.isExcluded()) {
                g2.setColor(Color.LIGHT_GRAY);
            } else {
                g2.setColor(((AlchemistMoleculeTreeCellRenderer)tree.getCellRenderer()).getNodeColor(node, selected));
            }
        } else {
            g2.setColor(tree.getBackground());
        }
        if (node.isExcluded()) {
            g2.setColor(tree.getBackground());
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.setColor(Color.LIGHT_GRAY);
            g2.setStroke(AlchemistGraphicsUtilities.DASHED_STROKE);
            int x = 0;
            int y = 0;
            int width = image.getWidth();
            int height = image.getHeight();
            int thickness = 2;
            for (int i = 0; i < thickness; ++i) {
                g2.drawLine(x, y + i, x + width - 1, y + i);
                g2.drawLine(x + i, y, x + i, y + height - 1);
                g2.drawLine(x, y + height - i - 1, x + width, y + height - i - 1);
                g2.drawLine(x + width - i - 1, y, x + width - i - 1, y + height - 1);
            }
            g2.setStroke(AlchemistGraphicsUtilities.NORMAL_STROKE);
        } else {
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.setColor(tree.getBackground());
            g2.fillRect(borderWidth, borderWidth, image.getWidth() - 2 * borderWidth, image.getHeight() - 2 * borderWidth);
        }
        g2.setFont(font);
        g2.setColor(tree.getForeground());
        int height = image.getHeight();
        int diff = height - g2.getFontMetrics().getAscent();
        if (limitLength && countedWidth + 4 * borderWidth >= image.getWidth()) {
            int i;
            for (i = 1; i < text.length(); ++i) {
                if (100.0f * zFactor - (float)(4 * borderWidth) >= (float)SwingUtilities.computeStringWidth(tree.getFontMetrics(font), text.substring(0, i) + "... ")) continue;
            }
            text = text.substring(0, i) + "...";
        }
        g2.drawString(text, 2 * borderWidth, height - diff / 2 - g2.getFontMetrics().getDescent() + Math.round(zFactor));
        g2.dispose();
        return image;
    }

    protected static void progressPainter(Graphics2D g2, int width, int height, int pos, String text, Color bgColor, Color fgColor, Font font, float zoom) {
        g2.setColor(bgColor);
        g2.fillRect(0, 0, width, height);
        g2.setColor(fgColor);
        g2.fillRect(0, 0, pos, height);
        if (text != null) {
            g2.setFont(font.deriveFont(font.getSize2D() * zoom));
            int diff = height - g2.getFontMetrics().getAscent();
            int countedWidth = SwingUtilities.computeStringWidth(g2.getFontMetrics(g2.getFont()), text);
            int offs = (width - countedWidth) / 2;
            g2.setXORMode(bgColor);
            g2.drawString(text, offs, height - diff / 2 - g2.getFontMetrics().getDescent() + Math.round(zoom));
        }
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 100){
                private static final long serialVersionUID = 432677796629946831L;

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    AlchemistMoleculeTreeCellRenderer.progressPainter(g2, this.getWidth(), this.getHeight(), this.getValue() > 0 && this.getMaximum() > 0 ? (int)((float)this.getWidth() * ((float)this.getValue() / (float)this.getMaximum())) : 0, this.isStringPainted() ? this.getString() : null, this.getBackground(), this.getForeground(), this.getFont(), AlchemistMoleculeTreeCellRenderer.this.getZoomFactor());
                    g2.dispose();
                }
            };
            this.progressBar.setStringPainted(true);
            this.progressBar.setBorder(null);
        }
        return this.progressBar;
    }

    private JPanel getLabelPanel() {
        if (this.labelPanel == null) {
            this.labelPanel = new JPanel(){
                private static final long serialVersionUID = -2789715029598345097L;

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics g2 = g.create();
                    int offs = AlchemistMoleculeTreeCellRenderer.this.isSelected() ? 2 : 2;
                    g2.translate(-offs, -offs);
                    if (AlchemistMoleculeTreeCellRenderer.this.getLabelImage() != null) {
                        g2.drawImage(AlchemistMoleculeTreeCellRenderer.this.getLabelImage(), 0, 0, Color.BLACK, null);
                    }
                }
            };
        }
        return this.labelPanel;
    }

    private static Color getAccumulationColor(float value) {
        float r = (double)value > 0.5 ? 2.0f * (1.0f - value) : 1.0f;
        float g = (double)value < 0.5 ? 2.0f * value : 1.0f;
        float b = 0.0f;
        return new Color(r, g, b, 0.5f);
    }

    public static void paintToolBar(Graphics2D g, float zoomFactor, AlchemistTreeNode node) {
        Font font = g.getFont().deriveFont(g.getFont().getSize2D() * zoomFactor);
        int left = 0;
        if (node != null && !node.isExcluded()) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setFont(font);
            g2.translate(left, 0);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawLine((int)Math.max(2.0f, 2.0f * zoomFactor), (int)(7.0f * zoomFactor), (int)Math.max(2.0f, 2.0f * zoomFactor), (int)(12.0f * zoomFactor));
            g2.drawLine((int)Math.max(2.0f, 2.0f * zoomFactor), (int)(12.0f * zoomFactor), (int)(11.0f * zoomFactor), (int)(12.0f * zoomFactor));
            g2.fillPolygon(new int[]{(int)(9.0f * zoomFactor), (int)(9.0f * zoomFactor), (int)(14.0f * zoomFactor)}, new int[]{(int)(9.0f * zoomFactor), (int)(15.0f * zoomFactor), (int)(12.0f * zoomFactor)}, 3);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            String text = "";
            switch (node.getChildrenDepth()) {
                case -1: {
                    text = "x";
                    g2.setColor(Color.RED);
                    break;
                }
                case 0: {
                    text = "?";
                    g2.setColor(Color.BLUE);
                    break;
                }
                default: {
                    text = String.valueOf(node.getChildrenDepth());
                }
            }
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.drawString(text, 3.0f * zoomFactor + 1.0f, 9.0f * zoomFactor);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2.dispose();
            left = (int)((float)left + 20.0f * zoomFactor);
            if (node instanceof AlchemistMoleculeTreeNode) {
                if (MetabolizerCalculator.getInstance().calculateProductionCategory(((AlchemistMoleculeTreeNode)node).getProduction(), ((AlchemistMoleculeTreeNode)node).getTreeRootSynthesisCode()) > 0) {
                    Graphics2D g3 = (Graphics2D)g.create();
                    g3.setFont(font);
                    g3.translate(left, 0);
                    String data = new DecimalFormat("0.00").format(((AlchemistMoleculeTreeNode)node).getAccumulation() * 100.0f) + "%";
                    int width = SwingUtilities.computeStringWidth(g3.getFontMetrics(), data);
                    g3.setColor(AlchemistMoleculeTreeCellRenderer.getAccumulationColor(((AlchemistMoleculeTreeNode)node).getAccumulation()));
                    g3.fillRect(0, (int)Math.max(1.0f, zoomFactor), (int)Math.ceil((float)(width + 10) * ((AlchemistMoleculeTreeNode)node).getAccumulation()) + 1, (int)(13.0f * zoomFactor));
                    g3.setColor(Color.BLACK);
                    g3.drawString(data, 5.0f * zoomFactor, 12.0f * zoomFactor);
                    g3.setColor(Color.LIGHT_GRAY);
                    g3.drawRect(0, (int)Math.max(1.0f, zoomFactor), width + (int)(10.0f * zoomFactor), (int)(13.0f * zoomFactor));
                    g3.dispose();
                    left = (int)((float)left + (20.0f * zoomFactor + (float)width));
                }
                if (node.getParentID() == null) {
                    int lvl = ((AlchemistMoleculeTreeNode)node).getStabilityLevel();
                    if (lvl == 0) {
                        lvl = 1;
                    }
                    if (lvl != -1) {
                        Graphics2D g4 = (Graphics2D)g.create();
                        g4.translate(left, 0);
                        for (int i = 0; i < 5; ++i) {
                            if (lvl < i) {
                                g4.setColor(Color.LIGHT_GRAY);
                            } else {
                                g4.setColor(CATEGORY_COLOR[lvl]);
                            }
                            g4.fillRect(i * (int)Math.max(2.0f, 3.0f * zoomFactor), (int)(15.0f * zoomFactor) - (int)Math.max(1.0f, (float)(2 * (i + 1)) * zoomFactor), (int)Math.max(1.0f, 2.0f * zoomFactor), (int)Math.max(1.0f, (float)(2 * (i + 1)) * zoomFactor));
                        }
                        g4.dispose();
                        left = (int)((float)left + 20.0f * zoomFactor);
                    }
                }
            }
        }
    }

    private JPanel getToolPanel() {
        if (this.toolPanel == null) {
            this.toolPanel = new JPanel(){
                private static final long serialVersionUID = 3923336794931086306L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    AlchemistMoleculeTreeCellRenderer.paintToolBar((Graphics2D)g, AlchemistMoleculeTreeCellRenderer.this.getZoomFactor(), AlchemistMoleculeTreeCellRenderer.this.getNode());
                }
            };
            this.toolPanel.setBackground(Color.WHITE);
        }
        this.toolPanel.setPreferredSize(new Dimension(0, (int)(16.0f * this.getZoomFactor())));
        return this.toolPanel;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            CardLayout cl = new CardLayout();
            this.northPanel.setLayout(cl);
            this.northPanel.setOpaque(false);
            this.northPanel.add((Component)this.getLabelPanel(), COMPONENT_LABEL);
            this.northPanel.add((Component)this.getProgressBar(), COMPONENT_PROGRESSBAR);
            this.northPanel.setBorder(null);
        }
        return this.northPanel;
    }

    protected JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(){
                private static final long serialVersionUID = 3923336794931086306L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (AlchemistMoleculeTreeCellRenderer.this.bracketOnFocus && AlchemistMoleculeTreeCellRenderer.this.isFocused() || !AlchemistMoleculeTreeCellRenderer.this.bracketOnFocus && AlchemistMoleculeTreeCellRenderer.this.isSelected()) {
                        int leftBegin = 0;
                        int leftEnd = (int)(20.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor());
                        int rightEnd = AlchemistMoleculeTreeCellRenderer.this.getPanel().getWidth() - (int)(20.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor());
                        int rightBegin = AlchemistMoleculeTreeCellRenderer.this.getPanel().getWidth();
                        int topBegin = 0;
                        int topEnd = (int)(20.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor());
                        int bottomBegin = AlchemistMoleculeTreeCellRenderer.this.getPanel().getHeight();
                        int bottomEnd = AlchemistMoleculeTreeCellRenderer.this.getPanel().getHeight() - (int)(20.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor());
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.BLUE);
                        g2.fillRect(leftBegin, topBegin, leftEnd, topBegin + 2);
                        g2.fillRect(leftBegin, topBegin, leftBegin + 2, topEnd);
                        g2.fillRect(leftBegin, bottomEnd, leftBegin + 2, bottomBegin);
                        g2.fillRect(leftBegin, bottomBegin - 2, leftEnd, bottomBegin);
                        g2.fillRect(rightEnd, topBegin, rightBegin, topBegin + 2);
                        g2.fillRect(rightBegin - 2, topBegin, rightBegin, topEnd);
                        g2.fillRect(rightEnd, bottomBegin - 2, rightBegin, bottomBegin);
                        g2.fillRect(rightBegin - 2, bottomEnd, rightBegin, bottomBegin);
                        g2.dispose();
                    }
                }
            };
            this.panel.setLayout(new BorderLayout());
            this.panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.panel.setOpaque(false);
            this.panel.add((Component)this.getNorthPanel(), "North");
            this.panel.add((Component)this.getMoleculePanel(), "Center");
            this.panel.add((Component)this.getToolPanel(), "South");
        }
        return this.panel;
    }

    protected JPanel getMoleculePanel() {
        if (this.moleculePanel == null) {
            this.moleculePanel = new JPanel(){
                private static final long serialVersionUID = -7549502558243732264L;

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics g2;
                    super.paintComponent(g);
                    if (AlchemistMoleculeTreeCellRenderer.this.isShowNodeCaption() && AlchemistMoleculeTreeCellRenderer.this.isShowBorder()) {
                        g2 = (Graphics2D)g.create();
                        g2.setColor(AlchemistMoleculeTreeCellRenderer.this.getNodeColor(AlchemistMoleculeTreeCellRenderer.this.getNode()));
                        if (AlchemistMoleculeTreeCellRenderer.this.isExcluded()) {
                            g2.setColor(Color.LIGHT_GRAY);
                            ((Graphics2D)g2).setStroke(AlchemistGraphicsUtilities.DASHED_STROKE);
                            int x = AlchemistMoleculeTreeCellRenderer.this.isSelected() ? -2 : -2;
                            int y = 0;
                            int width = (int)(100.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor());
                            int height = AlchemistMoleculeTreeCellRenderer.this.isSelected() ? 2 : 2;
                            int thickness = 2;
                            for (int i = 0; i < thickness; ++i) {
                                g2.drawLine(x, y + i, x + width - 1, y + i);
                                g2.drawLine(x + i, y, x + i, y + height - 1);
                                g2.drawLine(x, y + height - i - 1, x + width, y + height - i - 1);
                                g2.drawLine(x + width - i - 1, y, x + width - i - 1, y + height - 1);
                            }
                        } else {
                            g2.fillRect(0, 0, (int)(100.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor()), AlchemistMoleculeTreeCellRenderer.this.isSelected() ? 2 : 2);
                        }
                        g2.dispose();
                    }
                    if (AlchemistMoleculeTreeCellRenderer.this.isShowMolecule() && AlchemistMoleculeTreeCellRenderer.this.getMolecule() != null) {
                        g2 = g.create();
                        g2.translate(2, 2);
                        if (AlchemistMoleculeTreeCellRenderer.this.dispOpts != -2 && AlchemistMoleculeTreeCellRenderer.this.dispOptsExt != -1) {
                            AlchemistMoleculePainter.drawMolecule(AlchemistMoleculeTreeCellRenderer.this.getMolecule(), g2, (int)(100.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor() - 4.0f), (int)(100.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor() - 4.0f), AlchemistMoleculeTreeCellRenderer.this.dispOpts, AlchemistMoleculeTreeCellRenderer.this.dispOptsExt);
                        } else {
                            AlchemistMoleculePainter.drawMolecule(AlchemistMoleculeTreeCellRenderer.this.getMolecule(), g2, (int)(100.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor() - 4.0f), (int)(100.0f * AlchemistMoleculeTreeCellRenderer.this.getZoomFactor() - 4.0f));
                        }
                        g2.dispose();
                    }
                    if (!AlchemistMoleculeTreeCellRenderer.this.isShowNodeCaption() && AlchemistMoleculeTreeCellRenderer.this.getNode() != null && AlchemistMoleculeTreeCellRenderer.this.getNode().isLoading()) {
                        g2 = (Graphics2D)g.create();
                        AlchemistMoleculeTreeCellRenderer.progressPainter((Graphics2D)g2, (int)AlchemistMoleculeTreeCellRenderer.this.getMoleculePanel().getPreferredSize().getWidth(), (int)AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getPreferredSize().getHeight(), AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getValue() > 0 && AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getMaximum() > 0 ? (int)((float)this.getWidth() * ((float)AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getValue() / (float)AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getMaximum())) : 0, AlchemistMoleculeTreeCellRenderer.this.getProgressBar().isStringPainted() ? AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getString() : null, AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getBackground(), AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getForeground(), AlchemistMoleculeTreeCellRenderer.this.getProgressBar().getFont(), AlchemistMoleculeTreeCellRenderer.this.getZoomFactor());
                        g2.dispose();
                    }
                }
            };
            this.moleculePanel.setOpaque(false);
            this.moleculePanel.setBorder(null);
        }
        return this.moleculePanel;
    }

    private void setComponentVisible(String component) {
        ((CardLayout)this.getNorthPanel().getLayout()).show(this.getNorthPanel(), component);
    }

    private static boolean getBooleanProperty(JTree tree, String propertyKey) {
        Object prop = tree.getClientProperty(propertyKey);
        if (prop != null) {
            if (prop instanceof Boolean) {
                Boolean bprop = (Boolean)prop;
                return bprop;
            }
            return false;
        }
        return false;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setNode(null);
        this.setSelected(selected);
        this.setFocused(hasFocus);
        Float zoom = (Float)tree.getClientProperty("zoomFactor");
        this.setZoomFactor(zoom == null ? 1.0f : zoom.floatValue());
        this.setShowMolecule(AlchemistMoleculeTreeCellRenderer.getBooleanProperty(tree, "moleculeVisible"));
        this.setShowNodeCaption(AlchemistMoleculeTreeCellRenderer.getBooleanProperty(tree, "nodeCaptionVisible"));
        boolean showToolPanel = AlchemistMoleculeTreeCellRenderer.getBooleanProperty(tree, "statusbarVisible");
        this.setShowBorder(AlchemistMoleculeTreeCellRenderer.getBooleanProperty(tree, "nodeBorderVisible"));
        this.colorMode = (AlchemistTreeView.BorderType)((Object)tree.getClientProperty("AlchemistTreeView_BorderType"));
        this.bracketOnFocus = AlchemistMoleculeTreeCellRenderer.getBooleanProperty(tree, "bracketOnFocus");
        Float minimum = (Float)tree.getClientProperty("AlchemistTreeView_MinorMetaboliteLimit");
        Float maximum = (Float)tree.getClientProperty("AlchemistTreeView_MajorMetaboliteLimit");
        this.minimumRange = minimum == null ? 0.1f : minimum.floatValue();
        float f = this.maximumRange = maximum == null ? 10.0f : maximum.floatValue();
        if (value instanceof AlchemistTreeNode) {
            this.setNode((AlchemistTreeNode)value);
        }
        if (this.getNode() != null) {
            this.setExcluded(this.getNode().isExcluded());
        }
        this.getProgressBar().setBackground(tree.getBackground());
        if (this.isShowBorder()) {
            if (this.colorMode != AlchemistTreeView.BorderType.NONE) {
                this.getPanel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.isExcluded() ? new AlchemistDashedBorder(Color.LIGHT_GRAY, 2) : BorderFactory.createLineBorder(this.getNodeColor(this.getNode()), selected ? 2 : 2)));
            } else {
                this.getPanel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.isExcluded() ? new AlchemistDashedBorder(Color.LIGHT_GRAY, 2) : BorderFactory.createLineBorder(selected ? Color.RED : Color.BLACK, 2)));
            }
        } else {
            this.getPanel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.isExcluded() ? new AlchemistDashedBorder(tree.getBackground(), 2) : BorderFactory.createLineBorder(tree.getBackground(), selected ? 2 : 2)));
        }
        if (!this.isShowMolecule() && !this.isShowNodeCaption()) {
            this.getPanel().setPreferredSize(new Dimension((int)(100.0f * this.getZoomFactor() + 8.0f), (int)(20.0f * this.getZoomFactor() + 8.0f)));
            this.getNorthPanel().setVisible(false);
            this.getMoleculePanel().setVisible(false);
        } else if (this.isShowMolecule() && !this.isShowNodeCaption()) {
            if (this.getNode() != null) {
                this.setMolecule(this.getNode().getMolecule());
            }
            this.getMoleculePanel().setPreferredSize(new Dimension((int)(100.0f * this.getZoomFactor() + 4.0f), (int)(100.0f * this.getZoomFactor() + 4.0f)));
            if (selected) {
                this.getMoleculePanel().setBackground(Color.LIGHT_GRAY);
            }
            this.getPanel().setPreferredSize(new Dimension((int)(100.0f * this.getZoomFactor() + 8.0f), (int)(100.0f * this.getZoomFactor() + 8.0f)));
            this.getMoleculePanel().setVisible(true);
            this.getNorthPanel().setVisible(false);
        } else if (!this.isShowMolecule() && this.isShowNodeCaption()) {
            this.getPanel().setPreferredSize(new Dimension((int)(100.0f * this.getZoomFactor() + 8.0f), (int)(20.0f * this.getZoomFactor() + 8.0f)));
            this.getMoleculePanel().setVisible(false);
            this.getNorthPanel().setVisible(true);
        } else {
            this.setMolecule(this.getNode().getMolecule());
            this.getMoleculePanel().setPreferredSize(new Dimension((int)(100.0f * this.getZoomFactor() + 4.0f), (int)(100.0f * this.getZoomFactor() + 4.0f)));
            if (selected) {
                this.getMoleculePanel().setBackground(Color.LIGHT_GRAY);
            }
            this.getPanel().setPreferredSize(new Dimension((int)(100.0f * this.getZoomFactor() + 8.0f), (int)(120.0f * this.getZoomFactor() + 8.0f)));
            this.getMoleculePanel().setVisible(true);
            this.getNorthPanel().setVisible(true);
        }
        if (showToolPanel) {
            Dimension dim = this.getPanel().getPreferredSize();
            dim.height += (int)(16.0f * this.getZoomFactor());
            this.getPanel().setPreferredSize(dim);
            this.getToolPanel().setVisible(true);
        } else {
            this.getToolPanel().setVisible(false);
        }
        this.getNorthPanel().setPreferredSize(new Dimension((int)(100.0f * this.getZoomFactor() + 4.0f), (int)(20.0f * this.getZoomFactor())));
        if (this.getNode() != null) {
            if (this.getNode().isLoading()) {
                this.getProgressBar().setValue(this.getNode().getLoadPercentage());
                this.getProgressBar().setString("Loading: " + (int)(this.getProgressBar().getPercentComplete() * 100.0) + "%");
                this.setComponentVisible(COMPONENT_PROGRESSBAR);
            } else {
                this.setLabelImage(AlchemistMoleculeTreeCellRenderer.getFullTextLabelImage(this.getNode(), tree, this.getZoomFactor(), selected, true));
                this.setComponentVisible(COMPONENT_LABEL);
            }
        }
        return this.getPanel();
    }

    protected void setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    protected float getZoomFactor() {
        return this.zoomFactor;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setLabelImage(BufferedImage labelImage) {
        this.labelImage = labelImage;
    }

    public BufferedImage getLabelImage() {
        return this.labelImage;
    }

    public void setNode(AlchemistTreeNode node) {
        this.node = node;
    }

    public AlchemistTreeNode getNode() {
        return this.node;
    }

    public void setShowNodeCaption(boolean showNodeCaption) {
        this.showNodeCaption = showNodeCaption;
    }

    public boolean isShowNodeCaption() {
        return this.showNodeCaption;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setExcluded(boolean isExcluded) {
        this.isExcluded = isExcluded;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public void setShowMolecule(boolean showMolecule) {
        this.showMolecule = showMolecule;
    }

    public boolean isShowMolecule() {
        return this.showMolecule;
    }

    public void setMolecule(Molecule molecule) {
        this.molecule = molecule;
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public int getDispOpts() {
        return this.dispOpts;
    }

    public int getDispOptsExt() {
        return this.dispOptsExt;
    }

    public void setDispOpts(int opt) {
        this.dispOpts = opt;
    }

    public void setDispOptsExt(int opt) {
        this.dispOptsExt = opt;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }
}

