/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer.moleculetree;

import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;

public class AlchemistMoleculeTreeNode
extends AlchemistTreeNode {
    private static final String SEPARATOR = "\",";
    private static final long serialVersionUID = -518836374221676074L;
    private static final String DEFAULT_MOLECULE_FORMAT = "smiles:q";
    private final String moleculeFormat;
    private String moleculeName = null;
    private static final String[] SAVED_PROPERTIES = new String[]{"Synthesis Code", "METABOLIZER_PARENTSYNTHESISCODE", "CHILDDEPTH", "METABOLIZER_SYNTHESISLEVEL", "ACCUMULATION", "PRODUCTION", "TRANSMISSIVITY", "EXACT_MASS", "STABILITY", "PARENTS", "SPEED_CATEGORY", "METABOLIC_TREE_COUNT"};

    public AlchemistMoleculeTreeNode(Molecule molecule) {
        this(molecule, DEFAULT_MOLECULE_FORMAT);
    }

    public AlchemistMoleculeTreeNode(Molecule molecule, String format2) {
        this.moleculeFormat = format2;
        this.setMolecule(molecule);
    }

    public AlchemistMoleculeTreeNode(String uniqueID) {
        this(new Molecule());
        this.properties.put("Synthesis Code", uniqueID);
    }

    public Molecule getReaction() {
        Molecule mol = new Molecule();
        try {
            if (this.getUserObject() != null) {
                mol = MolImporter.importMol(String.valueOf(this.getUserObject()));
            }
        }
        catch (MolFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < SAVED_PROPERTIES.length; ++i) {
            mol.setProperty(SAVED_PROPERTIES[i], (String)this.properties.get(SAVED_PROPERTIES[i]));
        }
        return mol;
    }

    @Override
    public Molecule getMolecule() {
        Molecule mol = new Molecule();
        try {
            if (this.getUserObject() != null && (mol = MolImporter.importMol(String.valueOf(this.getUserObject()))).isReaction() && RxnMolecule.getReaction(mol).getProduct(0) != null) {
                mol = RxnMolecule.getReaction(mol).getProduct(0);
            }
        }
        catch (MolFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < SAVED_PROPERTIES.length; ++i) {
            mol.setProperty(SAVED_PROPERTIES[i], (String)this.properties.get(SAVED_PROPERTIES[i]));
        }
        return mol;
    }

    @Override
    public void setMolecule(Molecule molecule) {
        this.setUserObject(molecule.toFormat(this.moleculeFormat));
        for (int i = 0; i < SAVED_PROPERTIES.length; ++i) {
            this.properties.put(SAVED_PROPERTIES[i], molecule.getProperty(SAVED_PROPERTIES[i]));
        }
        Molecule mol = molecule;
        if (mol.isReaction() && RxnMolecule.getReaction(mol).getProduct(0) != null) {
            mol = RxnMolecule.getReaction(mol).getProduct(0);
        }
        this.properties.put("EXACT_MASS", String.valueOf(mol.getExactMass()));
    }

    public int getPropertyInt(String key) {
        String prop = (String)this.properties.get(key);
        try {
            return prop != null ? Integer.parseInt(prop) : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getPropertyFloat(String key) {
        String prop = (String)this.properties.get(key);
        try {
            return prop != null ? Float.parseFloat(prop) : 0.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setProperty(String key, int value) {
        this.properties.put(key, String.valueOf(value));
    }

    public void setProperty(String key, float value) {
        this.properties.put(key, String.valueOf(value));
    }

    @Override
    public String getParentID() {
        return (String)this.properties.get("METABOLIZER_PARENTSYNTHESISCODE");
    }

    @Override
    public void setParentID(String parentID) {
        this.properties.put("METABOLIZER_PARENTSYNTHESISCODE", parentID);
    }

    @Override
    public void setChildrenDepth(int depth) {
        this.setProperty("CHILDDEPTH", depth);
    }

    @Override
    public int getChildrenDepth() {
        return this.getPropertyInt("CHILDDEPTH");
    }

    @Override
    public String getUniqueID() {
        return this.getProperty("Synthesis Code");
    }

    @Override
    public void setUniqueID(String uniqueID) {
        this.setProperty("Synthesis Code", uniqueID);
    }

    public int getSynthesisLevel() {
        return this.getPropertyInt("METABOLIZER_SYNTHESISLEVEL");
    }

    public int getStabilityLevel() {
        String stab = this.getProperty("STABILITY");
        if (stab != null) {
            try {
                return Integer.parseInt(stab);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public float getAccumulation() {
        return this.getPropertyFloat("ACCUMULATION");
    }

    public void setAccumulation(float value) {
        this.setProperty("ACCUMULATION", value);
    }

    public float getProduction() {
        return this.getPropertyFloat("PRODUCTION");
    }

    public void setProduction(float value) {
        this.setProperty("PRODUCTION", value);
    }

    public String getTreeRootSynthesisCode() {
        return this.getProperty("METABOLIC_TREE_COUNT");
    }

    public void setTreeRootSynthesisCode(String treeRootSynthesisCode) {
        this.setProperty("METABOLIC_TREE_COUNT", treeRootSynthesisCode);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(95);
        buff.append(this.getClass().getName());
        buff.append("[molecule=\"");
        buff.append(String.valueOf(this.getUserObject()));
        buff.append(SEPARATOR);
        for (String name : this.properties.keySet()) {
            buff.append(name + "=\"" + (String)this.properties.get(name) + "\", ");
        }
        buff.append("isExcluded=\"" + this.isExcluded() + SEPARATOR);
        buff.append("isLoading=\"" + this.isLoading() + SEPARATOR);
        buff.append("loadPercentage=\"" + this.getLoadPercentage() + SEPARATOR);
        buff.append("isChildrenLoaded=\"" + this.isChildrenLoaded() + "\"]");
        return buff.toString();
    }

    public String getMoleculeName() {
        if (this.moleculeName == null) {
            this.moleculeName = this.getMolecule().toFormat("name");
        }
        return this.moleculeName;
    }
}

