/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer.moleculetree;

import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeCellRenderer;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeNode;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeViewDataProvider;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeViewInteractiveDataProvider;
import chemaxon.alchemist.metabolizer.moleculetree.IterableDefaultTreeModel;
import chemaxon.alchemist.metabolizer.moleculetree.export.MoleculeTreeExporter;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistLinearMoleculeView;
import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.moleculetree.AlchemistMoleculeTree;
import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.alchemist.utils.moleculetree.TreeDataProvider;
import chemaxon.marvin.beans.MViewPane;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.metabolizer.MetabolizerCalculator;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.metabolizer.MetabolizerUtilities;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class AlchemistTreeView
extends JPanel {
    private static final String EXPORT_FILE_EXISTS = "The selected file '%s' already exists.\nDo you want to overwrite?";
    private static final String EXPORT_FILE_EXISTS_TITLE = "File already exists";
    @Deprecated
    public static final String PROPERTY_KEY_TREE_ZOOM_FACTOR = "zoomFactor";
    @Deprecated
    public static final String PROPERTY_KEY_NODE_IS_LOADING = "nodeLoading";
    public static final String PROPERTY_KEY_LAST_EXPORT_PATH = "AlchemistTreeView_LastExportPath";
    @Deprecated
    public static final String PROPERTY_KEY_SHOW_NODE_CAPTION = "nodeCaptionVisible";
    public static final String PROPERTY_KEY_NODE_CAPTION_DATA = "AlchemistTreeView_NodeCaptionData";
    @Deprecated
    public static final String PROPERTY_KEY_SHOW_MOLECULE = "moleculeVisible";
    @Deprecated
    public static final String PROPERTY_KEY_MAGNIFIER_MODE = "magnifierEnabled";
    @Deprecated
    public static final String PROPERTY_KEY_DETAILED_MODE = "detailsEnabled";
    public static final String PROPERTY_KEY_SHOW_FRAME_TITLES = "AlchemistTreeView_ShowFrameTitles";
    public static final String PROPERTY_KEY_BORDER_TYPE = "AlchemistTreeView_BorderType";
    @Deprecated
    public static final String PROPERTY_KEY_SHOW_STATUSBAR = "statusbarVisible";
    @Deprecated
    public static final String PROPERTY_KEY_SHOW_STEP_LINES = "stepLinesVisible";
    @Deprecated
    public static final String PROPERTY_KEY_SHOW_NODE_LINES = "nodeLinesVisible";
    @Deprecated
    public static final String PROPERTY_KEY_SHOW_BORDER = "nodeBorderVisible";
    public static final String PROPERTY_KEY_SHOW_EXCLUDED = "AlchemistTreeView_ShowExluded";
    public static final String PROPERTY_KEY_MAJOR_METABOLITE_LIMIT = "AlchemistTreeView_MajorMetaboliteLimit";
    public static final String PROPERTY_KEY_MINOR_METABOLITE_LIMIT = "AlchemistTreeView_MinorMetaboliteLimit";
    public static final String PROPERTY_KEY_METABOLITE_LIST_MODE = "AlchemistTreeView_MetaboliteListMode";
    @Deprecated
    public static final String ROOT_UNIQUE_ID = "GLOBAL_ROOT";
    private static final String MAJOR_VIEW = "majorView";
    private static final String FINAL_VIEW = "finalView";
    private static final long serialVersionUID = 8270274134894436322L;
    private JSplitPane horizontalSplit = null;
    private JSplitPane verticalSplit = null;
    private AlchemistLinearMoleculeView majorMetabolitesView = null;
    private AlchemistLinearMoleculeView finalMetabolitesView = null;
    protected boolean synchingMajorView = false;
    protected boolean synchingFinalView = false;
    private JPanel mainPanel = null;
    private AlchemistLinearMoleculeView metabolicPathwayView = null;
    private MoleculeTreeImpl moleculeTree = null;
    private boolean frameTitlesVisible = true;
    private MViewPane cornerView = null;
    private final Object cancelMutex = new Object();
    protected Object majorCalcMetabolizerMutex = new Object();
    private MetabolizerUtilities majorCalculationMetabolizerUtilities = null;
    private AlchemistFileChooserForJChem exportFileChooser = null;
    private AlchemistState state = null;
    private JSplitPane rightPanel = null;
    private boolean cancelLoad;
    private final List<ExcludedNode> excludeList = new ArrayList<ExcludedNode>();
    private JLabel treeTitle = null;
    private JLabel pathTitle = null;
    private JLabel majorTitle = null;
    private JLabel selectedTitle = null;
    private JPopupMenu majorTitleSelectorMenu = null;
    private JPanel rightListMetabolitesViewPanel = null;

    public AlchemistTreeView() {
        this((AlchemistState)null);
    }

    public AlchemistTreeView(AlchemistState state) {
        this.state = state;
        this.majorCalculationMetabolizerUtilities = new MetabolizerUtilities();
        this.initialize();
    }

    private void initialize() {
        this.setMoleculesVisible(true);
        this.setSeparatorLinesVisible(true);
        this.setNodeLinesVisible(true);
        this.setNodeStatusBarVisible(true);
        this.setFrameTitlesVisible(true);
        this.setNodeBorderVisible(true);
        this.setBorderType(BorderType.HIGHEST_ACCUMULATION);
        this.setNodeCaptionDataType(NodeCaptionDataType.SYNTHESISCODE);
        this.setExcludedNodesVisible(true);
        this.setDetailedMode(true);
        this.setMetaboliteListMode(MetaboliteListMode.MAJOR);
        this.getMoleculeTree().addPropertyToDetails("ACCUMULATION", "Accumulation");
        this.getMoleculeTree().addPropertyToDetails("PRODUCTION", "Production");
        this.getMoleculeTree().addPropertyToDetails("TRANSMISSIVITY", "Transmissivity");
        this.getMoleculeTree().addPropertyToDetails("STABILITY", "Stability");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(382, 251));
        this.add((Component)this.getHorizontalSplit(), "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlchemistTreeView.this.getHorizontalSplit().setDividerLocation(1.0);
            }
        });
        try {
            this.setExportFileChooser(new AlchemistFileChooserForJChem());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected JSplitPane getHorizontalSplit() {
        if (this.horizontalSplit == null) {
            this.horizontalSplit = new JSplitPane();
            this.horizontalSplit.setBorder(null);
            BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.horizontalSplit.getUI()).getDivider();
            divider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
            this.horizontalSplit.setOneTouchExpandable(true);
            this.horizontalSplit.setResizeWeight(1.0);
            this.horizontalSplit.setRightComponent(this.getRightPanel());
            this.horizontalSplit.setLeftComponent(this.getVerticalSplit());
        }
        return this.horizontalSplit;
    }

    protected JSplitPane getVerticalSplit() {
        if (this.verticalSplit == null) {
            this.verticalSplit = new JSplitPane();
            this.verticalSplit.setBorder(null);
            BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.verticalSplit.getUI()).getDivider();
            divider.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.GRAY));
            this.verticalSplit.setOrientation(0);
            JPanel topComponent = new JPanel(new BorderLayout());
            topComponent.add((Component)this.getTreeTitle(), "North");
            topComponent.add((Component)this.getMainPanel(), "Center");
            JPanel bottomComponent = new JPanel(new BorderLayout());
            bottomComponent.add((Component)this.getPathTitle(), "North");
            bottomComponent.add((Component)this.getMetabolicPathwayView(), "Center");
            this.verticalSplit.setTopComponent(topComponent);
            this.verticalSplit.setBottomComponent(bottomComponent);
            this.verticalSplit.setResizeWeight(1.0);
            this.verticalSplit.addPropertyChangeListener("lastDividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (AlchemistTreeView.this.getRightPanel().getDividerLocation() != AlchemistTreeView.this.getVerticalSplit().getDividerLocation()) {
                        AlchemistTreeView.this.getRightPanel().setDividerLocation(AlchemistTreeView.this.getVerticalSplit().getDividerLocation());
                    }
                }
            });
        }
        return this.verticalSplit;
    }

    protected AlchemistLinearMoleculeView getMajorMetabolitesView() {
        if (this.majorMetabolitesView == null) {
            this.majorMetabolitesView = new AlchemistLinearMoleculeView(0);
            this.majorMetabolitesView.setBackground(new Color(this.getMoleculeTree().getBackground().getRGB()));
            this.majorMetabolitesView.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
            this.majorMetabolitesView.setMinimumSize(new Dimension(100, 0));
            this.majorMetabolitesView.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlchemistTreeView.this.getMajorMetabolitesView().redoLayout();
                        }
                    });
                }
            });
            this.majorMetabolitesView.setSelectable(true);
            this.majorMetabolitesView.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        AlchemistTreeView.this.synchTreeSelectionWithMajorView(AlchemistTreeView.this.getMajorMetabolitesView());
                    }
                }
            });
        }
        return this.majorMetabolitesView;
    }

    protected AlchemistLinearMoleculeView getFinalMetabolitesView() {
        if (this.finalMetabolitesView == null) {
            this.finalMetabolitesView = new AlchemistLinearMoleculeView(0);
            this.finalMetabolitesView.setBackground(new Color(this.getMoleculeTree().getBackground().getRGB()));
            this.finalMetabolitesView.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
            this.finalMetabolitesView.setMinimumSize(new Dimension(100, 0));
            this.finalMetabolitesView.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlchemistTreeView.this.getFinalMetabolitesView().redoLayout();
                        }
                    });
                }
            });
            this.finalMetabolitesView.setSelectable(true);
            this.finalMetabolitesView.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        AlchemistTreeView.this.synchTreeSelectionWithFinalView(AlchemistTreeView.this.getFinalMetabolitesView());
                    }
                }
            });
        }
        return this.finalMetabolitesView;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setPreferredSize(new Dimension(500, 500));
            this.mainPanel.setLayout(new BorderLayout());
            JScrollPane scroll = new JScrollPane();
            scroll.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
            scroll.setViewportView(this.getMoleculeTree());
            AdjustmentListener adjListener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    AlchemistTreeView.this.getMoleculeTree().gatherVisibleNodes();
                }
            };
            scroll.setHorizontalScrollBarPolicy(32);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getHorizontalScrollBar().addAdjustmentListener(adjListener);
            scroll.getVerticalScrollBar().addAdjustmentListener(adjListener);
            this.mainPanel.add((Component)scroll, "Center");
        }
        return this.mainPanel;
    }

    protected AlchemistLinearMoleculeView getMetabolicPathwayView() {
        if (this.metabolicPathwayView == null) {
            this.metabolicPathwayView = new AlchemistLinearMoleculeView(1);
            this.metabolicPathwayView.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
            this.metabolicPathwayView.setBackground(new Color(this.getMoleculeTree().getBackground().getRGB()));
            this.metabolicPathwayView.setMinimumSize(new Dimension(0, 100));
            this.metabolicPathwayView.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlchemistTreeView.this.getMetabolicPathwayView().redoLayout();
                        }
                    });
                }
            });
            this.metabolicPathwayView.setShowArrows(true);
        }
        return this.metabolicPathwayView;
    }

    public Iterator<Molecule> iterator() {
        return ((IterableDefaultTreeModel)this.getModel()).moleculeIterator();
    }

    @Override
    public Color getBackground() {
        return this.getMoleculeTree().getBackground();
    }

    @Override
    public void setBackground(Color bg) {
        this.getMoleculeTree().setBackground(bg);
    }

    public MoleculeTreeImpl getMoleculeTree() {
        if (this.moleculeTree == null) {
            this.moleculeTree = new MoleculeTreeImpl();
            this.moleculeTree.putClientProperty(PROPERTY_KEY_MAJOR_METABOLITE_LIMIT, new Float(10.0f));
            this.moleculeTree.putClientProperty(PROPERTY_KEY_MINOR_METABOLITE_LIMIT, new Float(0.1f));
            this.moleculeTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getNewLeadSelectionPath();
                    if (path != null) {
                        Object[] obj = path.getPath();
                        LinkedList<Molecule> list = new LinkedList<Molecule>();
                        for (int i = 1; i < obj.length; ++i) {
                            AlchemistMoleculeTreeNode node = (AlchemistMoleculeTreeNode)obj[i];
                            Molecule mol = node.getMolecule();
                            list.add(mol);
                            if (i + 1 != obj.length) continue;
                            AlchemistTreeView.this.getCornerView().setM(0, mol);
                        }
                        String[] reactionNames = AlchemistTreeView.this.getMoleculeTree().getNodeIDsFromRoot((AlchemistMoleculeTreeNode)path.getLastPathComponent());
                        HashMap<String, String> rNameMap = new HashMap<String, String>();
                        for (int i = 0; i < reactionNames.length; ++i) {
                            String name = reactionNames[i];
                            if (AlchemistTreeView.this.getMoleculeTree().getZoneLabelMap().containsKey(reactionNames[i])) {
                                name = AlchemistTreeView.this.getMoleculeTree().getZoneLabelMap().get(reactionNames[i]);
                            }
                            rNameMap.put(reactionNames[i], name);
                        }
                        AlchemistTreeView.this.getMetabolicPathwayView().setMoleculeList(list, rNameMap, reactionNames);
                        TreePath[] selPaths = e.getPaths();
                        String[] selectedNodeIDS = new String[selPaths.length];
                        for (int i = 0; i < selectedNodeIDS.length; ++i) {
                            selectedNodeIDS[i] = ((AlchemistMoleculeTreeNode)selPaths[i].getLastPathComponent()).getUniqueID();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AlchemistTreeView.this.synchTreeSelectionWithFinalView(AlchemistTreeView.this.getMoleculeTree());
                                AlchemistTreeView.this.synchTreeSelectionWithMajorView(AlchemistTreeView.this.getMoleculeTree());
                            }
                        });
                    }
                }
            });
            this.moleculeTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        AlchemistTreeNode node = AlchemistTreeView.this.moleculeTree.getSelectedReactionNode();
                        if (node instanceof AlchemistMoleculeTreeNode) {
                            Molecule mol = ((AlchemistMoleculeTreeNode)node).getReaction();
                            mol.clean(2, null);
                            AlchemistTreeView.this.getCornerView().setM(0, mol);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AlchemistTreeView.this.synchTreeSelectionWithFinalView(AlchemistTreeView.this.getMoleculeTree());
                                AlchemistTreeView.this.synchTreeSelectionWithMajorView(AlchemistTreeView.this.getMoleculeTree());
                            }
                        });
                    }
                }
            });
            this.moleculeTree.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AlchemistTreeView.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            });
        }
        return this.moleculeTree;
    }

    protected String[] getTreeSelectionIDs(boolean sort) {
        TreePath[] spaths = this.getMoleculeTree().getSelectionPaths();
        Object[] treeIDs = new String[spaths == null ? 0 : spaths.length];
        for (int i = 0; i < treeIDs.length; ++i) {
            treeIDs[i] = ((AlchemistMoleculeTreeNode)spaths[i].getLastPathComponent()).getUniqueID();
        }
        if (sort) {
            Arrays.sort(treeIDs);
        }
        return treeIDs;
    }

    protected String[] getLinearViewSelectionIDs(AlchemistLinearMoleculeView view, boolean sort) {
        Molecule[] mols = view.getSelectedValues();
        Object[] ids = new String[mols.length];
        for (int i = 0; i < mols.length; ++i) {
            ids[i] = mols[i].getProperty("Synthesis Code");
        }
        if (sort) {
            Arrays.sort(ids);
        }
        return ids;
    }

    protected String[] getLinearViewIDs(AlchemistLinearMoleculeView view, boolean sort) {
        List<Molecule> mols = view.getMoleculeList();
        Object[] ids = new String[mols == null ? 0 : mols.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = mols.get(i).getProperty("Synthesis Code");
        }
        Arrays.sort(ids);
        return ids;
    }

    protected synchronized void synchTreeSelectionWithLinearView(Object source, AlchemistLinearMoleculeView linearView) {
        String[] selViewIDs;
        String[] treeIDs = this.getTreeSelectionIDs(true);
        boolean eq = treeIDs.length == (selViewIDs = this.getLinearViewSelectionIDs(linearView, true)).length;
        for (int i = 0; i < selViewIDs.length && eq; ++i) {
            eq = selViewIDs[i].equals(treeIDs[i]);
        }
        if (eq) {
            return;
        }
        String[] viewIDs = this.getLinearViewIDs(linearView, true);
        if (source == this.getMoleculeTree()) {
            List<String> viewList = Arrays.asList(viewIDs);
            ArrayList<String> matches = new ArrayList<String>();
            for (int i = 0; i < treeIDs.length; ++i) {
                if (Collections.binarySearch(viewList, treeIDs[i]) < 0) continue;
                matches.add(treeIDs[i]);
            }
            int[] indexes = new int[matches.size()];
            List<String> idList = Arrays.asList(this.getLinearViewIDs(linearView, false));
            int idx = 0;
            for (int i = 0; i < matches.size(); ++i) {
                int pos = Collections.binarySearch(idList, matches.get(i));
                if (pos < 0) continue;
                indexes[idx++] = pos;
            }
            linearView.setAdjusting(true);
            linearView.setSelectedIndexes(indexes);
            linearView.setAdjusting(false);
        } else if (source.equals(linearView)) {
            ArrayList<TreePath> matches = new ArrayList<TreePath>();
            for (int i = 0; i < selViewIDs.length; ++i) {
                AlchemistTreeNode node = this.getMoleculeTree().getNode(selViewIDs[i]);
                if (node == null) continue;
                matches.add(new TreePath(node.getPath()));
            }
            this.getMoleculeTree().setSelectionPaths(matches.toArray(new TreePath[0]));
            this.getMoleculeTree().scrollPathToVisible(this.getSelectionPath());
        }
    }

    protected void synchTreeSelectionWithMajorView(Object source) {
        this.synchTreeSelectionWithLinearView(source, this.getMajorMetabolitesView());
    }

    protected void synchTreeSelectionWithFinalView(Object source) {
        this.synchTreeSelectionWithLinearView(source, this.getFinalMetabolitesView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Molecule[] getMajorMetabolites() {
        Molecule[] mols = null;
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            List<Molecule> list = this.getMajorMetabolitesView().getMoleculeList();
            mols = list.toArray(new Molecule[0]);
        }
        return mols;
    }

    protected MViewPane getCornerView() {
        if (this.cornerView == null) {
            this.cornerView = new MViewPane();
            this.cornerView.setMinimumSize(new Dimension(100, 100));
            this.cornerView.setPreferredSize(new Dimension(100, 100));
            this.cornerView.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        }
        return this.cornerView;
    }

    public synchronized void addNodes(AlchemistTreeNode[] nodeArray) {
        this.getMoleculeTree().addNodes(nodeArray);
    }

    public void removeNodeFromParent(AlchemistTreeNode node) {
        ((IterableDefaultTreeModel)this.getModel()).removeNodeFromParent(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataProvider(final AlchemistTreeViewDataProvider provider, final AlchemistTreeNode[] nodes) {
        this.cancelLoad = false;
        this.getMoleculeTree().setDataProvider(provider);
        try {
            provider.open();
            Object object = this.cancelMutex;
            synchronized (object) {
                if (!this.cancelLoad) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            AlchemistTreeNode[] nodesArray = nodes;
                            try {
                                if (nodesArray == null) {
                                    nodesArray = provider.getTreeData(null, AlchemistTreeView.this.getMoleculeTree().getProgressMonitor());
                                }
                            }
                            catch (IOException e) {
                                AlchemistErrorDialog.showError("Data provider exception", (Exception)e);
                            }
                            if (!Thread.currentThread().isInterrupted()) {
                                if (nodesArray != null) {
                                    AlchemistTreeView.this.addNodes(nodesArray);
                                }
                                AlchemistTreeView.this.expandPath(new TreePath(AlchemistTreeView.this.getModel().getRoot()));
                            }
                        }
                    });
                    thread.setPriority(4);
                    thread.start();
                }
            }
        }
        catch (IOException e) {
            AlchemistErrorDialog.showError("Data provider exception", (Exception)e);
        }
    }

    public void setDataProvider(AlchemistTreeViewDataProvider provider) {
        this.setDataProvider(provider, null);
    }

    @Deprecated
    public void interrupt() {
    }

    public void close() {
        this.getMoleculeTree().clear();
        this.cornerView.setM(0, new Molecule());
        this.metabolicPathwayView.setMoleculeList(null);
        this.majorMetabolitesView.setMoleculeList(null);
    }

    private JPanel getRightListMetabolitesViewPanel() {
        if (this.rightListMetabolitesViewPanel == null) {
            CardLayout cc = new CardLayout();
            this.rightListMetabolitesViewPanel = new JPanel(cc);
            this.rightListMetabolitesViewPanel.add((Component)this.getMajorMetabolitesView(), MAJOR_VIEW);
            this.rightListMetabolitesViewPanel.add((Component)this.getFinalMetabolitesView(), FINAL_VIEW);
            cc.show(this.rightListMetabolitesViewPanel, this.getMetaboliteListMode() == MetaboliteListMode.MAJOR ? MAJOR_VIEW : FINAL_VIEW);
        }
        return this.rightListMetabolitesViewPanel;
    }

    protected JSplitPane getRightPanel() {
        if (this.rightPanel == null) {
            this.rightPanel = new JSplitPane();
            BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.rightPanel.getUI()).getDivider();
            divider.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY));
            this.rightPanel.setBorder(null);
            this.rightPanel.setOrientation(0);
            JPanel topComponent = new JPanel(new BorderLayout());
            topComponent.add((Component)this.getMajorTitle(), "North");
            topComponent.add((Component)this.getRightListMetabolitesViewPanel(), "Center");
            JPanel bottomComponent = new JPanel(new BorderLayout());
            bottomComponent.add((Component)this.getSelectedTitle(), "North");
            bottomComponent.add((Component)this.getCornerView(), "Center");
            this.rightPanel.setTopComponent(topComponent);
            this.rightPanel.setBottomComponent(bottomComponent);
            this.rightPanel.setResizeWeight(1.0);
            this.rightPanel.addPropertyChangeListener("lastDividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (AlchemistTreeView.this.getRightPanel().getDividerLocation() != AlchemistTreeView.this.getVerticalSplit().getDividerLocation()) {
                        AlchemistTreeView.this.getVerticalSplit().setDividerLocation(AlchemistTreeView.this.getRightPanel().getDividerLocation());
                    }
                }
            });
        }
        return this.rightPanel;
    }

    public void setMoleculesVisible(boolean visible) {
        this.getMoleculeTree().setNodeMoleculeVisible(visible);
    }

    public boolean isMoleculesVisible() {
        return this.getMoleculeTree().isNodeMoleculeVisible();
    }

    public void toggleMoleculesVisible() {
        this.getMoleculeTree().setNodeMoleculeVisible(!this.getMoleculeTree().isNodeMoleculeVisible());
    }

    public boolean isNodeBorderVisible() {
        return this.getMoleculeTree().isNodeBorderVisible();
    }

    public void setNodeBorderVisible(boolean visible) {
        this.getMoleculeTree().setNodeBorderVisible(visible);
    }

    public void toggleNodeBorderVisible() {
        this.setNodeBorderVisible(!this.isNodeBorderVisible());
    }

    public void toggleMagnifierMode() {
        this.getMoleculeTree().setMagnifierEnabled(!this.getMoleculeTree().isMagnifierEnabled());
    }

    public boolean isMagnifierMode() {
        return this.getMoleculeTree().isMagnifierEnabled();
    }

    public void setMagnifierMode(boolean enabled) {
        this.getMoleculeTree().setMagnifierEnabled(enabled);
    }

    public void setDetailedMode(boolean enabled) {
        this.getMoleculeTree().setDetailsEnabled(enabled);
    }

    public boolean isDetailedMode() {
        return this.getMoleculeTree().isDetailsEnabled();
    }

    public void toggleDetailedMode() {
        this.setDetailedMode(!this.isDetailedMode());
    }

    public void setSeparatorLinesVisible(boolean visible) {
        this.getMoleculeTree().setStepLineVisible(visible);
    }

    public boolean isSeparatorLinesVisible() {
        return this.getMoleculeTree().isStepLineVisible();
    }

    public void toggleSeparatorLinesVisible() {
        this.setSeparatorLinesVisible(!this.isSeparatorLinesVisible());
    }

    public void setNodeStatusBarVisible(boolean visible) {
        this.getMoleculeTree().setNodeStatusbarVisible(true);
    }

    public boolean isNodeStatusBarVisible() {
        return this.getMoleculeTree().isNodeStatusbarVisible();
    }

    public void toggleNodeStatusBarVisible() {
        this.setNodeStatusBarVisible(!this.isNodeStatusBarVisible());
    }

    public void setNodeLinesVisible(boolean visible) {
        this.getMoleculeTree().setNodeLineVisible(visible);
    }

    public boolean isNodeLinesVisible() {
        return this.getMoleculeTree().isNodeLineVisible();
    }

    public void setNodeCaptionVisible(boolean visible) {
        this.getMoleculeTree().setNodeCaptionVisible(visible);
    }

    public boolean isNodeCaptionVisible() {
        return this.getMoleculeTree().isNodeCaptionVisible();
    }

    public void toggleNodeLinesVisible() {
        this.setNodeLinesVisible(!this.isNodeLinesVisible());
    }

    public void toggleNodeCaptionVisible() {
        this.setNodeCaptionVisible(!this.isNodeCaptionVisible());
    }

    @Deprecated
    public void increaseZoom(int percent) {
        float newValue = this.getMoleculeTree().getZoomFactor() + (float)percent / 100.0f;
        if (newValue > 2.0f) {
            newValue = 2.0f;
        }
        this.setZoom(newValue);
    }

    @Deprecated
    public void decreaseZoom(int percent) {
        float newValue = this.getMoleculeTree().getZoomFactor() - (float)percent / 100.0f;
        if (newValue < 0.1f) {
            newValue = 0.1f;
        }
        this.setZoom(newValue);
    }

    public void resetZoom() {
        this.getMoleculeTree().setZoomFactor(1.0f);
    }

    public void setZoom(float zoom) {
        this.getMoleculeTree().setZoomFactor(zoom);
    }

    public AlchemistProgressMonitor getProgressMonitor() {
        return this.getMoleculeTree().getProgressMonitor();
    }

    public void setReactionNameMap(Map<String, String> reactionNamesMap) {
        this.getMoleculeTree().setZoneLabelMap(reactionNamesMap);
    }

    public void collapseAll() {
        this.getMoleculeTree().collapseAll();
    }

    public void expandAll() {
        this.getMoleculeTree().expandAll();
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.getMoleculeTree().getSelectionModel().addTreeSelectionListener(tsl);
    }

    public int getSelectionCount() {
        return this.getMoleculeTree().getSelectionCount();
    }

    public TreeSelectionModel getSelectionModel() {
        return this.getMoleculeTree().getSelectionModel();
    }

    public TreePath getSelectionPath() {
        return this.getMoleculeTree().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.getMoleculeTree().getSelectionPaths();
    }

    public int[] getSelectionRows() {
        return this.getMoleculeTree().getSelectionRows();
    }

    public TreeModel getModel() {
        return this.getMoleculeTree().getModel();
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.getMoleculeTree().addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        this.getMoleculeTree().addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener l) {
        this.getMoleculeTree().addMouseWheelListener(l);
    }

    @Override
    public MouseListener[] getMouseListeners() {
        return this.getMoleculeTree().getMouseListeners();
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        return this.getMoleculeTree().getMouseMotionListeners();
    }

    @Override
    public MouseWheelListener[] getMouseWheelListeners() {
        return this.getMoleculeTree().getMouseWheelListeners();
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.getMoleculeTree().removeMouseListener(l);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        this.getMoleculeTree().removeMouseMotionListener(l);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener l) {
        this.getMoleculeTree().removeMouseWheelListener(l);
    }

    public void collapsePath(TreePath path) {
        this.getMoleculeTree().collapsePath(path);
    }

    public void collapseRow(int row) {
        this.getMoleculeTree().collapseRow(row);
    }

    public void expandPath(TreePath path) {
        this.getMoleculeTree().expandPath(path);
    }

    public void expandRow(int row) {
        this.getMoleculeTree().expandRow(row);
    }

    public boolean isExpanded(int row) {
        return this.getMoleculeTree().isExpanded(row);
    }

    public boolean isExpanded(TreePath path) {
        return this.getMoleculeTree().isExpanded(path);
    }

    public void exportTree(chemaxon.alchemist.utils.moleculetree.MoleculeTreeExporter exporter) {
        File exportFile = null;
        if (this.getExportFileChooser() != null) {
            String message;
            String lastPath;
            FileFilter lastFileFilter = this.getExportFileChooser().getFileFilter();
            this.getExportFileChooser().clearChoosableFileFilters();
            this.getExportFileChooser().setMultiSelectionEnabled(false);
            String string = lastPath = this.state != null ? (String)this.state.getProperty(PROPERTY_KEY_LAST_EXPORT_PATH) : null;
            if (lastPath != null) {
                this.getExportFileChooser().setCurrentDirectory(new File(lastPath));
            }
            this.getExportFileChooser().setDialogTitle(exporter.getName());
            this.getExportFileChooser().addFileFilters(exporter.getSupportedFileFilters());
            if (lastFileFilter != null) {
                for (FileFilter filter : exporter.getSupportedFileFilters()) {
                    if (!String.valueOf(lastFileFilter.getDescription()).equals(String.valueOf(filter.getDescription()))) continue;
                    this.getExportFileChooser().setFileFilter(filter);
                    break;
                }
            }
            if (this.getExportFileChooser().showSaveDialog(this) == 0 && (exportFile = this.getExportFileChooser().getSelectedFile()) != null && exportFile.exists() && JOptionPane.showConfirmDialog(this, message = EXPORT_FILE_EXISTS.replaceFirst("%s", exportFile.getAbsolutePath()), EXPORT_FILE_EXISTS_TITLE, 0) != 0) {
                exportFile = null;
            }
            if (this.state != null) {
                this.state.setPersistentProperty(PROPERTY_KEY_LAST_EXPORT_PATH, this.getExportFileChooser().getCurrentDirectory().getAbsolutePath());
            }
        }
        if (exportFile != null) {
            String format2 = ((MolFileFilter)this.getExportFileChooser().getFileFilter()).getFormat();
            try {
                if (exporter instanceof MoleculeTreeExporter) {
                    ((MoleculeTreeExporter)exporter).export(this, exportFile, format2);
                } else {
                    exporter.export(this.getMoleculeTree(), new FileOutputStream(exportFile), format2);
                }
            }
            catch (FileNotFoundException e) {
                AlchemistErrorDialog.showError(exporter.getFailureMessage());
            }
        }
    }

    @Deprecated
    public void exportTreeData(MoleculeTreeExporter exporter) {
        this.exportTree(exporter);
    }

    @Deprecated
    public void addExporters(MoleculeTreeExporter[] exporters) {
        for (int i = 0; i < exporters.length; ++i) {
            this.addExporter((chemaxon.alchemist.utils.moleculetree.MoleculeTreeExporter)exporters[i]);
        }
    }

    @Deprecated
    public void addExporter(MoleculeTreeExporter exporter) {
        this.getMoleculeTree().addExporter(exporter);
    }

    public void addExporter(chemaxon.alchemist.utils.moleculetree.MoleculeTreeExporter exporter) {
        this.getMoleculeTree().addExporter(exporter);
    }

    @Deprecated
    public void removeExporter(MoleculeTreeExporter exporter) {
        this.removeExporters(new MoleculeTreeExporter[]{exporter});
    }

    public void removeExporter(chemaxon.alchemist.utils.moleculetree.MoleculeTreeExporter exporter) {
        this.getMoleculeTree().removeExporter(exporter.getClass());
    }

    @Deprecated
    public void removeExporters(MoleculeTreeExporter[] exporters) {
        for (int i = 0; i < exporters.length; ++i) {
            this.getMoleculeTree().removeExporter(exporters[i].getClass());
        }
    }

    private void excludeWithChildDepthCalc(TreePath selPath) {
        AlchemistMoleculeTreeNode xNode = (AlchemistMoleculeTreeNode)selPath.getLastPathComponent();
        boolean isInDeepest = ((IterableDefaultTreeModel)this.getModel()).isNodeInDeepestPath(xNode);
        xNode.setChildrenDepth(0);
        ((IterableDefaultTreeModel)this.getModel()).excludeNode(xNode);
        while (isInDeepest) {
            if ((xNode = (AlchemistMoleculeTreeNode)xNode.getParent()) != this.getModel().getRoot()) {
                isInDeepest = ((IterableDefaultTreeModel)this.getModel()).isNodeInDeepestPath(xNode);
                xNode.setChildrenDepth(((IterableDefaultTreeModel)this.getModel()).getSubTreeHeight(xNode));
                continue;
            }
            isInDeepest = false;
        }
    }

    public void excludeSelectedMolecules() {
        if (this.getMoleculeTree().getSelectionCount() > 0) {
            this.majorCalculationMetabolizerUtilities.cancel();
            TreePath[] selPath = this.getMoleculeTree().getSelectionPaths();
            for (int i = selPath.length - 1; i >= 0; --i) {
                AlchemistMoleculeTreeNode node = (AlchemistMoleculeTreeNode)selPath[i].getLastPathComponent();
                if (node.isExcluded()) continue;
                this.excludeWithChildDepthCalc(selPath[i]);
                ArrayList<AlchemistMoleculeTreeNode> parentList = new ArrayList<AlchemistMoleculeTreeNode>();
                parentList.add(node);
                if (!this.isExcludedNodesVisible()) {
                    ExcludedNode exNode = new ExcludedNode(node, node.getParent().getIndex(node), (AlchemistMoleculeTreeNode)node.getParent());
                    this.excludeList.add(0, exNode);
                    ((IterableDefaultTreeModel)this.getModel()).removeNodeFromParent(node);
                }
                while (!parentList.isEmpty()) {
                    node = (AlchemistMoleculeTreeNode)parentList.remove(0);
                    for (int count = node.getChildCount() - 1; count >= 0; --count) {
                        AlchemistMoleculeTreeNode tmpnode = (AlchemistMoleculeTreeNode)node.getChildAt(!this.isExcludedNodesVisible() ? 0 : count);
                        if (((IterableDefaultTreeModel)this.getModel()).isNodeRealParent(tmpnode)) {
                            parentList.add(tmpnode);
                        }
                        ((IterableDefaultTreeModel)this.getModel()).excludeNode(tmpnode);
                        tmpnode.setChildrenDepth(0);
                        if (this.isExcludedNodesVisible()) continue;
                        ExcludedNode exNode = new ExcludedNode(tmpnode, tmpnode.getParent().getIndex(tmpnode), (AlchemistMoleculeTreeNode)tmpnode.getParent());
                        this.excludeList.add(0, exNode);
                        ((IterableDefaultTreeModel)this.getModel()).removeNodeFromParent(tmpnode);
                    }
                }
            }
            this.recalculateDominance();
            this.getMoleculeTree().repaint();
            MetabolizerCalculator.getInstance().setAccumulations(((IterableDefaultTreeModel)this.getModel()).moleculeIterator());
            this.getMoleculeTree().recalculateTreeData();
            this.getMoleculeTree().gatherVisibleNodes();
        }
    }

    public void includeSelectedMolecules() {
        if (this.getMoleculeTree().getSelectionCount() > 0) {
            this.majorCalculationMetabolizerUtilities.cancel();
            TreePath[] selPath = this.getMoleculeTree().getSelectionPaths();
            for (int i = 0; i < selPath.length; ++i) {
                int depth = 0;
                for (AlchemistMoleculeTreeNode node = (AlchemistMoleculeTreeNode)selPath[i].getLastPathComponent(); node != this.getModel().getRoot(); node = (AlchemistMoleculeTreeNode)node.getParent()) {
                    if (node.isExcluded()) {
                        ((IterableDefaultTreeModel)this.getModel()).includeNode(node);
                    }
                    if (node.getChildrenDepth() < depth) {
                        node.setChildrenDepth(depth);
                    }
                    ++depth;
                }
            }
            this.recalculateDominance();
            this.getMoleculeTree().repaint();
            MetabolizerCalculator.getInstance().setAccumulations(((IterableDefaultTreeModel)this.getModel()).moleculeIterator());
            this.getMoleculeTree().recalculateTreeData();
            this.getMoleculeTree().gatherVisibleNodes();
        }
    }

    private void recalculateDominance() {
        Map<String, String> domMap = MetabolizerCalculator.getInstance().generateDominanceMap(((IterableDefaultTreeModel)this.getModel()).moleculeIterator());
        ArrayList<AlchemistMoleculeTreeNode> parentList = new ArrayList<AlchemistMoleculeTreeNode>();
        parentList.add((AlchemistMoleculeTreeNode)this.getModel().getRoot());
        while (!parentList.isEmpty()) {
            AlchemistMoleculeTreeNode parentNode = (AlchemistMoleculeTreeNode)parentList.remove(0);
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                AlchemistMoleculeTreeNode node = (AlchemistMoleculeTreeNode)parentNode.getChildAt(i);
                if (domMap.containsKey(node.getUniqueID())) {
                    node.setAccumulation(Float.parseFloat(domMap.get(node.getUniqueID())));
                }
                if (!((IterableDefaultTreeModel)this.getModel()).isNodeRealParent(node)) continue;
                parentList.add(node);
            }
        }
        domMap.clear();
    }

    private void gatherNodesToExclude(List<ExcludedNode> list, AlchemistMoleculeTreeNode node) {
        if (node.getChildCount() > 0) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.gatherNodesToExclude(list, (AlchemistMoleculeTreeNode)node.getChildAt(i));
            }
        }
        if (node.isExcluded()) {
            list.add(new ExcludedNode(node, node.getParent().getIndex(node), (AlchemistMoleculeTreeNode)node.getParent()));
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.getMoleculeTree().addTreeExpansionListener(tel);
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return this.getMoleculeTree().getTreeExpansionListeners();
    }

    public void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.getMoleculeTree().removeTreeExpansionListener(tel);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.getMoleculeTree().addKeyListener(l);
    }

    @Override
    public KeyListener[] getKeyListeners() {
        return this.getMoleculeTree().getKeyListeners();
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        this.getMoleculeTree().removeKeyListener(l);
    }

    public void setExcludedNodesVisible(boolean visible) {
        if (!visible) {
            this.excludeList.clear();
            this.gatherNodesToExclude(this.excludeList, (AlchemistMoleculeTreeNode)this.getModel().getRoot());
            for (int i = 0; i < this.excludeList.size(); ++i) {
                ((IterableDefaultTreeModel)this.getModel()).removeNodeFromParent(this.excludeList.get(i).getNode());
            }
        } else {
            for (int i = 0; i < this.excludeList.size(); ++i) {
                ((IterableDefaultTreeModel)this.getModel()).insertNodeInto(this.excludeList.get(i).getNode(), this.excludeList.get(i).getParent(), this.excludeList.get(i).getChildIndex());
            }
            this.getMoleculeTree().expandPath(new TreePath(this.getModel().getRoot()));
        }
        this.getMoleculeTree().putClientProperty(PROPERTY_KEY_SHOW_EXCLUDED, visible);
    }

    public boolean isExcludedNodesVisible() {
        return Boolean.TRUE.equals(this.getMoleculeTree().getClientProperty(PROPERTY_KEY_SHOW_EXCLUDED));
    }

    public void toggleExcludedNodesVisible() {
        this.setExcludedNodesVisible(!this.isExcludedNodesVisible());
    }

    public void setFrameTitlesVisible(boolean visible) {
        boolean oldValue = this.isFrameTitlesVisible();
        this.frameTitlesVisible = visible;
        this.getTreeTitle().setVisible(visible);
        this.getPathTitle().setVisible(visible);
        this.getMajorTitle().setVisible(visible);
        this.getSelectedTitle().setVisible(visible);
        this.firePropertyChange(PROPERTY_KEY_SHOW_FRAME_TITLES, oldValue, visible);
    }

    public boolean isFrameTitlesVisible() {
        return this.frameTitlesVisible;
    }

    public void toggleFrameTitlesVisible() {
        this.setFrameTitlesVisible(!this.isFrameTitlesVisible());
    }

    public void setMajorMetaboliteLimit(float value) {
        float oldLimit = this.getMajorMetaboliteLimit();
        this.getMoleculeTree().putClientProperty(PROPERTY_KEY_MAJOR_METABOLITE_LIMIT, Float.valueOf(value));
        this.repaint();
        this.firePropertyChange(PROPERTY_KEY_MAJOR_METABOLITE_LIMIT, oldLimit, value);
    }

    public void setMinorMetaboliteLimit(float value) {
        float oldLimit = this.getMinorMetaboliteLimit();
        this.getMoleculeTree().putClientProperty(PROPERTY_KEY_MINOR_METABOLITE_LIMIT, Float.valueOf(value));
        this.repaint();
        this.firePropertyChange(PROPERTY_KEY_MINOR_METABOLITE_LIMIT, oldLimit, value);
    }

    public float getMajorMetaboliteLimit() {
        Float f = (Float)this.getMoleculeTree().getClientProperty(PROPERTY_KEY_MAJOR_METABOLITE_LIMIT);
        return f == null ? 0.0f : f.floatValue();
    }

    public float getMinorMetaboliteLimit() {
        Float f = (Float)this.getMoleculeTree().getClientProperty(PROPERTY_KEY_MINOR_METABOLITE_LIMIT);
        return f == null ? 0.0f : f.floatValue();
    }

    public void setTerminationCondition(String chemTerm) {
        if (this.getMoleculeTree().getDataProvider() instanceof AlchemistTreeViewInteractiveDataProvider) {
            try {
                ((AlchemistTreeViewInteractiveDataProvider)this.getMoleculeTree().getDataProvider()).getMetabolizer().setTermCondition(chemTerm);
            }
            catch (MetabolizerException e) {
                throw new IllegalArgumentException("Invalid termination condition", e);
            }
        }
    }

    public String getTerminationCondition() {
        if (this.getMoleculeTree().getDataProvider() instanceof AlchemistTreeViewInteractiveDataProvider) {
            return ((AlchemistTreeViewInteractiveDataProvider)this.getMoleculeTree().getDataProvider()).getMetabolizer().getTermCondition();
        }
        return null;
    }

    public void setNodeLoading(AlchemistMoleculeTreeNode node, boolean isLoading) {
        this.getMoleculeTree().setNodeLoading(node, isLoading);
    }

    public void setBorderType(BorderType borderType) {
        BorderType oldType = this.getBorderType();
        this.getMoleculeTree().putClientProperty(PROPERTY_KEY_BORDER_TYPE, (Object)borderType);
        this.repaint();
        this.firePropertyChange(PROPERTY_KEY_BORDER_TYPE, (Object)oldType, (Object)borderType);
    }

    public BorderType getBorderType() {
        return (BorderType)((Object)this.getMoleculeTree().getClientProperty(PROPERTY_KEY_BORDER_TYPE));
    }

    public void setNodeCaptionDataType(NodeCaptionDataType dataType) {
        NodeCaptionDataType oldType = this.getNodeCaptionDataType();
        this.getMoleculeTree().putClientProperty(PROPERTY_KEY_NODE_CAPTION_DATA, (Object)dataType);
        this.repaint();
        this.firePropertyChange(PROPERTY_KEY_NODE_CAPTION_DATA, (Object)oldType, (Object)dataType);
    }

    public NodeCaptionDataType getNodeCaptionDataType() {
        return (NodeCaptionDataType)((Object)this.getMoleculeTree().getClientProperty(PROPERTY_KEY_NODE_CAPTION_DATA));
    }

    private JLabel getTreeTitle() {
        if (this.treeTitle == null) {
            this.treeTitle = new JLabel("Metabolic Tree");
            this.treeTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        }
        return this.treeTitle;
    }

    private JLabel getPathTitle() {
        if (this.pathTitle == null) {
            this.pathTitle = new JLabel("Metabolic Route");
            this.pathTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        }
        return this.pathTitle;
    }

    protected JLabel getMajorTitle() {
        if (this.majorTitle == null) {
            this.majorTitle = new JLabel("Major Metabolites");
            this.majorTitle.setHorizontalTextPosition(2);
            this.majorTitle.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif"));
            this.majorTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.majorTitle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AlchemistTreeView.this.getMajorSelectorMenu().show(AlchemistTreeView.this.getMajorTitle(), 0, AlchemistTreeView.this.getMajorTitle().getHeight());
                }
            });
        }
        return this.majorTitle;
    }

    protected JPopupMenu getMajorSelectorMenu() {
        if (this.majorTitleSelectorMenu == null) {
            this.majorTitleSelectorMenu = new JPopupMenu();
            JMenuItem item1 = new JMenuItem(new AbstractAction(){
                private static final long serialVersionUID = -8244035760724996289L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlchemistTreeView.this.setMetaboliteListMode(MetaboliteListMode.MAJOR);
                }
            });
            item1.setText("Major Metabolites");
            JMenuItem item2 = new JMenuItem(new AbstractAction(){
                private static final long serialVersionUID = -7339031514839758161L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlchemistTreeView.this.setMetaboliteListMode(MetaboliteListMode.FINAL);
                }
            });
            item2.setText("Final Metabolites");
            this.majorTitleSelectorMenu.add(item1);
            this.majorTitleSelectorMenu.add(item2);
        }
        return this.majorTitleSelectorMenu;
    }

    private JLabel getSelectedTitle() {
        if (this.selectedTitle == null) {
            this.selectedTitle = new JLabel("Selected Molecule");
            this.selectedTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        }
        return this.selectedTitle;
    }

    public void setMetaboliteListMode(MetaboliteListMode listMode) {
        this.getMoleculeTree().putClientProperty(PROPERTY_KEY_METABOLITE_LIST_MODE, (Object)listMode);
        if (listMode == MetaboliteListMode.MAJOR) {
            this.getMajorTitle().setText("Major Metabolites");
            ((CardLayout)this.getRightListMetabolitesViewPanel().getLayout()).show(this.getRightListMetabolitesViewPanel(), MAJOR_VIEW);
        } else {
            this.getMajorTitle().setText("Final Metabolites");
            ((CardLayout)this.getRightListMetabolitesViewPanel().getLayout()).show(this.getRightListMetabolitesViewPanel(), FINAL_VIEW);
        }
    }

    public MetaboliteListMode getMetaboliteListMode() {
        return (MetaboliteListMode)((Object)this.getMoleculeTree().getClientProperty(PROPERTY_KEY_METABOLITE_LIST_MODE));
    }

    public void toggleMetaboliteListMode() {
        if (this.getMetaboliteListMode() == MetaboliteListMode.FINAL) {
            this.setMetaboliteListMode(MetaboliteListMode.MAJOR);
        } else {
            this.setMetaboliteListMode(MetaboliteListMode.FINAL);
        }
    }

    private void recursiveListRemovalE(AlchemistTreeNode node, List<ExcludedNode> list) {
        int i;
        ArrayList<ExcludedNode> removeList = new ArrayList<ExcludedNode>();
        for (i = 0; i < list.size(); ++i) {
            if (!list.get(i).getNode().equals(node)) continue;
            removeList.add(list.get(i));
        }
        for (i = 0; i < removeList.size(); ++i) {
            ExcludedNode exnode = (ExcludedNode)removeList.get(i);
            for (int j = 0; j < exnode.getNode().getChildCount(); ++j) {
                this.recursiveListRemovalE((AlchemistTreeNode)exnode.getNode().getChildAt(j), list);
            }
        }
    }

    public synchronized int removeSubstrate(String synthCode) {
        AlchemistTreeNode node = this.getMoleculeTree().removeMolecule(synthCode);
        return node == null ? -1 : 0;
    }

    public synchronized void addSubstrate(Molecule mol) {
        this.getMoleculeTree().addMolecule(mol);
    }

    public synchronized void updateSubstrate(String synthCode, Molecule mol) {
        this.getMoleculeTree().updateMolecule(synthCode, mol);
    }

    public void selectAll() {
        this.getMoleculeTree().selectAll();
    }

    public void invertSelection() {
        this.getMoleculeTree().invertSelection();
    }

    public void selectMajorMetabolites() {
        this.getMajorMetabolitesView().selectAll();
    }

    public void selectPath() {
        this.getMoleculeTree().selectPath();
    }

    public void selectSiblings() {
        this.getMoleculeTree().selectSiblings();
    }

    public void selectSubtree() {
        this.getMoleculeTree().selectSubtree();
    }

    public void unselectAll() {
        this.getMoleculeTree().clearSelection();
    }

    protected void setExportFileChooser(AlchemistFileChooserForJChem exportFileChooser) {
        this.exportFileChooser = exportFileChooser;
    }

    protected AlchemistFileChooserForJChem getExportFileChooser() {
        return this.exportFileChooser;
    }

    private static class ExcludedNode {
        private final AlchemistMoleculeTreeNode node;
        private final int childIndex;
        private final AlchemistMoleculeTreeNode parent;

        public ExcludedNode(AlchemistMoleculeTreeNode node, int childIndex, AlchemistMoleculeTreeNode parent) {
            this.node = node;
            this.childIndex = childIndex;
            this.parent = parent;
        }

        public AlchemistMoleculeTreeNode getNode() {
            return this.node;
        }

        public int getChildIndex() {
            return this.childIndex;
        }

        public AlchemistMoleculeTreeNode getParent() {
            return this.parent;
        }
    }

    public static enum MetaboliteListMode {
        MAJOR,
        FINAL;

    }

    public static enum NodeCaptionDataType {
        SYNTHESISCODE,
        EXACTMASS,
        MOLECULENAME;

    }

    public static enum BorderType {
        NONE,
        ACCUMULATION,
        PRODUCTION,
        HIGHEST_ACCUMULATION,
        CUSTOM;

    }

    private final class MoleculeTreeImpl
    extends AlchemistMoleculeTree {
        private static final long serialVersionUID = 1354487488343239119L;

        public MoleculeTreeImpl() {
            super(new IterableDefaultTreeModel(new AlchemistTreeNode(AlchemistTreeView.ROOT_UNIQUE_ID)));
        }

        @Override
        public void exportTreeData(chemaxon.alchemist.utils.moleculetree.MoleculeTreeExporter exporter) {
            AlchemistTreeView.this.exportTree(exporter);
        }

        void setNodeLoading(AlchemistMoleculeTreeNode node, boolean isLoading) {
            node.setLoading(isLoading);
            if (isLoading) {
                this.loadingNodeRoot = node;
                this.nodeLoadTimer.start();
            } else {
                this.loadingNodeRoot = null;
                this.nodeLoadTimer.stop();
            }
        }

        @Override
        protected void paintMoleculeDataPopup(Graphics g) {
            if (this.isDetailsEnabled() && this.popupNode != null && this.popupNode.getMolecule() != null && !this.popupNode.getMolecule().isReaction()) {
                Graphics gr2 = g.create();
                gr2.translate(this.isMagnifierEnabled() ? this.lastMagnifierPopup.x + 205 : this.lastMagnifierPopup.x, this.lastMagnifierPopup.y + 11);
                gr2.setColor(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
                int count = 0;
                for (String label : this.detailedPropertiesMap.keySet()) {
                    if (this.popupNode.getProperty(label) == null) continue;
                    ++count;
                }
                if (count > 0) {
                    int height = count * (gr2.getFontMetrics().getHeight() + 3);
                    if (!AlchemistTreeView.this.getBorderType().equals((Object)BorderType.NONE) && this.isNodeBorderVisible()) {
                        height += 15 + 6 * (gr2.getFontMetrics().getHeight() + 3);
                    }
                    gr2.fillRect(0, 0, 175, height + 10);
                    gr2.setColor(Color.BLACK);
                    int y = gr2.getFontMetrics().getAscent() + 5;
                    Font normalFont = gr2.getFont();
                    Font boldFont = normalFont.deriveFont(1);
                    for (String label : this.detailedPropertiesMap.keySet()) {
                        if (this.popupNode.getProperty(label) == null) continue;
                        gr2.setFont(boldFont);
                        gr2.drawString((String)this.detailedPropertiesMap.get(label) + ":", 5, y);
                        gr2.setFont(normalFont);
                        float f = 0.0f;
                        try {
                            f = Float.parseFloat(this.popupNode.getProperty(label));
                        }
                        catch (NumberFormatException e) {
                            f = Float.NaN;
                        }
                        String data = new DecimalFormat("0.00").format(f * 100.0f) + "%";
                        gr2.drawString(data, 125, y);
                        y += gr2.getFontMetrics().getHeight() + 3;
                    }
                    if (!AlchemistTreeView.this.getBorderType().equals((Object)BorderType.NONE) && this.isNodeBorderVisible()) {
                        String legend = "Border color Legend";
                        gr2.setFont(boldFont);
                        gr2.drawString(legend, 5 + (175 - SwingUtilities.computeStringWidth(gr2.getFontMetrics(), legend)) / 2, y += 10);
                        y += gr2.getFontMetrics().getHeight() + 8;
                        float[] values = MetabolizerCalculator.getInstance().getCategoryBorderRanges(this.popupNode.getUniqueID(), AlchemistTreeView.this.getMinorMetaboliteLimit(), AlchemistTreeView.this.getMajorMetaboliteLimit());
                        gr2.setFont(normalFont);
                        for (int i = 0; i < 5; ++i) {
                            gr2.setColor(AlchemistMoleculeTreeCellRenderer.CATEGORY_COLOR[i]);
                            gr2.fillRect(15, y - gr2.getFontMetrics().getHeight() + 2, gr2.getFontMetrics().getHeight(), gr2.getFontMetrics().getHeight());
                            gr2.setColor(Color.BLACK);
                            float low = i > 0 ? values[i - 1] * 100.0f + 0.01f : 0.0f;
                            float high = i < values.length ? values[i] * 100.0f : 100.0f;
                            String data = new DecimalFormat("0.00").format(low) + "% - " + new DecimalFormat("0.00").format(high) + "%";
                            gr2.drawString(data, 30 + gr2.getFontMetrics().getHeight(), y);
                            gr2.drawRect(15, y - gr2.getFontMetrics().getHeight() + 2, gr2.getFontMetrics().getHeight(), gr2.getFontMetrics().getHeight());
                            y += gr2.getFontMetrics().getHeight() + 3;
                        }
                    }
                    gr2.drawRect(0, 0, 175, height + 10);
                }
                gr2.dispose();
            }
        }

        @Override
        public void setDataProvider(TreeDataProvider<AlchemistTreeNode> dataProvider) {
            if (this.getDataProvider() instanceof AlchemistTreeViewDataProvider && this.getDataProvider() != dataProvider) {
                try {
                    ((AlchemistTreeViewDataProvider)this.getDataProvider()).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            super.setDataProvider(dataProvider);
        }

        public void addMolecule(Molecule molecule) {
            if (this.getDataProvider() instanceof AlchemistTreeViewInteractiveDataProvider) {
                this.expandLock = true;
                AlchemistTreeNode[] nodes = ((AlchemistTreeViewInteractiveDataProvider)this.getDataProvider()).addSubstrate(molecule);
                this.addNodes(nodes);
                this.expandPath(new TreePath(this.getModel().getRoot()));
                this.repaint();
                this.expandLock = false;
                this.recalculateTreeData();
                this.gatherVisibleNodes();
            }
        }

        public void updateMolecule(String uniqueId, Molecule molecule) {
            if (this.getDataProvider() instanceof AlchemistTreeViewInteractiveDataProvider) {
                this.expandLock = true;
                int index = this.getMoleculeIndex(uniqueId);
                if (index != -1) {
                    this.removeMolecule(index);
                    if (this.getDataProvider() instanceof AlchemistTreeViewInteractiveDataProvider) {
                        AlchemistTreeNode[] nodes = ((AlchemistTreeViewInteractiveDataProvider)this.getDataProvider()).updateSubstrate(uniqueId, molecule);
                        this.addNodes(nodes);
                    }
                    AlchemistTreeNode root = (AlchemistTreeNode)this.getModel().getRoot();
                    AlchemistTreeNode node = (AlchemistTreeNode)root.getLastChild();
                    ((IterableDefaultTreeModel)this.getModel()).insertNodeInto(node, root, index);
                    this.expandPath(new TreePath(root));
                    this.repaint();
                }
                this.expandLock = false;
                this.recalculateTreeData();
                this.gatherVisibleNodes();
            }
        }

        private void removeNodesFromVisibleNodesMap(AlchemistTreeNode node, Map<AlchemistTreeNode, Rectangle> map) {
            int i;
            map.remove(node);
            ArrayList<AlchemistTreeNode> removelist = new ArrayList<AlchemistTreeNode>();
            for (i = 0; i < node.getChildCount(); ++i) {
                removelist.add((AlchemistTreeNode)node.getChildAt(i));
            }
            for (i = 0; i < removelist.size(); ++i) {
                this.removeNodesFromVisibleNodesMap((AlchemistTreeNode)removelist.get(i), map);
            }
        }

        private void removeNodesFromNodeMap(AlchemistTreeNode node, Map<String, AlchemistTreeNode> map) {
            int i;
            map.remove(node.getUniqueID());
            ArrayList<AlchemistTreeNode> removelist = new ArrayList<AlchemistTreeNode>();
            for (i = 0; i < node.getChildCount(); ++i) {
                removelist.add((AlchemistTreeNode)node.getChildAt(i));
            }
            for (i = 0; i < removelist.size(); ++i) {
                this.removeNodesFromNodeMap((AlchemistTreeNode)removelist.get(i), map);
            }
        }

        public AlchemistTreeNode removeMolecule(String uniqueId) {
            int index = this.getMoleculeIndex(uniqueId);
            if (index != -1) {
                return this.removeMolecule(index);
            }
            return null;
        }

        protected AlchemistTreeNode removeMolecule(int index) {
            AlchemistTreeNode root = (AlchemistTreeNode)this.getModel().getRoot();
            AlchemistTreeNode node = (AlchemistTreeNode)root.getChildAt(index);
            ((IterableDefaultTreeModel)this.getModel()).removeNodeFromParent(node);
            this.removeNodesFromVisibleNodesMap(node, this.visibleNodesMap);
            this.removeNodesFromNodeMap(node, this.nodeMap);
            AlchemistTreeView.this.recursiveListRemovalE(node, AlchemistTreeView.this.excludeList);
            if (this.getDataProvider() instanceof AlchemistTreeViewInteractiveDataProvider) {
                ((AlchemistTreeViewInteractiveDataProvider)this.getDataProvider()).removeSubstrate(node.getUniqueID());
            }
            MetabolizerCalculator.getInstance().removeTreeData(node.getUniqueID());
            this.expandPath(new TreePath(this.getModel().getRoot()));
            this.recalculateTreeData();
            this.gatherVisibleNodes();
            this.repaint();
            return node;
        }

        @Override
        protected void recalculateTreeData() {
            if (this.isExpandLock()) {
                AlchemistTreeView.this.majorCalculationMetabolizerUtilities.cancel();
                AlchemistTreeView.this.getMajorMetabolitesView().setWaiting(true);
                AlchemistTreeView.this.getFinalMetabolitesView().setWaiting(true);
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = AlchemistTreeView.this.majorCalcMetabolizerMutex;
                        synchronized (object) {
                            try {
                                List<Molecule> list = MetabolizerCalculator.getInstance().calculateMajorMetaboliteList(((IterableDefaultTreeModel)MoleculeTreeImpl.this.getModel()).moleculeIterator(), 0.0f);
                                for (int i = 0; i < list.size(); ++i) {
                                    RxnMolecule rxn = RxnMolecule.getReaction(list.get(i));
                                    if (rxn == null) continue;
                                    Molecule product = rxn.getProduct(0);
                                    MetabolizerUtilities.copyProperties(rxn, product);
                                    list.set(i, product);
                                }
                                AlchemistTreeView.this.getMajorMetabolitesView().setMoleculeList(list);
                                AlchemistTreeView.this.getMajorMetabolitesView().setWaiting(false);
                                ArrayList<Molecule> list2 = new ArrayList<Molecule>();
                                Iterator<AlchemistTreeNode> iterator = ((IterableDefaultTreeModel)MoleculeTreeImpl.this.getModel()).nodeIterator();
                                while (iterator.hasNext()) {
                                    AlchemistTreeNode node = iterator.next();
                                    if (!node.isLeaf(true)) continue;
                                    Molecule molecule = node.getMolecule();
                                    RxnMolecule rxn = RxnMolecule.getReaction(molecule);
                                    if (rxn != null) {
                                        Molecule product = rxn.getProduct(0);
                                        MetabolizerUtilities.copyProperties(rxn, product);
                                        list2.add(product);
                                        continue;
                                    }
                                    list2.add(molecule);
                                }
                                AlchemistTreeView.this.getFinalMetabolitesView().setMoleculeList(list2);
                                AlchemistTreeView.this.getFinalMetabolitesView().setWaiting(false);
                                AlchemistTreeView.this.getMoleculeTree().repaint();
                            }
                            catch (ConcurrentModificationException e) {
                                AlchemistTreeView.this.getFinalMetabolitesView().setWaiting(true);
                            }
                        }
                    }
                });
                thread.setPriority(4);
                thread.start();
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.setModel(new IterableDefaultTreeModel(new AlchemistTreeNode(AlchemistTreeView.ROOT_UNIQUE_ID){

                @Override
                public Molecule getMolecule() {
                    return null;
                }

                @Override
                public void setMolecule(Molecule molecule) {
                }
            }));
        }
    }
}

