/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer.moleculetree;

import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeNode;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeViewDataProvider;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.alchemist.utils.ProgressMonitorWrapper;
import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.formats.MolImporter;
import chemaxon.metabolizer.Metabolizer;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class AlchemistTreeViewInteractiveDataProvider
implements AlchemistTreeViewDataProvider {
    private static final String PROPERTY_VALUE_CAN_NOT_INITIALIZE_METABOLIZER = "Can not initialize Metabolizer";
    public static final String PROPERTY_KEY_VIRTUAL_CHILDREN_IN_FILE_LEVEL = "MetabolizerTreeViewInteractiveDataProvider_ChildrenInFileLevel";
    public static final String PROPERTY_KEY_VIRTUAL_CHILDREN_IN_FILE = "MetabolizerTreeViewInteractiveDataProvider_ChildrenInFile";
    public static final String PROPERTY_KEY_VIRTUAL_CHILDREN_INDEX_FILE = "MetabolizerTreeViewInteractiveDataProvider_ChildrenIndexFile";
    private boolean calcuateDominance = false;
    private String libraryPath = null;
    private Molecule[] substrates = null;
    private Metabolizer metabolizer = null;
    private boolean canceled = false;
    private final RxnMolecule[] reactionLibrary;

    public AlchemistTreeViewInteractiveDataProvider(String libraryPath, Molecule[] substrates) {
        this.libraryPath = libraryPath;
        this.substrates = substrates;
        this.reactionLibrary = null;
    }

    public AlchemistTreeViewInteractiveDataProvider(String libraryPath, Molecule[] substrates, boolean calculateDominance) {
        this.libraryPath = libraryPath;
        this.substrates = substrates;
        this.calcuateDominance = calculateDominance;
        this.reactionLibrary = null;
    }

    public AlchemistTreeViewInteractiveDataProvider(RxnMolecule[] reactionLibrary) {
        this.reactionLibrary = reactionLibrary;
        try {
            this.libraryPath = null;
            this.metabolizer = new Metabolizer(0, reactionLibrary, true);
        }
        catch (MetabolizerException e) {
            AlchemistErrorDialog.showError(PROPERTY_VALUE_CAN_NOT_INITIALIZE_METABOLIZER, (Exception)e);
        }
    }

    public AlchemistTreeViewInteractiveDataProvider(RxnMolecule[] reactionLibrary, boolean calculateDominance) {
        this.reactionLibrary = reactionLibrary;
        try {
            this.libraryPath = null;
            this.metabolizer = new Metabolizer(0, reactionLibrary, true);
            this.calcuateDominance = calculateDominance;
        }
        catch (MetabolizerException e) {
            AlchemistErrorDialog.showError(PROPERTY_VALUE_CAN_NOT_INITIALIZE_METABOLIZER, (Exception)e);
        }
    }

    public Metabolizer getMetabolizer() {
        return this.metabolizer;
    }

    @Override
    public void close() {
        this.substrates = null;
        this.libraryPath = null;
        this.metabolizer = null;
    }

    @Override
    public AlchemistTreeNode[] updateSubstrate(String synthCode, Molecule mol) {
        ArrayList<Molecule> sub = new ArrayList<Molecule>(Arrays.asList(this.substrates));
        boolean updated = false;
        for (int i = 0; i < sub.size() && !updated; ++i) {
            Molecule molecule = (Molecule)sub.get(i);
            if (!molecule.getProperty("Synthesis Code").equalsIgnoreCase(synthCode)) continue;
            mol.setProperty("Synthesis Code", synthCode);
            sub.set(i, mol);
            updated = true;
        }
        this.substrates = sub.toArray(new Molecule[0]);
        return this.generateSubstrate(mol, synthCode);
    }

    @Override
    public AlchemistMoleculeTreeNode[] addSubstrate(Molecule mol) {
        ArrayList<Molecule> sub = new ArrayList<Molecule>(Arrays.asList(this.substrates));
        sub.add(mol);
        this.substrates = sub.toArray(new Molecule[0]);
        return this.generateSubstrate(mol, null);
    }

    private AlchemistMoleculeTreeNode[] generateSubstrate(Molecule mol, String synthCode) {
        ArrayList<AlchemistMoleculeTreeNode> list = new ArrayList<AlchemistMoleculeTreeNode>();
        if (this.metabolizer == null) {
            this.initializeMetabolizer();
        }
        try {
            this.metabolizer.setLevelCount(0);
            this.metabolizer.setSubstrates(new Molecule[]{mol});
            this.metabolizer.setGeneratingSubstrates(true);
            Molecule[] molecules = this.metabolizer.next();
            if (molecules != null) {
                AlchemistMoleculeTreeNode node = new AlchemistMoleculeTreeNode(molecules[0]);
                if (synthCode != null) {
                    node.setUniqueID(synthCode);
                }
                list.add(node);
                AlchemistMoleculeTreeNode virtual = new AlchemistMoleculeTreeNode(new Molecule());
                virtual.setUniqueID("virtual" + node.getUniqueID());
                virtual.setParentID(node.getUniqueID());
                virtual.setProduction(0.0f);
                list.add(virtual);
            }
        }
        catch (MetabolizerException e) {
            AlchemistErrorDialog.showError("Metabolizer failed", (Exception)e);
        }
        return list.toArray(new AlchemistMoleculeTreeNode[list.size()]);
    }

    @Override
    public void removeSubstrate(String synthCode) {
        ArrayList<Molecule> sub = new ArrayList<Molecule>(Arrays.asList(this.substrates));
        boolean removed = false;
        for (int i = 0; i < sub.size() && !removed; ++i) {
            Molecule molecule = (Molecule)sub.get(i);
            if (!molecule.getProperty("Synthesis Code").equalsIgnoreCase(synthCode)) continue;
            sub.remove(i);
            removed = true;
        }
        this.substrates = sub.toArray(new Molecule[0]);
    }

    public AlchemistMoleculeTreeNode[] getTreeData(AlchemistTreeNode parent, AlchemistProgressMonitor monitor) {
        AlchemistProgressMonitor pMon;
        String parentKey = parent == null ? null : parent.getUniqueID();
        ArrayList<AlchemistMoleculeTreeNode> list = new ArrayList<AlchemistMoleculeTreeNode>();
        this.canceled = false;
        if (this.metabolizer == null) {
            this.initializeMetabolizer();
        }
        if ((pMon = monitor) != null) {
            this.metabolizer.setProgressMonitor(new ProgressMonitorWrapper(pMon));
        }
        try {
            Molecule[] moleculeArray;
            this.metabolizer.setLevelCount(parentKey == null || parentKey.equalsIgnoreCase("null") ? 0 : 1);
            if (parent == null || !(parent instanceof AlchemistMoleculeTreeNode)) {
                moleculeArray = this.substrates;
            } else {
                Molecule[] moleculeArray2 = new Molecule[1];
                moleculeArray = moleculeArray2;
                moleculeArray2[0] = ((AlchemistMoleculeTreeNode)parent).getReaction();
            }
            this.metabolizer.setSubstrates(moleculeArray);
            this.metabolizer.setGeneratingSubstrates(true);
            while (this.metabolizer.hasMoreLevel() && !this.canceled) {
                while (!this.metabolizer.isCurrentLevelEnded() && !this.canceled) {
                    Molecule[] molecules = this.metabolizer.next();
                    if (molecules == null) continue;
                    for (int i = 0; i < molecules.length && !this.canceled; ++i) {
                        AlchemistMoleculeTreeNode node = new AlchemistMoleculeTreeNode(molecules[i]);
                        list.add(node);
                        AlchemistMoleculeTreeNode virtual = new AlchemistMoleculeTreeNode(new Molecule());
                        virtual.setUniqueID("virtual" + node.getUniqueID());
                        virtual.setParentID(node.getUniqueID());
                        virtual.setProduction(0.0f);
                        list.add(virtual);
                    }
                }
                this.metabolizer.nextLevel();
            }
        }
        catch (MetabolizerException e1) {
            AlchemistErrorDialog.showError("Metabolizer failed", (Exception)e1);
            this.canceled = true;
        }
        if (pMon != null && !this.canceled) {
            pMon.setDone(true);
        }
        return list.toArray(new AlchemistMoleculeTreeNode[list.size()]);
    }

    private void initializeMetabolizer() {
        MolImporter importer = null;
        try {
            if (this.libraryPath == null) {
                this.metabolizer = new Metabolizer(0, this.reactionLibrary, true);
                return;
            }
            importer = new MolImporter(this.libraryPath);
            ArrayList<RxnMolecule> list2 = new ArrayList<RxnMolecule>();
            Molecule mol = null;
            mol = importer.read();
            while (mol != null && !this.canceled) {
                list2.add((RxnMolecule)mol);
                mol = importer.read();
            }
            RxnMolecule[] arr = list2.toArray(new RxnMolecule[list2.size()]);
            this.metabolizer = new Metabolizer(0, arr, true);
        }
        catch (IOException e) {
            AlchemistErrorDialog.showError(PROPERTY_VALUE_CAN_NOT_INITIALIZE_METABOLIZER, (Exception)e);
            this.canceled = true;
        }
        catch (MetabolizerException e) {
            AlchemistErrorDialog.showError(PROPERTY_VALUE_CAN_NOT_INITIALIZE_METABOLIZER, (Exception)e);
            this.canceled = true;
        }
    }

    @Override
    public void open() {
        if (this.libraryPath != null) {
            MolImporter importer = null;
            try {
                importer = new MolImporter(this.libraryPath);
                while (importer.skipRecord()) {
                }
            }
            catch (IOException e) {
                AlchemistErrorDialog.showError("Can not open data provider", (Exception)e);
                this.canceled = true;
            }
        }
    }

    public void setSubstrates(Molecule[] substrates) {
        this.substrates = substrates;
    }

    public boolean isCalcuateDominance() {
        return this.calcuateDominance;
    }

    public void setCalcuateDominance(boolean calcuateDominance) {
        this.calcuateDominance = calcuateDominance;
    }
}

