/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer.moleculetree;

import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeNode;
import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.alchemist.utils.moleculetree.IterableTreeModel;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class IterableDefaultTreeModel
extends IterableTreeModel {
    private static final long serialVersionUID = 2752967107353917372L;

    public IterableDefaultTreeModel(TreeNode root, boolean asksAllowsChildren) {
        super(root);
    }

    public IterableDefaultTreeModel(TreeNode root) {
        super(root);
    }

    public Iterator<Molecule> moleculeIterator() {
        return new TreeNodeIterator(this);
    }

    public Iterator<AlchemistTreeNode> nodeIterator() {
        return super.iterator();
    }

    @Override
    public synchronized void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        if (this.getModificationCount() != Long.MAX_VALUE) {
            this.setModificationCount(this.getModificationCount() + 1L);
        } else {
            this.setModificationCount(Long.MIN_VALUE);
        }
        super.insertNodeInto(newChild, parent, index);
    }

    @Override
    public synchronized void removeNodeFromParent(MutableTreeNode node) {
        if (this.getModificationCount() != Long.MAX_VALUE) {
            this.setModificationCount(this.getModificationCount() + 1L);
        } else {
            this.setModificationCount(Long.MIN_VALUE);
        }
        super.removeNodeFromParent(node);
    }

    private class TreeNodeIterator
    implements Iterator<Molecule> {
        private final List<AlchemistTreeNode> parentList = new ArrayList<AlchemistTreeNode>();
        private AlchemistTreeNode parentNode = null;
        private int childIndex = 0;
        private final long modificationId;

        public TreeNodeIterator(DefaultTreeModel model) {
            this.parentNode = (AlchemistTreeNode)model.getRoot();
            this.modificationId = IterableDefaultTreeModel.this.getModificationCount();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = true;
            if (this.parentList.size() <= 0) {
                hasNext = false;
                for (int i = this.childIndex; i < this.parentNode.getChildCount() && !hasNext; ++i) {
                    hasNext = !((AlchemistTreeNode)this.parentNode.getChildAt(i)).isExcluded();
                }
            }
            return hasNext;
        }

        @Override
        public Molecule next() {
            boolean readNext = true;
            AlchemistTreeNode nextNode = null;
            while (readNext) {
                if (IterableDefaultTreeModel.this.getModificationCount() != this.modificationId) {
                    throw new ConcurrentModificationException();
                }
                if (this.childIndex >= this.parentNode.getChildCount()) {
                    if (!this.parentList.isEmpty()) {
                        this.parentNode = this.parentList.remove(0);
                        this.childIndex = 0;
                    } else {
                        throw new NoSuchElementException();
                    }
                }
                nextNode = (AlchemistTreeNode)this.parentNode.getChildAt(this.childIndex);
                ++this.childIndex;
                if (nextNode.isExcluded()) continue;
                readNext = false;
                if (!IterableDefaultTreeModel.this.isNodeRealParent(nextNode)) continue;
                this.parentList.add(nextNode);
            }
            return nextNode instanceof AlchemistMoleculeTreeNode ? ((AlchemistMoleculeTreeNode)nextNode).getReaction() : new Molecule();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

