/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer.moleculetree.export;

import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeNode;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeView;
import chemaxon.alchemist.metabolizer.moleculetree.export.MoleculeTreeExporter;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.formats.MolExporter;
import chemaxon.metabolizer.MetabolizerUtilities;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

public class SimpleReactionExporter
extends MoleculeTreeExporter {
    @Override
    public boolean canExportMultipleSelection() {
        return true;
    }

    private Molecule[] getSelectedReactions(AlchemistTreeView treeView) {
        TreePath[] path = treeView.getSelectionPaths();
        ArrayList<Molecule> moleculeList = new ArrayList<Molecule>();
        for (int i = 0; i < path.length; ++i) {
            Object[] obj = path[i].getPath();
            if (!(obj[obj.length - 1] instanceof AlchemistMoleculeTreeNode)) continue;
            AlchemistMoleculeTreeNode node = (AlchemistMoleculeTreeNode)obj[obj.length - 1];
            Molecule mol = node.getReaction();
            if (mol.isReaction()) {
                moleculeList.add(mol);
                continue;
            }
            RxnMolecule reaction = new RxnMolecule();
            MetabolizerUtilities.copyProperties(mol, reaction);
            reaction.addComponent(mol, 1);
            moleculeList.add(reaction);
        }
        return moleculeList.toArray(new Molecule[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(AlchemistTreeView treeView, File outputFile, String format2) {
        FileOutputStream ostream = null;
        MolExporter exporter = null;
        try {
            ostream = new FileOutputStream(outputFile);
            exporter = new MolExporter(ostream, "smiles".equalsIgnoreCase(format2) ? "smiles:qTSynthesis Code:METABOLIZER_SYNTHESISLEVEL:METABOLIZER_PARENTSYNTHESISCODE:SPEED_CATEGORY:CHILDDEPTH:PRODUCTION:ACCUMULATION:TRANSMISSIVITY:STABILITY:PARENTS:METABOLIC_TREE_COUNT" : format2);
            Molecule[] mol = this.getSelectedReactions(treeView);
            for (int i = 0; i < mol.length; ++i) {
                if (mol[i].getDim() == 0) {
                    mol[i].clean(2, null);
                }
                exporter.write(mol[i]);
            }
        }
        catch (Exception ex) {
            AlchemistErrorDialog.showError("Export failed", ex);
        }
        finally {
            try {
                if (exporter != null) {
                    exporter.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public String getExporterDescription() {
        return "Exports the selected transformations to a file.";
    }

    @Override
    public String getExporterName() {
        return "Export selected transformations";
    }

    @Override
    public FileFilter[] getSupportedFileFilters() {
        return AlchemistFileChooserForJChem.getReactionSaveFileFilters();
    }
}

