/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.reactor.ReactorAlchemistController;
import chemaxon.alchemist.standardizer.StandardizerAlchemist;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.marvin.beans.splash.MarvinSplashScreen;
import chemaxon.util.SplashScreenUtils;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;

public class ReactorAlchemist
implements AlchemistLaunchable {
    public static void createAndShowGUI() {
        MarvinBasedAlchemistApplication.setLookAndFeel();
        SplashScreenUtils.showSplashScreen(SplashScreenUtils.Product.Reactor, StandardizerAlchemist.class.getResource("/chemaxon/alchemist/images/reactor_splash.jpg"));
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ReactorAlchemistController controller = new ReactorAlchemistController();
                    controller.getAlchemist().getApplicationFrame().setVisible(true);
                }
                catch (Exception e) {
                    AlchemistErrorDialog.showError(e);
                }
                finally {
                    MarvinSplashScreen.disposeSplash();
                }
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactorAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    public void launch() {
        ReactorAlchemist.main(new String[0]);
    }
}

