/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.AlchemistController;
import chemaxon.alchemist.reactor.ReactorAlchemistTask;
import chemaxon.alchemist.reactor.ReactorInputPanel;
import chemaxon.alchemist.reactor.ReactorOptionsPanel;
import chemaxon.alchemist.reactor.ReactorProgressPanel;
import chemaxon.alchemist.reactor.ReactorReactantSelector;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.DotfileUtil;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ReactorAlchemistController
extends AlchemistController {
    private static final String PERSISTENT_PROPERTY_PATH = "/alchemist/.reactor";
    public static final String DEFAULT_TITLE = "Reactor " + VersionInfo.JCHEM_VERSION;
    private ReactorProgressPanel page4;
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReactorAlchemistController.this.page4.showManualSelectionPanel();
        }
    };

    public ReactorAlchemistController() {
        this(DEFAULT_TITLE);
    }

    public ReactorAlchemistController(String title) {
        this(title, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/reactor.png"));
    }

    public ReactorAlchemistController(String title, Image image) {
        super(title, image);
        this.initializePages();
        this.initAlchemist();
    }

    protected void initializePages() {
        ReactorInputPanel page1 = new ReactorInputPanel(true);
        page1.setTopText("Select Reaction", "Select a reaction from the list or open a reaction file.");
        page1.setTopTextVisible(true);
        page1.setBottomText("Press 'Next' to specify reactants");
        page1.setBottomTextVisible(true);
        this.addPage("Select Reaction", page1);
        ReactorReactantSelector page2 = new ReactorReactantSelector();
        page2.setTopText("Specify Reactants", "Specify reactants of the selected reaction in the same order as drawn in the scheme.");
        page2.setTopTextVisible(true);
        page2.setBottomText("Press 'Next' to set reactor options.");
        page2.setBottomTextVisible(true);
        this.addPage("Specify Reactants", page2);
        ReactorOptionsPanel page3 = new ReactorOptionsPanel();
        page3.setTopText("Set Reactor Options", "Set the reaction processing parameters.");
        page3.setTopTextVisible(true);
        this.addPage("Set Reactor Options", page3);
        this.page4 = new ReactorProgressPanel(this.DONE_ACTION, new ReactorAlchemistTask(this.state));
        this.addPage("Run Reactor", this.page4);
    }

    @Override
    protected void cancelPressed() {
        this.saveProperties();
    }

    @Override
    protected void finishPressed() {
        File outFile = new File((String)this.state.getProperty("ReactorOptionsPanel_OutputPath"));
        if (outFile.exists() && JOptionPane.showConfirmDialog(null, outFile.getAbsolutePath() + " exists.\nDo you want to overwrite?", "Output file exists", 0) == 1) {
            this.FINISH_ACTION.setEnabled(true);
            this.CANCEL_ACTION.setEnabled(true);
            this.BACK_ACTION.setEnabled(true);
            return;
        }
        ReactorAlchemistTask currentTask = this.page4.getCurrentTask();
        if (currentTask != null) {
            currentTask.getPropertyChangeSupport().removePropertyChangeListener(this.listener);
        }
        this.page4.setPanelState(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactorAlchemistController.this.page4.runTask(4, ReactorAlchemistController.this.listener);
            }
        });
    }

    @Override
    public File getPropertiesFile() {
        return DotfileUtil.getDotFile(PERSISTENT_PROPERTY_PATH);
    }

    @Override
    public String getHelpURL() {
        return "http://www.chemaxon.com/jchem/doc/user/Reactor.html";
    }
}

