/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanelFactory;
import chemaxon.alchemist.configbuilder.ConfigElementFactory;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationReader;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationWriter;
import chemaxon.alchemist.reactor.ReactorPropertyCopyUtils;
import chemaxon.alchemist.reactor.reactioneditor.Properties;
import chemaxon.alchemist.utils.AbstractAlchemistMoleculeEditor;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.config.struct.XMLFileFilter;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;

public class ReactorOptionsPanel
extends AlchemistPage {
    public static final String PROPERTY_KEY_PRODUCT_STANDARDIZATION_FILE = "ReactorOptionsPanel_ProductStandardizationFile";
    public static final String PROPERTY_KEY_LAST_STANDARDIZATION_DIR = "ReactorOptionsPanel_StandardizationPath";
    public static final String PROPERTY_KEY_MAPPING_STYLE = "ReactorOptionsPanel_MappingStyle";
    public static final String PROPERTY_KEY_UNAMBIGOUS = "ReactorOptionsPanel_Unambigous";
    public static final String PROPERTY_KEY_MULTIPLE_PROC_MODE = "ReactorOptionsPanel_MultipleProcMode";
    public static final String PROPERTY_KEY_OUTPUT_TYPE = "ReactorOptionsPanel_OutputType";
    public static final String PROPERTY_KEY_IGNORE = "ReactorOptionsPanel_Ignore";
    public static final String PROPERTY_KEY_IGNORE_ERRORS = "ReactorOptionsPanel_IgnoreErrors";
    public static final String PROPERTY_KEY_GENERATE_SCHEMA_SYNTHESIS_CODE_FROM_FILENAME = "ReactorOptionsPanel_GenerateSchemaSynthesisCodeFromFilename";
    public static final String PROPERTY_KEY_GENERATE_INPUT_SYNTHESIS_CODE_FROM_FILENAME = "ReactorOptionsPanel_GenerateBooleanSynthesisCodeFromFilename";
    public static final String PROPERTY_KEY_GENERATE_SYNTHESIS_CODE = "ReactorOptionsPanel_GenerateSynthesisCode";
    public static final String PROPERTY_KEY_SCHEMA_SYNTHESIS_CODE_FIELD = "ReactorOptionsPanel_SchemaSynthesisCodeField";
    public static final String PROPERTY_KEY_INPUT_SYNTHESIS_CODE_FIELDS = "ReactorOptionsPanel_InputSynthesisCodeFields";
    public static final String PROPERTY_KEY_OUTPUT_SYNTHESIS_CODE_FIELD = "ReactorOptionsPanel_OutputSynthesisCodeField";
    public static final String PROPERTY_KEY_MANUAL_SELECTION = "ReactorOptionsPanel_ManualSelection";
    public static final String PROPERTY_KEY_OUTPUT_PATH = "ReactorOptionsPanel_OutputPath";
    public static final String PROPERTY_KEY_OUTPUT_FORMAT = "ReactorOptionsPanel_OutputFormat";
    public static final String PROPERTY_KEY_LAST_USED_DIR = "ReactorOptionsPanel_LastUsedDir";
    public static final String PROPERTY_KEY_MAPPING_STYLE_NAME = "ReactorOptionsPanel_MappingStyleName";
    public static final String PROPERTY_KEY_IGNORE_NAME = "ReactorOptionsPanel_IgnoreName";
    public static final String PROPERTY_KEY_GENERATE_UNSUCCESFUL_REACTIONS = "ReactorOptionsPanel_GenerateUnsuccesfulReactions";
    public static final String PROPERTY_KEY_INCLUDED_PRODUCTS = "ReactorOptionsPanel_IncludedProducts";
    public static final String PROPERTY_KEY_REACTANT_RATIO = "ReactorOptionsPanel_ReactantRatio";
    public static final String PROPERTY_KEY_SOURCE_PROPERTY_NAMES = "SourcePropertyNames";
    public static final String PROPERTY_KEY_TARGET_PROPERTY_NAMES = "TargetPropertyNames";
    public static final String PROPERTY_KEY_PATTERN_BASED_PROPERTY_MAP = "PatternBasedPropertyMap";
    public static final String PROPERTY_VALUE_MULTIPROC_MODE_SEQUENTIAL = "Sequential";
    public static final String PROPERTY_VALUE_MULTIPROC_MODE_COMBINATORICAL = "Combinatorial";
    public static final String PROPERTY_VALUE_OUTPUT_TYPE_PRODUCT = "Product";
    public static final String PROPERTY_VALUE_OUTPUT_TYPE_REACTION = "Reaction";
    public static final String PROPERTY_VALUE_OUTPUT_TYPE_FUSED = "Fused reaction";
    private static final long serialVersionUID = 2270633029935265256L;
    protected static final ConfigElementFactory CONFIG_ELEMENT_FACTORY = new ConfigElementFactory("/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml");
    private static final String MAPPING_STYLE_LABEL_NONE = "None";
    private static final String MAPPING_STYLE_LABEL_CHANGING = "Changing";
    private static final String MAPPING_STYLE_LABEL_COMPLETE = "Complete";
    private static final String MAPPING_STYLE_LABEL_MATCHING = "Matching";
    private boolean reversed = false;
    private JPanel defaultPanel = null;
    private JComboBox cmbMappingStyle = null;
    private JCheckBox chkUnambiguous = null;
    private JComboBox cmbMultipleProcMode = null;
    private JComboBox cmbOutputType = null;
    private JCheckBox chkRuleReactivityExclude = null;
    private JCheckBox chkRuleSelectivity = null;
    private JCheckBox chkRuleTolerance = null;
    private JCheckBox chkGenerateUnsuccesful = null;
    private JCheckBox ignoreErrorsCheck = null;
    private JCheckBox manualSelectionCheck = null;
    private JTextField txtOutputPath = null;
    private JButton buttBrowse = null;
    private AlchemistFileChooserForJChem saveDialog = null;
    private AlchemistFileChooserForJChem openDialog = null;
    private AlchemistFileChooserForJChem saveConfigChooser = null;
    private String fileFormat = null;
    private String ignoreNames = "";
    private JTextField productStandardizationPath = null;
    private JButton browseProductStandardization = null;
    private JPanel productIncludePanel = null;
    private JCheckBox[] productInclude = null;
    private JTextField[] ratioText = null;
    private JPanel ratioPanel = null;
    private JPanel productIncludeEvenPanel = null;
    private JPanel productIncludeOddPanel = null;
    private JPanel advancedOptionsPanel = null;
    private JPanel generalOptionsPanel = null;
    private JPanel propertiesPanel = null;
    private JLabel generateUnsuccesfulLabel = new JLabel("Generate unsuccessful reactions");
    private JLabel manualSelectionLabel = new JLabel("Manual product selection");
    private JTable propertiesTable = null;
    private JCheckBox generateSynthesisCodeCheck = null;
    private JComboBox schemaSynthesisCodeFieldCombo = null;
    private JComboBox[] inputSynthesisCodeFieldCombos = null;
    private JTextField outputSynthesisCodeText = null;
    private JPanel synthesisCodeOptionsPanel = null;
    private JToggleButton synthesisCodeFeaturesToggle = null;
    private JToggleButton propertiesToggle = null;
    private int productCount;
    private JButton clearProductStandardization = null;
    private JButton editProductStandardization = null;
    private ConfigBuilderPanel configBuilderPanel = null;
    private JPanel configBuilderHolderPanel = null;
    private JPanel configBuilderButtonPanel = null;
    private JButton applyButton = null;
    private JButton cancelButton = null;
    private JPanel holderPanel = null;
    private JPanel borderPanel = null;
    private JToggleButton advancedFeaturesToggle;
    private boolean propertyCopyValid = true;
    private long[] reactantIteratorRevisions = null;
    private final AbstractAction EDIT_PRODUCT_STANDARDIZATION_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -1435469133662579719L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ReactorOptionsPanel.this.getProductStandardizationPath().getText().equalsIgnoreCase("")) {
                try {
                    FileInputStream inputStream = new FileInputStream(ReactorOptionsPanel.this.getProductStandardizationPath().getText());
                    StandardizerConfigurationReader reader = new StandardizerConfigurationReader(CONFIG_ELEMENT_FACTORY, inputStream);
                    ReactorOptionsPanel.this.getConfigBuilderPanel().readConfiguration(reader);
                    ((InputStream)inputStream).close();
                }
                catch (FileNotFoundException e1) {
                    JOptionPane.showMessageDialog(ReactorOptionsPanel.this, "File '" + ReactorOptionsPanel.this.getProductStandardizationPath().getText() + "' not found.\nA new file with given name will be created", "File not found", 1);
                }
                catch (Exception e1) {
                    AlchemistErrorDialog.showError("Failed to open configuration", e1);
                }
            }
            ReactorOptionsPanel.this.changeCard();
            ReactorOptionsPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", true, false);
        }
    };
    private final AbstractAction APPLY_CONFIG_EDIT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 799930863190337941L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactorOptionsPanel.this.getProductStandardizationPath().getText().equalsIgnoreCase("") && ReactorOptionsPanel.this.getSaveConfigChooser() != null && ReactorOptionsPanel.this.getSaveConfigChooser().showSaveDialog(ReactorOptionsPanel.this) == 0) {
                ReactorOptionsPanel.this.getProductStandardizationPath().setText(ReactorOptionsPanel.this.getSaveConfigChooser().getSelectedFile().getAbsolutePath());
            }
            if (!ReactorOptionsPanel.this.getProductStandardizationPath().getText().equalsIgnoreCase("")) {
                try {
                    FileOutputStream outputStream = new FileOutputStream(ReactorOptionsPanel.this.getProductStandardizationPath().getText());
                    StandardizerConfigurationWriter writer = new StandardizerConfigurationWriter(outputStream);
                    ReactorOptionsPanel.this.getConfigBuilderPanel().writeConfiguration(writer);
                    ((OutputStream)outputStream).close();
                    ReactorOptionsPanel.this.changeCard();
                    ReactorOptionsPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", false, true);
                }
                catch (Exception e1) {
                    AlchemistErrorDialog.showError("Failed to save configuration", e1);
                }
            }
        }
    };
    private final AbstractAction CANCEL_CONFIG_EDIT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -1330779633226180930L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactorOptionsPanel.this.getConfigBuilderPanel().clear();
            ReactorOptionsPanel.this.changeCard();
            ReactorOptionsPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", false, true);
        }
    };
    private final DocumentListener ratioChangeListener = new DocumentListener(){

        private void handleChanges(DocumentEvent e) {
            if (ReactorOptionsPanel.this.ratioText != null) {
                boolean enabled = true;
                for (JTextField text : ReactorOptionsPanel.this.ratioText) {
                    if ("1".equalsIgnoreCase(text.getText())) continue;
                    enabled = false;
                    break;
                }
                ReactorOptionsPanel.this.getPropertiesToggle().setEnabled(enabled);
                ReactorOptionsPanel.this.getPropertiesPanel().setVisible(enabled && ReactorOptionsPanel.this.getPropertiesToggle().isSelected());
            }
            ReactorOptionsPanel.this.getNotifier().firePropertyChange(ReactorOptionsPanel.PROPERTY_KEY_REACTANT_RATIO, false, true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChanges(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChanges(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChanges(e);
        }
    };

    public ReactorOptionsPanel() {
        this.initialize();
        this.getBottomPanel().setBackground(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
        this.getBottomTextLabel().setOpaque(false);
        this.setBottomTextVisible(false);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHolderPanel(), "Center");
        try {
            this.setSaveDialog(new AlchemistFileChooserForJChem());
            this.getSaveDialog().addDefaultSaveFileFilters();
            this.getSaveDialog().setAcceptAllFileFilterUsed(false);
            this.setOpenDialog(new AlchemistFileChooserForJChem());
            this.getOpenDialog().addChoosableFileFilter(new XMLFileFilter());
            this.getOpenDialog().setAcceptAllFileFilterUsed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int[] getRatio() {
        int[] data = new int[this.ratioText.length];
        for (int i = 0; i < data.length; ++i) {
            try {
                data[i] = Integer.parseInt(this.ratioText[i].getText().trim());
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (data.length == 1 && data[0] >= 0) {
            return data;
        }
        boolean valid = true;
        int oneCount = 0;
        HashSet<Integer> values = new HashSet<Integer>();
        for (int i = 0; i < data.length && valid; ++i) {
            if (data[i] == 1) {
                ++oneCount;
            }
            if (data[i] < 0) {
                valid = false;
                continue;
            }
            values.add(data[i]);
        }
        if (oneCount != 1 && oneCount != data.length) {
            valid = false;
        }
        if (values.size() > 2) {
            valid = false;
        }
        return (int[])(valid ? data : null);
    }

    protected AlchemistFileChooserForJChem getSaveConfigChooser() {
        if (this.saveConfigChooser == null) {
            try {
                this.saveConfigChooser = new AlchemistFileChooserForJChem();
                this.saveConfigChooser.setFileFilter(new XMLFileFilter());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.saveConfigChooser;
    }

    @Override
    public boolean isCorrect() {
        int i;
        this.setBottomTextVisible(false);
        boolean isProductSelected = false;
        if (!this.propertyCopyValid) {
            return false;
        }
        for (i = 0; i < this.productInclude.length; ++i) {
            isProductSelected = isProductSelected || this.productInclude[i].isSelected();
        }
        if (this.getRatio() == null) {
            if (this.ratioText.length == 1) {
                this.setBottomText("Invalid ratio. Ratio must be a positive integer or 0.");
            } else if (this.ratioText.length == 2) {
                this.setBottomText("Invalid ratio. Ratio must be in format \"1:N\" or \"N:1\", where N is a positive integer or 0.");
            } else if (this.ratioText.length == 3) {
                this.setBottomText("Invalid ratio. Ratio must be in format \"1:N:N\", \"N:1:N\" or \"N:N:1\", where N is a positive integer or 0.");
            } else {
                this.setBottomText("Invalid ratio. Ratio must be in format \"1:N:N:N\", where N is a positive integer or 0. Position of the \"1\" is variable.");
            }
            this.setBottomTextVisible(true);
            return false;
        }
        if (!this.reversed && this.getGenerateSynthesisCodeCheck().isSelected()) {
            if (this.getSchemaSynthesisCodeFieldCombo().getSelectedItem() == null) {
                this.setBottomText("No schema synthesis code field selected. Select a field, or disable synthesis code generation.");
                this.setBottomTextVisible(true);
                return false;
            }
            if (this.getOutputSynthesisCodeText().getText().trim().length() == 0) {
                this.setBottomText("No output synthesis code field selected. Select a field, or disable synthesis code generation.");
                this.setBottomTextVisible(true);
                return false;
            }
            for (i = 0; i < this.getInputSynthesisCodeFieldCombos().length; ++i) {
                if (this.getInputSynthesisCodeFieldCombos()[i] != null && this.getInputSynthesisCodeFieldCombos()[i].getSelectedItem() != null) continue;
                this.setBottomText("No synthesis code field selected. Select a field, or disable synthesis code generation.");
                this.setBottomTextVisible(true);
                return false;
            }
        }
        return this.txtOutputPath.getText().length() > 0 && (isProductSelected || ((String)this.cmbOutputType.getSelectedItem()).equalsIgnoreCase(PROPERTY_VALUE_OUTPUT_TYPE_REACTION));
    }

    private JPanel getDefaultPanel() {
        if (this.defaultPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.defaultPanel = new JPanel(new BorderLayout());
            this.defaultPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.defaultPanel.setLayout((LayoutManager)new FormLayout("4dlu, pref, fill:min:grow, 4dlu", "4dlu, pref, 2dlu, min, 2dlu, pref, 2dlu, min, 2dlu, pref, 2dlu, min, 2dlu, pref, 4dlu"));
            this.defaultPanel.setFont(new Font("Tahoma", 1, 11));
            this.defaultPanel.setName("pnlDefault");
            this.defaultPanel.add((Component)this.getGeneralOptionsPanel(), cc.xyw(2, 2, 2));
            this.defaultPanel.add((Component)this.getAdvancedFeaturesToggle(), cc.xy(2, 4));
            this.defaultPanel.add((Component)this.getAdvancedOptionsPanel(), cc.xyw(2, 6, 2));
            this.defaultPanel.add((Component)this.getSynthesisCodeFeaturesToggle(), cc.xy(2, 8));
            this.defaultPanel.add((Component)this.getSynthesisCodeOptionsPanel(), cc.xyw(2, 10, 2));
            this.defaultPanel.add((Component)this.getPropertiesToggle(), cc.xy(2, 12));
            this.defaultPanel.add((Component)this.getPropertiesPanel(), cc.xyw(2, 14, 2));
            this.getAdvancedOptionsPanel().setVisible(false);
            this.getSynthesisCodeOptionsPanel().setVisible(false);
            this.getPropertiesPanel().setVisible(false);
        }
        return this.defaultPanel;
    }

    protected JPanel getSynthesisCodeOptionsPanel() {
        if (this.synthesisCodeOptionsPanel == null) {
            this.synthesisCodeOptionsPanel = new JPanel();
        }
        return this.synthesisCodeOptionsPanel;
    }

    protected JPanel getPropertiesPanel() {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new JPanel(new BorderLayout());
            JScrollPane scroll = new JScrollPane(20, 31);
            scroll.setViewportView(this.getPropertiesTable());
            scroll.getViewport().setBackground(Color.WHITE);
            this.propertiesPanel.add((Component)scroll, "North");
        }
        return this.propertiesPanel;
    }

    protected JTable getPropertiesTable() {
        if (this.propertiesTable == null) {
            this.propertiesTable = ReactorPropertyCopyUtils.createCopyPropertyTable(null);
            this.propertiesTable.addPropertyChangeListener("PropertyCopyValid", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() instanceof Boolean) {
                        ReactorOptionsPanel.this.propertyCopyValid = (Boolean)evt.getNewValue();
                    }
                    ReactorOptionsPanel.this.getNotifier().firePropertyChange(evt);
                }
            });
        }
        return this.propertiesTable;
    }

    private JPanel getGeneralOptionsPanel() {
        if (this.generalOptionsPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.generalOptionsPanel = new JPanel((LayoutManager)new FormLayout("pref, 2dlu, fill:min:grow, min", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref"));
            this.generalOptionsPanel.add((Component)new JLabel("Output file"), cc.xy(1, 1));
            this.generalOptionsPanel.add((Component)this.getTxtOutputPath(), cc.xy(3, 1));
            this.generalOptionsPanel.add((Component)this.getButtBrowse(), cc.xy(4, 1));
            this.generalOptionsPanel.add((Component)new JLabel("Reactant combination"), cc.xy(1, 3));
            this.generalOptionsPanel.add((Component)this.getCmbMultipleProcMode(), cc.xyw(3, 3, 2));
            this.generalOptionsPanel.add((Component)new JLabel("Output type"), cc.xy(1, 5));
            this.generalOptionsPanel.add((Component)this.getCmbOutputType(), cc.xyw(3, 5, 2));
            this.generalOptionsPanel.add((Component)new JLabel("Mapping style"), cc.xy(1, 7));
            this.generalOptionsPanel.add((Component)this.getCmbMappingStyle(), cc.xyw(3, 7, 2));
            this.generalOptionsPanel.add((Component)this.manualSelectionLabel, cc.xy(1, 9));
            this.generalOptionsPanel.add((Component)this.getManualSelectionCheck(), cc.xyw(3, 9, 2));
            this.generalOptionsPanel.add((Component)new JLabel("Ignore errors"), cc.xy(1, 11));
            this.generalOptionsPanel.add((Component)this.getIgnoreErrorsCheck(), cc.xyw(3, 11, 2));
        }
        return this.generalOptionsPanel;
    }

    protected JPanel getAdvancedOptionsPanel() {
        if (this.advancedOptionsPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.advancedOptionsPanel = new JPanel((LayoutManager)new FormLayout("pref, 2dlu, fill:min:grow, min, min, min", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref"));
            this.advancedOptionsPanel.add((Component)new JLabel("Ratio"), cc.xy(1, 1));
            this.advancedOptionsPanel.add((Component)this.getRatioPanel(), cc.xyw(3, 1, 4));
            this.advancedOptionsPanel.add((Component)new JLabel("Product standardization"), cc.xy(1, 3));
            this.advancedOptionsPanel.add((Component)this.getProductStandardization(), cc.xy(3, 3));
            this.advancedOptionsPanel.add((Component)this.getClearProductStandardization(), cc.xy(4, 3));
            this.advancedOptionsPanel.add((Component)this.getEditProductStandardization(), cc.xy(5, 3));
            this.advancedOptionsPanel.add((Component)this.getBrowseProductStandardization(), cc.xy(6, 3));
            this.advancedOptionsPanel.add((Component)this.generateUnsuccesfulLabel, cc.xy(1, 5));
            this.advancedOptionsPanel.add((Component)this.getChkGenerateUnsuccesful(), cc.xyw(3, 5, 4));
            this.advancedOptionsPanel.add((Component)new JLabel("Unambiguous only"), cc.xy(1, 7));
            this.advancedOptionsPanel.add((Component)this.getChkUnambiguous(), cc.xyw(3, 7, 4));
            this.advancedOptionsPanel.add((Component)new JLabel("Ignore reaction rules"), cc.xy(1, 9));
            this.advancedOptionsPanel.add((Component)this.getCmbRuleReactivityExclude(), cc.xyw(3, 9, 4));
            this.advancedOptionsPanel.add((Component)this.getChkRuleSelectivity(), cc.xyw(3, 11, 4));
            this.advancedOptionsPanel.add((Component)this.getChkRuleTolerance(), cc.xyw(3, 11, 4));
            this.advancedOptionsPanel.add((Component)new JLabel("Included products"), cc.xy(1, 15));
            this.advancedOptionsPanel.add((Component)this.getProductIncludePanel(), cc.xyw(3, 15, 4));
        }
        return this.advancedOptionsPanel;
    }

    protected JComboBox getCmbMappingStyle() {
        if (this.cmbMappingStyle == null) {
            this.cmbMappingStyle = new JComboBox();
            this.cmbMappingStyle.addItem(MAPPING_STYLE_LABEL_NONE);
            this.cmbMappingStyle.addItem(MAPPING_STYLE_LABEL_CHANGING);
            this.cmbMappingStyle.addItem(MAPPING_STYLE_LABEL_COMPLETE);
            this.cmbMappingStyle.addItem(MAPPING_STYLE_LABEL_MATCHING);
        }
        return this.cmbMappingStyle;
    }

    private JCheckBox getManualSelectionCheck() {
        if (this.manualSelectionCheck == null) {
            this.manualSelectionCheck = new JCheckBox();
        }
        return this.manualSelectionCheck;
    }

    private JCheckBox getChkUnambiguous() {
        if (this.chkUnambiguous == null) {
            this.chkUnambiguous = new JCheckBox();
        }
        return this.chkUnambiguous;
    }

    private JComboBox getCmbMultipleProcMode() {
        if (this.cmbMultipleProcMode == null) {
            this.cmbMultipleProcMode = new JComboBox();
            this.cmbMultipleProcMode.addItem(PROPERTY_VALUE_MULTIPROC_MODE_SEQUENTIAL);
            this.cmbMultipleProcMode.addItem(PROPERTY_VALUE_MULTIPROC_MODE_COMBINATORICAL);
        }
        return this.cmbMultipleProcMode;
    }

    protected JComboBox getCmbOutputType() {
        if (this.cmbOutputType == null) {
            this.cmbOutputType = new JComboBox();
            this.cmbOutputType.addItem(PROPERTY_VALUE_OUTPUT_TYPE_PRODUCT);
            this.cmbOutputType.addItem(PROPERTY_VALUE_OUTPUT_TYPE_REACTION);
            this.cmbOutputType.addItem(PROPERTY_VALUE_OUTPUT_TYPE_FUSED);
            this.cmbOutputType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorOptionsPanel.this.getNotifier().firePropertyChange(ReactorOptionsPanel.PROPERTY_KEY_OUTPUT_TYPE, null, ReactorOptionsPanel.this.getCmbOutputType().getSelectedItem());
                    ReactorOptionsPanel.this.getCmbMappingStyle().setEnabled(((String)ReactorOptionsPanel.this.getCmbOutputType().getSelectedItem()).equalsIgnoreCase(ReactorOptionsPanel.PROPERTY_VALUE_OUTPUT_TYPE_REACTION));
                    if (!ReactorOptionsPanel.this.getCmbMappingStyle().isEnabled()) {
                        ReactorOptionsPanel.this.getCmbMappingStyle().setSelectedIndex(0);
                    }
                    ReactorOptionsPanel.this.getChkGenerateUnsuccesful().setEnabled(!ReactorOptionsPanel.PROPERTY_VALUE_OUTPUT_TYPE_PRODUCT.equals(ReactorOptionsPanel.this.cmbOutputType.getSelectedItem()));
                    ReactorOptionsPanel.this.generateUnsuccesfulLabel.setEnabled(!ReactorOptionsPanel.PROPERTY_VALUE_OUTPUT_TYPE_PRODUCT.equals(ReactorOptionsPanel.this.cmbOutputType.getSelectedItem()));
                    ReactorOptionsPanel.this.getManualSelectionCheck().setEnabled(!ReactorOptionsPanel.this.reversed && !ReactorOptionsPanel.PROPERTY_VALUE_OUTPUT_TYPE_FUSED.equals(ReactorOptionsPanel.this.cmbOutputType.getSelectedItem()));
                    ReactorOptionsPanel.this.manualSelectionLabel.setEnabled(!ReactorOptionsPanel.this.reversed && !ReactorOptionsPanel.PROPERTY_VALUE_OUTPUT_TYPE_FUSED.equals(ReactorOptionsPanel.this.cmbOutputType.getSelectedItem()));
                }
            });
        }
        return this.cmbOutputType;
    }

    private JCheckBox getIgnoreErrorsCheck() {
        if (this.ignoreErrorsCheck == null) {
            this.ignoreErrorsCheck = new JCheckBox();
        }
        return this.ignoreErrorsCheck;
    }

    private JCheckBox getCmbRuleReactivityExclude() {
        if (this.chkRuleReactivityExclude == null) {
            this.chkRuleReactivityExclude = new JCheckBox();
            this.chkRuleReactivityExclude.setText("Reactivity and exclude");
        }
        return this.chkRuleReactivityExclude;
    }

    private JCheckBox getChkRuleSelectivity() {
        if (this.chkRuleSelectivity == null) {
            this.chkRuleSelectivity = new JCheckBox();
            this.chkRuleSelectivity.setText("Selectivity");
        }
        return this.chkRuleSelectivity;
    }

    private JCheckBox getChkRuleTolerance() {
        if (this.chkRuleTolerance == null) {
            this.chkRuleTolerance = new JCheckBox();
            this.chkRuleTolerance.setText("Tolerance");
        }
        return this.chkRuleTolerance;
    }

    private JCheckBox getChkGenerateUnsuccesful() {
        if (this.chkGenerateUnsuccesful == null) {
            this.chkGenerateUnsuccesful = new JCheckBox();
        }
        return this.chkGenerateUnsuccesful;
    }

    protected JTextField getTxtOutputPath() {
        if (this.txtOutputPath == null) {
            this.txtOutputPath = new JTextField();
            this.txtOutputPath.setEnabled(false);
        }
        return this.txtOutputPath;
    }

    private JButton getButtBrowse() {
        if (this.buttBrowse == null) {
            this.buttBrowse = new JButton();
            this.buttBrowse.setText("Browse...");
            this.buttBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReactorOptionsPanel.this.getSaveDialog() != null) {
                        if (ReactorOptionsPanel.this.getSaveDialog().showSaveDialog(null) == 0) {
                            String outputPath = ReactorOptionsPanel.this.getSaveDialog().getSelectedFile().getAbsolutePath();
                            String extension = ((MolFileFilter)ReactorOptionsPanel.this.getSaveDialog().getFileFilter()).getExtension();
                            ReactorOptionsPanel.this.getTxtOutputPath().setText(outputPath.endsWith(extension) ? outputPath : outputPath + "." + extension);
                            ReactorOptionsPanel.this.setFileFormat(((MolFileFilter)ReactorOptionsPanel.this.getSaveDialog().getFileFilter()).getFormat());
                        }
                        ReactorOptionsPanel.this.getNotifier().firePropertyChange(ReactorOptionsPanel.PROPERTY_KEY_OUTPUT_PATH, null, ReactorOptionsPanel.this.getTxtOutputPath().getText());
                    }
                }
            });
        }
        return this.buttBrowse;
    }

    protected JCheckBox getGenerateSynthesisCodeCheck() {
        if (this.generateSynthesisCodeCheck == null) {
            this.generateSynthesisCodeCheck = new JCheckBox(new AbstractAction(){
                private static final long serialVersionUID = 5718705111160784898L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean enabled = ReactorOptionsPanel.this.getGenerateSynthesisCodeCheck().isSelected();
                    ReactorOptionsPanel.this.getSchemaSynthesisCodeFieldCombo().setEnabled(enabled);
                    ReactorOptionsPanel.this.getOutputSynthesisCodeText().setEnabled(enabled);
                    for (int i = 0; i < ReactorOptionsPanel.this.getInputSynthesisCodeFieldCombos().length; ++i) {
                        ReactorOptionsPanel.this.getInputSynthesisCodeFieldCombos()[i].setEnabled(enabled);
                    }
                    ReactorOptionsPanel.this.getNotifier().firePropertyChange(ReactorOptionsPanel.PROPERTY_KEY_GENERATE_SYNTHESIS_CODE, !enabled, enabled);
                }
            });
        }
        return this.generateSynthesisCodeCheck;
    }

    protected JComboBox getSchemaSynthesisCodeFieldCombo() {
        if (this.schemaSynthesisCodeFieldCombo == null) {
            this.schemaSynthesisCodeFieldCombo = new JComboBox();
            this.schemaSynthesisCodeFieldCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorOptionsPanel.this.getNotifier().firePropertyChange(ReactorOptionsPanel.PROPERTY_KEY_SCHEMA_SYNTHESIS_CODE_FIELD, null, ReactorOptionsPanel.this.getSchemaSynthesisCodeFieldCombo().getSelectedItem());
                }
            });
            this.schemaSynthesisCodeFieldCombo.setEnabled(this.getGenerateSynthesisCodeCheck().isSelected());
        }
        return this.schemaSynthesisCodeFieldCombo;
    }

    protected JTextField getOutputSynthesisCodeText() {
        if (this.outputSynthesisCodeText == null) {
            this.outputSynthesisCodeText = new JTextField();
            this.outputSynthesisCodeText.setEnabled(this.getGenerateSynthesisCodeCheck().isSelected());
            this.outputSynthesisCodeText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    ReactorOptionsPanel.this.getNotifier().firePropertyChange(ReactorOptionsPanel.PROPERTY_KEY_OUTPUT_SYNTHESIS_CODE_FIELD, null, ReactorOptionsPanel.this.getOutputSynthesisCodeText().getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.outputSynthesisCodeText;
    }

    private Integer getMappingStyle() {
        Object mappingStyle = this.getCmbMappingStyle().getSelectedItem();
        if (MAPPING_STYLE_LABEL_CHANGING.equals(mappingStyle)) {
            return 1;
        }
        if (MAPPING_STYLE_LABEL_COMPLETE.equals(mappingStyle)) {
            return 2;
        }
        if (MAPPING_STYLE_LABEL_MATCHING.equals(mappingStyle)) {
            return 3;
        }
        return 0;
    }

    private Integer getIgonoreRules() {
        int retVal = 0;
        this.ignoreNames = "";
        if (this.chkRuleReactivityExclude.isSelected()) {
            retVal = 1;
            this.ignoreNames = "Reactivity and Exclude";
        }
        if (this.chkRuleSelectivity.isSelected()) {
            retVal |= 2;
            if ("".equals(this.ignoreNames)) {
                this.ignoreNames = this.ignoreNames + "|";
            }
            this.ignoreNames = this.ignoreNames + "Selectivity";
        }
        if (this.chkRuleTolerance.isSelected()) {
            retVal |= 4;
            if ("".equals(this.ignoreNames)) {
                this.ignoreNames = this.ignoreNames + "|";
            }
            this.ignoreNames = this.ignoreNames + "Tolerance";
        }
        return retVal;
    }

    @Override
    public void enterPage(AlchemistState state) {
        int i;
        int i2;
        File lastDir;
        String path;
        RxnMolecule reaction = RxnMolecule.getReaction((Molecule)state.getProperty("ReactorInputPanel_SelectedReaction"));
        this.reversed = (Boolean)state.getProperty("ReactorInputPanel_Reversed");
        Object[] iterators = (Object[])state.getProperty("ReactorReactantSelector_ReactantIteratorArray");
        String multiprocMode = (String)state.getProperty(PROPERTY_KEY_MULTIPLE_PROC_MODE);
        if (iterators.length == 1) {
            multiprocMode = null;
        }
        if (multiprocMode != null) {
            this.cmbMultipleProcMode.setSelectedItem(multiprocMode);
        } else {
            this.cmbMultipleProcMode.setSelectedIndex(0);
        }
        this.cmbMultipleProcMode.setEnabled(iterators.length != 1);
        this.cmbMappingStyle.setEnabled(this.cmbOutputType.getSelectedIndex() == 1);
        if (this.getSaveDialog() != null && (path = (String)state.getProperty(PROPERTY_KEY_LAST_USED_DIR)) != null && (lastDir = new File(path)).isDirectory()) {
            this.getSaveDialog().setCurrentDirectory(lastDir);
        }
        if (this.getOpenDialog() != null && (path = (String)state.getProperty(PROPERTY_KEY_LAST_STANDARDIZATION_DIR)) != null && (lastDir = new File(path)).isDirectory()) {
            this.getOpenDialog().setCurrentDirectory(lastDir);
        }
        this.productCount = this.reversed ? reaction.getReactantCount() : reaction.getProductCount();
        int[] includedProducts = (int[])state.getProperty(PROPERTY_KEY_INCLUDED_PRODUCTS);
        this.createProductIncludeCheckBoxes(this.productCount);
        if (includedProducts != null) {
            for (i2 = 0; i2 < includedProducts.length; ++i2) {
                if (includedProducts[i2] >= this.productInclude.length) continue;
                this.productInclude[includedProducts[i2]].setSelected(true);
            }
        } else {
            for (i2 = 0; i2 < this.productInclude.length; ++i2) {
                this.productInclude[i2].setSelected(true);
            }
        }
        int reactantCount = this.reversed ? reaction.getProductCount() : reaction.getReactantCount();
        this.createRatioTextAreas(reactantCount, (int[])state.getProperty(PROPERTY_KEY_REACTANT_RATIO));
        this.createInputSynthCodeComboBoxes(reactantCount, state);
        String outputField = (String)state.getProperty(PROPERTY_KEY_OUTPUT_SYNTHESIS_CODE_FIELD);
        this.getOutputSynthesisCodeText().setText(outputField == null ? "Synthesis Code" : outputField);
        if (this.reversed) {
            this.getSynthesisCodeFeaturesToggle().setSelected(false);
            this.getSynthesisCodeOptionsPanel().setVisible(false);
        }
        this.getSynthesisCodeFeaturesToggle().setEnabled(!this.reversed);
        this.getChkGenerateUnsuccesful().setEnabled(!PROPERTY_VALUE_OUTPUT_TYPE_PRODUCT.equals(this.cmbOutputType.getSelectedItem()));
        this.generateUnsuccesfulLabel.setEnabled(!PROPERTY_VALUE_OUTPUT_TYPE_PRODUCT.equals(this.cmbOutputType.getSelectedItem()));
        this.getManualSelectionCheck().setEnabled(!this.reversed && !PROPERTY_VALUE_OUTPUT_TYPE_FUSED.equals(this.cmbOutputType.getSelectedItem()));
        this.manualSelectionLabel.setEnabled(!this.reversed && !PROPERTY_VALUE_OUTPUT_TYPE_FUSED.equals(this.cmbOutputType.getSelectedItem()));
        if (this.reactantIteratorRevisions == null) {
            this.reactantIteratorRevisions = (long[])state.getProperty("ReactorReactantSelector_IteratorRevisions");
            ((DefaultTableModel)this.getPropertiesTable().getModel()).setRowCount(0);
        } else {
            long[] revisions = (long[])state.getProperty("ReactorReactantSelector_IteratorRevisions");
            if (revisions != null && revisions.length == this.reactantIteratorRevisions.length) {
                for (i = 0; i < revisions.length; ++i) {
                    if (revisions[i] == this.reactantIteratorRevisions[i]) continue;
                    ((DefaultTableModel)this.getPropertiesTable().getModel()).setRowCount(0);
                    break;
                }
            } else {
                ((DefaultTableModel)this.getPropertiesTable().getModel()).setRowCount(0);
            }
            this.reactantIteratorRevisions = revisions;
        }
        Iterator[] clones = new Iterator[iterators.length];
        for (i = 0; i < clones.length; ++i) {
            if (!(iterators[i] instanceof AbstractAlchemistMoleculeEditor.MoleculeIteratorImpl)) continue;
            try {
                clones[i] = (Iterator)((AbstractAlchemistMoleculeEditor.MoleculeIteratorImpl)iterators[i]).clone();
                continue;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        ReactorPropertyCopyUtils.updateEditors(clones, this.getPropertiesTable());
    }

    @Override
    public void leavePage(AlchemistState state) {
        state.setProperty(PROPERTY_KEY_PRODUCT_STANDARDIZATION_FILE, new File(this.getProductStandardization().getText()));
        state.setProperty(PROPERTY_KEY_MAPPING_STYLE, this.getMappingStyle());
        state.setProperty(PROPERTY_KEY_GENERATE_UNSUCCESFUL_REACTIONS, this.chkGenerateUnsuccesful.isSelected() && !PROPERTY_VALUE_OUTPUT_TYPE_PRODUCT.equals(this.getCmbOutputType().getSelectedItem()));
        state.setProperty(PROPERTY_KEY_MANUAL_SELECTION, this.getManualSelectionCheck().isSelected() && !PROPERTY_VALUE_OUTPUT_TYPE_FUSED.equals(this.getCmbOutputType().getSelectedItem()));
        state.setProperty(PROPERTY_KEY_UNAMBIGOUS, this.chkUnambiguous.isSelected());
        state.setPersistentProperty(PROPERTY_KEY_MULTIPLE_PROC_MODE, this.cmbMultipleProcMode.getSelectedItem());
        state.setProperty(PROPERTY_KEY_OUTPUT_TYPE, this.cmbOutputType.getSelectedItem());
        state.setProperty(PROPERTY_KEY_IGNORE, this.getIgonoreRules());
        state.setProperty(PROPERTY_KEY_OUTPUT_PATH, this.txtOutputPath.getText());
        state.setProperty(PROPERTY_KEY_OUTPUT_FORMAT, this.getFileFormat());
        state.setProperty(PROPERTY_KEY_IGNORE_ERRORS, this.getIgnoreErrorsCheck().isSelected());
        state.setProperty(PROPERTY_KEY_GENERATE_SYNTHESIS_CODE, this.getGenerateSynthesisCodeCheck().isSelected());
        String[] input = new String[this.getInputSynthesisCodeFieldCombos().length];
        Boolean[] genFromFile = new Boolean[this.getInputSynthesisCodeFieldCombos().length];
        for (int i = 0; i < input.length; ++i) {
            input[i] = (String)this.getInputSynthesisCodeFieldCombos()[i].getSelectedItem();
            genFromFile[i] = this.getInputSynthesisCodeFieldCombos()[i].getSelectedIndex() == 0;
        }
        state.setProperty(PROPERTY_KEY_GENERATE_SCHEMA_SYNTHESIS_CODE_FROM_FILENAME, this.getSchemaSynthesisCodeFieldCombo().getSelectedIndex() == 0);
        state.setProperty(PROPERTY_KEY_GENERATE_INPUT_SYNTHESIS_CODE_FROM_FILENAME, genFromFile);
        if (this.getGenerateSynthesisCodeCheck().isSelected()) {
            state.setPersistentProperty(PROPERTY_KEY_SCHEMA_SYNTHESIS_CODE_FIELD, this.getSchemaSynthesisCodeFieldCombo().getSelectedItem());
            state.setPersistentProperty(PROPERTY_KEY_OUTPUT_SYNTHESIS_CODE_FIELD, this.getOutputSynthesisCodeText().getText());
            state.setPersistentProperty(PROPERTY_KEY_INPUT_SYNTHESIS_CODE_FIELDS, input);
        } else {
            state.setProperty(PROPERTY_KEY_SCHEMA_SYNTHESIS_CODE_FIELD, this.getSchemaSynthesisCodeFieldCombo().getSelectedItem());
            state.setProperty(PROPERTY_KEY_OUTPUT_SYNTHESIS_CODE_FIELD, this.getOutputSynthesisCodeText().getText());
            state.setProperty(PROPERTY_KEY_INPUT_SYNTHESIS_CODE_FIELDS, input);
        }
        if (this.getSaveDialog() != null) {
            state.setPersistentProperty(PROPERTY_KEY_LAST_USED_DIR, this.getSaveDialog().getCurrentDirectory().getAbsolutePath());
        }
        if (this.getOpenDialog() != null) {
            state.setPersistentProperty(PROPERTY_KEY_LAST_STANDARDIZATION_DIR, this.getOpenDialog().getCurrentDirectory().getAbsolutePath());
        }
        state.setProperty(PROPERTY_KEY_REACTANT_RATIO, this.getRatio());
        state.setProperty(PROPERTY_KEY_IGNORE_NAME, this.ignoreNames);
        state.setProperty(PROPERTY_KEY_MAPPING_STYLE_NAME, this.cmbMappingStyle.getSelectedItem().toString());
        ArrayList<Integer> includeList = new ArrayList<Integer>();
        for (int i = 0; i < this.productCount; ++i) {
            if (!this.productInclude[i].isSelected()) continue;
            includeList.add(i);
        }
        int[] included = new int[includeList.size()];
        for (int i = 0; i < includeList.size(); ++i) {
            included[i] = (Integer)includeList.get(i);
        }
        state.setProperty(PROPERTY_KEY_INCLUDED_PRODUCTS, included);
        state.setProperty(PROPERTY_KEY_SOURCE_PROPERTY_NAMES, ReactorPropertyCopyUtils.getSourcePropertyNames(this.getPropertiesTable()));
        state.setProperty(PROPERTY_KEY_TARGET_PROPERTY_NAMES, ReactorPropertyCopyUtils.getTargetPropertyNames(this.getPropertiesTable()));
        state.setProperty(PROPERTY_KEY_PATTERN_BASED_PROPERTY_MAP, ReactorPropertyCopyUtils.getPatterBasedPropertyData(this.getPropertiesTable()));
    }

    protected JToggleButton getAdvancedFeaturesToggle() {
        if (this.advancedFeaturesToggle == null) {
            this.advancedFeaturesToggle = new JToggleButton("Advanced options...");
            this.advancedFeaturesToggle.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/down.gif")));
            this.advancedFeaturesToggle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/up.gif")));
            this.advancedFeaturesToggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorOptionsPanel.this.getAdvancedOptionsPanel().setVisible(ReactorOptionsPanel.this.getAdvancedFeaturesToggle().isSelected());
                }
            });
        }
        return this.advancedFeaturesToggle;
    }

    protected JToggleButton getSynthesisCodeFeaturesToggle() {
        if (this.synthesisCodeFeaturesToggle == null) {
            this.synthesisCodeFeaturesToggle = new JToggleButton("Synthesis code options...");
            this.synthesisCodeFeaturesToggle.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/down.gif")));
            this.synthesisCodeFeaturesToggle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/up.gif")));
            this.synthesisCodeFeaturesToggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorOptionsPanel.this.getSynthesisCodeOptionsPanel().setVisible(ReactorOptionsPanel.this.getSynthesisCodeFeaturesToggle().isSelected());
                }
            });
        }
        return this.synthesisCodeFeaturesToggle;
    }

    protected JToggleButton getPropertiesToggle() {
        if (this.propertiesToggle == null) {
            this.propertiesToggle = new JToggleButton("Property Copy...");
            this.propertiesToggle.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/down.gif")));
            this.propertiesToggle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/up.gif")));
            this.propertiesToggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorOptionsPanel.this.getPropertiesPanel().setVisible(ReactorOptionsPanel.this.getPropertiesToggle().isSelected());
                }
            });
        }
        return this.propertiesToggle;
    }

    private JTextField getProductStandardization() {
        if (this.getProductStandardizationPath() == null) {
            this.setProductStandardizationPath(new JTextField());
            this.getProductStandardizationPath().setEnabled(false);
        }
        return this.getProductStandardizationPath();
    }

    private JButton getBrowseProductStandardization() {
        if (this.browseProductStandardization == null) {
            this.browseProductStandardization = new JButton();
            this.browseProductStandardization.setText("Browse...");
            this.browseProductStandardization.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReactorOptionsPanel.this.getOpenDialog() != null) {
                        if (ReactorOptionsPanel.this.getOpenDialog().showOpenDialog(null) == 0) {
                            ReactorOptionsPanel.this.getProductStandardizationPath().setText(ReactorOptionsPanel.this.getOpenDialog().getSelectedFile().getAbsolutePath());
                            ReactorOptionsPanel.this.getClearProductStandardization().setEnabled(true);
                        }
                        ReactorOptionsPanel.this.getNotifier().firePropertyChange(ReactorOptionsPanel.PROPERTY_KEY_PRODUCT_STANDARDIZATION_FILE, null, ReactorOptionsPanel.this.getProductStandardizationPath().getText());
                    }
                }
            });
        }
        return this.browseProductStandardization;
    }

    private JPanel getProductIncludePanel() {
        if (this.productIncludePanel == null) {
            this.productIncludePanel = new JPanel();
            this.productIncludePanel.setLayout(new BoxLayout(this.getProductIncludePanel(), 0));
            this.productIncludePanel.add((Component)this.getProductIncludeEvenPanel(), null);
            this.productIncludePanel.add((Component)this.getProductIncludeOddPanel(), null);
        }
        return this.productIncludePanel;
    }

    private JPanel getRatioPanel() {
        if (this.ratioPanel == null) {
            this.ratioPanel = new JPanel();
            this.ratioPanel.setLayout(new FlowLayout(0, 0, 0));
        }
        return this.ratioPanel;
    }

    private void createRatioTextAreas(int numberOfReactants, int[] ratio) {
        int i;
        if (this.ratioText != null) {
            for (i = 0; i < this.ratioText.length; ++i) {
                this.ratioText[i].getDocument().removeDocumentListener(this.ratioChangeListener);
            }
        }
        this.getRatioPanel().removeAll();
        this.ratioText = new JTextField[numberOfReactants];
        for (i = 0; i < this.ratioText.length; ++i) {
            this.ratioText[i] = new JFormattedTextField(NumberFormat.getInstance());
            Dimension dim = this.ratioText[i].getPreferredSize();
            dim.width = 30;
            if (ratio != null && this.ratioText.length == ratio.length) {
                this.ratioText[i].setText(String.valueOf(ratio[i]));
            } else {
                this.ratioText[i].setText("1");
            }
            this.ratioText[i].setPreferredSize(dim);
            this.ratioText[i].getDocument().addDocumentListener(this.ratioChangeListener);
            this.getRatioPanel().add(this.ratioText[i]);
            if (i < this.ratioText.length - 1) {
                this.getRatioPanel().add(new JLabel(":"));
            }
            this.getRatioPanel().add(Box.createHorizontalGlue());
        }
        this.isCorrect();
    }

    private void createProductIncludeCheckBoxes(int numberOfProducts) {
        this.getProductIncludeEvenPanel().removeAll();
        this.getProductIncludeOddPanel().removeAll();
        this.productInclude = new JCheckBox[numberOfProducts];
        for (int i = 0; i < this.productInclude.length; ++i) {
            this.productInclude[i] = new JCheckBox(this.productInclude.length > 1 ? "Product " + (i + 1) : PROPERTY_VALUE_OUTPUT_TYPE_PRODUCT);
            this.productInclude[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorOptionsPanel.this.getNotifier().firePropertyChange(ReactorOptionsPanel.PROPERTY_KEY_INCLUDED_PRODUCTS, null, null);
                }
            });
            if (i % 2 == 0) {
                this.getProductIncludeEvenPanel().add(this.productInclude[i]);
                continue;
            }
            this.getProductIncludeOddPanel().add(this.productInclude[i]);
        }
        if (this.productInclude.length == 1) {
            this.productInclude[0].setEnabled(false);
        }
    }

    private void createInputSynthCodeComboBoxes(int numberOfinputs, AlchemistState state) {
        this.getSynthesisCodeOptionsPanel().removeAll();
        this.setInputSynthesisCodeFieldCombos(new JComboBox[numberOfinputs]);
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref, 2dlu, fill:min:grow"), this.getSynthesisCodeOptionsPanel());
        builder.append("Generate synthesis code", (Component)this.getGenerateSynthesisCodeCheck());
        builder.append("Field name in schema", (Component)this.getSchemaSynthesisCodeFieldCombo());
        this.initializeSchemaSynthCodeCombo(state);
        for (int i = 0; i < numberOfinputs; ++i) {
            this.getInputSynthesisCodeFieldCombos()[i] = new JComboBox();
            this.getInputSynthesisCodeFieldCombos()[i].setEnabled(this.getGenerateSynthesisCodeCheck().isSelected());
            builder.append("Field name in" + (this.reversed ? " product " : " reactant ") + (i + 1), (Component)this.getInputSynthesisCodeFieldCombos()[i]);
        }
        if (this.reversed) {
            this.initializeProductSynthCodeCombos(state);
        } else {
            this.initializeReactantSynthCodeCombos(state);
        }
        builder.append("Field name in Output", (Component)this.getOutputSynthesisCodeText());
    }

    private JPanel getProductIncludeEvenPanel() {
        if (this.productIncludeEvenPanel == null) {
            this.productIncludeEvenPanel = new JPanel();
            this.productIncludeEvenPanel.setLayout(new BoxLayout(this.getProductIncludeEvenPanel(), 1));
            this.productIncludeEvenPanel.setAlignmentY(0.0f);
        }
        return this.productIncludeEvenPanel;
    }

    private JPanel getProductIncludeOddPanel() {
        if (this.productIncludeOddPanel == null) {
            this.productIncludeOddPanel = new JPanel();
            this.productIncludeOddPanel.setLayout(new BoxLayout(this.getProductIncludeOddPanel(), 1));
            this.productIncludeOddPanel.setAlignmentY(0.0f);
        }
        return this.productIncludeOddPanel;
    }

    protected JButton getClearProductStandardization() {
        if (this.clearProductStandardization == null) {
            this.clearProductStandardization = new JButton();
            this.clearProductStandardization.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/clear.gif")));
            this.clearProductStandardization.setEnabled(false);
            this.clearProductStandardization.setPreferredSize(new Dimension(23, 23));
            this.clearProductStandardization.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ReactorOptionsPanel.this.getProductStandardizationPath().setText("");
                    ReactorOptionsPanel.this.getClearProductStandardization().setEnabled(false);
                }
            });
        }
        return this.clearProductStandardization;
    }

    private JButton getEditProductStandardization() {
        if (this.editProductStandardization == null) {
            this.editProductStandardization = new JButton(this.EDIT_PRODUCT_STANDARDIZATION_ACTION);
            this.editProductStandardization.setText("Edit");
        }
        return this.editProductStandardization;
    }

    protected ConfigBuilderPanel getConfigBuilderPanel() {
        if (this.configBuilderPanel == null) {
            try {
                this.configBuilderPanel = ConfigBuilderPanelFactory.createStandardizerPanel();
            }
            catch (Exception e) {
                e.printStackTrace();
                AlchemistErrorDialog.showError("Failed to init embedded standardizer", e);
            }
            this.configBuilderPanel.setIgnoreMissingLicense(true);
        }
        return this.configBuilderPanel;
    }

    private JPanel getConfigBuilderHolderPanel() {
        if (this.configBuilderHolderPanel == null) {
            this.configBuilderHolderPanel = new JPanel();
            this.configBuilderHolderPanel.setLayout(new BorderLayout());
            this.configBuilderHolderPanel.setName("pnlConfigBuilder");
            this.configBuilderHolderPanel.add((Component)this.getConfigBuilderPanel(), "Center");
            this.configBuilderHolderPanel.add((Component)this.getConfigBuilderButtonPanel(), "South");
        }
        return this.configBuilderHolderPanel;
    }

    private JPanel getConfigBuilderButtonPanel() {
        if (this.configBuilderButtonPanel == null) {
            this.configBuilderButtonPanel = new JPanel();
            this.configBuilderButtonPanel.setLayout(new BoxLayout(this.configBuilderButtonPanel, 0));
            this.configBuilderButtonPanel.add(this.getApplyButton());
            this.configBuilderButtonPanel.add(this.getCancelButton());
        }
        return this.configBuilderButtonPanel;
    }

    private JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton(this.APPLY_CONFIG_EDIT_ACTION);
            this.applyButton.setText("Apply");
        }
        return this.applyButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(this.CANCEL_CONFIG_EDIT_ACTION);
            this.cancelButton.setText("Cancel");
        }
        return this.cancelButton;
    }

    protected void changeCard() {
        ((CardLayout)this.holderPanel.getLayout()).next(this.holderPanel);
    }

    private JPanel getHolderPanel() {
        if (this.holderPanel == null) {
            this.holderPanel = new JPanel();
            this.holderPanel.setLayout(new CardLayout());
            this.holderPanel.setName("holderPanel");
            this.holderPanel.add((Component)this.getBorderPanel(), this.getBorderPanel().getName());
            this.holderPanel.add((Component)this.getConfigBuilderHolderPanel(), this.getConfigBuilderHolderPanel().getName());
        }
        return this.holderPanel;
    }

    private JPanel getBorderPanel() {
        if (this.borderPanel == null) {
            this.borderPanel = new JPanel();
            this.borderPanel.setLayout(new BorderLayout());
            this.borderPanel.setName("borderPanel");
            JScrollPane pane = new JScrollPane(this.getDefaultPanel(), 20, 31);
            pane.setBorder(null);
            this.borderPanel.add((Component)pane, "Center");
        }
        return this.borderPanel;
    }

    private void initializeSchemaSynthCodeCombo(AlchemistState state) {
        RxnMolecule reaction = RxnMolecule.getReaction((Molecule)state.getProperty("ReactorInputPanel_SelectedReaction"));
        String[] values = reaction.properties().getKeys();
        ReactorOptionsPanel.initializeComboForSynthCode(this.getSchemaSynthesisCodeFieldCombo(), values, (String)state.getProperty(PROPERTY_KEY_SCHEMA_SYNTHESIS_CODE_FIELD), null);
    }

    private void initializeReactantSynthCodeCombos(AlchemistState state) {
        Object[] iterators = (Object[])state.getProperty("ReactorReactantSelector_ReactantIteratorArray");
        String[] keys = (String[])state.getProperty(PROPERTY_KEY_INPUT_SYNTHESIS_CODE_FIELDS);
        if (keys == null) {
            keys = new String[iterators.length];
        }
        String[][] values = (String[][])state.getProperty("ReactorReactantSelector_PropertyNames");
        String[] sources = (String[])state.getProperty("ReactorReactantSelector_ReactantInputSources");
        for (int i = 0; i < iterators.length; ++i) {
            String[] value = values[i];
            ReactorOptionsPanel.initializeComboForSynthCode(this.getInputSynthesisCodeFieldCombos()[i], value, i < keys.length ? keys[i] : null, sources[i]);
        }
    }

    private void initializeProductSynthCodeCombos(AlchemistState state) {
        this.initializeReactantSynthCodeCombos(state);
    }

    private static void initializeComboForSynthCode(JComboBox combo, String[] values, String preferredValue, String source) {
        Arrays.sort(values);
        combo.removeAllItems();
        if (source != null) {
            combo.addItem(source + "#Index");
        }
        for (int i = 0; i < values.length; ++i) {
            if (!"NAME".equalsIgnoreCase(values[i]) && !"Synthesis Code".equalsIgnoreCase(values[i]) && Properties.isReserved(values[i])) continue;
            String val = values[i].substring(0, 1).toUpperCase() + values[i].substring(1).toLowerCase();
            combo.addItem(val);
        }
        String value = preferredValue == null ? "Synthesis Code" : preferredValue;
        combo.setSelectedItem(value);
    }

    protected void setProductStandardizationPath(JTextField productStandardizationPath) {
        this.productStandardizationPath = productStandardizationPath;
    }

    protected JTextField getProductStandardizationPath() {
        return this.productStandardizationPath;
    }

    protected void setOpenDialog(AlchemistFileChooserForJChem openDialog) {
        this.openDialog = openDialog;
    }

    protected AlchemistFileChooserForJChem getOpenDialog() {
        return this.openDialog;
    }

    protected void setSaveDialog(AlchemistFileChooserForJChem saveDialog) {
        this.saveDialog = saveDialog;
    }

    protected AlchemistFileChooserForJChem getSaveDialog() {
        return this.saveDialog;
    }

    protected void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    protected String getFileFormat() {
        return this.fileFormat;
    }

    protected void setInputSynthesisCodeFieldCombos(JComboBox[] inputSynthesisCodeFieldCombos) {
        this.inputSynthesisCodeFieldCombos = inputSynthesisCodeFieldCombos;
    }

    protected JComboBox[] getInputSynthesisCodeFieldCombos() {
        return this.inputSynthesisCodeFieldCombos;
    }
}

