/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.reaction.PatternProperty;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ReactorPropertyCopyUtils {
    private static final int READLIMIT = 10;
    public static final String PROPERTY_KEY_VALID = "PropertyCopyValid";
    public static final String PATTERN = "Pattern";
    private static final String PATTERN_TOOLTIP = "<html><b>Pattern:</b><br/>&lt;propertyName&gt;=[&lt;text&gt;*#{&lt;moleculeID&gt;.&lt;propertyID&gt;}]*&lt;text&gt;*<br/><br/><b>Where:</b><ul>propertyName - the name of the property in the output file<br/>text - may contain anything except #{ and ..<br/>moleculeID - a text that has a numeric postfix optionally:<ul>Non-numeric postfix - property of the reaction itself<br/>Numeric postfix - index of a reactant<ul>(indexing starts from 1)</ul></ul>propertyID - a property of the input molecule</ul><b>Examples of pattern:</b><ul>logP=logP values of reactants: 1st:#{r1.LOGP}, 2nd:#{r2.LOGP}<br/>id=#{Reaction.ID}(#{mol1.ID}, #{mol2.ID}, #{mol3.ID})<br/>corp_ID=#{R.ID}(#{R1.corp_ID}, #{R2.corp_ID}, #{R3.corp_ID})</ul></html>";

    public static JTable createCopyPropertyTable(Iterator<Molecule>[] reactantIterators) {
        PropertyCopyTableImpl table = new PropertyCopyTableImpl();
        ReactorPropertyCopyUtils.updateEditors(reactantIterators, table);
        return table;
    }

    public static void updateEditors(Iterator<Molecule>[] reactantIterators, JTable table) throws IllegalArgumentException {
        ArrayList properties;
        if (table instanceof PropertyCopyTableImpl) {
            if (table.getRowCount() < 1) {
                ((DefaultTableModel)table.getModel()).addRow(new Object[]{null, null, null});
            }
            properties = new ArrayList();
            if (reactantIterators != null) {
                for (int i = 0; i < reactantIterators.length; ++i) {
                    HashSet<String> propertyNames = new HashSet<String>();
                    int count = 0;
                    while (reactantIterators[i].hasNext() && count < 10) {
                        Molecule mol = reactantIterators[i].next();
                        if (mol == null) continue;
                        for (int j = 0; j < mol.getPropertyCount(); ++j) {
                            propertyNames.add(mol.getPropertyKey(j));
                        }
                    }
                    properties.add(propertyNames);
                }
            }
        } else {
            throw new IllegalArgumentException("Table is not created with ReactorPropertyCopyUtils.");
        }
        ((PropertyCopyTableImpl)table).setPropertyNames(properties);
    }

    public static String[][] getSourcePropertyNames(JTable table) throws IllegalArgumentException {
        return ReactorPropertyCopyUtils.getPropertyNames(table, 1);
    }

    public static String[][] getTargetPropertyNames(JTable table) throws IllegalArgumentException {
        return ReactorPropertyCopyUtils.getPropertyNames(table, 2);
    }

    public static Map<String, String> getPatterBasedPropertyData(JTable table) throws IllegalArgumentException {
        if (table instanceof PropertyCopyTableImpl) {
            if (table.getCellEditor() != null && !table.getCellEditor().stopCellEditing()) {
                table.getCellEditor().cancelCellEditing();
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < table.getRowCount() - 1; ++i) {
                if (table.getValueAt(i, 0) instanceof Number) continue;
                if (builder.length() > 0) {
                    builder.append("..");
                }
                builder.append(String.valueOf(table.getValueAt(i, 2)));
            }
            Map<String, String> map = Collections.emptyMap();
            try {
                map = PatternProperty.parsePatternsOfProperties(builder.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return map;
        }
        throw new IllegalArgumentException("Table is not created with ReactorPropertyCopyUtils.");
    }

    private static String[][] getPropertyNames(JTable table, int columnIndex) throws IllegalArgumentException {
        if (table instanceof PropertyCopyTableImpl) {
            int reactantCount = ((PropertyCopyTableImpl)table).sourceCombo.getModel().getSize() - 1;
            String[][] source = new String[reactantCount][];
            for (int i = 0; i < source.length; ++i) {
                ArrayList<String> properties = new ArrayList<String>();
                for (int j = 0; j < table.getRowCount() - 1; ++j) {
                    if (!(table.getValueAt(j, 0) instanceof Number) || !Integer.valueOf(i + 1).equals(table.getValueAt(j, 0))) continue;
                    properties.add((String)table.getValueAt(j, columnIndex));
                }
                source[i] = properties.toArray(new String[properties.size()]);
            }
            return source;
        }
        throw new IllegalArgumentException("Table is not created with ReactorPropertyCopyUtils.");
    }

    private static final class PropertyCopyTableImpl
    extends JTable {
        private final JComboBox sourceCombo = new JComboBox();
        private final TableCellEditor sourceEditor = new DefaultCellEditor(this.sourceCombo);
        private final List<TableCellEditor> propertyKeyEditors = new ArrayList<TableCellEditor>();
        private final JTextField valueField = new JTextField();
        private final TableCellEditor valueEditor = new DefaultCellEditor(this.valueField);
        private Set<String> numberedProperties = new HashSet<String>();
        private Set<Integer> duplications = new HashSet<Integer>();
        private boolean valid = true;
        private final Action removeAction = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/clear.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = PropertyCopyTableImpl.this.getEditingRow();
                TableCellEditor editor = PropertyCopyTableImpl.this.getCellEditor();
                if (editor != null && !editor.stopCellEditing()) {
                    editor.cancelCellEditing();
                }
                if (row != -1 && JOptionPane.showConfirmDialog(PropertyCopyTableImpl.this, "Do you want to remove property from copy list?", "Remove property copy setting", 0) == 0) {
                    ((DefaultTableModel)PropertyCopyTableImpl.this.getModel()).removeRow(row);
                    PropertyCopyTableImpl.this.updateDuplications();
                    PropertyCopyTableImpl.this.updateValidity();
                }
            }
        };
        private final TableCellEditor deleteRowEditor = new DefaultCellEditor(new JCheckBox()){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return new JButton(PropertyCopyTableImpl.this.removeAction);
            }
        };
        private final TableCellRenderer renderer = new DefaultTableCellRenderer(){
            private JButton removeButton = null;

            private JButton getRemoveButton() {
                if (this.removeButton == null) {
                    this.removeButton = new JButton(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/clear.gif"));
                }
                return this.removeButton;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, false, false, row, column);
                if (column == 3) {
                    return row < table.getRowCount() - 1 ? this.getRemoveButton() : null;
                }
                if (component instanceof JLabel) {
                    component.setForeground(table.getForeground());
                    if (column == 0) {
                        if (value == null) {
                            component.setForeground(Color.LIGHT_GRAY);
                            ((JLabel)component).setText("<Click to select reactant>");
                        } else {
                            ((JLabel)component).setText((value instanceof Number ? "Reactant " : "") + value);
                        }
                    } else if (column == 1 && table.getModel().getValueAt(row, 0) != null && value == null) {
                        component.setForeground(Color.LIGHT_GRAY);
                        ((JLabel)component).setText(table.getModel().getValueAt(row, 0) instanceof Number ? "<Click to select property>" : "Pattern based");
                    } else if (column == 2 && table.getModel().getValueAt(row, 2) != null && PropertyCopyTableImpl.this.duplications.contains(row)) {
                        ((JLabel)component).setBorder(BorderFactory.createLineBorder(Color.RED));
                    }
                }
                return component;
            }
        };

        private PropertyCopyTableImpl() {
            super(new Vector<String>(Arrays.asList(new String[]{null})), new Vector<String>(Arrays.asList("Copy from", "Property name", "Copy as", "")));
            this.getTableHeader().setReorderingAllowed(false);
            this.getColumnModel().getColumn(3).setMinWidth(18);
            this.getColumnModel().getColumn(3).setMaxWidth(18);
            this.sourceCombo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (component instanceof JLabel && value != null) {
                        ((JLabel)component).setText((value instanceof Number ? "Reactant " : "") + value);
                        ((JLabel)component).setToolTipText(value instanceof Number ? null : ReactorPropertyCopyUtils.PATTERN_TOOLTIP);
                    }
                    return component;
                }
            });
            this.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == 0 && e.getFirstRow() != -1 && e.getColumn() != -1) {
                        if (e.getColumn() == 0) {
                            for (int i = 1; i < PropertyCopyTableImpl.this.getModel().getColumnCount(); ++i) {
                                PropertyCopyTableImpl.this.getModel().setValueAt(null, e.getFirstRow(), i);
                            }
                        } else if (e.getColumn() == 1) {
                            if (PropertyCopyTableImpl.this.getModel().getValueAt(e.getFirstRow(), 1) != null) {
                                StringBuilder builder = new StringBuilder();
                                builder.append((String)PropertyCopyTableImpl.this.getModel().getValueAt(e.getFirstRow(), 1));
                                if (PropertyCopyTableImpl.this.numberedProperties.contains(builder.toString())) {
                                    builder.append("_");
                                    builder.append(PropertyCopyTableImpl.this.getModel().getValueAt(e.getFirstRow(), 0));
                                }
                                PropertyCopyTableImpl.this.getModel().setValueAt(builder.toString(), e.getFirstRow(), 2);
                            }
                        } else if (e.getColumn() == 2) {
                            if (PropertyCopyTableImpl.this.getModel().getValueAt(PropertyCopyTableImpl.this.getModel().getRowCount() - 1, 2) != null) {
                                ((DefaultTableModel)PropertyCopyTableImpl.this.getModel()).addRow(new Object[]{null, null, null});
                            }
                            PropertyCopyTableImpl.this.updateDuplications();
                        }
                    }
                    PropertyCopyTableImpl.this.updateValidity();
                }
            });
        }

        private void updateValidity() {
            boolean oldValue = this.valid;
            this.valid = this.duplications.isEmpty();
            for (int i = 0; i < this.getRowCount() - 1 && this.valid; ++i) {
                this.valid = this.getValueAt(i, 0) != null && this.getValueAt(i, 2) != null && (this.getValueAt(i, 1) != null || !(this.getValueAt(i, 0) instanceof Number));
            }
            this.firePropertyChange(ReactorPropertyCopyUtils.PROPERTY_KEY_VALID, oldValue, this.valid);
        }

        private void updateDuplications() {
            this.duplications.clear();
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, 2) == null) continue;
                for (int j = 0; j < this.getRowCount(); ++j) {
                    if (i == j || !this.getValueAt(i, 2).equals(this.getValueAt(j, 2))) continue;
                    this.duplications.add(i);
                    this.duplications.add(j);
                }
            }
            this.repaint();
        }

        private void setPropertyNames(List<Set<String>> properties) {
            ((DefaultComboBoxModel)this.sourceCombo.getModel()).removeAllElements();
            this.propertyKeyEditors.clear();
            this.numberedProperties.clear();
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            for (int i = 0; i < properties.size(); ++i) {
                ((DefaultComboBoxModel)this.sourceCombo.getModel()).addElement(i + 1);
                this.propertyKeyEditors.add(new DefaultCellEditor(new JComboBox<Object>(properties.get(i).toArray())));
                for (String property : properties.get(i)) {
                    if (countMap.containsKey(property)) {
                        countMap.put(property, (Integer)countMap.get(property) + 1);
                        continue;
                    }
                    countMap.put(property, 0);
                }
            }
            ((DefaultComboBoxModel)this.sourceCombo.getModel()).addElement(ReactorPropertyCopyUtils.PATTERN);
            for (String property : countMap.keySet()) {
                if ((Integer)countMap.get(property) <= 0) continue;
                this.numberedProperties.add(property);
            }
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return this.sourceEditor;
            }
            if (column == 1) {
                for (int i = 0; i < this.sourceCombo.getModel().getSize(); ++i) {
                    if (!this.sourceCombo.getModel().getElementAt(i).equals(this.getValueAt(row, 0))) continue;
                    return this.getValueAt(row, 0) instanceof Number ? this.propertyKeyEditors.get(i) : null;
                }
                return null;
            }
            if (column == 2) {
                if (this.getModel().getValueAt(row, 1) == null && this.getValueAt(row, 0) instanceof Number) {
                    return null;
                }
                this.valueField.setToolTipText(this.getValueAt(row, 0) instanceof Number ? null : ReactorPropertyCopyUtils.PATTERN_TOOLTIP);
                return this.valueEditor;
            }
            if (column == 3) {
                return row < this.getRowCount() - 1 ? this.deleteRowEditor : null;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return this.renderer;
        }
    }
}

