/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistMoleculeEditor;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ReactorReactantPanel
extends AlchemistPage
implements PropertyChangeListener {
    private static final long serialVersionUID = -5557537175506748756L;
    private JPanel pnlCommand = null;
    private JPanel pnlOrder = null;
    private JPanel viewerPanel = null;
    private AlchemistMoleculeEditor editor = null;
    private AlchemistFileChooserForJChem openDialog = null;
    private String openDialogPath = "";
    private RxnMolecule reaction = null;
    private int number = 0;
    private InputSource inputSource = InputSource.MANUAL;
    private transient String reactantFileName = null;
    private final boolean reversed;
    private boolean isLoading = false;
    private Timer progressTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactorReactantPanel.this.isLoading()) {
                ReactorReactantPanel.this.updateProgressBar(ReactorReactantPanel.this.getEditor().getProgressPercentage());
            } else {
                ReactorReactantPanel.this.hideProgressBar();
                ReactorReactantPanel.this.setBottomTextVisible(false);
                ReactorReactantPanel.this.getProgressTimer().stop();
            }
        }
    });
    private final Action IMPORT_EXAMPLES_ACTION = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/importreaction.gif")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            MolImporter importer = null;
            try {
                String examples = ReactorReactantPanel.this.reaction.getProperty("EXAMPLE");
                if (examples != null) {
                    RxnMolecule rxn = null;
                    Molecule tempMolecule = null;
                    importer = new MolImporter(new ByteArrayInputStream(examples.getBytes()));
                    if (ReactorReactantPanel.this.getEditor().getMoleculeCount() == 0) {
                        ReactorReactantPanel.this.inputSource = InputSource.EXAMPLE;
                    } else {
                        ReactorReactantPanel.this.inputSource = InputSource.MANUAL;
                    }
                    while ((tempMolecule = importer.read()) != null) {
                        rxn = RxnMolecule.getReaction(tempMolecule);
                        if (rxn == null) continue;
                        if (ReactorReactantPanel.this.reversed) {
                            if (ReactorReactantPanel.this.reaction.getProductCount() != rxn.getProductCount()) continue;
                            ReactorReactantPanel.this.getEditor().addMolecule(rxn.getProduct(ReactorReactantPanel.this.number));
                            continue;
                        }
                        if (ReactorReactantPanel.this.reaction.getReactantCount() != rxn.getReactantCount()) continue;
                        ReactorReactantPanel.this.getEditor().addMolecule(rxn.getReactant(ReactorReactantPanel.this.number));
                    }
                }
            }
            catch (IOException e1) {
                AlchemistErrorDialog.showError("An error has occured while trying to create tempfile for examples. Examples could not be imported.", (Exception)e1);
            }
            finally {
                try {
                    if (importer != null) {
                        importer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    };
    private final Action OPEN_FILE_ACTION = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/opendocument.gif")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactorReactantPanel.this.getOpenDialog() != null) {
                File lastDir = new File(ReactorReactantPanel.this.getOpenDialogPath());
                if (lastDir.isDirectory() && lastDir.exists()) {
                    ReactorReactantPanel.this.getOpenDialog().setCurrentDirectory(lastDir);
                }
                if (ReactorReactantPanel.this.getOpenDialog().showOpenDialog(null) == 0) {
                    ReactorReactantPanel.this.resetViewer();
                    ReactorReactantPanel.this.reactantFileName = ReactorReactantPanel.this.getOpenDialog().getSelectedFile().getName();
                    final String reactantPath = ReactorReactantPanel.this.getOpenDialog().getSelectedFile().getAbsolutePath();
                    try {
                        ReactorReactantPanel.this.setLoading(true);
                        ReactorReactantPanel.this.setBottomTextVisible(true);
                        ReactorReactantPanel.this.showProgressBar("Load molecules");
                        ReactorReactantPanel.this.getProgressTimer().start();
                        ReactorReactantPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", true, false);
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (ReactorReactantPanel.this.getEditor().getMoleculeCount() == 0) {
                                    ReactorReactantPanel.this.inputSource = InputSource.FILE;
                                } else {
                                    ReactorReactantPanel.this.inputSource = InputSource.MANUAL;
                                }
                                ReactorReactantPanel.this.getEditor().importMolecules(reactantPath);
                                ReactorReactantPanel.this.setLoading(false);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ReactorReactantPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", false, true);
                                    }
                                });
                            }
                        });
                        thread.setPriority(4);
                        thread.start();
                    }
                    catch (Exception e1) {
                        ReactorReactantPanel.this.resetViewer();
                        AlchemistErrorDialog.showError(e1);
                    }
                    ReactorReactantPanel.this.setOpenDialogPath(ReactorReactantPanel.this.getOpenDialog().getCurrentDirectory().getAbsolutePath());
                }
            }
            ReactorReactantPanel.this.getOpenDialog().clear();
        }
    };
    private final Action CLEAR_ACTION = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/clear.gif")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(ReactorReactantPanel.this, "Do you want to remove all structures?", "Remove structures", 0) == 0) {
                ReactorReactantPanel.this.resetViewer();
            }
        }
    };

    public ReactorReactantPanel(PropertyChangeListener listener, RxnMolecule reaction, int number) {
        this(listener, reaction, number, false);
    }

    public ReactorReactantPanel(PropertyChangeListener listener, RxnMolecule reaction, int number, boolean reversed) {
        this.OPEN_FILE_ACTION.putValue("ShortDescription", "Open molecule file");
        this.CLEAR_ACTION.putValue("ShortDescription", "Remove all");
        this.IMPORT_EXAMPLES_ACTION.putValue("ShortDescription", "Import Examples");
        this.reversed = reversed;
        this.getNotifier().addPropertyChangeListener(listener);
        this.getNotifier().addPropertyChangeListener(this);
        this.reaction = reaction;
        this.number = number;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(318, 252));
        this.add((Component)this.getPnlCommand(), "North");
        this.add((Component)this.getPnlOrder(), "East");
        this.add((Component)this.getViewerPanel(), "Center");
        try {
            this.setOpenDialog(new AlchemistFileChooserForJChem(true));
            this.getOpenDialog().addDefaultOpenFileFilters();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel getViewerPanel() {
        if (this.viewerPanel == null) {
            this.viewerPanel = new JPanel();
            this.viewerPanel.setLayout(new BorderLayout());
            this.viewerPanel.add((Component)this.getEditor(), "Center");
        }
        return this.viewerPanel;
    }

    protected AlchemistMoleculeEditor getEditor() {
        if (this.editor == null) {
            this.editor = new AlchemistMoleculeEditor(2, 1, 10, 10, true, this.getNotifier()){
                private static final long serialVersionUID = -2141124723591356218L;

                @Override
                public void applyChanges() {
                    super.applyChanges();
                    ReactorReactantPanel.this.inputSource = InputSource.MANUAL;
                }
            };
            this.editor.getToolBar().removeAll();
            this.editor.getToolBar().add(this.editor.getADD_MOLECULE_ACTION());
            this.editor.getToolBar().add(this.editor.getEDIT_MOLECULE_ACTION());
            this.editor.getToolBar().add(this.editor.getREMOVE_MOLECULE_ACTION());
            this.editor.getToolBar().add(this.CLEAR_ACTION);
            this.editor.getToolBar().add(this.IMPORT_EXAMPLES_ACTION);
            this.editor.getToolBar().add(this.OPEN_FILE_ACTION);
        }
        return this.editor;
    }

    public MoleculeIterator getMoleculeIterator() {
        return this.getEditor().getMoleculeIterator();
    }

    private JPanel getPnlCommand() {
        if (this.pnlCommand == null) {
            this.pnlCommand = new JPanel();
            this.pnlCommand.setLayout(new BoxLayout(this.getPnlCommand(), 0));
        }
        return this.pnlCommand;
    }

    private JPanel getPnlOrder() {
        if (this.pnlOrder == null) {
            this.pnlOrder = new JPanel();
            this.pnlOrder.setLayout(new BoxLayout(this.getPnlOrder(), 1));
        }
        return this.pnlOrder;
    }

    @Override
    public boolean isCorrect() {
        return !this.isLoading() && this.getEditor().getMoleculeCount() > 0;
    }

    public String getReactantFileName() {
        return this.inputSource.equals((Object)InputSource.FILE) ? this.reactantFileName : null;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    @Override
    public void enterPage(AlchemistState state) {
    }

    @Override
    public void leavePage(AlchemistState state) {
    }

    public String getOpenDialogPath() {
        return this.openDialogPath;
    }

    public void setOpenDialogPath(String openDialogPath) {
        if (openDialogPath != null) {
            this.openDialogPath = openDialogPath;
        }
    }

    protected void resetViewer() {
        this.getEditor().clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("Alchemist_Enable")) {
            boolean enabled = (Boolean)evt.getNewValue();
            this.getEditor().setEnabled(enabled);
            this.IMPORT_EXAMPLES_ACTION.setEnabled(enabled);
            this.OPEN_FILE_ACTION.setEnabled(enabled);
            this.CLEAR_ACTION.setEnabled(enabled);
        }
    }

    protected void setOpenDialog(AlchemistFileChooserForJChem openDialog) {
        this.openDialog = openDialog;
    }

    protected AlchemistFileChooserForJChem getOpenDialog() {
        return this.openDialog;
    }

    protected void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    protected boolean isLoading() {
        return this.isLoading;
    }

    protected void setProgressTimer(Timer progressTimer) {
        this.progressTimer = progressTimer;
    }

    protected Timer getProgressTimer() {
        return this.progressTimer;
    }

    public static enum InputSource {
        FILE,
        EXAMPLE,
        MANUAL;

    }
}

