/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.reactor.ReactorReactantPanel;
import chemaxon.alchemist.utils.AbstractAlchemistMoleculeEditor;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.JTabbedPane;

public class ReactorReactantSelector
extends AlchemistPage
implements PropertyChangeListener {
    public static final String PROPERTY_KEY_REACTANT_INPUT_SOURCES_ARRAY = "ReactorReactantSelector_ReactantInputSources";
    public static final String PROPERTY_KEY_REACTANT_ITERATOR_ARRAY = "ReactorReactantSelector_ReactantIteratorArray";
    public static final String PROPERTY_KEY_REACTANT_PROPERTY_NAMES = "ReactorReactantSelector_PropertyNames";
    public static final String PROPERTY_KEY_REACTANT_ITERATOR_REVISIONS = "ReactorReactantSelector_IteratorRevisions";
    public static final String PROPERTY_KEY_LAST_USED_DIR = "ReactorReactantSelector_LastUsedDir";
    private static final long serialVersionUID = -6786187131297334424L;
    private JTabbedPane tbdPane = null;
    private RxnMolecule reaction = null;
    private String path = "";
    private boolean reversed = false;

    public ReactorReactantSelector() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(259, 238));
        this.add((Component)this.getTbdPane(), "Center");
    }

    @Override
    public boolean isCorrect() {
        boolean retVal;
        this.setDialogPaths();
        if (this.tbdPane.getComponentCount() > 0) {
            retVal = true;
            for (int i = 0; i < this.tbdPane.getComponentCount(); ++i) {
                AlchemistPage tabPanel;
                if (!(this.tbdPane.getComponent(i) instanceof AlchemistPage) || (tabPanel = (AlchemistPage)this.tbdPane.getComponent(i)).isCorrect()) continue;
                retVal = false;
            }
        } else {
            retVal = false;
        }
        return retVal;
    }

    private void setDialogPaths() {
        int i;
        for (i = 0; i < this.tbdPane.getComponentCount(); ++i) {
            if (!(this.tbdPane.getComponent(i) instanceof AlchemistPage) || ((ReactorReactantPanel)this.tbdPane.getComponent(i)).getOpenDialogPath().equalsIgnoreCase("") || this.path.equalsIgnoreCase(((ReactorReactantPanel)this.tbdPane.getComponent(i)).getOpenDialogPath())) continue;
            this.path = ((ReactorReactantPanel)this.tbdPane.getComponent(i)).getOpenDialogPath();
            break;
        }
        for (i = 0; i < this.tbdPane.getComponentCount(); ++i) {
            if (!(this.tbdPane.getComponent(i) instanceof AlchemistPage) || ((ReactorReactantPanel)this.tbdPane.getComponent(i)).getOpenDialogPath().equalsIgnoreCase(this.path) || "".equalsIgnoreCase(this.path)) continue;
            ((ReactorReactantPanel)this.tbdPane.getComponent(i)).setOpenDialogPath(this.path);
        }
    }

    private void setTabs() {
        while (this.tbdPane.getTabCount() > 0) {
            this.tbdPane.removeTabAt(0);
        }
        int count = 0;
        if (this.reaction != null && this.reaction.isReaction()) {
            count = this.reversed ? this.reaction.getProductCount() : this.reaction.getReactantCount();
        }
        for (int i = 0; i < count; ++i) {
            ReactorReactantPanel panel = new ReactorReactantPanel(this.getNotifier().getPropertyChangeListeners()[0], this.reaction, i, this.reversed);
            panel.getNotifier().addPropertyChangeListener(this);
            this.tbdPane.addTab(count > 1 ? "Reactant " + (i + 1) : "Reactant", panel);
        }
        this.tbdPane.validate();
    }

    private JTabbedPane getTbdPane() {
        if (this.tbdPane == null) {
            this.tbdPane = new JTabbedPane();
        }
        return this.tbdPane;
    }

    @Override
    public void enterPage(AlchemistState state) {
        boolean tmpReversed = (Boolean)state.getProperty("ReactorInputPanel_Reversed");
        RxnMolecule tmpReaction = RxnMolecule.getReaction((Molecule)state.getProperty("ReactorInputPanel_SelectedReaction"));
        if (!tmpReaction.equals(this.reaction) || tmpReversed != this.reversed) {
            this.reaction = tmpReaction;
            this.reversed = tmpReversed;
            this.setTabs();
            for (int i = 0; i < this.tbdPane.getTabCount(); ++i) {
                ((ReactorReactantPanel)this.tbdPane.getComponent(i)).setOpenDialogPath((String)state.getProperty(PROPERTY_KEY_LAST_USED_DIR));
            }
        }
    }

    @Override
    public void leavePage(AlchemistState state) {
        MoleculeIterator[] iterators = this.reaction == null ? new MoleculeIterator[]{} : new MoleculeIterator[this.reversed ? this.reaction.getProductCount() : this.reaction.getReactantCount()];
        long[] revisions = new long[iterators.length];
        String[] sources = new String[iterators.length];
        ArrayList<String[]> properties = new ArrayList<String[]>();
        for (int i = 0; i < iterators.length; ++i) {
            TreeSet<String> set = new TreeSet<String>();
            ReactorReactantPanel panel = (ReactorReactantPanel)this.tbdPane.getComponent(i);
            switch (panel.getInputSource()) {
                case EXAMPLE: {
                    sources[i] = "BuiltInExample";
                    break;
                }
                case FILE: {
                    sources[i] = panel.getReactantFileName();
                    break;
                }
                default: {
                    sources[i] = "ManualInput";
                }
            }
            iterators[i] = panel.getMoleculeIterator();
            revisions[i] = iterators[i] instanceof AbstractAlchemistMoleculeEditor.MoleculeIteratorImpl ? ((AbstractAlchemistMoleculeEditor.MoleculeIteratorImpl)iterators[i]).getRevision() : -1L;
            Molecule[] molecules = panel.getEditor().getMolecules(100);
            for (int j = 0; j < molecules.length; ++j) {
                String[] props = molecules[j].properties().getKeys();
                for (int k = 0; k < props.length; ++k) {
                    set.add(props[k]);
                }
            }
            properties.add(set.toArray(new String[set.size()]));
        }
        state.setProperty(PROPERTY_KEY_REACTANT_ITERATOR_REVISIONS, revisions);
        state.setProperty(PROPERTY_KEY_REACTANT_INPUT_SOURCES_ARRAY, sources);
        state.setProperty(PROPERTY_KEY_REACTANT_PROPERTY_NAMES, properties.toArray((T[])new String[properties.size()][]));
        state.setProperty(PROPERTY_KEY_REACTANT_ITERATOR_ARRAY, iterators);
        if (this.tbdPane.getComponentCount() > 0) {
            state.setPersistentProperty(PROPERTY_KEY_LAST_USED_DIR, ((ReactorReactantPanel)this.tbdPane.getComponent(0)).getOpenDialogPath());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("Alchemist_Enable")) {
            boolean enabled = (Boolean)evt.getNewValue();
            this.tbdPane.setEnabled(enabled);
        }
    }
}

