/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor;

import chemaxon.alchemist.AlchemistApplication;
import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.reactor.reactioneditor.ReactionEditorPanel;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.DotfileUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

public class ReactionEditorAlchemist
extends AlchemistApplication
implements AlchemistLaunchable,
PropertyChangeListener {
    private static final String APP_TITLE = "Reaction Editor " + VersionInfo.JCHEM_VERSION;
    private static final String PERSISTENT_PROPERTY_PATH = "/alchemist/.reactioneditor";
    private ReactionEditorPanel editor = null;

    public ReactionEditorAlchemist() {
        super(APP_TITLE, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/reactor.png"));
        this.initialize();
    }

    private void initialize() {
        this.editor = new ReactionEditorPanel(this);
        this.editor.enterPage(this.getApplicationState());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.editor, "Center");
    }

    @Override
    protected boolean frameClosing() {
        this.editor.leavePage(this.getApplicationState());
        return super.frameClosing();
    }

    public static void createAndShowGUI() {
        MarvinBasedAlchemistApplication.setLookAndFeel();
        try {
            ReactionEditorAlchemist rea = new ReactionEditorAlchemist();
            rea.show();
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError(e);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactionEditorAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    protected String getPropertyFilePath() {
        return DotfileUtil.getDotFile(PERSISTENT_PROPERTY_PATH).getAbsolutePath();
    }

    @Override
    public void launch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactionEditorAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ReactionEditorPanel_FileChanged")) {
            this.getApplicationFrame().setTitle(APP_TITLE + " - " + evt.getNewValue());
        }
    }
}

