/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor;

import chemaxon.alchemist.reactor.reactioneditor.ReactionEditorPanel;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistMoleculeEditor;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.SwingPropertyChangeSupport;

public class ReactionExampleEditor {
    public static final String PROPERTY_KEY_EDIT_MODE_CHANGED = "ReactionExampleEditor_EditModeChanged";
    private static final long serialVersionUID = -9086064109602939575L;
    protected AlchemistMoleculeEditor moleculeEditor = null;
    private final ReactionEditorPanel reactionEditorPanel;
    private final SwingPropertyChangeSupport propertyChangeSupport;
    private final JPanel examplePanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private CountDownLatch latch;
    private final Action EXAMPLE_UP_ACTION = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/up.gif")){
        private static final long serialVersionUID = -1474793437399779509L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionExampleEditor.this.moleculeEditor.swapSelectedWithPrevious();
        }
    };
    private final Action EXAMPLE_DOWN_ACTION = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif")){
        private static final long serialVersionUID = 3355420430550247948L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionExampleEditor.this.moleculeEditor.swapSelectedWithNext();
        }
    };

    public JPanel getExamplePanel() {
        return this.examplePanel;
    }

    ReactionExampleEditor(ReactionEditorPanel reactionEditorPanel) {
        this.reactionEditorPanel = reactionEditorPanel;
        this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        this.moleculeEditor = new AlchemistMoleculeEditor(1, 1, false, this.propertyChangeSupport);
        this.moleculeEditor.addPropertyChangeListener("LoadingStateChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Boolean.FALSE.equals(evt.getNewValue()) && ReactionExampleEditor.this.getLatch() != null) {
                    ReactionExampleEditor.this.getLatch().countDown();
                }
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 1));
        this.controlPanel.add(new JButton(this.EXAMPLE_UP_ACTION));
        this.controlPanel.add(new JButton(this.EXAMPLE_DOWN_ACTION));
        this.propertyChangeSupport.addPropertyChangeListener(this.reactionEditorPanel);
        this.examplePanel.setLayout(new BorderLayout());
        this.examplePanel.add((Component)this.moleculeEditor, "Center");
        this.examplePanel.add((Component)this.controlPanel, "East");
    }

    public void clearInformations() {
        this.moleculeEditor.clear();
    }

    public synchronized void refreshInformations(Molecule reaction) {
        String mols = this.getExamples(reaction);
        if (mols != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(mols.getBytes());
            this.setLatch(new CountDownLatch(1));
            this.moleculeEditor.importMolecules(bis);
            try {
                this.getLatch().await();
            }
            catch (InterruptedException e) {}
        } else {
            this.moleculeEditor.clear();
        }
    }

    public boolean isExampleSelected() {
        return this.moleculeEditor.isMoleculeSelected();
    }

    private String getExamples(Molecule reaction) {
        if (reaction == null) {
            return null;
        }
        if (reaction.getProperty("EXAMPLE") != null) {
            return reaction.getProperty("EXAMPLE");
        }
        return null;
    }

    public Molecule[] getMolecules() {
        return this.moleculeEditor.getMolecules();
    }

    public AbstractAction getADD_MOLECULE_ACTION() {
        return this.moleculeEditor.getADD_MOLECULE_ACTION();
    }

    public AbstractAction getAPPLY_MOLECULE_EDIT_ACTION() {
        return this.moleculeEditor.getAPPLY_MOLECULE_EDIT_ACTION();
    }

    public AbstractAction getCANCEL_MOLECULE_EDIT_ACTION() {
        return this.moleculeEditor.getCANCEL_MOLECULE_EDIT_ACTION();
    }

    public AbstractAction getEDIT_MOLECULE_ACTION() {
        return this.moleculeEditor.getEDIT_MOLECULE_ACTION();
    }

    public AbstractAction getREMOVE_MOLECULE_ACTION() {
        return this.moleculeEditor.getREMOVE_MOLECULE_ACTION();
    }

    protected void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    protected CountDownLatch getLatch() {
        return this.latch;
    }
}

