/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.reactor.reactioneditor.ReactionEditorPanel;
import chemaxon.alchemist.reactor.reactioneditor.ReactorPropertyGeneratorPanel;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.ScrollableCellEditor;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ReactorPropertyEditorPanel
extends AlchemistPage {
    public static final String PROPERTY_KEY_SELECTION_CHANGED = "ReactorPropertyEditorPanel_SelectionChanged";
    protected static final String DEFAULT_PROPERTY_NAME = "New_Property";
    protected static final String DEFAULT_PROPERTY_VALUE = "No_Value";
    protected static final int MINIMUM_ROW_HEIGHT = 23;
    protected static final int MAXIMUM_ROW_HEIGHT = 100;
    protected static final Dimension INTERCELL_SPACING = new Dimension(3, 3);
    protected static final Font VALUE_FONT = new Font("MS Sans Serif", 0, 12);
    protected static final Font PROPERTY_FONT = new Font("MS Sans Serif", 1, 12);
    protected SwingPropertyChangeSupport notifier = null;
    private static final long serialVersionUID = -5242458354842087951L;
    private JSplitPane contentSplitPane = null;
    private JScrollPane scrlProperties = null;
    private JTable tlbProperties = null;
    private ReactorPropertyGeneratorPanel pnlPropGen = null;
    private boolean isInitializing = true;
    private JPanel propertiesPanel = null;
    private JPanel buttonPanel = null;
    private JButton upButton = null;
    private JButton downButton = null;
    private JComboBox moleculeChooser = null;
    private boolean isValueChanging = false;
    private Molecule[] molecules;
    private Molecule reaction;
    private final AbstractAction MOVE_DOWN_PROPERTY_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -8018473279548522991L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactorPropertyEditorPanel.this.getTlbProperties().getSelectedRow() != ReactorPropertyEditorPanel.this.getTlbProperties().getRowCount() - 1) {
                ReactorPropertyEditorPanel.this.setValueChanging(true);
                int selectedIndex = ReactorPropertyEditorPanel.this.getTlbProperties().getSelectedRow();
                TableModel model = ReactorPropertyEditorPanel.this.getTlbProperties().getModel();
                Object name = model.getValueAt(selectedIndex, 0);
                Object value = model.getValueAt(selectedIndex, 1);
                model.setValueAt(model.getValueAt(selectedIndex + 1, 0), selectedIndex, 0);
                model.setValueAt(model.getValueAt(selectedIndex + 1, 1), selectedIndex, 1);
                model.setValueAt(name, selectedIndex + 1, 0);
                model.setValueAt(value, selectedIndex + 1, 1);
                ReactorPropertyEditorPanel.this.getTlbProperties().addRowSelectionInterval(selectedIndex + 1, selectedIndex + 1);
                ReactorPropertyEditorPanel.this.setValueChanging(false);
                ReactorPropertyEditorPanel.this.setProperties();
            }
        }
    };
    private final AbstractAction MOVE_UP_PROPERTY_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -2715412294310719108L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactorPropertyEditorPanel.this.getTlbProperties().getSelectedRow() != 0) {
                ReactorPropertyEditorPanel.this.setValueChanging(true);
                int selectedIndex = ReactorPropertyEditorPanel.this.getTlbProperties().getSelectedRow();
                TableModel model = ReactorPropertyEditorPanel.this.getTlbProperties().getModel();
                Object name = model.getValueAt(selectedIndex, 0);
                Object value = model.getValueAt(selectedIndex, 1);
                model.setValueAt(model.getValueAt(selectedIndex - 1, 0), selectedIndex, 0);
                model.setValueAt(model.getValueAt(selectedIndex - 1, 1), selectedIndex, 1);
                model.setValueAt(name, selectedIndex - 1, 0);
                model.setValueAt(value, selectedIndex - 1, 1);
                ReactorPropertyEditorPanel.this.getTlbProperties().addRowSelectionInterval(selectedIndex - 1, selectedIndex - 1);
                ReactorPropertyEditorPanel.this.setValueChanging(false);
                ReactorPropertyEditorPanel.this.setProperties();
            }
        }
    };
    private JPanel propertyHolderPanel = null;
    private JPanel reactionProperties = null;

    public ReactorPropertyEditorPanel() {
        this.initialize();
    }

    public void setPropertyKeys(List<String> properties) {
        this.getPnlPropGen().setPropertyKeys(properties);
    }

    public void addProperty(String propertyName, String propertyValue) {
        ((DefaultTableModel)this.tlbProperties.getModel()).addRow(new String[]{propertyName.trim(), propertyValue.trim()});
    }

    public void removeProperty(String propertyName) {
        for (int i = 0; i < this.tlbProperties.getRowCount(); ++i) {
            Vector<Vector> data = ((DefaultTableModel)this.tlbProperties.getModel()).getDataVector();
            String propName = ((List)data.get(i)).get(0).toString();
            if (!propName.equals(propertyName)) continue;
            this.removeProperty(i);
            return;
        }
    }

    public void removeProperty(int rowNumber) {
        ((DefaultTableModel)this.tlbProperties.getModel()).removeRow(rowNumber);
    }

    public void clearTable() {
        ((DefaultTableModel)this.tlbProperties.getModel()).setRowCount(0);
    }

    private void initialize() {
        this.notifier = new SwingPropertyChangeSupport(this);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(425, 275));
        this.add((Component)this.getContentSplitPane(), "Center");
        this.getContentSplitPane().setDividerLocation(1.0);
    }

    @Override
    public boolean isCorrect() {
        return true;
    }

    private ReactorPropertyGeneratorPanel getPnlPropGen() {
        if (this.pnlPropGen == null) {
            this.pnlPropGen = new ReactorPropertyGeneratorPanel();
            this.pnlPropGen.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlPropGen.setPropEd(this);
        }
        return this.pnlPropGen;
    }

    protected JSplitPane getContentSplitPane() {
        if (this.contentSplitPane == null) {
            this.contentSplitPane = new JSplitPane(1);
            this.contentSplitPane.setOneTouchExpandable(true);
            this.contentSplitPane.setResizeWeight(1.0);
            this.contentSplitPane.setBorder(null);
            this.contentSplitPane.setLeftComponent(this.getPropertiesPanel());
            this.contentSplitPane.setRightComponent(this.getPnlPropGen());
            this.contentSplitPane.setDividerSize(8);
            this.contentSplitPane.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    if (ReactorPropertyEditorPanel.this.isInitializing()) {
                        ReactorPropertyEditorPanel.this.getContentSplitPane().setDividerLocation(1.0);
                        ReactorPropertyEditorPanel.this.setInitializing(false);
                    }
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }
            });
            this.tlbProperties.setGridColor(this.contentSplitPane.getBackground());
            this.tlbProperties.setBackground(this.contentSplitPane.getBackground());
        }
        return this.contentSplitPane;
    }

    protected String generateUniqueName(String name, int skipRow) {
        boolean exists = true;
        int count = 1;
        String generatedName = name;
        block0: while (exists) {
            exists = false;
            for (int i = 0; i < this.tlbProperties.getRowCount(); ++i) {
                String dispName = name;
                if (count > 1) {
                    dispName = dispName + count;
                }
                generatedName = dispName;
                if (!((String)this.tlbProperties.getValueAt(i, 0)).equalsIgnoreCase(dispName) || skipRow == i) continue;
                exists = true;
                ++count;
                continue block0;
            }
        }
        return generatedName;
    }

    public void addProperty() {
        ArrayList<String> data = new ArrayList<String>();
        data.add(this.generateUniqueName(DEFAULT_PROPERTY_NAME, -1));
        data.add(DEFAULT_PROPERTY_VALUE);
        ((DefaultTableModel)this.tlbProperties.getModel()).addRow(data.toArray());
    }

    public void removeProperty() {
        int selRow = this.tlbProperties.getSelectedRow();
        if (selRow != -1 && JOptionPane.showConfirmDialog(null, "Delete selected property?", "Remove Property", 0, 3) == 0) {
            ((DefaultTableModel)this.tlbProperties.getModel()).removeRow(selRow);
        }
    }

    public boolean isPropertySelected() {
        return this.tlbProperties.getSelectedRow() != -1;
    }

    private JScrollPane getScrlProperties() {
        if (this.scrlProperties == null) {
            this.scrlProperties = new JScrollPane();
            this.scrlProperties.setVerticalScrollBarPolicy(22);
            this.scrlProperties.setViewportView(this.getTlbProperties());
        }
        return this.scrlProperties;
    }

    protected JTable getTlbProperties() {
        if (this.tlbProperties == null) {
            DefaultTableModel tableModel = new DefaultTableModel(new String[]{"Property Name", "Property Value"}, 0);
            TableCellRenderer tableCellRenderer = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    double preferredHeight;
                    double newHeight;
                    if (column == 0) {
                        JLabel label = new JLabel();
                        label.setText((String)value);
                        label.setFont(PROPERTY_FONT);
                        label.setBackground(Color.WHITE);
                        label.setBorder(new EmptyBorder(1, 1, 1, 1));
                        label.setVerticalTextPosition(1);
                        label.setVerticalAlignment(1);
                        if (isSelected) {
                            label.setOpaque(true);
                            label.setBackground(Color.LIGHT_GRAY);
                        } else {
                            label.setOpaque(false);
                        }
                        return label;
                    }
                    JTextArea textArea = new JTextArea();
                    JScrollPane scrollPane = new JScrollPane(textArea);
                    textArea.setWrapStyleWord(true);
                    textArea.setLineWrap(true);
                    textArea.setFont(VALUE_FONT);
                    textArea.setOpaque(true);
                    textArea.setText((String)value);
                    textArea.setSize(table.getColumnModel().getColumn(column).getWidth(), 0);
                    textArea.getUI().getRootView(textArea).setSize(textArea.getWidth(), 0.0f);
                    if (isSelected) {
                        textArea.setBackground(Color.LIGHT_GRAY);
                    }
                    if ((newHeight = (preferredHeight = (double)(textArea.getPreferredScrollableViewportSize().height + 2 * table.getRowMargin()))) < 23.0) {
                        newHeight = 23.0;
                    } else if (newHeight > 100.0) {
                        newHeight = 100.0;
                    }
                    if ((double)table.getRowHeight(row) != newHeight) {
                        table.setRowHeight(row, (int)newHeight);
                    }
                    scrollPane.setVerticalScrollBarPolicy(20);
                    scrollPane.invalidate();
                    return scrollPane;
                }
            };
            this.tlbProperties = new JTable(tableModel);
            this.tlbProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.tlbProperties.setSelectionMode(0);
            this.tlbProperties.setIntercellSpacing(INTERCELL_SPACING);
            this.tlbProperties.setRowHeight(23);
            this.tlbProperties.getColumn(this.tlbProperties.getColumnName(0)).setCellRenderer(tableCellRenderer);
            this.tlbProperties.getColumn(this.tlbProperties.getColumnName(1)).setCellRenderer(tableCellRenderer);
            this.tlbProperties.setAutoResizeMode(4);
            this.tlbProperties.setAutoscrolls(true);
            this.tlbProperties.getColumn(this.tlbProperties.getColumnName(1)).setCellEditor(new ScrollableCellEditor());
            this.tlbProperties.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ReactorPropertyEditorPanel.this.getUpButton().setEnabled(ReactorPropertyEditorPanel.this.getTlbProperties().getSelectedRow() != -1);
                    ReactorPropertyEditorPanel.this.getDownButton().setEnabled(ReactorPropertyEditorPanel.this.getTlbProperties().getSelectedRow() != -1);
                    ReactorPropertyEditorPanel.this.notifier.firePropertyChange(ReactorPropertyEditorPanel.PROPERTY_KEY_SELECTION_CHANGED, false, true);
                }
            });
            this.tlbProperties.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    int i;
                    if (e.getColumn() == 0 && e.getType() == 0 && !ReactorPropertyEditorPanel.this.isValueChanging()) {
                        for (i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                            String nameToAdd;
                            String propName = ((String)ReactorPropertyEditorPanel.this.getTlbProperties().getModel().getValueAt(i, e.getColumn())).trim();
                            if (!propName.equals(ReactorPropertyEditorPanel.this.getTlbProperties().getModel().getValueAt(i, e.getColumn()))) {
                                ReactorPropertyEditorPanel.this.setValueChanging(true);
                                ReactorPropertyEditorPanel.this.getTlbProperties().getModel().setValueAt(propName, i, e.getColumn());
                                ReactorPropertyEditorPanel.this.setValueChanging(false);
                            }
                            String string = nameToAdd = ReactionEditorPanel.isReservedProperty(propName) ? ReactorPropertyEditorPanel.this.generateUniqueName(propName, -1) : ReactorPropertyEditorPanel.this.generateUniqueName(propName, i);
                            if (propName.equals(nameToAdd)) continue;
                            if (ReactionEditorPanel.isReservedProperty(propName)) {
                                JOptionPane.showMessageDialog(ReactorPropertyEditorPanel.this, "[" + propName + "] is a reserved property. Renamed to [" + nameToAdd + "]", "Invalid property name", 2);
                            } else {
                                JOptionPane.showMessageDialog(ReactorPropertyEditorPanel.this, "[" + propName + "] already exists. Renamed to [" + nameToAdd + "]", "Invalid property name", 2);
                            }
                            ReactorPropertyEditorPanel.this.getTlbProperties().getModel().setValueAt(nameToAdd, i, e.getColumn());
                        }
                    }
                    if (e.getColumn() == 1 && e.getType() == 0 && !ReactorPropertyEditorPanel.this.isValueChanging()) {
                        for (i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                            String propValue = ((String)ReactorPropertyEditorPanel.this.getTlbProperties().getModel().getValueAt(i, e.getColumn())).trim();
                            if (propValue.equals(ReactorPropertyEditorPanel.this.getTlbProperties().getModel().getValueAt(i, e.getColumn()))) continue;
                            ReactorPropertyEditorPanel.this.setValueChanging(true);
                            ReactorPropertyEditorPanel.this.getTlbProperties().getModel().setValueAt(propValue, i, e.getColumn());
                            ReactorPropertyEditorPanel.this.setValueChanging(false);
                        }
                    }
                    if (!ReactorPropertyEditorPanel.this.isValueChanging()) {
                        ReactorPropertyEditorPanel.this.setProperties();
                    }
                }
            });
        }
        return this.tlbProperties;
    }

    private boolean isRemovableProperty(String propertyName) {
        if (ReactionEditorPanel.isReservedProperty(propertyName)) {
            return false;
        }
        for (int i = 0; i < this.tlbProperties.getModel().getRowCount(); ++i) {
            if (!((String)this.tlbProperties.getValueAt(i, 0)).equalsIgnoreCase(propertyName)) continue;
            return false;
        }
        return true;
    }

    private void setProperties(Molecule mol) {
        for (int i = 0; i < this.tlbProperties.getModel().getRowCount(); ++i) {
            String name = (String)this.tlbProperties.getValueAt(i, 0);
            String value = (String)this.tlbProperties.getValueAt(i, 1);
            mol.setProperty(name, null);
            mol.setProperty(name, value);
        }
        String[] keys = mol.properties().getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!this.isRemovableProperty(keys[i].trim())) continue;
            mol.setProperty(keys[i], null);
        }
    }

    @Override
    public void enterPage(AlchemistState state) {
    }

    @Override
    public void leavePage(AlchemistState state) {
    }

    private JPanel getPropertiesPanel() {
        if (this.propertiesPanel != null) {
            return this.propertiesPanel;
        }
        this.propertiesPanel = new JPanel();
        this.propertiesPanel.setLayout(new BorderLayout());
        this.propertiesPanel.add((Component)this.getMoleculeChooser(), "North");
        this.propertiesPanel.add((Component)this.getButtonPanel(), "East");
        this.propertiesPanel.add((Component)this.getPropertyHolderPanel(), "Center");
        return this.propertiesPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel != null) {
            return this.buttonPanel;
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.buttonPanel.add(this.getUpButton());
        this.buttonPanel.add(this.getDownButton());
        return this.buttonPanel;
    }

    protected JButton getDownButton() {
        if (this.downButton != null) {
            return this.downButton;
        }
        this.downButton = new JButton(this.MOVE_DOWN_PROPERTY_ACTION);
        this.downButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif"));
        this.downButton.setMinimumSize(new Dimension(23, 23));
        this.downButton.setMaximumSize(new Dimension(23, 23));
        this.downButton.setPreferredSize(new Dimension(23, 23));
        this.downButton.setEnabled(false);
        return this.downButton;
    }

    protected JButton getUpButton() {
        if (this.upButton != null) {
            return this.upButton;
        }
        this.upButton = new JButton(this.MOVE_UP_PROPERTY_ACTION);
        this.upButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/up.gif"));
        this.upButton.setMinimumSize(new Dimension(23, 23));
        this.upButton.setMaximumSize(new Dimension(23, 23));
        this.upButton.setPreferredSize(new Dimension(23, 23));
        this.upButton.setEnabled(false);
        return this.upButton;
    }

    protected JComboBox getMoleculeChooser() {
        if (this.moleculeChooser == null) {
            this.moleculeChooser = new JComboBox();
            this.moleculeChooser.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 4087904560004967932L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (index > 0) {
                        if (ReactionEditorPanel.hasCustomProperty(ReactorPropertyEditorPanel.this.getMolecules()[index - 1].properties().getKeys())) {
                            label.setFont(label.getFont().deriveFont(1));
                        } else {
                            label.setFont(label.getFont().deriveFont(0));
                        }
                    } else if (ReactionEditorPanel.hasCustomProperty(ReactorPropertyEditorPanel.this.getReaction().properties().getKeys())) {
                        label.setFont(label.getFont().deriveFont(1));
                    } else {
                        label.setFont(label.getFont().deriveFont(0));
                    }
                    return label;
                }
            });
            this.moleculeChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReactorPropertyEditorPanel.this.getMoleculeChooser().getSelectedIndex() == 0) {
                        ReactorPropertyEditorPanel.this.setValueChanging(true);
                        ReactorPropertyEditorPanel.this.clearTable();
                        for (int i = 0; i < ReactorPropertyEditorPanel.this.getReaction().getPropertyCount(); ++i) {
                            String propName = ReactorPropertyEditorPanel.this.getReaction().getPropertyKey(i);
                            if (ReactionEditorPanel.isReservedProperty(propName)) continue;
                            ReactorPropertyEditorPanel.this.addProperty(propName, ReactorPropertyEditorPanel.this.getReaction().getProperty(propName));
                        }
                        ReactorPropertyEditorPanel.this.setValueChanging(false);
                    } else if (ReactorPropertyEditorPanel.this.getMoleculeChooser().getSelectedIndex() > 0) {
                        ReactorPropertyEditorPanel.this.setValueChanging(true);
                        Molecule example = ReactorPropertyEditorPanel.this.getMolecules()[ReactorPropertyEditorPanel.this.getMoleculeChooser().getSelectedIndex() - 1];
                        ReactorPropertyEditorPanel.this.clearTable();
                        for (int i = 0; i < example.getPropertyCount(); ++i) {
                            String propName = example.getPropertyKey(i);
                            if (ReactionEditorPanel.isReservedProperty(propName)) continue;
                            ReactorPropertyEditorPanel.this.addProperty(propName, example.getProperty(propName));
                        }
                        ReactorPropertyEditorPanel.this.setValueChanging(false);
                    }
                }
            });
        }
        return this.moleculeChooser;
    }

    public void refreshInformations(Molecule reaction, Molecule[] molecules) {
        this.setValueChanging(true);
        this.setMolecules(molecules);
        this.setReaction(reaction);
        this.moleculeChooser.removeAllItems();
        this.moleculeChooser.addItem("Reaction");
        for (int i = 0; i < molecules.length; ++i) {
            this.moleculeChooser.addItem("Example" + (i + 1));
        }
        this.setValueChanging(false);
    }

    public void setReactionProperties(Molecule reaction) {
        if (this.getReaction() != null) {
            reaction.clearProperties();
            for (int i = 0; i < this.getReaction().getPropertyCount(); ++i) {
                reaction.setProperty(this.getReaction().getPropertyKey(i), this.getReaction().getProperty(this.getReaction().getPropertyKey(i)));
            }
        }
    }

    private JPanel getPropertyHolderPanel() {
        if (this.propertyHolderPanel == null) {
            this.propertyHolderPanel = new JPanel();
            this.propertyHolderPanel.setLayout(new BoxLayout(this.getPropertyHolderPanel(), 1));
            this.propertyHolderPanel.add((Component)this.getReactionProperties(), null);
        }
        return this.propertyHolderPanel;
    }

    private JPanel getReactionProperties() {
        if (this.reactionProperties == null) {
            this.reactionProperties = new JPanel();
            this.reactionProperties.setLayout(new BorderLayout());
            this.reactionProperties.add((Component)this.getScrlProperties(), "Center");
        }
        return this.reactionProperties;
    }

    protected void setProperties() {
        if (this.moleculeChooser.getSelectedIndex() == 0) {
            this.setProperties(this.getReaction());
        } else if (this.moleculeChooser.getSelectedIndex() > 0) {
            this.setProperties(this.getMolecules()[this.moleculeChooser.getSelectedIndex() - 1]);
        }
    }

    public void setExampleProperties(Molecule[] examples) {
        for (int i = 0; i < examples.length; ++i) {
            examples[i].clearProperties();
            for (int j = 0; j < this.getMolecules()[i].getPropertyCount(); ++j) {
                examples[i].setProperty(this.getMolecules()[i].getPropertyKey(j), this.getMolecules()[i].getProperty(this.getMolecules()[i].getPropertyKey(j)));
            }
        }
    }

    protected void setValueChanging(boolean isValueChanging) {
        this.isValueChanging = isValueChanging;
    }

    protected boolean isValueChanging() {
        return this.isValueChanging;
    }

    protected void setReaction(Molecule reaction) {
        this.reaction = reaction;
    }

    protected Molecule getReaction() {
        return this.reaction;
    }

    protected void setMolecules(Molecule[] molecules) {
        this.molecules = molecules;
    }

    protected Molecule[] getMolecules() {
        return this.molecules;
    }

    protected void setInitializing(boolean isInitializing) {
        this.isInitializing = isInitializing;
    }

    protected boolean isInitializing() {
        return this.isInitializing;
    }
}

