/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor;

import chemaxon.alchemist.reactor.reactioneditor.ReactionEditorPanel;
import chemaxon.alchemist.reactor.reactioneditor.ReactorPropertyEditorPanel;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.CheckBoxList;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ReactorPropertyGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = 8064981589949669857L;
    private JScrollPane srlpPropertyList = null;
    private CheckBoxList lstPropertyList = null;
    private JPanel pnlCommand = null;
    private JButton buttAccept = null;
    private JCheckBox chkAll = null;
    private ReactorPropertyEditorPanel propEd = null;
    private JButton buttImportProperties = null;
    private AlchemistFileChooserForJChem importProp = null;

    public ReactorPropertyGeneratorPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(413, 270));
        this.add((Component)this.getSrlpPropertyList(), "Center");
        this.add((Component)this.getPnlCommand(), "South");
        try {
            this.setImportProp(new AlchemistFileChooserForJChem());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JScrollPane getSrlpPropertyList() {
        if (this.srlpPropertyList == null) {
            this.srlpPropertyList = new JScrollPane();
            this.srlpPropertyList.setViewportView(this.getLstPropertyList());
        }
        return this.srlpPropertyList;
    }

    protected CheckBoxList getLstPropertyList() {
        if (this.lstPropertyList == null) {
            this.lstPropertyList = new CheckBoxList();
        }
        return this.lstPropertyList;
    }

    public void setPropertyKeys(List<String> properties) {
        DefaultListModel<JCheckBox> model = new DefaultListModel<JCheckBox>();
        for (int i = 0; i < properties.size(); ++i) {
            model.addElement(new JCheckBox(properties.get(i)));
        }
        this.lstPropertyList.setModel(model);
    }

    public void addPropertyKeys(List<String> properties) {
        int i;
        ArrayList<JCheckBox> checkbox = new ArrayList<JCheckBox>();
        for (i = 0; i < this.lstPropertyList.getModel().getSize(); ++i) {
            checkbox.add((JCheckBox)this.lstPropertyList.getModel().getElementAt(i));
        }
        for (i = 0; i < properties.size(); ++i) {
            boolean exists = false;
            for (int j = 0; j < this.lstPropertyList.getModel().getSize(); ++j) {
                String name = ((JCheckBox)this.lstPropertyList.getModel().getElementAt(j)).getText();
                if (!name.equalsIgnoreCase(properties.get(i))) continue;
                exists = true;
            }
            if (exists) continue;
            checkbox.add(new JCheckBox(properties.get(i)));
        }
        DefaultListModel<JCheckBox> model = new DefaultListModel<JCheckBox>();
        for (JCheckBox jCheckBox : checkbox) {
            model.addElement(jCheckBox);
        }
        this.lstPropertyList.setModel(model);
    }

    private JPanel getPnlCommand() {
        if (this.pnlCommand == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 4;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 1;
            this.pnlCommand = new JPanel();
            this.pnlCommand.setLayout(new GridBagLayout());
            this.pnlCommand.add((Component)this.getJCheckBox1(), gridBagConstraints2);
            this.pnlCommand.add((Component)this.getJButton(), gridBagConstraints1);
            this.pnlCommand.add((Component)this.getButtImportProperties(), gridBagConstraints3);
        }
        return this.pnlCommand;
    }

    private JButton getJButton() {
        if (this.buttAccept == null) {
            this.buttAccept = new JButton();
            this.buttAccept.setText("Set Properties");
            this.buttAccept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReactorPropertyGeneratorPanel.this.getPropEd() != null) {
                        for (int i = 0; i < ReactorPropertyGeneratorPanel.this.getLstPropertyList().getModel().getSize(); ++i) {
                            JCheckBox item = (JCheckBox)ReactorPropertyGeneratorPanel.this.getLstPropertyList().getModel().getElementAt(i);
                            if (!item.isSelected()) continue;
                            ReactorPropertyGeneratorPanel.this.getPropEd().addProperty(item.getText(), "GENERATED");
                        }
                    }
                }
            });
        }
        return this.buttAccept;
    }

    private JCheckBox getJCheckBox1() {
        if (this.getChkAll() == null) {
            this.setChkAll(new JCheckBox());
            this.getChkAll().setText("All Properties");
            this.getChkAll().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < ReactorPropertyGeneratorPanel.this.getLstPropertyList().getModel().getSize(); ++i) {
                        ((JCheckBox)ReactorPropertyGeneratorPanel.this.getLstPropertyList().getModel().getElementAt(i)).setSelected(ReactorPropertyGeneratorPanel.this.getChkAll().isSelected());
                    }
                    ReactorPropertyGeneratorPanel.this.getLstPropertyList().repaint();
                }
            });
        }
        return this.getChkAll();
    }

    public void setPropEd(ReactorPropertyEditorPanel propEd) {
        this.propEd = propEd;
    }

    private JButton getButtImportProperties() {
        if (this.buttImportProperties == null) {
            this.buttImportProperties = new JButton();
            this.buttImportProperties.setText("Import Properties...");
            this.buttImportProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReactorPropertyGeneratorPanel.this.getImportProp() != null) {
                        ReactorPropertyGeneratorPanel.this.getImportProp().setDialogTitle("Import Properties from File");
                        int rVal = ReactorPropertyGeneratorPanel.this.getImportProp().showOpenDialog(null);
                        if (rVal == 0) {
                            ReactorPropertyGeneratorPanel.this.readPropertiesFromFile(ReactorPropertyGeneratorPanel.this.getImportProp().getSelectedFile());
                        }
                    }
                }
            });
        }
        return this.buttImportProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPropertiesFromFile(File file) {
        MolImporter importer = null;
        try {
            ArrayList<String> properties = new ArrayList<String>();
            importer = new MolImporter(file, "");
            Molecule mol = importer.read();
            while (mol != null) {
                for (int i = 0; i < mol.getPropertyCount(); ++i) {
                    boolean exists = false;
                    boolean found = false;
                    int j = 0;
                    while (j < properties.size() && !exists && !found) {
                        if (((String)properties.get(j)).equalsIgnoreCase(mol.getPropertyKey(i))) {
                            exists = true;
                            continue;
                        }
                        if (((String)properties.get(j)).compareToIgnoreCase(mol.getPropertyKey(i)) > 0) {
                            found = true;
                            continue;
                        }
                        ++j;
                    }
                    if (exists || ReactionEditorPanel.isReservedProperty(mol.getPropertyKey(i))) continue;
                    properties.add(j, mol.getPropertyKey(i));
                }
                mol = importer.read();
            }
            this.addPropertyKeys(properties);
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError("Error when importing properties", e);
        }
        finally {
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void setImportProp(AlchemistFileChooserForJChem importProp) {
        this.importProp = importProp;
    }

    protected AlchemistFileChooserForJChem getImportProp() {
        return this.importProp;
    }

    protected void setChkAll(JCheckBox chkAll) {
        this.chkAll = chkAll;
    }

    protected JCheckBox getChkAll() {
        return this.chkAll;
    }

    protected ReactorPropertyEditorPanel getPropEd() {
        return this.propEd;
    }
}

