/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor.ide;

import chemaxon.alchemist.AlchemistApplication;
import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.reactor.reactioneditor.ide.ComponentFactory;
import chemaxon.alchemist.reactor.reactioneditor.ide.PropertyEditorDialog;
import chemaxon.alchemist.utils.AboutDialogFactory;
import chemaxon.alchemist.utils.AlchemistContainer;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistInnerDialog;
import chemaxon.alchemist.utils.transition.AlchemistFadeScrollPane;
import chemaxon.alchemist.utils.transition.AlchemistTransitionPanel;
import chemaxon.alchemist.utils.transition.AlchemistTransitionUtils;
import chemaxon.formats.MolExporter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.beans.splash.MarvinSplashScreen;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.uif.module.GUIModule;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class ReactionEditorApplication
extends MarvinBasedAlchemistApplication {
    public static final String PROPERTY_KEY_SELECTED_SCHEMA = "SelectedSchema";
    public static final String PROPERTY_KEY_SELECTED_EXAMPLE = "SelectedExample";
    public static final String PROPERTY_KEY_SCHEMA_STRUCTURE = "ReactionEditorApplication_SchemaStructure";
    public static final String PROPERTY_KEY_EXAMPLE_STRUCTURE = "ReactionEditorApplication_ExampleStructure";
    static final String PROPERTY_KEY_PROPERTY_EDITOR_CONTENT = "ReactionEditorApplication_PropertyEditorContent";
    static final String PROPERTY_KEY_SKETCH_CONTENT = "ReactionEditorApplication_SkecthContent";
    static final String PROPERTY_KEY_SKETCH_MODE = "ReactionEditorApplication_SkecthMode";
    static final String PROPERTY_VALUE_SCHEMA = "Schema";
    static final String PROPERTY_VALUE_EXAMPLE = "Example";
    static final String PROPERTY_VALUE_EDIT = "Edit";
    static final String PROPERTY_VALUE_ADD = "Add";
    private final UserSettings sketchUserSettings = new UserSettings("ReactionEditorApplication_Marvin.properties");
    protected final MSketchPane sketch = new MSketchPane(this.sketchUserSettings);
    protected AlchemistInnerDialog sketchDialog = null;
    protected PropertyEditorDialog propertyEditorDialog = null;
    private AlchemistTransitionPanel schemaToolbarFadePanel = null;

    public ReactionEditorApplication() {
        super("Reaction Editor " + VersionInfo.JCHEM_VERSION, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/reactor.png"), new AlchemistContainer());
        this.sketchUserSettings.setCheckerConfigFileName("ReactionEditorApplication_MarvinSketch_checkerconfig.xml");
        this.setMenuResources("chemaxon/alchemist/reactor/reactioneditor/ide/resources/menu.xml");
        this.setDocumentPathInFrameTitle(true);
        this.initializeUI();
    }

    private void initializeUI() {
        ((AlchemistContainer)this.getContentPane()).setWestResizable(true);
        JPanel schemaTableHolder = new JPanel(new BorderLayout());
        JTable reactionTable = ComponentFactory.getReactionTable(this);
        JScrollPane westScroll = new JScrollPane(reactionTable);
        westScroll.getViewport().setBackground(Color.WHITE);
        westScroll.setPreferredSize(new Dimension(200, 400));
        westScroll.setMinimumSize(new Dimension(200, 400));
        schemaTableHolder.add(westScroll);
        this.getContentPane().add((Component)schemaTableHolder, "West");
        this.schemaToolbarFadePanel = new AlchemistTransitionPanel(this.getGuiModule().getToolBar("schemaToolbar"), reactionTable.getTableHeader());
        reactionTable.setTableHeader(null);
        AlchemistTransitionUtils.transitionOnMouseOver(this.schemaToolbarFadePanel, schemaTableHolder);
        this.schemaToolbarFadePanel.setBackground(Color.WHITE);
        schemaTableHolder.add((Component)this.schemaToolbarFadePanel, "North");
        this.addPropertyChangeListener("DataIsLoading", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Boolean) {
                    Boolean value = (Boolean)evt.getNewValue();
                    if (value.booleanValue()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ReactionEditorApplication.this.disableContent(true);
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ReactionEditorApplication.this.enableContent();
                                JTable table = ComponentFactory.getReactionTable(ReactionEditorApplication.this);
                                if (table.getRowCount() > 0) {
                                    table.getSelectionModel().setSelectionInterval(0, 0);
                                }
                            }
                        });
                    }
                }
            }
        });
        this.initSchemaPage();
        this.initExamplePage();
        this.getPropertyEditorDialog();
    }

    private void initSchemaPage() {
        JSplitPane schemaPage = new JSplitPane(1);
        schemaPage.setResizeWeight(1.0);
        schemaPage.setName("Scheme");
        JPanel schemaParent = new JPanel(new BorderLayout());
        schemaParent.add((Component)ComponentFactory.getSchemaCanvas(this), "Center");
        final JTable schemaTable = ComponentFactory.getReactionTable(this);
        schemaTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ReactionEditorApplication.this.getGuiModule().getActions().getAction("removeSchema").setEnabled(schemaTable.getSelectedRow() != -1);
                    ReactionEditorApplication.this.getGuiModule().getActions().getAction("moveSchemaUpwards").setEnabled(schemaTable.getSelectedRow() > 0);
                    ReactionEditorApplication.this.getGuiModule().getActions().getAction("moveSchemaDownwards").setEnabled(schemaTable.getSelectedRow() > -1 && schemaTable.getSelectedRow() < schemaTable.getRowCount() - 1);
                }
            }
        });
        JTable schemaPropertyTable = ComponentFactory.getSchemaPropertyEditorTable(this);
        JScrollPane schemaPropertyScroll = new JScrollPane(schemaPropertyTable);
        schemaPropertyScroll.setPreferredSize(new Dimension(200, 400));
        schemaPropertyScroll.setMinimumSize(new Dimension(200, 400));
        schemaPropertyScroll.getViewport().setBackground(Color.WHITE);
        JPanel schemaPropertyPanel = new JPanel(new BorderLayout());
        AlchemistTransitionPanel schemaPropertyTableHeader = new AlchemistTransitionPanel(this.getGuiModule().getToolBar("schemaPropertyToolbar"), schemaPropertyTable.getTableHeader());
        AlchemistTransitionUtils.transitionOnMouseOver(schemaPropertyTableHeader, schemaPropertyPanel);
        schemaPropertyTable.setTableHeader(null);
        schemaPropertyPanel.add((Component)schemaPropertyTableHeader, "North");
        schemaPropertyPanel.add((Component)schemaPropertyScroll, "Center");
        schemaPage.setLeftComponent(schemaParent);
        schemaPage.setRightComponent(schemaPropertyPanel);
        schemaPage.setDividerLocation(0.75);
        this.getContentPane().add((Component)schemaPage, "Center");
        this.getGuiModule().getActions().getAction("addSchema").setEnabled(true);
        this.getGuiModule().getActions().getAction("removeSchema").setEnabled(schemaTable.getSelectedRow() != -1);
        this.getGuiModule().getActions().getAction("moveSchemaUpwards").setEnabled(schemaTable.getSelectedRow() > 0);
        this.getGuiModule().getActions().getAction("moveSchemaDownwards").setEnabled(schemaTable.getSelectedRow() > -1 && schemaTable.getSelectedRow() < schemaTable.getRowCount() - 1);
        this.getGuiModule().getActions().getAction("addSchemaProperty").setEnabled(schemaTable.getSelectedRow() != -1);
        this.getGuiModule().getActions().getAction("removeSchemaProperty").setEnabled(schemaPropertyTable.getSelectedRow() != -1);
        this.getGuiModule().getActions().getAction("moveSchemaPropertyUpwards").setEnabled(schemaPropertyTable.getSelectedRow() > 0);
        this.getGuiModule().getActions().getAction("moveSchemaPropertyDownwards").setEnabled(schemaPropertyTable.getSelectedRow() > -1 && schemaPropertyTable.getSelectedRow() < schemaPropertyTable.getRowCount() - 2);
    }

    private void initExamplePage() {
        JSplitPane examplePage = new JSplitPane(1);
        examplePage.setResizeWeight(1.0);
        examplePage.setName("Examples");
        final JList exampleList = ComponentFactory.getExampleList(this);
        JPanel exampleParent = new JPanel(new BorderLayout());
        final AlchemistFadeScrollPane exampleListScroll = new AlchemistFadeScrollPane(exampleList, 20, 31);
        exampleListScroll.getViewport().setBackground(Color.WHITE);
        exampleListScroll.setBorder(null);
        exampleListScroll.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Rectangle rect = exampleList.getVisibleRect();
                exampleList.setSize((int)(rect.getWidth() - rect.getX()), exampleList.getHeight());
                exampleListScroll.getVerticalScrollBar().setUnitIncrement((int)rect.getHeight());
                exampleListScroll.getVerticalScrollBar().setBlockIncrement((int)rect.getHeight());
            }
        });
        exampleListScroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                int index = exampleList.getFirstVisibleIndex();
                if (index != -1) {
                    if (exampleList.getClientProperty("PendingSelectionIndex") != null) {
                        index = (Integer)exampleList.getClientProperty("PendingSelectionIndex");
                        exampleList.putClientProperty("PendingSelectionIndex", null);
                    }
                    if (exampleList.getSelectedIndex() != index) {
                        exampleList.setSelectedIndex(index);
                    }
                    exampleList.ensureIndexIsVisible(index);
                }
            }
        });
        AlchemistTransitionPanel exampleToolbarFadePanel = new AlchemistTransitionPanel(this.getGuiModule().getToolBar("exampleToolbar"));
        AlchemistTransitionUtils.transitionOnMouseOver(exampleListScroll, exampleParent);
        AlchemistTransitionUtils.transitionOnMouseOver(exampleToolbarFadePanel, exampleParent);
        exampleToolbarFadePanel.setBackground(Color.WHITE);
        exampleList.setBorder(null);
        exampleParent.add((Component)exampleToolbarFadePanel, "North");
        exampleParent.add((Component)exampleListScroll, "Center");
        examplePage.setLeftComponent(exampleParent);
        JTable examplePropertyTable = ComponentFactory.getExamplePropertyEditorTable(this);
        JScrollPane examplePropertyScroll = new JScrollPane(examplePropertyTable);
        examplePropertyScroll.setPreferredSize(new Dimension(200, 400));
        examplePropertyScroll.setMinimumSize(new Dimension(200, 400));
        examplePropertyScroll.getViewport().setBackground(Color.WHITE);
        JPanel examplePropertyPanel = new JPanel(new BorderLayout());
        AlchemistTransitionPanel examplePropertyTableHeader = new AlchemistTransitionPanel(this.getGuiModule().getToolBar("examplePropertyToolbar"), examplePropertyTable.getTableHeader());
        AlchemistTransitionUtils.transitionOnMouseOver(examplePropertyTableHeader, examplePropertyPanel);
        examplePropertyTable.setTableHeader(null);
        examplePropertyPanel.add((Component)examplePropertyTableHeader, "North");
        examplePropertyPanel.add((Component)examplePropertyScroll, "Center");
        examplePage.setRightComponent(examplePropertyPanel);
        this.getContentPane().add((Component)examplePage, "Center");
        this.getGuiModule().getActions().getAction("addExample").setEnabled(ComponentFactory.getReactionTable(this).getSelectedRow() != -1);
        this.getGuiModule().getActions().getAction("removeExample").setEnabled(exampleList.getSelectedIndex() != -1);
        this.getGuiModule().getActions().getAction("moveExampleUpwards").setEnabled(exampleList.getSelectedIndex() > 0);
        this.getGuiModule().getActions().getAction("moveExampleDownwards").setEnabled(exampleList.getSelectedIndex() > -1 && exampleList.getSelectedIndex() < exampleList.getModel().getSize() - 1);
        this.getGuiModule().getActions().getAction("addExampleProperty").setEnabled(exampleList.getSelectedIndex() != -1);
        this.getGuiModule().getActions().getAction("removeExampleProperty").setEnabled(exampleList.getSelectedIndex() != -1);
        this.getGuiModule().getActions().getAction("moveExamplePropertyUpwards").setEnabled(exampleList.getSelectedIndex() > 0);
        this.getGuiModule().getActions().getAction("moveExamplePropertyDownwards").setEnabled(exampleList.getSelectedIndex() > -1 && exampleList.getSelectedIndex() < exampleList.getModel().getSize() - 2);
    }

    public void editSelectedSchema() {
        this.setEnabled(false);
        this.sketch.setMol(this.getSelectedSchema() == null ? new Molecule() : this.getSelectedSchema().cloneMolecule());
        this.sketch.putClientProperty(PROPERTY_KEY_SKETCH_MODE, this.getSelectedSchema() == null ? PROPERTY_VALUE_ADD : PROPERTY_VALUE_EDIT);
        this.sketch.putClientProperty(PROPERTY_KEY_SKETCH_CONTENT, PROPERTY_VALUE_SCHEMA);
        this.getSketchDialog().setText("Edit Schema");
        this.getSketchDialog().setVisible(true);
    }

    void editSelectedExample() {
        this.setEnabled(false);
        this.sketch.setMol(this.getSelectedExample() == null ? new Molecule() : this.getSelectedExample().cloneMolecule());
        this.sketch.putClientProperty(PROPERTY_KEY_SKETCH_MODE, this.getSelectedExample() == null ? PROPERTY_VALUE_ADD : PROPERTY_VALUE_EDIT);
        this.sketch.putClientProperty(PROPERTY_KEY_SKETCH_CONTENT, PROPERTY_VALUE_EXAMPLE);
        this.getSketchDialog().setText("Edit Example");
        this.getSketchDialog().setVisible(true);
    }

    public void addExample() {
        if (this.getSelectedSchema() != null) {
            this.setEnabled(false);
            this.sketch.setMol(new Molecule());
            this.sketch.putClientProperty(PROPERTY_KEY_SKETCH_MODE, PROPERTY_VALUE_ADD);
            this.sketch.putClientProperty(PROPERTY_KEY_SKETCH_CONTENT, PROPERTY_VALUE_EXAMPLE);
            this.getSketchDialog().setText("Edit Example");
            this.getSketchDialog().setVisible(true);
        }
    }

    public void removeExample() {
        JList list = ComponentFactory.getExampleList(this);
        if (list.getSelectedIndex() != -1) {
            ((DefaultListModel)list.getModel()).remove(list.getSelectedIndex());
            list.setSelectedIndex(list.getFirstVisibleIndex());
            this.saveExampleData();
        }
    }

    public void moveExampleUpwards() {
        JList list = ComponentFactory.getExampleList(this);
        if (list.getSelectedIndex() > 0) {
            Object prevItem = ((DefaultListModel)list.getModel()).remove(list.getSelectedIndex() - 1);
            ((DefaultListModel)list.getModel()).add(list.getSelectedIndex() + 1, prevItem);
            list.ensureIndexIsVisible(list.getSelectedIndex());
            this.saveExampleData();
        }
    }

    public void moveExampleDownwards() {
        JList list = ComponentFactory.getExampleList(this);
        if (list.getSelectedIndex() > -1 && list.getSelectedIndex() < list.getModel().getSize() - 1) {
            Object nextItem = ((DefaultListModel)list.getModel()).remove(list.getSelectedIndex() + 1);
            ((DefaultListModel)list.getModel()).add(list.getSelectedIndex(), nextItem);
            list.setSelectedIndex(list.getSelectedIndex() + 1);
            list.ensureIndexIsVisible(list.getSelectedIndex());
            this.saveExampleData();
        }
    }

    public void addSchema() {
        JTable table = ComponentFactory.getReactionTable(this);
        Molecule newSchema = new Molecule();
        newSchema.setProperty("NAME", "New Reaction");
        if (table.getSelectedRow() == -1) {
            ((DefaultTableModel)table.getModel()).addRow(new Object[]{newSchema});
            table.getSelectionModel().setSelectionInterval(table.getRowCount() - 1, table.getRowCount() - 1);
        } else {
            ((DefaultTableModel)table.getModel()).insertRow(table.getSelectedRow(), new Object[]{newSchema});
            table.getSelectionModel().setSelectionInterval(table.getSelectedRow() - 1, table.getSelectedRow() - 1);
        }
        table.scrollRectToVisible(table.getCellRect(table.getSelectedRow(), 0, true));
        this.modified();
    }

    void setPropertyTableKey(JTable table, String newKeyBase, int row) {
        int count = 1;
        String newKey = "EXAMPLE".equalsIgnoreCase(newKeyBase) ? newKeyBase + ++count : newKeyBase;
        boolean match = true;
        while (match) {
            match = false;
            for (int i = 0; i < table.getRowCount() && !match; ++i) {
                if (table.getValueAt(i, 0) == null || !newKey.equalsIgnoreCase(table.getValueAt(i, 0).toString()) || i == row) continue;
                match = true;
                newKey = newKeyBase + ++count;
            }
        }
        table.setValueAt(newKey, row, 0);
    }

    public void addSchemaProperty() {
        this.addProperty(ComponentFactory.getSchemaPropertyEditorTable(this));
    }

    public void removeSchemaProperty() {
        this.removeProperty(ComponentFactory.getSchemaPropertyEditorTable(this));
    }

    public void moveSchemaPropertyUpwards() {
        this.moveTableRowUpwards(ComponentFactory.getSchemaPropertyEditorTable(this));
    }

    public void moveSchemaPropertyDownwards() {
        JTable table = ComponentFactory.getSchemaPropertyEditorTable(this);
        if (table.getSelectedRow() > -1 && table.getSelectedRow() < table.getRowCount() - 2) {
            this.moveTableRowDownwards(table);
        }
    }

    public void addExampleProperty() {
        this.addProperty(ComponentFactory.getExamplePropertyEditorTable(this));
    }

    public void removeExampleProperty() {
        this.removeProperty(ComponentFactory.getExamplePropertyEditorTable(this));
    }

    public void moveExamplePropertyUpwards() {
        this.moveTableRowUpwards(ComponentFactory.getExamplePropertyEditorTable(this));
    }

    public void moveExamplePropertyDownwards() {
        JTable table = ComponentFactory.getExamplePropertyEditorTable(this);
        if (table.getSelectedRow() > -1 && table.getSelectedRow() < table.getRowCount() - 2) {
            this.moveTableRowDownwards(table);
        }
    }

    public void removeSchema() {
        JTable table = ComponentFactory.getReactionTable(this);
        if (table.getSelectedRow() != -1) {
            ((DefaultTableModel)table.getModel()).removeRow(table.getSelectedRow());
            this.modified();
        }
    }

    public void moveSchemaUpwards() {
        this.moveTableRowUpwards(ComponentFactory.getReactionTable(this));
    }

    public void moveSchemaDownwards() {
        this.moveTableRowDownwards(ComponentFactory.getReactionTable(this));
    }

    void editSelectedSchemaProperty() {
        this.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactionEditorApplication.this.getPropertyEditorDialog().initializeEditor(ReactionEditorApplication.PROPERTY_VALUE_SCHEMA);
                ReactionEditorApplication.this.getPropertyEditorDialog().pack();
                AlchemistInnerDialog.setCentered(ReactionEditorApplication.this.getPropertyEditorDialog());
                ReactionEditorApplication.this.getPropertyEditorDialog().setVisible(true);
            }
        });
    }

    void editSelectedExampleProperty() {
        this.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactionEditorApplication.this.getPropertyEditorDialog().initializeEditor(ReactionEditorApplication.PROPERTY_VALUE_EXAMPLE);
                ReactionEditorApplication.this.getPropertyEditorDialog().pack();
                AlchemistInnerDialog.setCentered(ReactionEditorApplication.this.getPropertyEditorDialog());
                ReactionEditorApplication.this.getPropertyEditorDialog().setVisible(true);
            }
        });
    }

    public void setReactionToolbarEffectEnabled(boolean enabled) {
        if (enabled) {
            this.schemaToolbarFadePanel.startTransition();
        } else {
            this.schemaToolbarFadePanel.startTransitionReversed();
        }
        this.schemaToolbarFadePanel.setEffectEnabled(enabled);
    }

    public boolean isReactionToolbarEffectEnabled() {
        return this.schemaToolbarFadePanel.isEffectEnabled();
    }

    public static void main(String[] args) {
        MarvinSplashScreen.splash(ReactionEditorApplication.class.getResource("/chemaxon/alchemist/images/reactioneditor_splash.jpg"));
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AlchemistApplication.setLookAndFeel();
                    ReactionEditorApplication app = new ReactionEditorApplication();
                    app.show();
                }
                catch (Exception e) {
                    AlchemistErrorDialog.showError(e);
                }
                finally {
                    MarvinSplashScreen.disposeSplash();
                }
            }
        });
    }

    protected AlchemistInnerDialog getSketchDialog() {
        if (this.sketchDialog == null) {
            final AbstractAction acceptAction = new AbstractAction("Accept"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReactionEditorApplication.PROPERTY_VALUE_SCHEMA.equals(ReactionEditorApplication.this.sketch.getClientProperty(ReactionEditorApplication.PROPERTY_KEY_SKETCH_CONTENT))) {
                        Molecule oldValue = ReactionEditorApplication.PROPERTY_VALUE_EDIT.equals(ReactionEditorApplication.this.sketch.getClientProperty(ReactionEditorApplication.PROPERTY_KEY_SKETCH_MODE)) ? ReactionEditorApplication.this.getSelectedSchema() : null;
                        ReactionEditorApplication.this.firePropertyChange(ReactionEditorApplication.PROPERTY_KEY_SCHEMA_STRUCTURE, oldValue, ReactionEditorApplication.this.sketch.getMol());
                    } else if (ReactionEditorApplication.PROPERTY_VALUE_EXAMPLE.equals(ReactionEditorApplication.this.sketch.getClientProperty(ReactionEditorApplication.PROPERTY_KEY_SKETCH_CONTENT))) {
                        Molecule oldValue = ReactionEditorApplication.PROPERTY_VALUE_EDIT.equals(ReactionEditorApplication.this.sketch.getClientProperty(ReactionEditorApplication.PROPERTY_KEY_SKETCH_MODE)) ? ReactionEditorApplication.this.getSelectedExample() : null;
                        ReactionEditorApplication.this.firePropertyChange(ReactionEditorApplication.PROPERTY_KEY_EXAMPLE_STRUCTURE, oldValue, ReactionEditorApplication.this.sketch.getMol());
                    }
                    ReactionEditorApplication.this.sketchDialog.setVisible(false);
                    ReactionEditorApplication.this.setEnabled(true);
                    ReactionEditorApplication.this.modified();
                }
            };
            final AbstractAction cancelAction = new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionEditorApplication.this.sketchDialog.setVisible(false);
                    ReactionEditorApplication.this.setEnabled(true);
                }
            };
            this.sketchDialog = new AlchemistInnerDialog("Edit Schema", new Action[]{acceptAction, cancelAction}, new BorderLayout());
            this.sketchDialog.setMaximizable(true);
            this.sketchDialog.setCloseAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = JOptionPane.showConfirmDialog(ReactionEditorApplication.this.sketchDialog, "Do you want to save changes?", "Close editor", 1, 3);
                    if (result == 0) {
                        acceptAction.actionPerformed(e);
                    } else if (result == 1) {
                        cancelAction.actionPerformed(e);
                    }
                }
            });
            this.sketchDialog.getContentPane().add((Component)this.sketch, "Center");
            this.sketchDialog.pack();
            this.addInnerDialog(this.sketchDialog);
            AlchemistInnerDialog.setCentered(this.sketchDialog);
            this.sketchDialog.setVisible(false);
        }
        return this.sketchDialog;
    }

    protected PropertyEditorDialog getPropertyEditorDialog() {
        if (this.propertyEditorDialog == null) {
            this.propertyEditorDialog = new PropertyEditorDialog(this);
            this.propertyEditorDialog.setMinimumSize(new Dimension(320, 240));
            this.propertyEditorDialog.pack();
            this.addInnerDialog(this.propertyEditorDialog);
            AlchemistInnerDialog.setCentered(this.propertyEditorDialog);
            this.propertyEditorDialog.setVisible(false);
        }
        return this.propertyEditorDialog;
    }

    @Override
    protected void aboutActionHandler() {
        AboutDialogFactory.createAboutDialog("Reaction Editor", "/chemaxon/alchemist/images/about/reactioneditor-64.png", VersionInfo.JCHEM_VERSION).setVisible(true);
    }

    @Override
    protected void saveDocumentActionHandler() {
        super.saveDocumentActionHandler();
        this.disableContent(true);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MolExporter exporter = null;
                try {
                    JTable table;
                    FileOutputStream ostream = new FileOutputStream(ReactionEditorApplication.this.getDocumentPath());
                    exporter = new MolExporter(ostream, ReactionEditorApplication.this.getDocumentFormat());
                    JTable jTable = table = ComponentFactory.getReactionTable(ReactionEditorApplication.this);
                    synchronized (jTable) {
                        for (int i = 0; i < table.getModel().getRowCount(); ++i) {
                            exporter.write((Molecule)table.getModel().getValueAt(i, 0));
                        }
                    }
                }
                catch (IOException e) {
                    ReactionEditorApplication.this.showError("Save failed.", e);
                }
                finally {
                    if (exporter != null) {
                        try {
                            exporter.close();
                        }
                        catch (Exception exception) {}
                    }
                    ReactionEditorApplication.this.enableContent();
                }
            }
        });
    }

    @Override
    protected String getPropertyFilePath() {
        return DotfileUtil.getDotFile("/alchemist/.redap").getAbsolutePath();
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.notifier.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Molecule getSelectedSchema() {
        JTable table = ComponentFactory.getReactionTable(this);
        return table.getSelectedRow() == -1 ? null : (Molecule)table.getValueAt(table.getSelectedRow(), 0);
    }

    public Molecule getSelectedExample() {
        return (Molecule)ComponentFactory.getExampleList(this).getSelectedValue();
    }

    void modified() {
        super.setDocumentChanged(true);
    }

    GUIModule getGUIModule() {
        return this.getGuiModule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveExampleData() {
        JList list = ComponentFactory.getExampleList(this);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        MolExporter exporter = null;
        try {
            exporter = new MolExporter(output, "mrv");
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                exporter.write((Molecule)list.getModel().getElementAt(i));
            }
            this.getSelectedSchema().setProperty("EXAMPLE", output.toString());
        }
        catch (IOException e) {
            this.showMessageBox("Save Error", "Failed to save properties.\n\n" + e.getMessage(), 0);
        }
        finally {
            if (exporter != null) {
                try {
                    exporter.close();
                }
                catch (IOException e) {}
            }
            try {
                output.close();
            }
            catch (IOException e) {}
        }
        this.modified();
    }

    @Override
    protected void newDocumentActionHandler() {
        JTable table = ComponentFactory.getReactionTable(this);
        table.clearSelection();
        while (table.getRowCount() > 0) {
            ((DefaultTableModel)table.getModel()).removeRow(0);
        }
        super.newDocumentActionHandler();
    }

    private void moveTableRowUpwards(JTable table) {
        if (table.getSelectedRow() > 0) {
            TableCellEditor editor = table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            table.removeEditor();
            Object[] prevData = new Object[table.getColumnCount()];
            for (int i = 0; i < prevData.length; ++i) {
                prevData[i] = ((DefaultTableModel)table.getModel()).getValueAt(table.getSelectedRow() - 1, i);
            }
            ((DefaultTableModel)table.getModel()).removeRow(table.getSelectedRow() - 1);
            ((DefaultTableModel)table.getModel()).insertRow(table.getSelectedRow() + 1, prevData);
            table.scrollRectToVisible(table.getCellRect(table.getSelectedRow(), 0, true));
            this.modified();
        }
    }

    private void moveTableRowDownwards(JTable table) {
        if (table.getSelectedRow() > -1 && table.getSelectedRow() < table.getRowCount() - 1) {
            TableCellEditor editor = table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            table.removeEditor();
            Object[] nextData = new Object[table.getColumnCount()];
            for (int i = 0; i < nextData.length; ++i) {
                nextData[i] = ((DefaultTableModel)table.getModel()).getValueAt(table.getSelectedRow() + 1, i);
            }
            ((DefaultTableModel)table.getModel()).removeRow(table.getSelectedRow() + 1);
            ((DefaultTableModel)table.getModel()).insertRow(table.getSelectedRow(), nextData);
            table.scrollRectToVisible(table.getCellRect(table.getSelectedRow(), 0, true));
            this.modified();
        }
    }

    private void addProperty(JTable table) {
        this.setPropertyTableKey(table, "New Property", table.getRowCount() - 1);
        table.removeEditor();
        if (table.getRowCount() > 0 && table.getValueAt(table.getRowCount() - 1, 0) != null) {
            ((DefaultTableModel)table.getModel()).addRow(new Object[]{null, null});
        }
    }

    private void removeProperty(JTable table) {
        if (table.getSelectedRow() != -1 && table.getSelectedRow() != table.getRowCount() - 1) {
            TableCellEditor editor = table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            table.removeEditor();
            if (table.getValueAt(table.getSelectedRow(), 1) != null && table.getValueAt(table.getSelectedRow(), 1).toString().length() > 0 && JOptionPane.showConfirmDialog(this.getApplicationFrame(), "Do you want to delete the selected property?", "Delete Property", 0, 3) != 0) {
                return;
            }
            ((DefaultTableModel)table.getModel()).removeRow(table.getSelectedRow());
        }
    }

    @Override
    protected void exitProgramActionHandler() {
        try {
            this.sketchUserSettings.save("Exit");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.exitProgramActionHandler();
    }
}

