/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.standardizer;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistFileTextBox;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class StandardizerOutputConfigPanel
extends AlchemistPage
implements PropertyChangeListener {
    private static final long serialVersionUID = -4286949568521426112L;
    private static final String OUTPUT_MATCHES_INPUT_TITLE = "Invalid output file";
    private static final String OUTPUT_MATCHES_INPUT_MESSAGE = "One of the input files is the same as the output file.";
    public static final String PROPERTY_KEY_LAST_USED_DIR = "StandardizerOutputConfigPanel_LastUsedDir";
    public static final String PROPERTY_KEY_SINGLE_FILE_PATH = "StandardizerOutputConfigPanel_SingleFilePath";
    public static final String PROPERTY_KEY_FILE_FORMAT = "StandardizerOutputConfigPanel_FileFormat";
    public static final String PROPERTY_KEY_IGNORE_ERRORS = "StandardizerOutputConfigPanel_IgnoreErrors";
    private String outputFormat = "smiles";
    private AlchemistFileChooserForJChem saveDialog = null;
    private JPanel pnlContainer = null;
    private AlchemistFileTextBox alchemistFileTextBox = null;
    private JCheckBox ignoreErrorsCheck = null;
    private Object[] inputFiles = null;

    public StandardizerOutputConfigPanel() {
        this.getNotifier().addPropertyChangeListener(this);
        this.initialize();
    }

    private void initialize() {
        try {
            this.saveDialog = new AlchemistFileChooserForJChem();
            this.saveDialog.addDefaultSaveFileFilters();
            this.saveDialog.setDialogTitle("Save Results");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.setSize(380, 380);
        this.setPreferredSize(new Dimension(380, 380));
        this.setMinimumSize(new Dimension(380, 380));
        this.add((Component)this.getPnlContainer(), "Center");
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getOutputPath() {
        return this.alchemistFileTextBox.getFilePath();
    }

    @Override
    public boolean isCorrect() {
        if (this.alchemistFileTextBox.getFilePath().length() != 0) {
            File myFile = new File(this.alchemistFileTextBox.getFilePath());
            if (myFile.isDirectory()) {
                return false;
            }
            if (myFile.exists() && !myFile.canWrite()) {
                return false;
            }
            return !this.isOutputMatchesInput();
        }
        return false;
    }

    private JPanel getPnlContainer() {
        if (this.pnlContainer == null) {
            this.pnlContainer = new JPanel();
            this.pnlContainer.setLayout((LayoutManager)new FormLayout("fill:default:grow", "default, top:default:grow"));
            this.pnlContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            CellConstraints cc = new CellConstraints();
            this.pnlContainer.add((Component)this.getAlchemistFileTextBox(), cc.xy(1, 1));
            this.pnlContainer.add((Component)this.getIgnoreErrorsCheck(), cc.xy(1, 2));
        }
        return this.pnlContainer;
    }

    private JCheckBox getIgnoreErrorsCheck() {
        if (this.ignoreErrorsCheck == null) {
            this.ignoreErrorsCheck = new JCheckBox("Ignore errors and continue with next molecule");
            this.ignoreErrorsCheck.setSelected(true);
        }
        return this.ignoreErrorsCheck;
    }

    @Override
    public void enterPage(AlchemistState state) {
        String path = (String)state.getProperty(PROPERTY_KEY_LAST_USED_DIR);
        this.inputFiles = (Object[])state.getProperty("FileListHandlerPanel_InputFileList");
        if (path != null) {
            this.saveDialog.setCurrentDirectory(new File(path));
        }
    }

    @Override
    public void leavePage(AlchemistState state) {
        state.setPersistentProperty(PROPERTY_KEY_LAST_USED_DIR, this.saveDialog.getCurrentDirectory().getAbsolutePath());
        state.setProperty(PROPERTY_KEY_SINGLE_FILE_PATH, this.alchemistFileTextBox.getFilePath());
        state.setProperty(PROPERTY_KEY_FILE_FORMAT, this.outputFormat);
        state.setProperty(PROPERTY_KEY_IGNORE_ERRORS, this.getIgnoreErrorsCheck().isSelected());
    }

    private AlchemistFileTextBox getAlchemistFileTextBox() {
        if (this.alchemistFileTextBox == null) {
            this.alchemistFileTextBox = new AlchemistFileTextBox(1, this.saveDialog, this.getNotifier(), "Output File", false, PROPERTY_KEY_SINGLE_FILE_PATH);
        }
        return this.alchemistFileTextBox;
    }

    private boolean isOutputMatchesInput() {
        if (this.inputFiles != null) {
            File output = new File(this.getAlchemistFileTextBox().getFilePath());
            for (int i = 0; i < this.inputFiles.length; ++i) {
                File input = new File(this.inputFiles[i].toString());
                if (!output.equals(input)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase(PROPERTY_KEY_SINGLE_FILE_PATH)) {
            this.getNotifier().firePropertyChange(PROPERTY_KEY_FILE_FORMAT, this.outputFormat, ((MolFileFilter)this.saveDialog.getFileFilter()).getFormat());
            this.outputFormat = ((MolFileFilter)this.saveDialog.getFileFilter()).getFormat();
            if (this.isOutputMatchesInput()) {
                JOptionPane.showMessageDialog(null, OUTPUT_MATCHES_INPUT_MESSAGE, OUTPUT_MATCHES_INPUT_TITLE, 2);
            }
        }
    }
}

