/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.structurechecker;

import chemaxon.alchemist.Alchemist;
import chemaxon.alchemist.AlchemistController;
import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.AlchemistProfile;
import chemaxon.alchemist.commonpages.FileListHandlerPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.structurechecker.StructureCheckerConfigBuilderAlchemist;
import chemaxon.alchemist.configbuilder.structurechecker.StructureCheckerConfigurationWriter;
import chemaxon.alchemist.structurechecker.StructureCheckerOptionsPanel;
import chemaxon.alchemist.structurechecker.StructureCheckerOutputPanel;
import chemaxon.alchemist.structurechecker.StructureCheckerProgressPanel;
import chemaxon.alchemist.structurechecker.StructureCheckerTask;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistInnerDialog;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.BasicCheckerRunner;
import chemaxon.checkers.runner.configuration.reader.XMLBasedConfigurationReader;
import chemaxon.license.LicenseManager;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerStatusbarComponent;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StructureCheckerController
extends AlchemistController {
    private static final String PROPERTY_VALUE_PRESS_NEXT_TO_CONTINUE = "Press 'Next' to continue...";
    public static final String PERSISTENT_PROPERTY_PATH = "/alchemist/.structurechecker";
    public static final String PROPERTY_KEY_CHECKER_COUNT = "CheckerPanel_CheckerCount";
    public static final String DEFAULT_TITLE = "Structure Checker " + VersionInfo.MARVIN_VERSION;
    public static final String PROPERTY_KEY_CONFIGURATION = "StructureChecker_ConfigBuilderConfiguration";
    private static final String DEFAULT_PROFILE_PATH = DotfileUtil.getDotFile("/alchemist/structurechecker_configbuilder.profile").getAbsolutePath();
    private String elementConfigurationPath = null;
    private ConfigBuilderPanel configBuilderPanel = null;
    private StructureCheckerProgressPanel page5 = null;
    private StructureCheckerTask task = null;
    private AlchemistInnerDialog userInputDialog = null;
    private final MSketchPane sketch;
    private final UserSettings sketchUserSettings = new UserSettings("StructureChecker_Marvin.properties");
    private final CheckerStatusbarComponent checkerStatusComponent;
    private final boolean useInnerDialog;
    private JCheckBox doNotAskAgainCheck = null;
    private final Action CANCEL_ACTION = new AbstractAction("Cancel"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(StructureCheckerController.this.getAlchemist().getApplicationFrame(), "Do you want to cancel calculation?", "Cancel Structure Checker", 0) == 0) {
                StructureCheckerController.this.ACCEPT_ACTION.setEnabled(false);
                StructureCheckerController.this.DISCARD_ACTION.setEnabled(false);
                StructureCheckerController.this.CANCEL_ACTION.setEnabled(false);
                StructureCheckerController.this.page5.getCurrentTask().stop();
                StructureCheckerController.this.disposeSketch();
            }
        }
    };
    private final Action DISCARD_ACTION = new AbstractAction("Discard"){

        @Override
        public void actionPerformed(ActionEvent e) {
            StructureCheckerController.this.ACCEPT_ACTION.setEnabled(false);
            StructureCheckerController.this.DISCARD_ACTION.setEnabled(false);
            StructureCheckerController.this.CANCEL_ACTION.setEnabled(false);
            if (StructureCheckerController.this.getDoNotAskAgainCheck().isSelected()) {
                StructureCheckerController.this.page5.getCurrentTask().setDefaultUserOperation(StructureCheckerTask.UserOperation.DISCARD);
            }
            StructureCheckerController.this.page5.getCurrentTask().setUserOperation(StructureCheckerTask.UserOperation.DISCARD);
            StructureCheckerController.this.disposeSketch();
        }
    };
    private final Action ACCEPT_ACTION = new AbstractAction("Accept"){

        @Override
        public void actionPerformed(ActionEvent e) {
            StructureCheckerController.this.ACCEPT_ACTION.setEnabled(false);
            StructureCheckerController.this.DISCARD_ACTION.setEnabled(false);
            StructureCheckerController.this.CANCEL_ACTION.setEnabled(false);
            String configuration = (String)StructureCheckerController.this.state.getProperty(StructureCheckerController.PROPERTY_KEY_CONFIGURATION);
            BasicCheckerRunner runner = new BasicCheckerRunner(new XMLBasedConfigurationReader(new ByteArrayInputStream(configuration.getBytes())));
            runner.setMolecule(StructureCheckerController.this.sketch.getMol());
            List<StructureCheckerResult> resultList = runner.checkAndWait();
            if (!resultList.isEmpty() && JOptionPane.showConfirmDialog(StructureCheckerController.this.getAlchemist().getApplicationFrame(), "The structure still contains problem.\nDo you want to save it?", "Confirm structure save", 2) == 2) {
                StructureCheckerController.this.ACCEPT_ACTION.setEnabled(true);
                StructureCheckerController.this.DISCARD_ACTION.setEnabled(true);
                StructureCheckerController.this.CANCEL_ACTION.setEnabled(true);
                return;
            }
            if (StructureCheckerController.this.getDoNotAskAgainCheck().isSelected()) {
                StructureCheckerController.this.page5.getCurrentTask().setDefaultUserOperation(StructureCheckerTask.UserOperation.ACCEPT);
            }
            StructureCheckerController.this.page5.getCurrentTask().setUserOperation(StructureCheckerTask.UserOperation.ACCEPT);
            StructureCheckerController.this.page5.getCurrentTask().setUserStructure(StructureCheckerController.this.sketch.getMol());
            StructureCheckerController.this.disposeSketch();
        }
    };
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("StructureCheckerTask_WaitingForManualFix")) {
                if (evt.getNewValue() instanceof Molecule) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String configString;
                            StructureCheckerController.this.page5.setBottomText(StructureCheckerController.this.page5.getCurrentTask().getStatusText());
                            StructureCheckerController.this.ACCEPT_ACTION.setEnabled(false);
                            StructureCheckerController.this.DISCARD_ACTION.setEnabled(false);
                            StructureCheckerController.this.CANCEL_ACTION.setEnabled(false);
                            StructureCheckerController.this.sketch.clearHistory();
                            StructureCheckerController.this.sketch.setMol((Molecule)evt.getNewValue());
                            if (StructureCheckerController.this.useInnerDialog) {
                                AlchemistInnerDialog.setCentered(StructureCheckerController.this.getUserInputDialog());
                                StructureCheckerController.this.getAlchemist().setEnabled(false);
                                StructureCheckerController.this.getUserInputDialog().setVisible(true);
                            } else {
                                StructureCheckerController.this.page5.showEditorPanel();
                            }
                            if (StructureCheckerController.this.checkerStatusComponent != null && (configString = (String)StructureCheckerController.this.state.getProperty(StructureCheckerController.PROPERTY_KEY_CONFIGURATION)) != null) {
                                StructureCheckerController.this.checkerStatusComponent.cancelCheck();
                                StructureCheckerController.this.checkerStatusComponent.getRunner().setConfigurationReader(new XMLBasedConfigurationReader(new ByteArrayInputStream(configString.getBytes())));
                                StructureCheckerController.this.checkerStatusComponent.performCheck();
                            }
                        }
                    });
                } else if (evt.getPropertyName().equals("canceled") && StructureCheckerController.this.checkerStatusComponent != null) {
                    StructureCheckerController.this.checkerStatusComponent.cancelCheck();
                }
            }
        }
    };

    public StructureCheckerController() {
        this(DEFAULT_TITLE);
    }

    public StructureCheckerController(String title) {
        this(title, "/chemaxon/checkers/resource/defaultcheckerconfig.xml");
    }

    public StructureCheckerController(String title, String elementConfigurationPath) {
        this(title, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/structurechecker.png"), elementConfigurationPath);
    }

    public StructureCheckerController(String title, Image image, String elementConfigurationPath) {
        this(title, image, elementConfigurationPath, false);
    }

    public StructureCheckerController(String title, Image image, String elementConfigurationPath, boolean useInnerDialog) {
        super(title, image);
        this.alchemist = new Alchemist(title, image, this){

            @Override
            protected int getMinimumWindowHeight() {
                return 700;
            }

            @Override
            protected int getMinimumWindowWidth() {
                return 935;
            }
        };
        this.initializeProperties();
        this.sketchUserSettings.setCheckerConfigFileName("StructureCheckerWizard_Marvin_checkerconfig.xml");
        this.sketchUserSettings.setProperty("CheckerConfigurationPanelEnabled", "false", false);
        this.sketch = new MSketchPane(this.sketchUserSettings);
        this.checkerStatusComponent = this.sketch.getMolPanel() instanceof SketchPanel ? CheckerStatusbarComponent.getInstance((SketchPanel)this.sketch.getMolPanel()) : null;
        this.useInnerDialog = useInnerDialog;
        this.elementConfigurationPath = elementConfigurationPath;
        this.initializePages();
        this.initAlchemist();
        this.sketch.getMolPanel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("StructureCheckerRunning") && !((Boolean)evt.getNewValue()).booleanValue()) {
                    StructureCheckerController.this.DISCARD_ACTION.setEnabled(true);
                    StructureCheckerController.this.ACCEPT_ACTION.setEnabled(true);
                    StructureCheckerController.this.CANCEL_ACTION.setEnabled(true);
                }
            }
        });
    }

    @Override
    protected void licenseManagerInvoked() {
        super.licenseManagerInvoked();
        if (this.configBuilderPanel != null) {
            this.configBuilderPanel.refreshLicenses();
        }
    }

    private void initializePages() {
        FileListHandlerPanel page1 = new FileListHandlerPanel(true);
        page1.setTopText("Select files", "Choose files you want to be checked and fixed.");
        page1.setTopTextVisible(true);
        page1.setBottomText(PROPERTY_VALUE_PRESS_NEXT_TO_CONTINUE);
        page1.setBottomTextVisible(true);
        this.addPage("Select input files", page1);
        AlchemistPage page2 = null;
        try {
            AlchemistProfile profile = new AlchemistProfile();
            try {
                profile.read(new FileInputStream(DEFAULT_PROFILE_PATH));
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            this.configBuilderPanel = StructureCheckerConfigBuilderAlchemist.createStructureCheckerPanel(this.elementConfigurationPath, null, profile, true);
            this.configBuilderPanel.addElementPropertyChangeListener(this);
            page2 = new AlchemistPage(){
                private static final long serialVersionUID = -5987964303687862823L;

                @Override
                public void enterPage(AlchemistState state) {
                }

                @Override
                public boolean isCorrect() {
                    return StructureCheckerController.this.configBuilderPanel.isValidConfiguration();
                }

                @Override
                public void performLeavePage() {
                    this.leavePage(StructureCheckerController.this.state);
                    super.performLeavePage();
                }

                @Override
                public void leavePage(AlchemistState state) {
                    StructureCheckerController.this.configBuilderPanel.updateProfile();
                    try {
                        StructureCheckerController.this.configBuilderPanel.getProfile().write(new FileOutputStream(DEFAULT_PROFILE_PATH));
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    StructureCheckerConfigurationWriter writer = new StructureCheckerConfigurationWriter(ostream);
                    try {
                        StructureCheckerController.this.configBuilderPanel.writeConfiguration(writer);
                        ostream.flush();
                        state.setProperty(StructureCheckerController.PROPERTY_KEY_CONFIGURATION, ostream.toString());
                        ostream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    state.setProperty(StructureCheckerController.PROPERTY_KEY_CHECKER_COUNT, StructureCheckerController.this.configBuilderPanel.getConfiguration().length);
                }
            };
            page2.setLayout(new BorderLayout());
            page2.add((Component)this.configBuilderPanel, "Center");
            page2.setBottomText(PROPERTY_VALUE_PRESS_NEXT_TO_CONTINUE);
            page2.setBottomTextVisible(true);
            this.addPage("Create checklist", page2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StructureCheckerOptionsPanel page3 = new StructureCheckerOptionsPanel();
        page3.setTopText("Set options", "Choose a run method determining how to handle the identified issues, and select a report generation option.");
        page3.setTopTextVisible(true);
        page3.setBottomText(PROPERTY_VALUE_PRESS_NEXT_TO_CONTINUE);
        page3.setBottomTextVisible(true);
        this.addPage("Set options", page3);
        StructureCheckerOutputPanel page4 = new StructureCheckerOutputPanel();
        page4.setTopText("Specify output", "Specify the location and name of the output files. You can save all structures in a single file, or you can separate the accepted and discarded ones in two files.");
        page4.setTopTextVisible(true);
        page4.setBottomText(PROPERTY_VALUE_PRESS_NEXT_TO_CONTINUE);
        page4.setBottomTextVisible(true);
        this.addPage("Specify output", page4);
        this.task = new StructureCheckerTask(this.state);
        this.page5 = new StructureCheckerProgressPanel(this.DONE_ACTION, this.task);
        this.addPage("Check", this.page5);
        if (this.useInnerDialog) {
            this.getUserInputDialog().pack();
            this.getAlchemist().addInnerDialog(this.getUserInputDialog());
        } else {
            CellConstraints cc = new CellConstraints();
            FormLayout layout = new FormLayout("4dlu, fill:min:grow, pref, 4dlu, pref, 4dlu, pref, fill:min:grow, 4dlu", "4dlu, fill:min:grow, 2dlu, min, 4dlu, min, 4dlu");
            layout.setColumnGroups((int[][])new int[][]{{2, 8}, {3, 5, 7}});
            JPanel editor = new JPanel((LayoutManager)layout);
            editor.add((Component)this.sketch, cc.xyw(2, 2, 7));
            editor.add((Component)this.getDoNotAskAgainCheck(), cc.xy(2, 4));
            editor.add((Component)new JButton(this.ACCEPT_ACTION), cc.xy(3, 6));
            editor.add((Component)new JButton(this.DISCARD_ACTION), cc.xy(5, 6));
            editor.add((Component)new JButton(this.CANCEL_ACTION), cc.xy(7, 6));
            this.page5.setEditorComponent(editor);
        }
    }

    private JCheckBox getDoNotAskAgainCheck() {
        if (this.doNotAskAgainCheck == null) {
            this.doNotAskAgainCheck = new JCheckBox("Do not ask again", false);
        }
        return this.doNotAskAgainCheck;
    }

    private AlchemistInnerDialog getUserInputDialog() {
        if (this.userInputDialog == null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.sketch, "Center");
            panel.add((Component)this.getDoNotAskAgainCheck(), "South");
            this.userInputDialog = AlchemistInnerDialog.createCustomBox("Manual structure fix", panel, new Action[]{this.ACCEPT_ACTION, this.DISCARD_ACTION, this.CANCEL_ACTION});
            this.userInputDialog.setCloseAction(null);
            this.userInputDialog.setMaximizable(true);
            this.userInputDialog.setVisible(false);
        }
        return this.userInputDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeSketch() {
        String configString;
        CheckerStatusbarComponent component;
        if (this.useInnerDialog) {
            this.getUserInputDialog().setVisible(false);
            this.alchemist.setEnabled(true);
        } else {
            this.page5.hideEditorPanel();
        }
        this.sketch.closeWindows();
        if (this.sketch.getMolPanel() instanceof SketchPanel && (component = CheckerStatusbarComponent.getInstance((SketchPanel)this.sketch.getMolPanel())) != null && (configString = (String)this.state.getProperty(PROPERTY_KEY_CONFIGURATION)) != null) {
            component.cancelCheck();
        }
        StructureCheckerTask structureCheckerTask = this.page5.getCurrentTask();
        synchronized (structureCheckerTask) {
            this.page5.getCurrentTask().notify();
        }
    }

    @Override
    protected void cancelPressed() {
        try {
            this.sketchUserSettings.save("Save");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.saveProperties();
    }

    @Override
    protected void finishPressed() {
        if (!LicenseManager.isLicensed("Structure Checker")) {
            this.getAlchemist().showMessageBox("License Error", "No Structure Checker License found.", 0);
            this.FINISH_ACTION.setEnabled(true);
            this.CANCEL_ACTION.setEnabled(true);
            this.BACK_ACTION.setEnabled(true);
            return;
        }
        this.getDoNotAskAgainCheck().setSelected(false);
        this.page5.setDefaultOperation(null);
        File outFile = new File((String)this.state.getProperty("OutputFilePath"));
        if (outFile.exists() && JOptionPane.showConfirmDialog(null, outFile.getAbsolutePath() + " exists.\nDo you want to overwrite?", "Output file exists", 0) == 1) {
            this.FINISH_ACTION.setEnabled(true);
            this.CANCEL_ACTION.setEnabled(true);
            this.BACK_ACTION.setEnabled(true);
            return;
        }
        StructureCheckerTask currentTask = this.page5.getCurrentTask();
        if (currentTask != null) {
            currentTask.getPropertyChangeSupport().removePropertyChangeListener(this.listener);
        }
        this.page5.setPanelState(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StructureCheckerController.this.page5.runTask(4, StructureCheckerController.this.listener);
            }
        });
    }

    @Override
    public File getPropertiesFile() {
        return DotfileUtil.getDotFile(PERSISTENT_PROPERTY_PATH);
    }

    @Override
    public String getHelpURL() {
        return "http://www.chemaxon.com/jchem/doc/user/structurechecker.html";
    }
}

