/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.structurechecker;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.utils.AlchemistFileChooserForMarvin;
import chemaxon.alchemist.utils.AlchemistFileTextBox;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.AlchemistUtilities;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class StructureCheckerOutputPanel
extends AlchemistPage {
    private static final long serialVersionUID = 1899260676690596202L;
    public static final String PROPERTY_KEY_LAST_USED_DIR = "LastUsedOutputDir";
    public static final String PROPERTY_KEY_OUTPUT_FILE_PATH = "OutputFilePath";
    public static final String PROPERTY_KEY_PROBLEM_FILE_PATH = "ProblemFilePath";
    public static final String PROPERTY_KEY_OUTPUT_FILE_FORMAT = "OutputFormat";
    public static final String PROPERTY_KEY_PROBLEM_FILE_FORMAT = "ProblemFormat";
    public static final String PROPERTY_KEY_IGNORE_ERRORS = "IgnoreErrors";
    public static final String PROPERTY_KEY_OUTPUT_MODE = "OutputMode";
    public static final String PROPERTY_VALUE_SINGLE = "Single";
    public static final String PROPERTY_VALUE_SEPARATED = "Separated";
    public static final String PROPERTY_KEY_IGNORE_OCR_ERRORS = "IgnoreOCRErrors";
    private static final String OUTPUT_MATCHES_INPUT_TITLE = "Invalid output file";
    private static final String OUTPUT_MATCHES_INPUT_MESSAGE = "Input and output can not be the same file.";
    private static final String OUTPUT_MATCHES_PROBLEM_TITLE = "Invalid output file";
    private static final String OUTPUT_MATCHES_PROBLEM_MESSAGE = "Output and problem can not be the same file.";
    private static final String PROBLEM_MATCHES_INPUT_TITLE = "Invalid problem file";
    private static final String PROBLEM_MATCHES_INPUT_MESSAGE = "Input and problem can not be the same file.";
    private static final String LOG_MATCHES_OUTPUT_TITLE = "Invalid report file";
    private static final String LOG_MATCHES_OUTPUT_MESSAGE = "Output and report can not be the same file.";
    private static final String LOG_MATCHES_PROBLEM_TITLE = "Invalid report file";
    private static final String LOG_MATCHES_PROBLEM_MESSAGE = "Problem and report can not be the same file.";
    private JPanel mainPanel = null;
    private AlchemistFileChooserForMarvin saveDialog = null;
    private JPanel singleOutputConfigPanel = null;
    private JPanel doubleOutputConfigPanel = null;
    private JLabel outputFileLabel = null;
    private JLabel problemFileLabel = null;
    private AlchemistFileTextBox outputFileText = null;
    private AlchemistFileTextBox problemFileText = null;
    private String outputFormat = null;
    private String problemFormat = null;
    private JRadioButton singleOutputRadio = null;
    private JRadioButton doubleOutputRadio = null;
    private JCheckBox ignoreErrorsCheck = null;
    private JCheckBox ignoreOCRErrors = null;
    private Object[] inputFiles = null;
    private String logFilePath = null;

    public StructureCheckerOutputPanel() {
        this.initialize();
    }

    private void initialize() {
        try {
            this.saveDialog = new AlchemistFileChooserForMarvin(true);
            this.saveDialog.addDefaultSaveFileFilters();
            this.saveDialog.setDialogTitle("Save results");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
        this.getNotifier().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (StructureCheckerOutputPanel.PROPERTY_KEY_OUTPUT_FILE_PATH.equalsIgnoreCase(evt.getPropertyName())) {
                    StructureCheckerOutputPanel.this.outputFormat = ((MolFileFilter)StructureCheckerOutputPanel.this.saveDialog.getFileFilter()).getFormat();
                    if (StructureCheckerOutputPanel.this.isOutputMatchesInput()) {
                        JOptionPane.showMessageDialog(StructureCheckerOutputPanel.this, StructureCheckerOutputPanel.OUTPUT_MATCHES_INPUT_MESSAGE, "Invalid output file", 2);
                    } else if (StructureCheckerOutputPanel.this.isOutputMatchesProblem()) {
                        JOptionPane.showMessageDialog(StructureCheckerOutputPanel.this, StructureCheckerOutputPanel.OUTPUT_MATCHES_PROBLEM_MESSAGE, "Invalid output file", 2);
                    } else if (StructureCheckerOutputPanel.this.isLogMatchesOutput()) {
                        JOptionPane.showMessageDialog(StructureCheckerOutputPanel.this, "Invalid report file", StructureCheckerOutputPanel.LOG_MATCHES_OUTPUT_MESSAGE, 2);
                    }
                } else if (StructureCheckerOutputPanel.PROPERTY_KEY_PROBLEM_FILE_PATH.equalsIgnoreCase(evt.getPropertyName())) {
                    StructureCheckerOutputPanel.this.problemFormat = ((MolFileFilter)StructureCheckerOutputPanel.this.saveDialog.getFileFilter()).getFormat();
                    if (StructureCheckerOutputPanel.this.isProblemMatchesInput()) {
                        JOptionPane.showMessageDialog(StructureCheckerOutputPanel.this, StructureCheckerOutputPanel.PROBLEM_MATCHES_INPUT_MESSAGE, StructureCheckerOutputPanel.PROBLEM_MATCHES_INPUT_TITLE, 2);
                    } else if (StructureCheckerOutputPanel.this.isOutputMatchesProblem()) {
                        JOptionPane.showMessageDialog(StructureCheckerOutputPanel.this, StructureCheckerOutputPanel.OUTPUT_MATCHES_PROBLEM_MESSAGE, "Invalid output file", 2);
                    } else if (StructureCheckerOutputPanel.this.isLogMatchesProblem()) {
                        JOptionPane.showMessageDialog(StructureCheckerOutputPanel.this, StructureCheckerOutputPanel.LOG_MATCHES_PROBLEM_MESSAGE, "Invalid report file", 2);
                    }
                }
            }
        });
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            CellConstraints cc = new CellConstraints();
            ButtonGroup output = new ButtonGroup();
            output.add(this.getSingleOutputRadio());
            output.add(this.getDoubleOutputRadio());
            this.mainPanel = new JPanel((LayoutManager)new FormLayout("4dlu, pref, fill:min:grow, 4dlu", "4dlu, fill:pref, 2dlu, fill:pref, 2dlu, min, 4dlu, min, 4dlu"));
            this.mainPanel.add((Component)this.getSingleOutputConfigPanel(), cc.xyw(2, 2, 2));
            this.mainPanel.add((Component)this.getDoubleOutputConfigPanel(), cc.xyw(2, 4, 2));
            this.mainPanel.add((Component)this.getIgnoreErrorsCheck(), cc.xyw(2, 6, 2));
            this.mainPanel.add((Component)this.getIgnoreOCRErrors(), cc.xyw(2, 8, 2));
            this.getSingleOutputRadio().setSelected(true);
            this.updateLayout();
        }
        return this.mainPanel;
    }

    private boolean isLogMatchesOutput() {
        if (this.getOutputFileText().getFilePath() == null || this.getOutputFileText().getFilePath().trim().length() == 0) {
            return false;
        }
        if (this.logFilePath == null || AlchemistUtilities.isEmpty(this.logFilePath)) {
            return false;
        }
        File output = new File(this.getOutputFileText().getFilePath());
        File log = new File(this.logFilePath);
        return output.equals(log);
    }

    private boolean isLogMatchesProblem() {
        if (this.getProblemFileText().getFilePath() == null || this.getProblemFileText().getFilePath().trim().length() == 0) {
            return false;
        }
        if (this.logFilePath == null || AlchemistUtilities.isEmpty(this.logFilePath)) {
            return false;
        }
        File problem = new File(this.getProblemFileText().getFilePath());
        File log = new File(this.logFilePath);
        return problem.equals(log);
    }

    private boolean isOutputMatchesInput() {
        if (this.inputFiles != null) {
            File output = new File(this.getOutputFileText().getFilePath());
            for (int i = 0; i < this.inputFiles.length; ++i) {
                File input = new File(this.inputFiles[i].toString());
                if (!output.equals(input)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProblemMatchesInput() {
        if (this.inputFiles != null) {
            File output = new File(this.getProblemFileText().getFilePath());
            for (int i = 0; i < this.inputFiles.length; ++i) {
                File input = new File(this.inputFiles[i].toString());
                if (!output.equals(input)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOutputMatchesProblem() {
        if (this.getOutputFileText().getFilePath() == null || this.getOutputFileText().getFilePath().trim().length() == 0) {
            return false;
        }
        if (this.getProblemFileText().getFilePath() == null || this.getProblemFileText().getFilePath().trim().length() == 0) {
            return false;
        }
        File output = new File(this.getOutputFileText().getFilePath());
        File problem = new File(this.getProblemFileText().getFilePath());
        return output.equals(problem);
    }

    private JRadioButton getSingleOutputRadio() {
        if (this.singleOutputRadio == null) {
            this.singleOutputRadio = new JRadioButton(new AbstractAction("<html><b>Single Output</b><br>Both fixed and unfixed structures will be saved to a single output file.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOutputPanel.this.getNotifier().firePropertyChange(StructureCheckerOutputPanel.PROPERTY_KEY_OUTPUT_MODE, "", StructureCheckerOutputPanel.PROPERTY_VALUE_SINGLE);
                    StructureCheckerOutputPanel.this.updateLayout();
                }
            });
            this.singleOutputRadio.setFocusPainted(false);
            this.singleOutputRadio.setOpaque(false);
        }
        return this.singleOutputRadio;
    }

    private JRadioButton getDoubleOutputRadio() {
        if (this.doubleOutputRadio == null) {
            this.doubleOutputRadio = new JRadioButton(new AbstractAction("<html><b>Separated Output</b><br>Fixed and Unfixed structures will be saved to separate output files.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOutputPanel.this.getNotifier().firePropertyChange(StructureCheckerOutputPanel.PROPERTY_KEY_OUTPUT_MODE, "", StructureCheckerOutputPanel.PROPERTY_VALUE_SEPARATED);
                    StructureCheckerOutputPanel.this.updateLayout();
                }
            });
            this.doubleOutputRadio.setFocusPainted(false);
            this.doubleOutputRadio.setOpaque(false);
        }
        return this.doubleOutputRadio;
    }

    private JCheckBox getIgnoreErrorsCheck() {
        if (this.ignoreErrorsCheck == null) {
            this.ignoreErrorsCheck = new JCheckBox("Ignore errors and continue with next structure");
            this.ignoreErrorsCheck.setSelected(true);
        }
        return this.ignoreErrorsCheck;
    }

    private JCheckBox getIgnoreOCRErrors() {
        if (this.ignoreOCRErrors == null) {
            this.ignoreOCRErrors = new JCheckBox("Discard OCR errors");
            this.ignoreOCRErrors.setSelected(false);
        }
        return this.ignoreOCRErrors;
    }

    private JPanel getSingleOutputConfigPanel() {
        if (this.singleOutputConfigPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.singleOutputConfigPanel = new JPanel((LayoutManager)new FormLayout("min, 2dlu, fill:min:grow", "fill:pref, 4dlu, fill:pref:grow"));
            this.singleOutputConfigPanel.add((Component)this.getSingleOutputRadio(), cc.xyw(1, 1, 3));
        }
        return this.singleOutputConfigPanel;
    }

    private JPanel getDoubleOutputConfigPanel() {
        if (this.doubleOutputConfigPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.doubleOutputConfigPanel = new JPanel((LayoutManager)new FormLayout("min, 2dlu, fill:min:grow", "fill:pref, 4dlu, fill:pref, 2dlu, fill:pref:grow"));
            this.doubleOutputConfigPanel.add((Component)this.getDoubleOutputRadio(), cc.xyw(1, 1, 3));
            this.doubleOutputConfigPanel.add((Component)this.getProblemFileLabel(), cc.xy(1, 5));
            this.doubleOutputConfigPanel.add((Component)this.getProblemFileText(), cc.xy(3, 5));
        }
        return this.doubleOutputConfigPanel;
    }

    private JLabel getOutputFileLabel() {
        if (this.outputFileLabel == null) {
            this.outputFileLabel = new JLabel("Output file");
            this.outputFileLabel.setOpaque(false);
        }
        return this.outputFileLabel;
    }

    private JLabel getProblemFileLabel() {
        if (this.problemFileLabel == null) {
            this.problemFileLabel = new JLabel("Discarded");
            this.problemFileLabel.setOpaque(false);
        }
        return this.problemFileLabel;
    }

    private AlchemistFileTextBox getOutputFileText() {
        if (this.outputFileText == null) {
            this.outputFileText = new AlchemistFileTextBox(1, this.saveDialog, this.getNotifier(), "", false, PROPERTY_KEY_OUTPUT_FILE_PATH);
            this.outputFileText.setOpaque(false);
            this.outputFileText.setBorder(null);
        }
        return this.outputFileText;
    }

    private AlchemistFileTextBox getProblemFileText() {
        if (this.problemFileText == null) {
            this.problemFileText = new AlchemistFileTextBox(1, this.saveDialog, this.getNotifier(), "", false, PROPERTY_KEY_PROBLEM_FILE_PATH);
            this.problemFileText.setOpaque(false);
            this.problemFileText.setBorder(null);
        }
        return this.problemFileText;
    }

    private void updateLayout() {
        CellConstraints cc = new CellConstraints();
        if (this.getSingleOutputRadio().isSelected()) {
            this.getOutputFileLabel().setText("Output file");
            this.getProblemFileLabel().setVisible(false);
            this.getProblemFileText().setVisible(false);
            this.getSingleOutputConfigPanel().add((Component)this.getOutputFileLabel(), cc.xy(1, 3));
            this.getSingleOutputConfigPanel().add((Component)this.getOutputFileText(), cc.xy(3, 3));
        } else if (this.getDoubleOutputRadio().isSelected()) {
            this.getOutputFileLabel().setText("Accepted");
            this.getProblemFileLabel().setVisible(true);
            this.getProblemFileText().setVisible(true);
            this.getDoubleOutputConfigPanel().add((Component)this.getOutputFileLabel(), cc.xy(1, 3));
            this.getDoubleOutputConfigPanel().add((Component)this.getOutputFileText(), cc.xy(3, 3));
        }
        this.getMainPanel().revalidate();
    }

    @Override
    public boolean isCorrect() {
        boolean outputOk;
        boolean bl = outputOk = this.getOutputFileText().getFilePath() != null && this.getOutputFileText().getFilePath().trim().length() > 0 && !this.isOutputMatchesInput();
        if (outputOk && this.getDoubleOutputRadio().isSelected()) {
            outputOk = !this.isOutputMatchesProblem() && this.getProblemFileText().getFilePath() != null && this.getProblemFileText().getFilePath().trim().length() > 0;
        }
        boolean problemOk = !this.getDoubleOutputRadio().isSelected() || !this.isProblemMatchesInput();
        boolean logOk = !this.isLogMatchesOutput() && (!this.isLogMatchesProblem() || !this.getDoubleOutputRadio().isSelected());
        return outputOk && problemOk && logOk;
    }

    @Override
    public void enterPage(AlchemistState state) {
        String fileName = (String)state.getProperty(PROPERTY_KEY_LAST_USED_DIR);
        if (fileName != null) {
            this.saveDialog.setCurrentDirectory(new File(fileName));
        }
        this.inputFiles = (Object[])state.getProperty("FileListHandlerPanel_InputFileList");
        this.logFilePath = (String)state.getProperty("LogFilePath");
    }

    @Override
    public void leavePage(AlchemistState state) {
        state.setPersistentProperty(PROPERTY_KEY_LAST_USED_DIR, this.saveDialog != null && this.saveDialog.getSelectedFile() != null ? this.saveDialog.getSelectedFile().getParent() : null);
        state.setProperty(PROPERTY_KEY_OUTPUT_FILE_PATH, this.getOutputFileText().getFilePath());
        state.setProperty(PROPERTY_KEY_OUTPUT_FILE_FORMAT, this.outputFormat);
        state.setProperty(PROPERTY_KEY_PROBLEM_FILE_PATH, this.getDoubleOutputRadio().isSelected() ? this.getProblemFileText().getFilePath() : null);
        state.setProperty(PROPERTY_KEY_PROBLEM_FILE_FORMAT, this.problemFormat);
        state.setProperty(PROPERTY_KEY_IGNORE_ERRORS, this.getIgnoreErrorsCheck().isSelected());
        state.setProperty(PROPERTY_KEY_IGNORE_OCR_ERRORS, this.getIgnoreOCRErrors().isSelected());
    }
}

