/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.structurechecker;

import chemaxon.alchemist.AlchemistTask;
import chemaxon.alchemist.commonpages.ProgressPanel;
import chemaxon.alchemist.structurechecker.StructureCheckerTask;
import chemaxon.alchemist.structurechecker.log.StructureCheckerLog;
import chemaxon.alchemist.structurechecker.log.StructureCheckerLogView;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.AlchemistUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StructureCheckerProgressPanel
extends ProgressPanel {
    private static final long serialVersionUID = 6593349912834138251L;
    private static final String SHOW_LOG = "Show Report";
    private static final String CLOSE_LOG = "Close Report";
    private JComponent editorComponent = null;
    private JPanel editorPanel = null;
    private JButton showLogButton = null;
    private JButton copyLogButton = null;
    private StructureCheckerLogView logView = null;

    public StructureCheckerProgressPanel(Action doneAction, AlchemistTask task) {
        super(doneAction, task);
    }

    @Override
    public void enterPage(AlchemistState state) {
        super.enterPage(state);
        Object[] inputFiles = (Object[])state.getProperty("FileListHandlerPanel_InputFileList");
        String outputPath = (String)state.getProperty("OutputFilePath");
        String errorPath = (String)state.getProperty("ProblemFilePath");
        Boolean ignoreFixers = (Boolean)state.getProperty("IgnoreFixers");
        Boolean askOnProblem = (Boolean)state.getProperty("AskOnProblem");
        String logFilePath = (String)state.getProperty("LogFilePath");
        String logFieldName = (String)state.getProperty("LogFieldName");
        String operationMode = (String)state.getProperty("OperationMode");
        Integer checkerCount = (Integer)state.getProperty("CheckerPanel_CheckerCount");
        if (ignoreFixers == null) {
            ignoreFixers = false;
        }
        if (askOnProblem == null) {
            askOnProblem = true;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Input files:");
        for (int i = 0; i < inputFiles.length; ++i) {
            builder.append('\t');
            builder.append(((File)inputFiles[i]).getAbsolutePath());
            builder.append('\n');
        }
        builder.append("\nOutput type: \t");
        builder.append(errorPath != null ? "Separated" : "Single");
        builder.append(errorPath != null ? "\n\nAccepted file:\t" : "\nOutput file:\t");
        builder.append(outputPath);
        builder.append('\n');
        if (errorPath != null && !AlchemistUtilities.isEmpty(errorPath)) {
            builder.append("\nDiscarded file: ");
            builder.append(errorPath);
            builder.append('\n');
        }
        builder.append("\nOperation mode: ");
        builder.append(operationMode);
        builder.append('\n');
        if (logFilePath != null && !AlchemistUtilities.isEmpty(logFilePath)) {
            builder.append("\nReport file: \t");
            builder.append(logFilePath);
            builder.append('\n');
            this.getResultButton().setEnabled(true);
        } else if (logFieldName != null && !AlchemistUtilities.isEmpty(logFieldName)) {
            builder.append("\nReport will be saved to structure as \"");
            builder.append(logFieldName);
            builder.append("\" field.\n");
            this.getResultButton().setEnabled(true);
        } else {
            builder.append("\nNo report.\n");
            this.getResultButton().setEnabled(false);
        }
        builder.append("\nNumber of checkers: ");
        builder.append(checkerCount);
        builder.append('\n');
        this.setMessage(builder.toString(), 0);
        this.setOutputFilePath(outputPath);
        JPanel customResult = new JPanel();
        customResult.setOpaque(false);
        customResult.setLayout(new BoxLayout(customResult, 0));
        customResult.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        customResult.add(Box.createHorizontalGlue());
        customResult.add(this.getCopyLogButton());
        customResult.add(Box.createHorizontalStrut(5));
        customResult.add(this.getResultButton());
        this.setResultCustomPanel(customResult);
    }

    @Override
    protected StructureCheckerTask getCurrentTask() {
        return (StructureCheckerTask)super.getCurrentTask();
    }

    @Override
    public void runTask() {
        this.runTask(5);
    }

    @Override
    public void runTask(int priority) {
        this.runTask(priority, null);
    }

    public void runTask(final int priority, final PropertyChangeListener listener) {
        this.setProgressValue(0);
        this.setMessage("Initializing...", 1);
        this.setBottomText("Initializing...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AlchemistTask clonedTask = (AlchemistTask)StructureCheckerProgressPanel.this.task.clone();
                    StructureCheckerProgressPanel.this.setCurrentTask(clonedTask);
                    if (listener != null) {
                        StructureCheckerProgressPanel.this.getCurrentTask().getPropertyChangeSupport().addPropertyChangeListener(listener);
                    }
                    StructureCheckerProgressPanel.this.getCurrentTask().go(priority);
                    StructureCheckerProgressPanel.this.startRefresh();
                }
                catch (CloneNotSupportedException e) {
                    Object clonedTask = null;
                }
            }
        });
    }

    public void setDefaultOperation(StructureCheckerTask.UserOperation operation) {
        ((StructureCheckerTask)this.task).setDefaultUserOperation(operation);
    }

    protected JPanel getEditorPanel() {
        if (this.editorPanel == null) {
            this.editorPanel = new JPanel(new BorderLayout());
        }
        return this.editorPanel;
    }

    public void setEditorComponent(JComponent component) {
        if (this.editorComponent != null) {
            this.getEditorPanel().remove(this.editorComponent);
        }
        this.editorComponent = component;
        this.getEditorPanel().add((Component)this.editorComponent, "Center");
    }

    public void showEditorPanel() {
        this.getContentPanel().remove(this.dummyPanel);
        this.dummyPanel = this.getEditorPanel();
        this.getContentPanel().add((Component)this.dummyPanel, "Center");
        this.revalidate();
        this.updateUI();
    }

    public void hideEditorPanel() {
        this.setPanelState(this.currentState);
    }

    @Override
    public void refreshInformations() {
        super.refreshInformations();
        this.setBottomText(this.getCurrentTask().getStatusText());
    }

    @Override
    public void setPanelState(int state) {
        super.setPanelState(state);
        this.setBottomTextVisible(state == 1);
        this.setBottomText(this.getCurrentTask() == null ? "" : this.getCurrentTask().getStatusText());
    }

    @Override
    public void leavePage(AlchemistState state) {
        this.showLogButton.setText(SHOW_LOG);
        this.getCopyLogButton().setVisible(false);
        this.getResultPanel().setVisible(false);
        this.getResultPanel().remove(this.getLogView());
        this.getResultView().clear();
        this.getResultPanel().add(this.getResultScrollPanel());
        this.getResultPanel().setVisible(true);
    }

    private StructureCheckerLogView getLogView() {
        if (this.logView == null) {
            this.logView = new StructureCheckerLogView();
        }
        return this.logView;
    }

    private StructureCheckerLogView getInitializedLogView() {
        this.getLogView().showLog(this.getCurrentTask().getLog());
        return this.getLogView();
    }

    private JButton getCopyLogButton() {
        if (this.copyLogButton == null) {
            this.copyLogButton = new JButton(new AbstractAction("Copy to Clipboard"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    try {
                        StructureCheckerLog.saveLog(output, StructureCheckerProgressPanel.this.getCurrentTask().getLog());
                        StringSelection text = new StringSelection(output.toString());
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(text, text);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.copyLogButton.setVisible(false);
        }
        return this.copyLogButton;
    }

    @Override
    protected JButton getResultButton() {
        if (this.showLogButton == null) {
            this.showLogButton = new JButton(SHOW_LOG);
            this.showLogButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase(StructureCheckerProgressPanel.SHOW_LOG)) {
                        StructureCheckerProgressPanel.this.showLogButton.setText(StructureCheckerProgressPanel.CLOSE_LOG);
                        StructureCheckerProgressPanel.this.getCopyLogButton().setVisible(true);
                        StructureCheckerProgressPanel.this.getResultPanel().setVisible(false);
                        StructureCheckerProgressPanel.this.getResultPanel().remove(StructureCheckerProgressPanel.this.getResultScrollPanel());
                        StructureCheckerProgressPanel.this.getResultPanel().add((Component)StructureCheckerProgressPanel.this.getInitializedLogView(), "Center");
                        StructureCheckerProgressPanel.this.getResultPanel().setVisible(true);
                    } else {
                        StructureCheckerProgressPanel.this.showLogButton.setText(StructureCheckerProgressPanel.SHOW_LOG);
                        StructureCheckerProgressPanel.this.getCopyLogButton().setVisible(false);
                        StructureCheckerProgressPanel.this.getResultPanel().setVisible(false);
                        StructureCheckerProgressPanel.this.getResultPanel().remove(StructureCheckerProgressPanel.this.getLogView());
                        StructureCheckerProgressPanel.this.getResultView().clear();
                        StructureCheckerProgressPanel.this.getResultPanel().add(StructureCheckerProgressPanel.this.getResultScrollPanel());
                        StructureCheckerProgressPanel.this.getResultPanel().setVisible(true);
                    }
                }
            });
        }
        return this.showLogButton;
    }
}

