/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.toxicity;

import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.toxicity.AlchemistToxicityBrowser;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.util.DotfileUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ToxicityViewerAlchemist
extends MarvinBasedAlchemistApplication
implements AlchemistLaunchable {
    private static final String MENU_CONFIGURATION_PATH = "chemaxon/alchemist/toxicity/ToxicityViewerAlchemistMenuConfiguration.xml";
    private static final String MENU_BUNDLE_BASENAME = "chemaxon/alchemist/toxicity/ToxicityViewerAlchemistMenuProperties";
    private static final String APPLICATION_TITLE = "Chemaxon - Toxicity Viewer - version " + VersionInfo.JCHEM_VERSION;
    private static final String PERSISTENT_PROPERTY_PATH = "/alchemist/.toxicity_viewer";
    private JPanel mainPanel;
    private AlchemistToxicityBrowser toxicityBrowser;
    private static final MolFileFilter[] FILE_FILTERS = new MolFileFilter[]{new MolFileFilter("mrv")};

    public ToxicityViewerAlchemist() {
        super(APPLICATION_TITLE);
        this.initialize();
    }

    @Override
    protected String getPropertyFilePath() {
        return DotfileUtil.getDotFile(PERSISTENT_PROPERTY_PATH).getAbsolutePath();
    }

    @Override
    protected FileFilter[] getSaveFileFilters() {
        return FILE_FILTERS;
    }

    @Override
    protected FileFilter[] getOpenFileFilters() {
        return FILE_FILTERS;
    }

    @Override
    protected void openDocumentActionHandler(String path) {
        this.toxicityBrowser.setToxicityFile(path);
    }

    private void initialize() {
        this.setDocumentPathInFrameTitle(true);
        this.setMenuResources(MENU_CONFIGURATION_PATH, MENU_BUNDLE_BASENAME, new MarvinBasedAlchemistApplication.DefaultActionConfigurer(this));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 0));
            this.mainPanel.add(this.getToxicityBrowser().getPanel());
        }
        return this.mainPanel;
    }

    private AlchemistToxicityBrowser getToxicityBrowser() {
        if (this.toxicityBrowser == null) {
            this.toxicityBrowser = new AlchemistToxicityBrowser();
        }
        return this.toxicityBrowser;
    }

    private static void createAndShowGUI() {
        try {
            ToxicityViewerAlchemist.setLookAndFeel();
            ToxicityViewerAlchemist toxicityViewerAlchemist = new ToxicityViewerAlchemist();
            toxicityViewerAlchemist.show();
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError(e);
        }
    }

    @Override
    public void launch() {
        ToxicityViewerAlchemist.main(null);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToxicityViewerAlchemist.createAndShowGUI();
            }
        });
    }
}

