/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.version.VersionInfo;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class AboutDialogFactory {
    private AboutDialogFactory() {
    }

    public static JDialog createAboutDialog(String appName) {
        return AboutDialogFactory.createAboutDialog(appName, null);
    }

    public static JDialog createAboutDialog(String appName, String iconPath) {
        return AboutDialogFactory.createAboutDialog(appName, iconPath, VersionInfo.MARVIN_VERSION);
    }

    public static JDialog createAboutDialog(String appName, String iconPath, String version) {
        final JDialog dialog = new JDialog();
        DecimalFormat fmt = new DecimalFormat("0.0");
        dialog.setTitle("About " + appName);
        dialog.setResizable(false);
        dialog.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        FormLayout layout = new FormLayout("10dlu, pref, 10dlu, pref, 4dlu, fill:pref:grow, pref, 10dlu", "10dlu, pref, 10dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref 4dlu, pref, 4dlu, pref, 4dlu, pref, 20dlu, pref, 4dlu, pref, 4dlu, pref, 10dlu");
        CellConstraints cc = new CellConstraints();
        panel.setLayout((LayoutManager)layout);
        if (iconPath != null) {
            panel.add((Component)new JLabel(AlchemistIconFactory.getIcon(iconPath)), cc.xy(2, 2));
        }
        panel.add((Component)AboutDialogFactory.getLabel(appName, 1, 18), cc.xyw(4, 2, 3));
        if (version != null) {
            panel.add((Component)AboutDialogFactory.getLabel("Product version:", 1, 11), cc.xy(4, 4));
            panel.add((Component)AboutDialogFactory.getLabel(appName + " " + version, 0, 11), cc.xy(6, 4));
        } else {
            panel.add((Component)AboutDialogFactory.getLabel("Product name:", 1, 11), cc.xy(4, 4));
            panel.add((Component)AboutDialogFactory.getLabel(appName, 0, 11), cc.xy(6, 4));
        }
        panel.add((Component)AboutDialogFactory.getLabel("Build date:", 1, 11), cc.xy(4, 6));
        panel.add((Component)AboutDialogFactory.getLabel(VersionInfo.buildDate(), 0, 11), cc.xy(6, 6));
        panel.add((Component)AboutDialogFactory.getLabel("Operating System:", 1, 11), cc.xy(4, 8));
        panel.add((Component)AboutDialogFactory.getLabel(System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version"), 0, 11), cc.xy(6, 8));
        panel.add((Component)AboutDialogFactory.getLabel("Java:", 1, 11), cc.xy(4, 10));
        panel.add((Component)AboutDialogFactory.getLabel(System.getProperty("java.vendor") + " Java " + System.getProperty("java.version"), 0, 11), cc.xy(6, 10));
        panel.add((Component)AboutDialogFactory.getLabel("Memory:", 1, 11), cc.xy(4, 12));
        panel.add((Component)AboutDialogFactory.getLabel(fmt.format(Runtime.getRuntime().maxMemory() / 0x100000L) + "M maximum, " + fmt.format(Runtime.getRuntime().totalMemory() / 0x100000L) + "M total, " + fmt.format(Runtime.getRuntime().freeMemory() / 0x100000L) + "M free", 0, 11), cc.xy(6, 12));
        panel.add((Component)AboutDialogFactory.getLabel("Environment:", 1, 11), cc.xy(4, 14));
        panel.add((Component)AboutDialogFactory.getLabel((Environment.APPLET ? (Environment.UNTRUSTED ? "Untrusted Applet" : "Trusted Applet") : (Environment.JAVAWEBSTART ? "Java Web Start" : "Application")) + (Environment.isAdmin() ? " (with Administrator rights)" : ""), 0, 11), cc.xy(6, 14));
        panel.add((Component)AboutDialogFactory.getLabel("Browser:", 1, 11), cc.xy(4, 16));
        try {
            panel.add((Component)AboutDialogFactory.getLabel(System.getProperty("browser") == null ? "-" : System.getProperty("browser") + " " + System.getProperty("browser.version"), 0, 11), cc.xy(6, 16));
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        panel.add((Component)AboutDialogFactory.getLabel("Copyright \u00a9 1998-2012 ChemAxon Ltd.", 0, 11), cc.xyw(4, 18, 3, "center, fill"));
        JEditorPane linkPane = new JEditorPane("text/html", "<html><body><a href=\"http://www.chemaxon.com\">http://www.chemaxon.com</a></body></html>");
        linkPane.setOpaque(false);
        linkPane.setEditable(false);
        linkPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        panel.add((Component)linkPane, cc.xyw(4, 20, 3, "center, fill"));
        JButton closeButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -3450038213981714765L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        closeButton.setText("Close");
        panel.add((Component)closeButton, cc.xy(7, 22));
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setModal(true);
        return dialog;
    }

    private static JLabel getLabel(String text, int style, int size) {
        JLabel label = new JLabel(text);
        label.setFont(new Font("Tahoma", style, size));
        return label;
    }
}

