/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistMoleculeView;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractAlchemistMoleculeEditor
extends AlchemistMoleculeView {
    public static final String PROPERTY_KEY_SELECTED_MOLECULE_INDEX_CHANGED = "OrderChanged";
    private final Map<Integer, Molecule> editedMolecules = new HashMap<Integer, Molecule>();
    private List<Integer> currentMoleculeIndexes;
    private final List<Molecule> localMolecules = new ArrayList<Molecule>();
    private MoleculeIndexArray indexArray = new MoleculeIndexArray(0);
    protected boolean isLoading;
    protected MSketchPane sketch = null;
    protected SwingPropertyChangeSupport notifier;
    private int editedMoleculeIndex;
    private final ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
            boolean enabled = !selectionModel.isSelectionEmpty() && AbstractAlchemistMoleculeEditor.this.currentRowNum * AbstractAlchemistMoleculeEditor.this.colNum + AbstractAlchemistMoleculeEditor.this.view.getSelectedRow() * AbstractAlchemistMoleculeEditor.this.colNum + AbstractAlchemistMoleculeEditor.this.view.getSelectedColumn() < AbstractAlchemistMoleculeEditor.this.maxMolecules;
            AbstractAlchemistMoleculeEditor.this.EDIT_MOLECULE_ACTION.setEnabled(enabled);
            AbstractAlchemistMoleculeEditor.this.REMOVE_MOLECULE_ACTION.setEnabled(enabled);
        }
    };
    protected long changeCount = 0L;
    protected final AbstractAction ADD_MOLECULE_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/addmolecule.gif"))){
        private static final long serialVersionUID = 7811055672305969700L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAlchemistMoleculeEditor.this.addMolecule();
        }
    };
    protected final AbstractAction EDIT_MOLECULE_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/editmolecule.gif"))){
        private static final long serialVersionUID = 1519894883293506704L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAlchemistMoleculeEditor.this.editMolecule();
        }
    };
    protected final AbstractAction APPLY_MOLECULE_EDIT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 8077612782642915593L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAlchemistMoleculeEditor.this.applyChanges();
        }
    };
    protected final AbstractAction CANCEL_MOLECULE_EDIT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 593540421312956131L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAlchemistMoleculeEditor.this.cancelChanges();
        }
    };
    protected final AbstractAction REMOVE_MOLECULE_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/removemolecule.gif"))){
        private static final long serialVersionUID = 8077612782642915593L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAlchemistMoleculeEditor.this.removeMolecule();
        }
    };
    public static final String PROPERTY_KEY_EDITED = "Edited";
    public static final String PROPERTY_KEY_ADDED = "Added";
    public static final String PROPERTY_KEY_REMOVED = "Removed";
    private static final long serialVersionUID = 3614400467166560723L;

    public AbstractAlchemistMoleculeEditor(int defaultRowNum, int defaultColNum, SwingPropertyChangeSupport notifier, MSketchPane sketch) {
        this(defaultRowNum, defaultColNum, 15, 15, notifier, sketch);
    }

    public AbstractAlchemistMoleculeEditor(int defaultRowNum, int defaultColNum, int maxRowNum, int maxColNum, SwingPropertyChangeSupport notifier, MSketchPane sketch) {
        super(defaultRowNum, defaultColNum, maxRowNum, maxColNum, false);
        this.notifier = notifier;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractAlchemistMoleculeEditor.this.notifier.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        this.sketch = sketch;
        this.initialize();
    }

    private void initialize() {
        this.currentMoleculeIndexes = new ArrayList<Integer>(this.rowNum * this.colNum);
        for (int i = 0; i < this.rowNum * this.colNum; ++i) {
            this.currentMoleculeIndexes.add(null);
        }
        this.view.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.view.getColumnModel().getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.EDIT_MOLECULE_ACTION.setEnabled(false);
        this.REMOVE_MOLECULE_ACTION.setEnabled(false);
        this.view.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int cellIndex = AbstractAlchemistMoleculeEditor.this.view.getSelectedRow() * AbstractAlchemistMoleculeEditor.this.view.getColumnCount() + AbstractAlchemistMoleculeEditor.this.view.getSelectedColumn();
                    if (cellIndex >= 0 && AbstractAlchemistMoleculeEditor.this.currentMoleculeIndexes.get(cellIndex) != null) {
                        AbstractAlchemistMoleculeEditor.this.EDIT_MOLECULE_ACTION.actionPerformed(null);
                    } else {
                        AbstractAlchemistMoleculeEditor.this.ADD_MOLECULE_ACTION.actionPerformed(null);
                    }
                }
            }
        });
    }

    public void swapSelectedWithPrevious() {
        ++this.changeCount;
        int moleculeIndex = this.currentRowNum * this.colNum + this.view.getSelectedRow() * this.colNum + this.view.getSelectedColumn();
        int cellIndex = this.view.getSelectedRow() * this.view.getColumnCount() + this.view.getSelectedColumn();
        Molecule currentMolecule = null;
        if (moleculeIndex > 0 && this.view.getSelectedColumn() != -1 && this.view.getSelectedRow() != -1 && moleculeIndex < this.maxMolecules && this.currentMoleculeIndexes.get(cellIndex) != null) {
            int localIndex;
            currentMolecule = moleculeIndex < this.indexArray.getLength() ? ((Molecule)this.dataModel.getValueAt(this.view.getSelectedRow(), this.view.getSelectedColumn())).cloneMolecule() : this.localMolecules.get(moleculeIndex - this.indexArray.getLength()).cloneMolecule();
            int prevIndex = moleculeIndex - 1;
            int prevCol = this.view.getSelectedColumn();
            int prevRow = this.view.getSelectedRow();
            if (prevCol == 0) {
                prevCol = this.view.getColumnCount() - 1;
                --prevRow;
            } else {
                --prevCol;
            }
            Molecule previousMolecule = null;
            if (prevRow >= 0 && prevCol >= 0) {
                previousMolecule = prevIndex < this.indexArray.getLength() ? ((Molecule)this.dataModel.getValueAt(prevRow, prevCol)).cloneMolecule() : this.localMolecules.get(prevIndex - this.indexArray.getLength()).cloneMolecule();
                this.view.changeSelection(prevRow, prevCol, false, false);
            } else {
                this.getScrollBar().setValue(this.getScrollBar().getValue() - 1);
                this.refreshView();
                this.view.changeSelection(0, this.view.getColumnCount() - 1, false, false);
                previousMolecule = ((Molecule)this.dataModel.getValueAt(0, this.view.getColumnCount() - 1)).cloneMolecule();
            }
            if (moleculeIndex < this.indexArray.getLength()) {
                this.editedMolecules.put(moleculeIndex, previousMolecule);
            } else {
                localIndex = moleculeIndex - (this.maxMolecules - this.localMolecules.size());
                this.localMolecules.set(localIndex, previousMolecule);
            }
            if (prevIndex < this.indexArray.getLength()) {
                this.editedMolecules.put(prevIndex, currentMolecule);
            } else {
                localIndex = prevIndex - (this.maxMolecules - this.localMolecules.size());
                this.localMolecules.set(localIndex, currentMolecule);
            }
            this.refreshView();
            this.firePropertyChange(PROPERTY_KEY_SELECTED_MOLECULE_INDEX_CHANGED, moleculeIndex, prevIndex);
        }
    }

    public void swapSelectedWithNext() {
        ++this.changeCount;
        int moleculeIndex = this.currentRowNum * this.colNum + this.view.getSelectedRow() * this.colNum + this.view.getSelectedColumn();
        int cellIndex = this.view.getSelectedRow() * this.view.getColumnCount() + this.view.getSelectedColumn();
        Molecule currentMolecule = null;
        if (moleculeIndex < this.maxMolecules - 1 && this.view.getSelectedColumn() != -1 && this.view.getSelectedRow() != -1 && this.currentMoleculeIndexes.get(cellIndex) != null) {
            int localIndex;
            currentMolecule = moleculeIndex < this.indexArray.getLength() ? ((Molecule)this.dataModel.getValueAt(this.view.getSelectedRow(), this.view.getSelectedColumn())).cloneMolecule() : this.localMolecules.get(moleculeIndex - this.indexArray.getLength()).cloneMolecule();
            int nextIndex = moleculeIndex + 1;
            int nextCol = this.view.getSelectedColumn();
            int nextRow = this.view.getSelectedRow();
            if (nextCol == this.view.getColumnCount() - 1) {
                nextCol = 0;
                ++nextRow;
            } else {
                ++nextCol;
            }
            Molecule nextMolecule = null;
            if (nextRow < this.view.getRowCount() && nextCol < this.view.getColumnCount()) {
                nextMolecule = nextIndex < this.indexArray.getLength() ? ((Molecule)this.dataModel.getValueAt(nextRow, nextCol)).cloneMolecule() : this.localMolecules.get(nextIndex - this.indexArray.getLength()).cloneMolecule();
                this.view.changeSelection(nextRow, nextCol, false, false);
            } else {
                this.getScrollBar().setValue(this.getScrollBar().getValue() + 1);
                this.refreshView();
                this.view.changeSelection(this.view.getRowCount() - 1, 0, false, false);
                nextMolecule = ((Molecule)this.dataModel.getValueAt(this.view.getRowCount() - 1, 0)).cloneMolecule();
            }
            if (moleculeIndex < this.indexArray.getLength()) {
                this.editedMolecules.put(moleculeIndex, nextMolecule);
            } else {
                localIndex = moleculeIndex - (this.maxMolecules - this.localMolecules.size());
                this.localMolecules.set(localIndex, nextMolecule);
            }
            if (nextIndex < this.indexArray.getLength()) {
                this.editedMolecules.put(nextIndex, currentMolecule);
            } else {
                localIndex = nextIndex - (this.maxMolecules - this.localMolecules.size());
                this.localMolecules.set(localIndex, currentMolecule);
            }
            this.refreshView();
            this.firePropertyChange(PROPERTY_KEY_SELECTED_MOLECULE_INDEX_CHANGED, moleculeIndex, nextIndex);
        }
    }

    @Override
    public void importMolecules(String path) {
        this.clear();
        super.importMolecules(path);
    }

    @Override
    public void importMolecules(InputStream inputStream) {
        this.clear();
        super.importMolecules(inputStream);
    }

    @Override
    protected void resetScrollBar() {
        this.indexArray = new MoleculeIndexArray(this.maxMolecules);
        super.resetScrollBar();
    }

    @Override
    protected void refreshView() {
        if (!this.isLoading) {
            this.view.putClientProperty("MoleculeTableCellRenderer_CurrentRowNum", this.currentRowNum);
            this.view.putClientProperty("MoleculeTableCellRenderer_MoleculeCount", this.maxMolecules);
            for (int offset = 0; offset < this.rowNum * this.colNum; ++offset) {
                if (this.inputStream != null) {
                    try {
                        if (this.inputStream.markSupported()) {
                            this.inputStream.reset();
                            this.importer = new MolImporter(this.inputStream);
                        }
                    }
                    catch (Exception exception) {
                        AlchemistErrorDialog.showError(exception);
                    }
                }
                int moleculeIndex = this.currentRowNum * this.colNum + offset;
                int rowIndex = offset / this.colNum;
                int columnIndex = offset % this.colNum;
                if (moleculeIndex < this.maxMolecules) {
                    try {
                        if (this.importer != null) {
                            if (moleculeIndex < this.indexArray.getLength()) {
                                if (this.editedMolecules.containsKey(this.indexArray.get(moleculeIndex))) {
                                    this.dataModel.setValueAt(this.editedMolecules.get(this.indexArray.get(moleculeIndex)), rowIndex, columnIndex);
                                } else {
                                    this.importer.seekRecord(this.indexArray.get(moleculeIndex), null);
                                    MDocument document = this.importer.nextDoc();
                                    if (document != null) {
                                        this.dataModel.setValueAt(document.getPrimaryMolecule(), rowIndex, columnIndex);
                                    }
                                }
                            } else {
                                this.dataModel.setValueAt(this.localMolecules.get(moleculeIndex - this.indexArray.getLength()), rowIndex, columnIndex);
                            }
                        } else {
                            this.dataModel.setValueAt(this.localMolecules.get(moleculeIndex), rowIndex, columnIndex);
                        }
                        this.currentMoleculeIndexes.set(offset, moleculeIndex);
                    }
                    catch (IOException e) {
                        AlchemistErrorDialog.showError(e);
                        this.dataModel.setValueAt(null, rowIndex, columnIndex);
                        this.currentMoleculeIndexes.set(offset, null);
                    }
                    continue;
                }
                this.dataModel.setValueAt(null, rowIndex, columnIndex);
                this.currentMoleculeIndexes.set(offset, null);
            }
            if (this.rowNum == 1) {
                this.listSelectionListener.valueChanged(new ListSelectionEvent(this.view.getSelectionModel(), this.view.getSelectedColumn(), this.view.getSelectedColumn(), false));
            }
        }
    }

    @Override
    protected void refreshGridLayout() {
        this.isLoading = true;
        super.refreshGridLayout();
        this.isLoading = false;
        for (int i = this.currentMoleculeIndexes.size(); i < this.rowNum * this.colNum; ++i) {
            this.currentMoleculeIndexes.add(null);
        }
        this.refreshView();
    }

    public int getMoleculeCount() {
        return this.maxMolecules;
    }

    public void writeToFile(File file) {
        this.writeToFile(file, "smiles");
    }

    public void writeToFile(File file, String format2) {
        try {
            this.percent = 0;
            FileOutputStream outputStream = new FileOutputStream(file);
            this.writeToStream(outputStream, format2);
            ((OutputStream)outputStream).close();
        }
        catch (Exception exception) {
            AlchemistErrorDialog.showError(exception);
        }
    }

    public void writeToStream(OutputStream outputStream, String format2) throws MolFormatException, IOException, EOFException {
        MolExporter exporter = new MolExporter(outputStream, format2);
        for (int index = 0; index < this.maxMolecules; ++index) {
            if (index < this.indexArray.getLength()) {
                Integer key = index;
                Molecule molecule = null;
                if (this.editedMolecules.containsKey(key)) {
                    molecule = this.editedMolecules.get(key);
                } else {
                    this.importer.seekRecord(this.indexArray.get(index), null);
                    molecule = this.importer.nextDoc().getPrimaryMolecule();
                }
                exporter.write(molecule);
            } else {
                exporter.write(this.localMolecules.get(index - this.indexArray.getLength()));
            }
            this.percent = (int)((float)index / (float)this.maxMolecules * 100.0f);
        }
        exporter.close();
    }

    public MoleculeIterator getMoleculeIterator() {
        return new MoleculeIteratorImpl(this.changeCount, this.maxMolecules);
    }

    public synchronized void importMolecules(Molecule[] molecules) {
        ++this.changeCount;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            MolExporter exporter = new MolExporter(outputStream, "mrv");
            for (int i = 0; i < molecules.length; ++i) {
                exporter.write(molecules[i]);
            }
            exporter.close();
            outputStream.flush();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            outputStream.close();
            this.isLoading = true;
            this.importMolecules(inputStream);
            this.isLoading = false;
            this.indexArray = new MoleculeIndexArray(this.maxMolecules);
            this.refreshView();
        }
        catch (Exception exception) {
            AlchemistErrorDialog.showError("Some error has occured while try to import molecules.", exception);
            outputStream = null;
            this.clear();
        }
    }

    public Molecule[] getMolecules(int from, int to) {
        int lfrom = from;
        int lto = to;
        if (lto > this.maxMolecules) {
            lto = this.maxMolecules;
        }
        if (lfrom < 0) {
            lfrom = 0;
        }
        Molecule[] molecules = new Molecule[this.maxMolecules];
        try {
            if (this.inputStream != null && this.inputStream.markSupported()) {
                this.inputStream.reset();
                this.importer = new MolImporter(this.inputStream);
            }
            for (int index = lfrom; index < lto; ++index) {
                if (index < this.indexArray.getLength()) {
                    Integer key = index;
                    Molecule molecule = null;
                    if (this.editedMolecules.containsKey(key)) {
                        molecule = this.editedMolecules.get(key);
                    } else {
                        this.importer.seekRecord(this.indexArray.get(index), null);
                        MDocument document = this.importer.nextDoc();
                        molecule = document != null ? document.getPrimaryMolecule() : new Molecule();
                    }
                    molecules[index] = molecule.cloneMolecule();
                    continue;
                }
                molecules[index] = this.localMolecules.get(index - this.indexArray.getLength()).cloneMolecule();
            }
        }
        catch (Exception exception) {
            AlchemistErrorDialog.showError("Some error has occured while try to export molecules. Molecule array will be empty", exception);
            return new Molecule[0];
        }
        return molecules;
    }

    public Molecule[] getMolecules(int limit) {
        return this.getMolecules(0, this.maxMolecules);
    }

    public Molecule[] getMolecules() {
        return this.getMolecules(this.maxMolecules);
    }

    protected abstract void showEditor();

    protected abstract void hideEditor();

    public boolean hasModified() {
        return this.indexArray.hasRemoved() || !this.localMolecules.isEmpty() || !this.editedMolecules.isEmpty();
    }

    @Override
    public void clear() {
        ++this.changeCount;
        this.maxMolecules = 0;
        this.indexArray = new MoleculeIndexArray(0);
        this.editedMolecules.clear();
        this.localMolecules.clear();
        super.clear();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.ADD_MOLECULE_ACTION.setEnabled(enabled);
        this.EDIT_MOLECULE_ACTION.setEnabled(this.view.getSelectedColumn() != -1 && this.view.getSelectedRow() != -1 && enabled);
        this.REMOVE_MOLECULE_ACTION.setEnabled(this.view.getSelectedColumn() != -1 && this.view.getSelectedRow() != -1 && enabled);
    }

    public int getScrollPosition() {
        return this.scrollBar.getValue();
    }

    public void setScrollPosition(int position) {
        this.scrollBar.setValue(position);
    }

    public AbstractAction getADD_MOLECULE_ACTION() {
        return this.ADD_MOLECULE_ACTION;
    }

    public AbstractAction getEDIT_MOLECULE_ACTION() {
        return this.EDIT_MOLECULE_ACTION;
    }

    public AbstractAction getAPPLY_MOLECULE_EDIT_ACTION() {
        return this.APPLY_MOLECULE_EDIT_ACTION;
    }

    public AbstractAction getCANCEL_MOLECULE_EDIT_ACTION() {
        return this.CANCEL_MOLECULE_EDIT_ACTION;
    }

    public AbstractAction getREMOVE_MOLECULE_ACTION() {
        return this.REMOVE_MOLECULE_ACTION;
    }

    public boolean isMoleculeSelected() {
        return this.view.getSelectedRow() != -1;
    }

    public boolean isNonEmptyCellSelected() {
        if (this.view.getSelectedRow() != -1) {
            int cellIndex = this.view.getSelectedRow() * this.view.getColumnCount() + this.view.getSelectedColumn();
            return this.currentMoleculeIndexes.get(cellIndex) != null;
        }
        return false;
    }

    public void addMolecule() {
        this.showEditor();
        this.editedMoleculeIndex = -1;
    }

    public void editMolecule() {
        int moleculeIndex = this.currentRowNum * this.colNum + this.view.getSelectedRow() * this.colNum + this.view.getSelectedColumn();
        int cellIndex = this.view.getSelectedRow() * this.view.getColumnCount() + this.view.getSelectedColumn();
        if (this.view.getSelectedColumn() != -1 && this.view.getSelectedRow() != -1 && moleculeIndex < this.maxMolecules && this.currentMoleculeIndexes.get(cellIndex) != null) {
            Molecule molecule;
            Molecule molecule2 = molecule = moleculeIndex < this.indexArray.getLength() ? ((Molecule)this.dataModel.getValueAt(this.view.getSelectedRow(), this.view.getSelectedColumn())).cloneMolecule() : this.localMolecules.get(moleculeIndex - this.indexArray.getLength()).cloneMolecule();
            if (molecule.getDim() != 2) {
                molecule.clean(2, null);
            }
            this.sketch.setMol(molecule);
            this.showEditor();
            this.editedMoleculeIndex = moleculeIndex;
        }
    }

    public void removeMolecule() {
        if (JOptionPane.showConfirmDialog(this, "Do you want to remove selected structure?", "Remove structure", 0) != 0) {
            return;
        }
        ++this.changeCount;
        int moleculeIndex = this.currentRowNum * this.colNum + this.view.getSelectedRow() * this.colNum + this.view.getSelectedColumn();
        int cellIndex = this.view.getSelectedRow() * this.view.getColumnCount() + this.view.getSelectedColumn();
        Molecule oldValue = null;
        if (this.view.getSelectedColumn() != -1 && this.view.getSelectedRow() != -1 && moleculeIndex < this.maxMolecules && this.currentMoleculeIndexes.get(cellIndex) != null) {
            if (this.editedMolecules.containsKey(moleculeIndex)) {
                oldValue = this.editedMolecules.remove(moleculeIndex);
            }
            if (moleculeIndex < this.indexArray.getLength()) {
                this.indexArray.remove(moleculeIndex);
            } else {
                int localIndex = moleculeIndex - (this.maxMolecules - this.localMolecules.size());
                oldValue = this.localMolecules.remove(localIndex);
            }
            --this.maxMolecules;
            this.scrollBar.setValues(this.currentRowNum, this.rowNum, 0, this.maxMolecules % this.colNum == 0 ? this.maxMolecules / this.colNum : this.maxMolecules / this.colNum + 1);
            this.view.getSelectionModel().clearSelection();
        }
        this.refreshView();
        this.notifier.firePropertyChange(PROPERTY_KEY_REMOVED, oldValue, null);
    }

    public void applyChanges() {
        ++this.changeCount;
        if (this.editedMoleculeIndex == -1) {
            this.addMolecule(this.sketch.getMol());
        } else if (this.editedMoleculeIndex < this.indexArray.getLength()) {
            this.editedMolecules.put(this.editedMoleculeIndex, this.sketch.getMol().cloneMolecule());
            this.refreshView();
            this.notifier.firePropertyChange(PROPERTY_KEY_EDITED, null, this.editedMolecules.get(this.editedMoleculeIndex));
        } else {
            int localIndex = this.editedMoleculeIndex - (this.maxMolecules - this.localMolecules.size());
            Molecule oldValue = this.localMolecules.get(localIndex);
            this.localMolecules.set(localIndex, this.sketch.getMol().cloneMolecule());
            this.refreshView();
            this.notifier.firePropertyChange(PROPERTY_KEY_EDITED, oldValue, this.localMolecules.get(localIndex));
        }
        this.hideEditor();
        this.sketch.setMol(new Molecule());
    }

    public void addMolecule(Molecule molecule) {
        this.localMolecules.add(molecule);
        ++this.maxMolecules;
        if (this.maxMolecules < this.rowNum * this.colNum) {
            this.refreshView();
        } else {
            this.scrollBar.setValues(this.currentRowNum, this.rowNum, 0, this.maxMolecules % this.colNum == 0 ? this.maxMolecules / this.colNum : this.maxMolecules / this.colNum + 1);
            this.refreshView();
        }
        this.notifier.firePropertyChange(PROPERTY_KEY_ADDED, null, molecule);
    }

    public void cancelChanges() {
        this.hideEditor();
        this.sketch.setMol(new Molecule());
    }

    protected static class MoleculeIndexArray {
        private int[] array;
        private boolean hasRemoved = false;

        public MoleculeIndexArray(int size) {
            this.array = new int[size];
        }

        public void remove(int index) {
            if (!this.hasRemoved) {
                this.hasRemoved = true;
                for (int i = 0; i < this.array.length; ++i) {
                    this.array[i] = i;
                }
            }
            int[] newArray = new int[this.array.length - 1];
            System.arraycopy(this.array, 0, newArray, 0, index);
            System.arraycopy(this.array, index + 1, newArray, index, this.array.length - index - 1);
            this.array = newArray;
        }

        public int get(int index) {
            if (this.hasRemoved) {
                return this.array[index];
            }
            return index;
        }

        public int getLength() {
            return this.array.length;
        }

        public boolean hasRemoved() {
            return this.hasRemoved;
        }
    }

    public class MoleculeIteratorImpl
    implements MoleculeIterator,
    Cloneable,
    Iterator<Molecule> {
        private final long revision;
        private final int maxIndex;
        private int index = 0;
        private Throwable problem = null;

        public MoleculeIteratorImpl(long revision, int maxIndex) {
            this.revision = revision;
            this.maxIndex = maxIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Molecule next() {
            if (AbstractAlchemistMoleculeEditor.this.changeCount != this.revision) {
                throw new ConcurrentModificationException();
            }
            Molecule molecule = null;
            try {
                if (this.index < AbstractAlchemistMoleculeEditor.this.indexArray.getLength()) {
                    Integer key = this.index;
                    if (AbstractAlchemistMoleculeEditor.this.editedMolecules.containsKey(key)) {
                        molecule = (Molecule)AbstractAlchemistMoleculeEditor.this.editedMolecules.get(key);
                    } else {
                        AbstractAlchemistMoleculeEditor.this.importer.seekRecord(AbstractAlchemistMoleculeEditor.this.indexArray.get(this.index), null);
                        molecule = AbstractAlchemistMoleculeEditor.this.importer.nextDoc().getPrimaryMolecule();
                    }
                } else {
                    molecule = (Molecule)AbstractAlchemistMoleculeEditor.this.localMolecules.get(this.index - AbstractAlchemistMoleculeEditor.this.indexArray.getLength());
                }
            }
            catch (IOException ex) {
                this.problem = ex;
            }
            finally {
                ++this.index;
            }
            return molecule;
        }

        @Override
        public boolean hasNext() {
            return this.problem == null && this.index < this.maxIndex;
        }

        @Override
        public Throwable getThrowable() {
            return this.problem;
        }

        @Override
        public double estimateProgress() {
            return (float)this.index / (float)this.maxIndex;
        }

        public Object clone() throws CloneNotSupportedException {
            MoleculeIteratorImpl clone = (MoleculeIteratorImpl)super.clone();
            clone.index = this.index;
            clone.problem = this.problem;
            return clone;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported");
        }

        public long getRevision() {
            return this.revision;
        }
    }
}

