/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class AlchemistAtomPropertyEditor
extends JPanel {
    private static final long serialVersionUID = 300270478841700901L;
    private final List<String> propertyFilter;
    private final MolPainter painter;
    private boolean splitterRealized;
    private JSplitPane mainSplitPane;
    private JPanel moleculePanel;
    private JPanel editorPanel;
    private JScrollPane tableScroll;
    private JTable propertyTable;
    private MDocument document;
    private final Map<Point2D, MolAtom> atomCoords;
    private int areaRadius;
    private Color highlightColor;
    private Color selectedColor;
    private MolAtom selectedAtom;
    private MolAtom highlightedAtom;
    private boolean columnHidingEnabled;
    private final TableModelListener tableModelListener;

    public AlchemistAtomPropertyEditor() {
        this((String)null);
    }

    public AlchemistAtomPropertyEditor(String editableProperty) {
        String[] stringArray;
        if (editableProperty == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = editableProperty;
        }
        this(stringArray);
    }

    public AlchemistAtomPropertyEditor(String[] editableProperties) {
        this.splitterRealized = false;
        this.mainSplitPane = null;
        this.moleculePanel = null;
        this.editorPanel = null;
        this.tableScroll = null;
        this.propertyTable = null;
        this.document = new MDocument(new Molecule());
        this.atomCoords = new HashMap<Point2D, MolAtom>();
        this.highlightColor = new Color(220, 220, 255);
        this.selectedColor = new Color(180, 180, 255);
        this.selectedAtom = null;
        this.highlightedAtom = null;
        this.columnHidingEnabled = true;
        this.tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() != -1 && e.getColumn() != 0) {
                    Object obj = AlchemistAtomPropertyEditor.this.getPropertyTable().getValueAt(e.getFirstRow(), e.getColumn());
                    String prop = obj == null ? null : obj.toString();
                    AlchemistAtomPropertyEditor.this.getMolecule().getAtom(e.getFirstRow()).putProperty(AlchemistAtomPropertyEditor.this.getPropertyTable().getColumnName(e.getColumn()), prop);
                }
            }
        };
        this.propertyFilter = editableProperties == null ? null : new ArrayList<String>(Arrays.asList(editableProperties));
        this.painter = new MolPainter(new MolPainterCommon());
        this.painter.getCommon().setDispopts(AlchemistMoleculePainter.DEFAULT_DISPLAY_OPTIONS);
        this.areaRadius = 10;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainSplitPane(), "Center");
    }

    public void setMolecule(Molecule molecule) {
        if (molecule.getDim() == 0) {
            molecule.clean(2, null);
        }
        this.document = new MDocument(molecule);
        this.painter.setBoundsFor(this.document);
        this.updateTableModel();
        this.updateCoordinates();
    }

    public Molecule getMolecule() {
        return this.document.getPrimaryMolecule();
    }

    public void setDisplayOptions(int dispOpts) {
        this.painter.getCommon().setDispopts(dispOpts);
        this.getMoleculePanel().repaint();
    }

    public int getDisplayOptions() {
        return this.painter.getCommon().getDispopts();
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
        if (this.highlightedAtom != null) {
            this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{this.highlightedAtom}, new MolBond[0], this.highlightColor));
        }
        this.getMoleculePanel().repaint();
        this.getPropertyTable().repaint();
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setSelectionColor(Color color) {
        this.selectedColor = color;
        if (this.selectedAtom != null) {
            this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{this.selectedAtom}, new MolBond[0], this.selectedColor));
        }
        this.getMoleculePanel().repaint();
        this.getPropertyTable().setSelectionBackground(color);
    }

    public Color getSelectionColor() {
        return this.selectedColor;
    }

    public void setAtomProperty(int atomIndex, String propertyKey, String propertyValue) {
        this.document.getMainMoleculeGraph().getAtom(atomIndex).putProperty(propertyKey, propertyValue);
        int index = AlchemistAtomPropertyEditor.getColumnIndexByProperty(this.getPropertyTable(), propertyKey);
        if (index != -1) {
            this.getPropertyTable().setValueAt(propertyValue, atomIndex, index);
        }
    }

    public String getAtomProperty(int atomIndex, String propertyKey) {
        Object obj = this.document.getMainMoleculeGraph().getAtom(atomIndex).getProperty(propertyKey);
        return obj == null ? null : obj.toString();
    }

    public void removeProperty(String propertyName) {
        this.removeProperty(propertyName, false);
    }

    public void removeProperty(String propertyName, boolean removeFromMolecule) {
        if (this.propertyFilter != null) {
            this.propertyFilter.remove(propertyName);
        }
        if (removeFromMolecule) {
            MolAtom[] atoms = this.getMolecule().getAtomArray();
            for (int i = 0; i < atoms.length; ++i) {
                atoms[i].removeProperty(propertyName);
            }
        }
        this.updateTableModel();
    }

    public void addProperty(String propertyName) {
        if (this.propertyFilter != null) {
            if (!this.propertyFilter.contains(propertyName)) {
                this.propertyFilter.add(propertyName);
            }
        } else if (this.getMolecule().getAtomCount() > 0 && this.getMolecule().getAtom(0).getProperty(propertyName) == null) {
            this.getMolecule().getAtom(0).putProperty(propertyName, null);
        }
        this.updateTableModel();
    }

    public void setCellEditor(String propertyName, TableCellEditor editor) {
        int index;
        TableCellEditor currentEditor = this.getPropertyTable().getCellEditor();
        if (currentEditor != null && !currentEditor.stopCellEditing()) {
            currentEditor.cancelCellEditing();
        }
        if ((index = AlchemistAtomPropertyEditor.getColumnIndexByProperty(this.getPropertyTable(), propertyName)) != -1) {
            this.getPropertyTable().getColumnModel().getColumn(index).setCellEditor(editor);
        }
    }

    public void setCellRenderer(String propertyName, TableCellRenderer renderer) {
        int index = AlchemistAtomPropertyEditor.getColumnIndexByProperty(this.getPropertyTable(), propertyName);
        if (index != -1) {
            this.getPropertyTable().getColumnModel().getColumn(index).setCellRenderer(renderer);
        }
        this.getPropertyTable().repaint();
    }

    public TableCellEditor getCellEditor(String propertyName) {
        int index;
        if (this.getPropertyTable().getRowCount() > 0 && (index = AlchemistAtomPropertyEditor.getColumnIndexByProperty(this.getPropertyTable(), propertyName)) != -1) {
            return this.getPropertyTable().getCellEditor(0, index);
        }
        return null;
    }

    public TableCellRenderer getCellRenderer(String propertyName) {
        int index;
        if (this.getPropertyTable().getRowCount() > 0 && (index = AlchemistAtomPropertyEditor.getColumnIndexByProperty(this.getPropertyTable(), propertyName)) != -1) {
            return this.getPropertyTable().getCellRenderer(0, index);
        }
        return null;
    }

    public boolean isColumnHidingEnabled() {
        return this.columnHidingEnabled;
    }

    public void setColumnHidingEnabled(boolean enabled) {
        this.columnHidingEnabled = enabled;
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane(0);
            this.mainSplitPane.setTopComponent(this.getMoleculePanel());
            this.mainSplitPane.setBottomComponent(this.getEditorPanel());
            this.mainSplitPane.setResizeWeight(1.0);
            this.mainSplitPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!AlchemistAtomPropertyEditor.this.splitterRealized) {
                        AlchemistAtomPropertyEditor.this.splitterRealized = true;
                        AlchemistAtomPropertyEditor.this.mainSplitPane.setDividerLocation(0.75);
                    }
                }
            });
        }
        return this.mainSplitPane;
    }

    public JPanel getEditorPanel() {
        if (this.editorPanel == null) {
            this.editorPanel = new JPanel(new BorderLayout());
            this.editorPanel.add((Component)this.getTableScroll(), "Center");
        }
        return this.editorPanel;
    }

    private JScrollPane getTableScroll() {
        if (this.tableScroll == null) {
            this.tableScroll = new JScrollPane();
            this.tableScroll.setViewportView(this.getPropertyTable());
        }
        return this.tableScroll;
    }

    private JTable getPropertyTable() {
        if (this.propertyTable == null) {
            this.propertyTable = new JTable(){
                private static final long serialVersionUID = -486493120762043928L;

                @Override
                public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                    Component component = super.prepareRenderer(renderer, row, column);
                    if (row != this.getSelectedRow()) {
                        if (AlchemistAtomPropertyEditor.this.highlightedAtom != null && row == AlchemistAtomPropertyEditor.this.getMolecule().indexOf(AlchemistAtomPropertyEditor.this.highlightedAtom)) {
                            component.setBackground(AlchemistAtomPropertyEditor.this.highlightColor);
                        } else {
                            component.setBackground(this.getBackground());
                        }
                    }
                    return component;
                }
            };
            this.propertyTable.setSelectionMode(0);
            this.propertyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int satm;
                        int srow = AlchemistAtomPropertyEditor.this.propertyTable.getSelectedRow();
                        int n = satm = AlchemistAtomPropertyEditor.this.selectedAtom == null ? -1 : AlchemistAtomPropertyEditor.this.getMolecule().indexOf(AlchemistAtomPropertyEditor.this.selectedAtom);
                        if (srow != satm) {
                            AlchemistAtomPropertyEditor.this.document.clearCheckerMarks();
                            if (AlchemistAtomPropertyEditor.this.highlightedAtom != null) {
                                AlchemistAtomPropertyEditor.this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{AlchemistAtomPropertyEditor.this.highlightedAtom}, new MolBond[0], AlchemistAtomPropertyEditor.this.highlightColor));
                            }
                            if (srow == -1) {
                                AlchemistAtomPropertyEditor.this.selectedAtom = null;
                            } else {
                                AlchemistAtomPropertyEditor.this.selectedAtom = AlchemistAtomPropertyEditor.this.getMolecule().getAtom(srow);
                                AlchemistAtomPropertyEditor.this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{AlchemistAtomPropertyEditor.this.selectedAtom}, new MolBond[0], AlchemistAtomPropertyEditor.this.selectedColor));
                            }
                            AlchemistAtomPropertyEditor.this.getMoleculePanel().repaint();
                        }
                    }
                }
            });
            this.propertyTable.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int index = AlchemistAtomPropertyEditor.this.propertyTable.rowAtPoint(e.getPoint());
                    if (index != -1) {
                        AlchemistAtomPropertyEditor.this.highlightedAtom = AlchemistAtomPropertyEditor.this.getMolecule().getAtom(index);
                        AlchemistAtomPropertyEditor.this.document.clearCheckerMarks();
                        AlchemistAtomPropertyEditor.this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{AlchemistAtomPropertyEditor.this.highlightedAtom}, new MolBond[0], AlchemistAtomPropertyEditor.this.highlightColor));
                        if (AlchemistAtomPropertyEditor.this.selectedAtom != null) {
                            AlchemistAtomPropertyEditor.this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{AlchemistAtomPropertyEditor.this.selectedAtom}, new MolBond[0], AlchemistAtomPropertyEditor.this.selectedColor));
                        }
                    }
                    AlchemistAtomPropertyEditor.this.getPropertyTable().repaint();
                    AlchemistAtomPropertyEditor.this.getMoleculePanel().repaint();
                }
            });
            this.propertyTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3 && AlchemistAtomPropertyEditor.this.isColumnHidingEnabled()) {
                        JPopupMenu popup = new JPopupMenu("Property Filter");
                        for (int i = 0; i < AlchemistAtomPropertyEditor.this.propertyTable.getColumnCount(); ++i) {
                            final int index = i;
                            JCheckBox check = new JCheckBox(new AbstractAction(AlchemistAtomPropertyEditor.this.propertyTable.getColumnName(i)){
                                private static final long serialVersionUID = 5714467417611954405L;

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (((JCheckBox)e.getSource()).isSelected()) {
                                        AlchemistAtomPropertyEditor.this.propertyTable.getColumnModel().getColumn(index).setMaxWidth(Integer.MAX_VALUE);
                                        AlchemistAtomPropertyEditor.this.propertyTable.getColumnModel().getColumn(index).setWidth(AlchemistAtomPropertyEditor.this.propertyTable.getColumnModel().getColumn(index).getPreferredWidth());
                                    } else {
                                        AlchemistAtomPropertyEditor.this.propertyTable.getColumnModel().getColumn(index).setMinWidth(0);
                                        AlchemistAtomPropertyEditor.this.propertyTable.getColumnModel().getColumn(index).setMaxWidth(0);
                                        AlchemistAtomPropertyEditor.this.propertyTable.getColumnModel().getColumn(index).setWidth(0);
                                    }
                                    AlchemistAtomPropertyEditor.this.propertyTable.doLayout();
                                    AlchemistAtomPropertyEditor.this.updateColumnsWidth();
                                }
                            });
                            check.setSelected(AlchemistAtomPropertyEditor.this.propertyTable.getColumnModel().getColumn(i).getMaxWidth() > 0);
                            popup.add(check);
                        }
                        popup.show(AlchemistAtomPropertyEditor.this.propertyTable, e.getX(), e.getY());
                    }
                }
            });
            this.propertyTable.setAutoResizeMode(3);
            this.propertyTable.setSelectionBackground(this.selectedColor);
        }
        return this.propertyTable;
    }

    public JPanel getMoleculePanel() {
        if (this.moleculePanel == null) {
            this.moleculePanel = new JPanel(null){
                private static final long serialVersionUID = 4551882703042204062L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics2D g2 = (Graphics2D)g.create();
                    Rectangle rect = AlchemistAtomPropertyEditor.this.painter.getBounds();
                    rect.x = (AlchemistAtomPropertyEditor.this.moleculePanel.getWidth() - (rect.width - rect.x)) / 2;
                    rect.y = (AlchemistAtomPropertyEditor.this.moleculePanel.getHeight() - (rect.height - rect.y)) / 2;
                    g2.translate(rect.x, rect.y);
                    AlchemistAtomPropertyEditor.this.painter.paintDocument(g2, AlchemistAtomPropertyEditor.this.document, null);
                    g2.dispose();
                }
            };
            this.moleculePanel.setBackground(this.painter.getBackground());
            this.moleculePanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AlchemistAtomPropertyEditor.this.document.clearCheckerMarks();
                    AlchemistAtomPropertyEditor.this.selectedAtom = null;
                    Rectangle rect = AlchemistAtomPropertyEditor.this.painter.getBounds();
                    rect.x = (AlchemistAtomPropertyEditor.this.moleculePanel.getWidth() - (rect.width - rect.x)) / 2;
                    rect.y = (AlchemistAtomPropertyEditor.this.moleculePanel.getHeight() - (rect.height - rect.y)) / 2;
                    for (Point2D p : AlchemistAtomPropertyEditor.this.atomCoords.keySet()) {
                        if (!(p.getX() + (double)rect.x - (double)AlchemistAtomPropertyEditor.this.areaRadius < (double)e.getX()) || !(p.getX() + (double)rect.x + (double)AlchemistAtomPropertyEditor.this.areaRadius > (double)e.getX()) || !(p.getY() + (double)rect.y - (double)AlchemistAtomPropertyEditor.this.areaRadius < (double)e.getY()) || !(p.getY() + (double)rect.y + (double)AlchemistAtomPropertyEditor.this.areaRadius > (double)e.getY())) continue;
                        AlchemistAtomPropertyEditor.this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{(MolAtom)AlchemistAtomPropertyEditor.this.atomCoords.get(p)}, new MolBond[0], AlchemistAtomPropertyEditor.this.selectedColor));
                        AlchemistAtomPropertyEditor.this.selectedAtom = (MolAtom)AlchemistAtomPropertyEditor.this.atomCoords.get(p);
                    }
                    if (AlchemistAtomPropertyEditor.this.selectedAtom != null) {
                        int index = AlchemistAtomPropertyEditor.this.getMolecule().indexOf(AlchemistAtomPropertyEditor.this.selectedAtom);
                        if (AlchemistAtomPropertyEditor.this.getPropertyTable().getSelectedRow() != index) {
                            AlchemistAtomPropertyEditor.this.getPropertyTable().setRowSelectionInterval(index, index);
                        }
                    } else if (AlchemistAtomPropertyEditor.this.getPropertyTable().getSelectedRow() != -1) {
                        AlchemistAtomPropertyEditor.this.getPropertyTable().clearSelection();
                    }
                    AlchemistAtomPropertyEditor.this.moleculePanel.repaint();
                }
            });
            this.moleculePanel.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    AlchemistAtomPropertyEditor.this.document.clearCheckerMarks();
                    AlchemistAtomPropertyEditor.this.highlightedAtom = null;
                    Rectangle rect = AlchemistAtomPropertyEditor.this.painter.getBounds();
                    rect.x = (AlchemistAtomPropertyEditor.this.moleculePanel.getWidth() - (rect.width - rect.x)) / 2;
                    rect.y = (AlchemistAtomPropertyEditor.this.moleculePanel.getHeight() - (rect.height - rect.y)) / 2;
                    for (Point2D p : AlchemistAtomPropertyEditor.this.atomCoords.keySet()) {
                        if (!(p.getX() + (double)rect.x - (double)AlchemistAtomPropertyEditor.this.areaRadius < (double)e.getX()) || !(p.getX() + (double)rect.x + (double)AlchemistAtomPropertyEditor.this.areaRadius > (double)e.getX()) || !(p.getY() + (double)rect.y - (double)AlchemistAtomPropertyEditor.this.areaRadius < (double)e.getY()) || !(p.getY() + (double)rect.y + (double)AlchemistAtomPropertyEditor.this.areaRadius > (double)e.getY())) continue;
                        AlchemistAtomPropertyEditor.this.highlightedAtom = (MolAtom)AlchemistAtomPropertyEditor.this.atomCoords.get(p);
                        AlchemistAtomPropertyEditor.this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{AlchemistAtomPropertyEditor.this.highlightedAtom}, new MolBond[0], AlchemistAtomPropertyEditor.this.highlightColor));
                    }
                    if (AlchemistAtomPropertyEditor.this.selectedAtom != null) {
                        AlchemistAtomPropertyEditor.this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{AlchemistAtomPropertyEditor.this.selectedAtom}, new MolBond[0], AlchemistAtomPropertyEditor.this.selectedColor));
                    }
                    AlchemistAtomPropertyEditor.this.moleculePanel.repaint();
                    AlchemistAtomPropertyEditor.this.getPropertyTable().repaint();
                }
            });
            this.moleculePanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    AlchemistAtomPropertyEditor.this.updateCoordinates();
                }
            });
            this.moleculePanel.setMinimumSize(new Dimension(100, 100));
        }
        return this.moleculePanel;
    }

    private void updateCoordinates() {
        this.painter.setScale(this.painter.maxScale(this.getMoleculePanel().getSize()));
        this.painter.setScreen(this.getMoleculePanel().getSize());
        MolAtom[] atoms = this.document.getPrimaryMolecule().getAtomArray();
        this.atomCoords.clear();
        for (int i = 0; i < atoms.length; ++i) {
            DPoint3 point = new DPoint3(atoms[i].getLocation());
            this.painter.calcGP(point);
            this.atomCoords.put(new Point((int)point.x, (int)point.y), atoms[i]);
        }
        this.areaRadius = (int)(this.painter.getAtomSize() * (this.painter.getScale() / 1.54));
        this.getMoleculePanel().repaint();
    }

    private static Collection<String> getAllEditableProperties(Molecule molecule) {
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            set.addAll(molecule.getAtom(i).propertyKeySet());
        }
        return set;
    }

    private void updateTableModel() {
        this.getPropertyTable().getModel().removeTableModelListener(this.tableModelListener);
        Vector<String> header = new Vector<String>(this.propertyFilter == null ? AlchemistAtomPropertyEditor.getAllEditableProperties(this.getMolecule()) : this.propertyFilter);
        header.add(0, "Atom");
        DefaultTableModel model = new DefaultTableModel(header, this.getMolecule().getAtomCount()){
            private static final long serialVersionUID = -2887312204132891241L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0;
            }
        };
        model.addTableModelListener(this.tableModelListener);
        this.getPropertyTable().setModel(model);
        this.updateColumnsWidth();
    }

    private void updateColumnsWidth() {
        final TableModel model = this.getPropertyTable().getModel();
        final int[] maxAtomColumnWidth = new int[model.getColumnCount()];
        for (int i = 0; i < model.getColumnCount(); ++i) {
            maxAtomColumnWidth[i] = SwingUtilities.computeStringWidth(this.getPropertyTable().getFontMetrics(this.getPropertyTable().getFont()), " " + model.getColumnName(i) + " ");
            for (int j = 0; j < model.getRowCount(); ++j) {
                String value = i == 0 ? "No. " + (j + 1) + " " + this.getMolecule().getAtom(j).getSymbol() : (String)this.getMolecule().getAtom(j).getProperty(model.getColumnName(i));
                model.setValueAt(value, j, i);
                int w = SwingUtilities.computeStringWidth(this.getPropertyTable().getFontMetrics(this.getPropertyTable().getFont()), " " + value + " ");
                if (w <= maxAtomColumnWidth[i]) continue;
                maxAtomColumnWidth[i] = w;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int sumW = 0;
                for (int i = 0; i < maxAtomColumnWidth.length - 1; ++i) {
                    sumW += maxAtomColumnWidth[i];
                    AlchemistAtomPropertyEditor.this.getPropertyTable().getColumnModel().getColumn(i).setPreferredWidth(maxAtomColumnWidth[i]);
                }
                if (sumW < AlchemistAtomPropertyEditor.this.getPropertyTable().getWidth()) {
                    Insets insets = AlchemistAtomPropertyEditor.this.getTableScroll().getInsets();
                    AlchemistAtomPropertyEditor.this.getPropertyTable().getColumnModel().getColumn(model.getColumnCount() - 1).setPreferredWidth(AlchemistAtomPropertyEditor.this.getTableScroll().getWidth() - sumW - insets.left - insets.right);
                }
            }
        });
    }

    private static int getColumnIndexByProperty(JTable table, String propertyName) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).equals(propertyName)) continue;
            return i;
        }
        return -1;
    }
}

