/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class AlchemistComponentSet {
    private final Collection<Component> components = new HashSet<Component>();
    private boolean visible;
    private boolean enabled;

    public AlchemistComponentSet() {
        this.visible = true;
        this.enabled = true;
    }

    public AlchemistComponentSet(boolean enabled) {
        this.visible = true;
        this.enabled = enabled;
    }

    public AlchemistComponentSet(boolean enabled, boolean visible) {
        this.visible = visible;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Iterator<Component> it = this.components.iterator();
        while (it.hasNext()) {
            it.next().setEnabled(enabled);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        Iterator<Component> it = this.components.iterator();
        while (it.hasNext()) {
            it.next().setVisible(visible);
        }
    }

    public void addComponent(Component component) {
        component.setEnabled(this.enabled);
        component.setVisible(this.visible);
        this.components.add(component);
    }

    public boolean removeComponent(Component component) {
        return this.components.remove(component);
    }

    public Collection<Component> getComponents() {
        return Collections.unmodifiableCollection(this.components);
    }

    public int size() {
        return this.components.size();
    }
}

