/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class AlchemistErrorDialog {
    private static final long serialVersionUID = 5808183940665721300L;
    private JTextPane txtErrorDesc = null;
    private JPanel pnlTop = null;
    private JButton buttDetails = null;
    private Exception exception = null;
    private String errorMessage = null;
    private boolean removed = true;
    private JPanel pnlContainer = null;
    private JButton buttOk = null;
    private JPanel pnlButtons = null;
    private JPanel pnlIcon = null;
    private JPanel pnlMessage = null;
    private JScrollPane jScrollPane = null;
    private static Image errorIcon = null;
    private JTextPane txtError = null;
    private final JDialog errorDialog;

    public static void showError(String humanReadableErrorMessage) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog();
        AlchemistErrorDialog.showError(alchemistError, humanReadableErrorMessage, null);
    }

    public static void showError(Exception exception) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog();
        AlchemistErrorDialog.showError(alchemistError, null, exception);
    }

    public static void showError(String humanReadableErrorMessage, Exception exception) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog();
        AlchemistErrorDialog.showError(alchemistError, humanReadableErrorMessage, exception);
    }

    public static void showError(Frame parentFrame, String humanReadableErrorMessage) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog(parentFrame);
        AlchemistErrorDialog.showError(alchemistError, humanReadableErrorMessage, null);
    }

    public static void showError(Frame parentFrame, Exception exception) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog(parentFrame);
        AlchemistErrorDialog.showError(alchemistError, null, exception);
    }

    public static void showError(Frame parentFrame, String humanReadableErrorMessage, Exception exception) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog(parentFrame);
        AlchemistErrorDialog.showError(alchemistError, humanReadableErrorMessage, exception);
    }

    public static void showError(Dialog parentDialog, String humanReadableErrorMessage) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog(parentDialog);
        AlchemistErrorDialog.showError(alchemistError, humanReadableErrorMessage, null);
    }

    public static void showError(Dialog parentDialog, Exception exception) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog(parentDialog);
        AlchemistErrorDialog.showError(alchemistError, null, null);
    }

    public static void showError(Dialog parentDialog, String humanReadableErrorMessage, Exception exception) {
        AlchemistErrorDialog alchemistError = new AlchemistErrorDialog(parentDialog);
        AlchemistErrorDialog.showError(alchemistError, humanReadableErrorMessage, exception);
    }

    protected static void showError(AlchemistErrorDialog error, String message, Exception exception) {
        final AlchemistErrorDialog aError = error;
        final String msg = message;
        final Exception ex = exception;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                aError.errorMessage = msg;
                aError.exception = ex;
                aError.initializeAndShow();
            }
        });
    }

    protected AlchemistErrorDialog(Frame parentFrame) {
        this.errorDialog = new JDialog(parentFrame, true);
    }

    protected AlchemistErrorDialog(Dialog parentDialog) {
        this.errorDialog = new JDialog(parentDialog, true);
    }

    protected AlchemistErrorDialog() {
        this.errorDialog = new JDialog();
        this.errorDialog.setModal(true);
    }

    private void loadImages() {
        if (errorIcon == null) {
            MediaTracker mediaTracker = new MediaTracker(this.errorDialog);
            errorIcon = this.errorDialog.getToolkit().getImage(this.getClass().getResource("/chemaxon/alchemist/images/critical_error.gif"));
            mediaTracker.addImage(errorIcon, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void initializeAndShow() {
        this.loadImages();
        this.errorDialog.setSize(new Dimension(400, 130));
        this.errorDialog.setContentPane(this.getPnlContainer());
        this.errorDialog.setDefaultCloseOperation(2);
        this.errorDialog.setLocationRelativeTo(null);
        this.errorDialog.setTitle("Error");
        this.buttDetails.setVisible(this.exception != null);
        if (this.exception != null) {
            ByteArrayOutputStream messageStream = new ByteArrayOutputStream();
            PrintWriter messageWriter = new PrintWriter(messageStream);
            this.exception.printStackTrace(messageWriter);
            messageWriter.close();
            String message = messageStream.toString();
            this.txtErrorDesc.setText(message);
            if (this.errorMessage == null) {
                this.errorMessage = this.exception.getMessage();
            }
        }
        if (this.errorMessage != null) {
            this.txtError.setText(this.errorMessage);
        }
        this.errorDialog.setVisible(true);
    }

    private JTextPane getTxtErrorDesc() {
        if (this.txtErrorDesc == null) {
            this.txtErrorDesc = new JTextPane();
            this.txtErrorDesc.setEditable(false);
            this.txtErrorDesc.setOpaque(false);
            this.txtErrorDesc.setVisible(true);
        }
        return this.txtErrorDesc;
    }

    private JPanel getPnlTop() {
        if (this.pnlTop == null) {
            this.pnlTop = new JPanel();
            this.pnlTop.setLayout(new BorderLayout());
            this.pnlTop.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.pnlTop.add((Component)this.getTxtError(), "North");
        }
        return this.pnlTop;
    }

    private JButton getButtDetails() {
        if (this.buttDetails == null) {
            this.buttDetails = new JButton();
            this.buttDetails.setText("Details");
            this.buttDetails.setVisible(true);
            this.buttDetails.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!AlchemistErrorDialog.this.removed) {
                        AlchemistErrorDialog.this.pnlMessage.remove(AlchemistErrorDialog.this.jScrollPane);
                        AlchemistErrorDialog.this.pnlMessage.remove(AlchemistErrorDialog.this.pnlTop);
                        AlchemistErrorDialog.this.pnlMessage.add((Component)AlchemistErrorDialog.this.pnlTop, "Center");
                    } else {
                        AlchemistErrorDialog.this.pnlMessage.remove(AlchemistErrorDialog.this.pnlTop);
                        AlchemistErrorDialog.this.pnlMessage.add((Component)AlchemistErrorDialog.this.jScrollPane, "Center");
                        AlchemistErrorDialog.this.pnlMessage.add((Component)AlchemistErrorDialog.this.pnlTop, "North");
                    }
                    AlchemistErrorDialog.this.removed = !AlchemistErrorDialog.this.removed;
                    AlchemistErrorDialog.this.pnlContainer.updateUI();
                }
            });
        }
        return this.buttDetails;
    }

    private JPanel getPnlContainer() {
        if (this.pnlContainer == null) {
            this.pnlContainer = new JPanel();
            this.pnlContainer.setLayout(new BorderLayout());
            this.pnlContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlContainer.add((Component)this.getPnlButtons(), "East");
            this.pnlContainer.add((Component)this.getPnlIcon(), "West");
            this.pnlContainer.add((Component)this.getPnlMessage(), "Center");
        }
        return this.pnlContainer;
    }

    private JButton getButtOk() {
        if (this.buttOk == null) {
            this.buttOk = new JButton();
            this.buttOk.setText("Close");
            this.buttOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlchemistErrorDialog.this.errorDialog.dispose();
                }
            });
        }
        return this.buttOk;
    }

    private JPanel getPnlButtons() {
        if (this.pnlButtons == null) {
            this.pnlButtons = new JPanel();
            this.pnlButtons.setLayout(new BoxLayout(this.getPnlButtons(), 1));
            this.pnlButtons.add((Component)this.getButtOk(), null);
            this.pnlButtons.add((Component)this.getButtDetails(), null);
        }
        return this.pnlButtons;
    }

    private JPanel getPnlIcon() {
        if (this.pnlIcon == null) {
            this.pnlIcon = new JPanel(){
                private static final long serialVersionUID = -7272715283502135747L;

                @Override
                public void paintComponent(Graphics g) {
                    g.drawImage(errorIcon, 5, 5, null);
                    super.paintComponent(g);
                }
            };
            this.pnlIcon.setMaximumSize(new Dimension(42, Short.MAX_VALUE));
            this.pnlIcon.setPreferredSize(new Dimension(42, 10));
            this.pnlIcon.setMinimumSize(new Dimension(42, 10));
            this.pnlIcon.setOpaque(false);
        }
        return this.pnlIcon;
    }

    private JPanel getPnlMessage() {
        if (this.pnlMessage == null) {
            this.pnlMessage = new JPanel();
            this.pnlMessage.setLayout(new BorderLayout());
            this.pnlMessage.add((Component)this.getPnlTop(), "Center");
            this.jScrollPane = this.getJScrollPane();
        }
        return this.pnlMessage;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane(this.getTxtErrorDesc());
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createBevelBorder(1)));
        }
        return this.jScrollPane;
    }

    private JTextPane getTxtError() {
        if (this.txtError == null) {
            this.txtError = new JTextPane();
            this.txtError.setOpaque(false);
            this.txtError.setEditable(false);
            this.txtError.setFont(new Font("MS Sans Serif", 1, 11));
        }
        return this.txtError;
    }
}

