/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.filefilters.XMLFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class AlchemistFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -6086509067396340514L;

    private static JButton getNewFolderButton(Container c) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            JButton button;
            Icon icon;
            if (!(components[i] instanceof JButton ? (icon = (button = (JButton)components[i]).getIcon()) != null && icon == UIManager.getIcon("FileChooser.newFolderIcon") : components[i] instanceof Container && (button = AlchemistFileChooser.getNewFolderButton((Container)components[i])) != null)) continue;
            return button;
        }
        return null;
    }

    public AlchemistFileChooser() {
        this.initialize();
    }

    public AlchemistFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.initialize();
    }

    public AlchemistFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.initialize();
    }

    public AlchemistFileChooser(FileSystemView fsv) {
        super(fsv);
        this.initialize();
    }

    public AlchemistFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
        this.initialize();
    }

    public AlchemistFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.initialize();
    }

    private void initialize() {
        final JButton newFolderButton = AlchemistFileChooser.getNewFolderButton(this);
        if (newFolderButton != null) {
            this.addPropertyChangeListener("directoryChanged", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() instanceof File) {
                        newFolderButton.setEnabled(AlchemistFileChooser.this.testWriteAccess((File)evt.getNewValue()));
                    }
                }
            });
            newFolderButton.setEnabled(this.testWriteAccess(this.getCurrentDirectory()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testWriteAccess(File dir) {
        boolean result = dir.canWrite();
        if (!dir.canWrite()) {
            File f = null;
            try {
                f = File.createTempFile("tmp", ".tmp", dir);
                result = f.canWrite();
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (f != null) {
                        f.delete();
                    }
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        super.setFileFilter(filter);
        if (!(this.getUI() instanceof BasicFileChooserUI)) {
            return;
        }
        final BasicFileChooserUI fileChooserUI = (BasicFileChooserUI)this.getUI();
        final String fileName = fileChooserUI.getFileName().trim();
        if (fileName == null || fileName.length() == 0) {
            return;
        }
        EventQueue.invokeLater(new Thread(){

            @Override
            public void run() {
                String currentFileName = fileChooserUI.getFileName();
                if (currentFileName == null || currentFileName.length() == 0) {
                    fileChooserUI.setFileName(fileName);
                }
            }
        });
    }

    public boolean clearChoosableFileFilters() {
        boolean succ = true;
        FileFilter[] filters = this.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            succ = succ && this.removeChoosableFileFilter(filters[i]);
        }
        return succ;
    }

    public void addFileFilters(FileFilter[] filterArray) {
        for (int i = 0; i < filterArray.length; ++i) {
            this.addChoosableFileFilter(filterArray[i]);
        }
    }

    public boolean hasFileFilter(FileFilter filter) {
        FileFilter[] filters = this.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].equals(filter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (this.getDialogType() == 1 && super.getSelectedFile() != null) {
            String fileName = super.getSelectedFile().getAbsolutePath();
            FileFilter filter = this.getFileFilter();
            if (filter instanceof XMLFileFilter) {
                int dotIndex = file.getName().lastIndexOf(".");
                if (dotIndex == -1) {
                    file = new File(fileName + ".xml");
                } else {
                    String ext = file.getName().substring(dotIndex);
                    if (!ext.endsWith("xml")) {
                        file = new File(fileName + ".xml");
                    }
                }
            }
        }
        return file;
    }

    public void clear() {
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        this.firePropertyChange("SelectedFileChangedProperty", null, this.getSelectedFile());
        return super.showDialog(parent, approveButtonText);
    }
}

