/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistIconFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class AlchemistInnerDialog
extends JPanel
implements Accessible {
    private static final long serialVersionUID = -7275682665161277138L;
    public static final String PROPERTY_KEY_MAXIMIZED = "AlchemistInnerFrame_Maximized";
    public static final String PROPERTY_KEY_MINIMIZED = "AlchemistInnerFrame_Minimized";
    public static final String PROPERTY_KEY_DETACHED = "AlchemistInnerFrame_Detached";
    private static final Map<Component, List<AlchemistInnerDialog>> MINIMIZED_COMPONENTS = new WeakHashMap<Component, List<AlchemistInnerDialog>>();
    private static final int DEFAULT_RESIZABLE_ZONE_SIZE = 4;
    public static final Action DEFAULT_CLOSE_ACTION = new AbstractAction("Close"){
        private static final long serialVersionUID = 3196130043890561602L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistInnerDialog.handleFrameHideAction(this, e);
        }
    };
    private JPanel content = null;
    private JLabel frameCaptionLabel = null;
    private JPanel controlPanel = null;
    private JPanel northPanel = null;
    private JPanel southPanel = null;
    private JPanel northSeparator = null;
    private JComponent[] borders = null;
    private Container parent = null;
    private Point pressPoint = null;
    private Rectangle oldRect = null;
    private int resizableZoneSize = 4;
    private boolean resizable = true;
    private boolean movable = true;
    private Action closeAction = null;
    private boolean maximizable = false;
    private boolean detachable = false;
    private boolean minimizable = false;
    private final boolean detached = false;
    private boolean modal = false;
    private boolean closeOnDetach = true;
    private ControlComponent closeMark = null;
    private ControlComponent maximizeMark = null;
    private ControlComponent minimizeMark = null;
    private ControlComponent restoreMark = null;
    private ControlComponent detachMark = null;
    private ComponentState state = ComponentState.NORMAL;
    private Rectangle restoreRect = null;
    private boolean oldMovable = true;
    private boolean oldResizable = true;
    private String oldTitle = "";
    MouseListener focusMouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            AlchemistInnerDialog.this.parent.setComponentZOrder(AlchemistInnerDialog.this, 0);
            AlchemistInnerDialog.this.parent.repaint();
        }
    };
    MouseListener moveAndResizeStartStopListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            int resmode = e.getComponent().getCursor().getType();
            if (resmode != 0) {
                AlchemistInnerDialog.this.pressPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(AlchemistInnerDialog.this.pressPoint, e.getComponent());
                AlchemistInnerDialog.this.oldRect = AlchemistInnerDialog.this.getBounds();
            } else {
                AlchemistInnerDialog.this.pressPoint = null;
                AlchemistInnerDialog.this.oldRect = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AlchemistInnerDialog.this.pressPoint = null;
            AlchemistInnerDialog.this.oldRect = null;
        }
    };
    private final MouseMotionListener moveAndResizeMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            Component c = e.getComponent();
            int type = c.getCursor().getType();
            if (c == AlchemistInnerDialog.this.getBorders()[0]) {
                if (AlchemistInnerDialog.this.isResizable() && e.getX() <= AlchemistInnerDialog.this.resizableZoneSize) {
                    if (type != 6) {
                        c.setCursor(Cursor.getPredefinedCursor(6));
                    }
                } else if (AlchemistInnerDialog.this.isResizable() && e.getX() >= c.getWidth() - AlchemistInnerDialog.this.resizableZoneSize) {
                    if (type != 7) {
                        c.setCursor(Cursor.getPredefinedCursor(7));
                    }
                } else if (AlchemistInnerDialog.this.isResizable() && type != 8) {
                    c.setCursor(Cursor.getPredefinedCursor(8));
                } else if (!AlchemistInnerDialog.this.isResizable() && type != 0) {
                    c.setCursor(Cursor.getDefaultCursor());
                }
            } else if (c == AlchemistInnerDialog.this.getBorders()[1]) {
                if (AlchemistInnerDialog.this.isResizable() && type != 11) {
                    c.setCursor(Cursor.getPredefinedCursor(11));
                }
            } else if (c == AlchemistInnerDialog.this.getBorders()[2]) {
                if (AlchemistInnerDialog.this.isResizable() && e.getX() <= AlchemistInnerDialog.this.resizableZoneSize) {
                    if (type != 4) {
                        c.setCursor(Cursor.getPredefinedCursor(4));
                    }
                } else if (AlchemistInnerDialog.this.isResizable() && e.getX() >= c.getWidth() - AlchemistInnerDialog.this.resizableZoneSize) {
                    if (type != 5) {
                        c.setCursor(Cursor.getPredefinedCursor(5));
                    }
                } else if (AlchemistInnerDialog.this.isResizable() && type != 9) {
                    c.setCursor(Cursor.getPredefinedCursor(9));
                } else if (!AlchemistInnerDialog.this.isResizable() && type != 0) {
                    c.setCursor(Cursor.getDefaultCursor());
                }
            } else if (c == AlchemistInnerDialog.this.getBorders()[3]) {
                if (AlchemistInnerDialog.this.isResizable() && type != 10) {
                    c.setCursor(Cursor.getPredefinedCursor(10));
                }
            } else if (c == AlchemistInnerDialog.this.getFrameCaptionLabel()) {
                if (AlchemistInnerDialog.this.isMovable() && type != 13) {
                    c.setCursor(Cursor.getPredefinedCursor(13));
                } else if (!AlchemistInnerDialog.this.isMovable() && type != 0) {
                    c.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int resmode = e.getComponent().getCursor().getType();
            if (AlchemistInnerDialog.this.pressPoint != null && AlchemistInnerDialog.this.oldRect != null) {
                Dimension minimum = AlchemistInnerDialog.this.getMinimumSize();
                Dimension maximum = AlchemistInnerDialog.this.getMaximumSize();
                Rectangle rect = new Rectangle(AlchemistInnerDialog.this.oldRect);
                Point point = e.getPoint();
                SwingUtilities.convertPointToScreen(point, e.getComponent());
                switch (resmode) {
                    case 8: {
                        rect.y = (int)((double)rect.y + (point.getY() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y));
                        rect.height = (int)((double)rect.height + ((double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y - point.getY()));
                        break;
                    }
                    case 7: {
                        rect.y = (int)((double)rect.y + (point.getY() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y));
                        rect.height = (int)((double)rect.height + ((double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y - point.getY()));
                        rect.width = (int)((double)rect.width + (point.getX() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x));
                        break;
                    }
                    case 11: {
                        rect.width = (int)((double)rect.width + (point.getX() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x));
                        break;
                    }
                    case 5: {
                        rect.height = (int)((double)rect.height + (point.getY() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y));
                        rect.width = (int)((double)rect.width + (point.getX() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x));
                        break;
                    }
                    case 9: {
                        rect.height = (int)((double)rect.height + (point.getY() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y));
                        break;
                    }
                    case 4: {
                        rect.x = (int)((double)rect.x + (point.getX() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x));
                        rect.width = (int)((double)rect.width + ((double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x - point.getX()));
                        rect.height = (int)((double)rect.height + (point.getY() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y));
                        break;
                    }
                    case 10: {
                        rect.x = (int)((double)rect.x + (point.getX() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x));
                        rect.width = (int)((double)rect.width + ((double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x - point.getX()));
                        break;
                    }
                    case 6: {
                        rect.x = (int)((double)rect.x + (point.getX() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x));
                        rect.width = (int)((double)rect.width + ((double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x - point.getX()));
                        rect.y = (int)((double)rect.y + (point.getY() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y));
                        rect.height = (int)((double)rect.height + ((double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y - point.getY()));
                        break;
                    }
                    case 13: {
                        rect.x = (int)((double)rect.x + (point.getX() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.x));
                        rect.y = (int)((double)rect.y + (point.getY() - (double)((AlchemistInnerDialog)AlchemistInnerDialog.this).pressPoint.y));
                    }
                }
                if (maximum != null) {
                    rect.width = Math.min(rect.width, maximum.width);
                    rect.height = Math.min(rect.height, maximum.height);
                }
                if (minimum != null) {
                    rect.width = Math.max(rect.width, minimum.width);
                    rect.height = Math.max(rect.height, minimum.height);
                }
                int maxX = AlchemistInnerDialog.this.getParent() != null ? AlchemistInnerDialog.this.getParent().getWidth() - 3 * AlchemistInnerDialog.this.resizableZoneSize : rect.x;
                int maxY = AlchemistInnerDialog.this.getParent() != null ? AlchemistInnerDialog.this.getParent().getHeight() - 3 * AlchemistInnerDialog.this.resizableZoneSize : rect.y;
                rect.x = Math.max(-rect.width + 3 * AlchemistInnerDialog.this.resizableZoneSize, Math.min(maxX, rect.x));
                rect.y = Math.max(0, Math.min(maxY, rect.y));
                AlchemistInnerDialog.this.setBounds(rect);
                AlchemistInnerDialog.this.validate();
            }
        }
    };
    private final ComponentListener parentResizedListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            Rectangle rect = AlchemistInnerDialog.this.getBounds();
            if (AlchemistInnerDialog.this.isMaximized()) {
                rect.setBounds(0, 0, AlchemistInnerDialog.this.parent.getWidth(), AlchemistInnerDialog.this.parent.getHeight());
                AlchemistInnerDialog.this.setBounds(0, 0, AlchemistInnerDialog.this.parent.getWidth(), AlchemistInnerDialog.this.parent.getHeight());
            } else if (AlchemistInnerDialog.this.isMinimized()) {
                AlchemistInnerDialog.arrangeMinimizedFrames(AlchemistInnerDialog.this.parent);
            } else {
                int maxX = AlchemistInnerDialog.this.getParent() != null ? AlchemistInnerDialog.this.getParent().getWidth() - 3 * AlchemistInnerDialog.this.resizableZoneSize : rect.x;
                int maxY = AlchemistInnerDialog.this.getParent() != null ? AlchemistInnerDialog.this.getParent().getHeight() - 3 * AlchemistInnerDialog.this.resizableZoneSize : rect.y;
                rect.x = Math.max(-rect.width + 3 * AlchemistInnerDialog.this.resizableZoneSize, Math.min(maxX, rect.x));
                rect.y = Math.max(0, Math.min(maxY, rect.y));
                AlchemistInnerDialog.this.setBounds(rect);
            }
        }
    };

    public AlchemistInnerDialog() {
        this((String)null);
    }

    public AlchemistInnerDialog(String title) {
        this(title, new FlowLayout());
    }

    public AlchemistInnerDialog(String title, Action closeAction) {
        this(title, new Action[]{closeAction}, new FlowLayout());
    }

    public AlchemistInnerDialog(String title, LayoutManager layout) {
        this(title, null, layout);
    }

    public AlchemistInnerDialog(LayoutManager layout) {
        this(null, null, layout);
    }

    public AlchemistInnerDialog(String title, Action[] actions, LayoutManager layout) {
        super(new BorderLayout(), true);
        this.getContentPane().setLayout(layout);
        this.closeAction = actions == null ? DEFAULT_CLOSE_ACTION : null;
        this.getFrameCaptionLabel().setText(title == null ? "" : title);
        this.setTitlebarVisible(title != null);
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.getBorders()[1], "East");
        this.add((Component)this.getSouthPanel(actions), "South");
        this.add((Component)this.getBorders()[3], "West");
        this.add((Component)this.getContentPane(), "Center");
        this.setSize(this.getPreferredSize());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.LIGHT_GRAY), BorderFactory.createRaisedBevelBorder()));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AlchemistInnerDialog.this.doLayout();
                AlchemistInnerDialog.this.validate();
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getID() == 1400 && (e.getChangeFlags() & 1L) != 0L) {
                    if (AlchemistInnerDialog.this.parent != null) {
                        AlchemistInnerDialog.this.parent.removeComponentListener(AlchemistInnerDialog.this.parentResizedListener);
                    }
                    AlchemistInnerDialog.this.parent = AlchemistInnerDialog.this.getParent();
                    if (AlchemistInnerDialog.this.parent != null) {
                        AlchemistInnerDialog.this.parent.addComponentListener(AlchemistInnerDialog.this.parentResizedListener);
                    }
                }
            }
        });
        this.addMouseListener(this.focusMouseListener);
    }

    private JPanel getNorthSeparator() {
        if (this.northSeparator == null) {
            this.northSeparator = new JPanel(null, false);
            this.northSeparator.setPreferredSize(new Dimension(4, 4));
        }
        return this.northSeparator;
    }

    private JLabel getFrameCaptionLabel() {
        if (this.frameCaptionLabel == null) {
            this.frameCaptionLabel = new JLabel();
            this.frameCaptionLabel.addMouseMotionListener(this.moveAndResizeMotionListener);
            this.frameCaptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
            this.frameCaptionLabel.addMouseListener(this.moveAndResizeStartStopListener);
            this.frameCaptionLabel.addMouseListener(this.focusMouseListener);
            this.frameCaptionLabel.setOpaque(false);
        }
        return this.frameCaptionLabel;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.northPanel = new JPanel((LayoutManager)new FormLayout("fill:pref:grow, pref", "pref, pref, pref"), true);
            this.northPanel.add((Component)this.getBorders()[0], cc.xyw(1, 1, 2));
            this.northPanel.add((Component)this.getFrameCaptionLabel(), cc.xy(1, 2));
            this.northPanel.add((Component)this.getControlPanel(), cc.xy(2, 2));
            this.northPanel.add((Component)this.getNorthSeparator(), cc.xyw(1, 3, 2));
            if (UIManager.get("activeCaption") instanceof Color) {
                this.northPanel.setBackground((Color)UIManager.get("activeCaption"));
            }
        }
        return this.northPanel;
    }

    private JPanel getSouthPanel(Action[] actions) {
        if (this.southPanel == null) {
            this.southPanel = new JPanel();
            this.southPanel.setLayout(new BoxLayout(this.southPanel, 1));
            if (actions != null && actions.length > 0) {
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(Box.createHorizontalGlue());
                panel.add(new JButton(actions[0]));
                for (int i = 1; i < actions.length; ++i) {
                    panel.add(Box.createHorizontalStrut(5));
                    panel.add(new JButton(actions[i]));
                }
                panel.add(Box.createHorizontalGlue());
                this.southPanel.add(panel);
            }
            this.southPanel.add(this.getBorders()[2]);
        }
        return this.southPanel;
    }

    public void setActions(Action[] actions) {
        if (this.southPanel != null) {
            this.remove(this.southPanel);
            this.southPanel = null;
        }
        this.add((Component)this.getSouthPanel(actions), "South");
    }

    private JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 5));
            this.controlPanel.setOpaque(false);
            this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
            this.controlPanel.add(Box.createHorizontalStrut(5));
            this.controlPanel.add(this.getDetachMark());
            this.controlPanel.add(this.getMinimizeMark());
            this.controlPanel.add(this.getRestoreMark());
            this.controlPanel.add(this.getMaximizeMark());
            this.controlPanel.add(this.getCloseMark());
        }
        return this.controlPanel;
    }

    private ControlComponent getCloseMark() {
        if (this.closeMark == null) {
            this.closeMark = new ControlComponent("/chemaxon/alchemist/images/frame_close.gif", "/chemaxon/alchemist/images/frame_close_w.gif", this.closeAction);
            this.closeMark.setVisible(this.closeAction != null);
        }
        return this.closeMark;
    }

    private ControlComponent getMaximizeMark() {
        if (this.maximizeMark == null) {
            this.maximizeMark = new ControlComponent("/chemaxon/alchemist/images/frame_maximize.gif", "/chemaxon/alchemist/images/frame_maximize_w.gif", new AbstractAction(){
                private static final long serialVersionUID = 6453572534317707782L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlchemistInnerDialog.this.setMaximized();
                }
            });
            this.maximizeMark.setVisible(this.isMaximizable() && !this.isMaximized());
        }
        return this.maximizeMark;
    }

    private ControlComponent getRestoreMark() {
        if (this.restoreMark == null) {
            this.restoreMark = new ControlComponent("/chemaxon/alchemist/images/frame_restore.gif", "/chemaxon/alchemist/images/frame_restore_w.gif", new AbstractAction(){
                private static final long serialVersionUID = 6442646598072864130L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlchemistInnerDialog.this.setNormal();
                }
            });
            this.restoreMark.setVisible(this.isMaximized() || this.isMinimized());
        }
        return this.restoreMark;
    }

    private ControlComponent getDetachMark() {
        if (this.detachMark == null) {
            this.detachMark = new ControlComponent("/chemaxon/alchemist/images/frame_unpin.gif", "/chemaxon/alchemist/images/frame_unpin_w.gif", new AbstractAction(){
                private static final long serialVersionUID = -5467721635114065568L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlchemistInnerDialog.this.setDetached(true);
                }
            });
            this.detachMark.setVisible(this.isDetachable());
        }
        return this.detachMark;
    }

    private ControlComponent getMinimizeMark() {
        if (this.minimizeMark == null) {
            this.minimizeMark = new ControlComponent("/chemaxon/alchemist/images/frame_minimize.gif", "/chemaxon/alchemist/images/frame_minimize_w.gif", new AbstractAction(){
                private static final long serialVersionUID = -5467721635114065568L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlchemistInnerDialog.this.setMinimized();
                }
            });
            this.minimizeMark.setVisible(this.isMinimizable() && !this.isMinimized());
        }
        return this.minimizeMark;
    }

    private JComponent[] getBorders() {
        if (this.borders == null) {
            this.borders = new JPanel[4];
            for (int i = 0; i < this.borders.length; ++i) {
                this.borders[i] = new JPanel(null, false);
                this.borders[i].setPreferredSize(new Dimension(this.resizableZoneSize, this.resizableZoneSize));
                this.borders[i].addMouseListener(this.moveAndResizeStartStopListener);
                this.borders[i].addMouseMotionListener(this.moveAndResizeMotionListener);
            }
        }
        return this.borders;
    }

    private static void arrangeMinimizedFrames(Container parent) {
        List<AlchemistInnerDialog> list = MINIMIZED_COMPONENTS.get(parent);
        if (list != null && !list.isEmpty()) {
            Point p = new Point(5, parent.getHeight() - 10);
            int preWidth = 0;
            for (int i = 0; i < list.size(); ++i) {
                AlchemistInnerDialog frame = list.get(i);
                p.x += preWidth + 5;
                if (p.x + 10 + frame.getWidth() > parent.getWidth() && p.x > 10) {
                    p.x = 10;
                    p.y -= 5 + frame.getHeight();
                }
                frame.setLocation(p.x, p.y - frame.getHeight());
                preWidth = frame.getWidth();
            }
        }
    }

    public int getResizableZoneSize() {
        return this.resizableZoneSize;
    }

    public void setResizableZoneSize(int size) {
        this.resizableZoneSize = size;
        for (int i = 0; i < this.getBorders().length; ++i) {
            this.getBorders()[i].setPreferredSize(new Dimension(this.resizableZoneSize, this.resizableZoneSize));
        }
        this.getFrameCaptionLabel().setBorder(BorderFactory.createEmptyBorder(0, size, size, 0));
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        if (!resizable) {
            for (int i = 0; i < this.getBorders().length; ++i) {
                this.getBorders()[i].setCursor(Cursor.getDefaultCursor());
                this.pressPoint = null;
                this.oldRect = null;
            }
        }
    }

    public Container getContentPane() {
        if (this.content == null) {
            this.content = new JPanel();
        }
        return this.content;
    }

    public void setIcon(Icon icon) {
        this.getFrameCaptionLabel().setIcon(icon);
    }

    public Icon getIcon() {
        return this.getFrameCaptionLabel().getIcon();
    }

    public void setText(String text) {
        if (this.isMinimized()) {
            this.oldTitle = text;
            if (this.oldTitle.length() > 10) {
                this.getFrameCaptionLabel().setText(text.substring(0, 7) + "...");
            } else {
                this.getFrameCaptionLabel().setText(text);
            }
        } else {
            this.getFrameCaptionLabel().setText(text);
        }
    }

    public String getText() {
        return this.getFrameCaptionLabel().getText();
    }

    public void setTitlebarVisible(boolean visible) {
        this.getFrameCaptionLabel().setVisible(visible);
        this.getControlPanel().setVisible(visible);
        this.getBorders()[0].setOpaque(!visible);
        this.getNorthSeparator().setVisible(visible);
    }

    public boolean isTitlebarVisible() {
        return this.getFrameCaptionLabel().isVisible();
    }

    public void setTitlebarForeground(Color color) {
        this.getFrameCaptionLabel().setForeground(color);
    }

    public Color getTitlebarForeground() {
        return this.getFrameCaptionLabel().getForeground();
    }

    public void setTitlebarBackground(Color color) {
        this.getNorthPanel().setBackground(color);
    }

    public Color getTitlebarBackground() {
        return this.getNorthPanel().getBackground();
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
        if (!this.isResizable()) {
            this.getFrameCaptionLabel().setCursor(Cursor.getDefaultCursor());
            for (int i = 0; i < this.getBorders().length; ++i) {
                this.getBorders()[i].setCursor(Cursor.getDefaultCursor());
                this.pressPoint = null;
                this.oldRect = null;
            }
        }
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setCloseAction(Action closeAction) {
        this.closeAction = closeAction;
        this.getCloseMark().action = closeAction;
        this.getCloseMark().setVisible(closeAction != null);
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public void setMaximizable(boolean maximizable) {
        this.maximizable = maximizable;
        this.getRestoreMark().setVisible(maximizable && this.isMaximized());
        this.getMaximizeMark().setVisible(maximizable && !this.isMaximized());
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public void setMinimizable(boolean minimizable) {
        this.minimizable = minimizable;
        this.getRestoreMark().setVisible(minimizable && this.isMinimized());
        this.getMinimizeMark().setVisible(minimizable && !this.isMinimized());
    }

    public boolean isMinimizable() {
        return this.minimizable;
    }

    public void setMaximized() {
        if (this.isMaximizable() && !this.isMaximized() && !this.isDetached()) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            if (this.state == ComponentState.NORMAL) {
                this.restoreRect = this.getBounds();
                this.oldMovable = this.isMovable();
                this.oldResizable = this.isResizable();
            } else {
                this.getFrameCaptionLabel().setText(this.oldTitle);
            }
            this.setMovable(false);
            this.setResizable(false);
            ComponentState oldState = this.state;
            this.state = ComponentState.MAXIMIZED;
            this.getRestoreMark().setVisible(true);
            this.getMaximizeMark().setVisible(false);
            this.getMinimizeMark().setVisible(this.isMinimizable());
            if (this.parent != null) {
                this.setBounds(0, 0, this.parent.getWidth(), this.parent.getHeight());
            }
            if (oldState == ComponentState.MINIMIZED) {
                if (this.parent != null) {
                    List<AlchemistInnerDialog> list = MINIMIZED_COMPONENTS.get(this.parent);
                    if (list != null) {
                        list.remove(this);
                    }
                    AlchemistInnerDialog.arrangeMinimizedFrames(this.parent);
                }
                this.firePropertyChange(PROPERTY_KEY_MINIMIZED, true, false);
            }
            this.firePropertyChange(PROPERTY_KEY_MAXIMIZED, false, true);
        }
    }

    public boolean isMaximized() {
        return this.state == ComponentState.MAXIMIZED;
    }

    public void setMinimized() {
        if (this.isMinimizable() && !this.isMinimized() && !this.isDetached()) {
            if (this.state == ComponentState.NORMAL) {
                this.restoreRect = this.getBounds();
                this.oldMovable = this.isMovable();
                this.oldResizable = this.isResizable();
            }
            this.oldTitle = this.getText();
            if (this.oldTitle.length() > 10) {
                this.getFrameCaptionLabel().setText(this.oldTitle.substring(0, 7) + "...");
            }
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.LIGHT_GRAY), BorderFactory.createRaisedBevelBorder()));
            this.setMovable(false);
            this.setResizable(false);
            ComponentState oldState = this.state;
            this.state = ComponentState.MINIMIZED;
            this.getRestoreMark().setVisible(true);
            this.getMinimizeMark().setVisible(false);
            this.getMaximizeMark().setVisible(this.isMaximizable());
            this.getContentPane().setVisible(false);
            Insets insets = this.getInsets();
            this.getNorthSeparator().setVisible(false);
            this.setSize((int)this.getFrameCaptionLabel().getPreferredSize().getWidth() + this.getControlPanel().getWidth() + insets.left + insets.right, this.getFrameCaptionLabel().getHeight() + this.getResizableZoneSize() + insets.top + insets.bottom);
            if (this.parent != null) {
                List<AlchemistInnerDialog> list = MINIMIZED_COMPONENTS.get(this.parent);
                if (list == null) {
                    list = new ArrayList<AlchemistInnerDialog>();
                }
                list.add(this);
                MINIMIZED_COMPONENTS.put(this.parent, list);
                AlchemistInnerDialog.arrangeMinimizedFrames(this.parent);
            }
            if (oldState == ComponentState.MAXIMIZED) {
                this.firePropertyChange(PROPERTY_KEY_MAXIMIZED, true, false);
            }
            this.firePropertyChange(PROPERTY_KEY_MINIMIZED, false, true);
        }
    }

    public boolean isMinimized() {
        return this.state == ComponentState.MINIMIZED;
    }

    public void setNormal() {
        if (this.state != ComponentState.NORMAL && !this.isDetached()) {
            this.setMovable(this.oldMovable);
            this.setResizable(this.oldResizable);
            ComponentState oldState = this.state;
            this.state = ComponentState.NORMAL;
            this.getRestoreMark().setVisible(false);
            this.getMaximizeMark().setVisible(this.isMaximizable());
            this.getMinimizeMark().setVisible(this.isMinimizable());
            this.getContentPane().setVisible(true);
            this.getNorthSeparator().setVisible(this.isTitlebarVisible());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.LIGHT_GRAY), BorderFactory.createRaisedBevelBorder()));
            Rectangle rect = this.restoreRect == null ? new Rectangle(this.getPreferredSize()) : this.restoreRect;
            int maxX = this.getParent() != null ? this.getParent().getWidth() - 3 * this.resizableZoneSize : rect.x;
            int maxY = this.getParent() != null ? this.getParent().getHeight() - 3 * this.resizableZoneSize : rect.y;
            rect.x = Math.max(-rect.width + 3 * this.resizableZoneSize, Math.min(maxX, rect.x));
            rect.y = Math.max(0, Math.min(maxY, rect.y));
            this.setBounds(rect);
            if (oldState == ComponentState.MAXIMIZED) {
                this.firePropertyChange(PROPERTY_KEY_MAXIMIZED, true, false);
            } else if (oldState == ComponentState.MINIMIZED) {
                this.getFrameCaptionLabel().setText(this.oldTitle);
                if (this.parent != null) {
                    List<AlchemistInnerDialog> list = MINIMIZED_COMPONENTS.get(this.parent);
                    if (list != null) {
                        list.remove(this);
                    }
                    AlchemistInnerDialog.arrangeMinimizedFrames(this.parent);
                }
                this.firePropertyChange(PROPERTY_KEY_MINIMIZED, true, false);
            }
        }
    }

    public boolean isNormal() {
        return this.state == ComponentState.NORMAL;
    }

    public void setDetachable(boolean detachable) {
        this.detachable = detachable;
        this.getDetachMark().setVisible(detachable);
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public void setDetached(boolean detached) {
        if (this.isDetachable() && this.isDetached() != detached) {
            if (!this.isDetached()) {
                Point p = new Point(this.getX(), this.getY());
                this.setVisible(false);
                Window root = SwingUtilities.getWindowAncestor(this);
                final JDialog dialog = root instanceof JFrame ? new JDialog((JFrame)root) : (root instanceof JDialog ? new JDialog((JDialog)root) : new JDialog());
                dialog.setContentPane(this.getContentPane());
                dialog.setTitle(this.getText());
                dialog.setResizable(this.isResizable());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        AlchemistInnerDialog.this.add((Component)dialog.getContentPane(), "Center");
                        AlchemistInnerDialog.this.setVisible(true);
                        AlchemistInnerDialog.this.firePropertyChange(AlchemistInnerDialog.PROPERTY_KEY_DETACHED, true, false);
                        if (AlchemistInnerDialog.this.isCloseOnDetach() && AlchemistInnerDialog.this.closeAction != null) {
                            AlchemistInnerDialog.this.closeAction.actionPerformed(new ActionEvent(AlchemistInnerDialog.this, 0, null));
                        }
                    }
                });
                SwingUtilities.convertPointToScreen(p, this.parent);
                dialog.setLocation(p);
                dialog.setSize(this.getSize());
                dialog.setModal(this.isModal());
                this.firePropertyChange(PROPERTY_KEY_DETACHED, false, true);
                dialog.setVisible(true);
            } else {
                Window root = SwingUtilities.getWindowAncestor(this);
                if (root instanceof JDialog) {
                    JDialog dialog = (JDialog)root;
                    dialog.dispose();
                }
            }
        }
    }

    public boolean isDetached() {
        return false;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setCloseOnDetach(boolean close) {
        this.closeOnDetach = close;
    }

    public boolean isCloseOnDetach() {
        return this.closeOnDetach;
    }

    public void dispose() {
        if (this.isDetached()) {
            this.setDetached(false);
        }
        this.parent.remove(this);
    }

    public void pack() {
        if (this.isNormal()) {
            Dimension minimum = this.getMinimumSize();
            Dimension maximum = this.getMaximumSize();
            Rectangle rect = new Rectangle();
            rect.x = this.getX();
            rect.y = this.getY();
            rect.width = this.getPreferredSize().width;
            rect.height = this.getPreferredSize().height;
            if (maximum != null) {
                rect.width = Math.min(rect.width, maximum.width);
                rect.height = Math.min(rect.height, maximum.height);
            }
            if (minimum != null) {
                rect.width = Math.max(rect.width, minimum.width);
                rect.height = Math.max(rect.height, minimum.height);
            }
            int maxX = this.getParent() != null ? this.getParent().getWidth() - 3 * this.resizableZoneSize : rect.x;
            int maxY = this.getParent() != null ? this.getParent().getHeight() - 3 * this.resizableZoneSize : rect.y;
            rect.x = Math.max(-rect.width + 3 * this.resizableZoneSize, Math.min(maxX, rect.x));
            rect.y = Math.max(0, Math.min(maxY, rect.y));
            this.setBounds(rect);
        }
    }

    public static AlchemistInnerDialog createMessageBox(String title, String message) {
        return AlchemistInnerDialog.createCustomBox(title, message, new Action[]{DEFAULT_CLOSE_ACTION});
    }

    public static AlchemistInnerDialog createMessageBox(String title, Component message) {
        return AlchemistInnerDialog.createCustomBox(title, message, new Action[]{DEFAULT_CLOSE_ACTION});
    }

    public static AlchemistInnerDialog createCustomBox(String title, String message, Action[] actions) {
        JTextArea text = new JTextArea(message);
        text.setBorder(null);
        text.setEditable(false);
        text.setOpaque(false);
        return AlchemistInnerDialog.createCustomBox(title, text, actions);
    }

    public static AlchemistInnerDialog createCustomBox(String title, Component message, Action[] actions) {
        AlchemistInnerDialog frame = new AlchemistInnerDialog(title, actions, new BorderLayout());
        frame.setCloseAction(DEFAULT_CLOSE_ACTION);
        frame.getContentPane().add(message, "Center");
        return frame;
    }

    private static void handleFrameHideAction(Action action, ActionEvent e) {
        if (e.getSource() instanceof Component) {
            for (Component c = (Component)e.getSource(); c != null; c = c.getParent()) {
                if (!(c instanceof AlchemistInnerDialog)) continue;
                AlchemistInnerDialog frame = (AlchemistInnerDialog)c;
                if (frame.isDetached()) {
                    frame.setDetached(false);
                }
                frame.setVisible(false);
                return;
            }
        }
    }

    public static void setCentered(AlchemistInnerDialog dialog) {
        if (!dialog.isDetached()) {
            dialog.setLocation((dialog.getParent().getWidth() - dialog.getWidth()) / 2, (dialog.getParent().getHeight() - dialog.getHeight()) / 2);
        }
    }

    private static enum ComponentState {
        MINIMIZED,
        NORMAL,
        MAXIMIZED;

    }

    private class ControlComponent
    extends JComponent {
        private static final long serialVersionUID = 8045932701971381862L;
        private final Image normalImage;
        private final Image hoverImage;
        private Action action;
        private boolean hovered = false;

        private ControlComponent(String normal, String hover, Action action) {
            this.normalImage = AlchemistIconFactory.getImage(normal);
            this.hoverImage = AlchemistIconFactory.getImage(hover);
            this.action = action;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ControlComponent.this.hovered = true;
                    ControlComponent.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ControlComponent.this.hovered = false;
                    ControlComponent.this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ControlComponent.this.action != null && ControlComponent.this.action.isEnabled()) {
                        ControlComponent.this.action.actionPerformed(new ActionEvent(AlchemistInnerDialog.this, 0, null));
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.action != null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.drawImage(this.hovered && this.action.isEnabled() ? this.hoverImage : this.normalImage, 0, 0, null);
                g2.dispose();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(18, 16);
        }
    }
}

