/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class AlchemistLabel
extends JLabel {
    private static final long serialVersionUID = -3985998359923330546L;
    public static final int DEFAULT_STYLE = 0;
    public static final int INFORMATION_STYLE = 1;
    public static final int QUESTION_STYLE = 2;
    public static final int WARNING_STYLE = 3;
    public static final int ERROR_STYLE = 4;
    public static final int CUSTOM_STYLE = 5;
    private static final String INFORMATION_ICON_PATH = "/chemaxon/alchemist/images/info16.gif";
    private static final String QUESTION_ICON_PATH = "/chemaxon/alchemist/images/question16.gif";
    private static final String WARNING_ICON_PATH = "/chemaxon/alchemist/images/warning16.gif";
    private static final String ERROR_ICON_PATH = "/chemaxon/alchemist/images/error16.gif";
    private int style = 0;
    private boolean decorated = true;
    private String customPath = "";

    public AlchemistLabel() {
        this("");
    }

    public AlchemistLabel(String text) {
        this(text, 0);
    }

    public AlchemistLabel(String text, String customIconPath) {
        this("text", 5);
    }

    public AlchemistLabel(int style) {
        this("", style);
    }

    public AlchemistLabel(String text, int style) {
        this(text, style, 10);
    }

    public AlchemistLabel(String text, int style, int horizontalAlignment) {
        this(text, style, horizontalAlignment, "");
    }

    public AlchemistLabel(String text, int style, int horizontalAlignment, String customIconPath) {
        super(text, horizontalAlignment);
        this.style = style;
        this.customPath = customIconPath;
        this.initialize();
    }

    private void initialize() {
        this.setBackground(Color.WHITE);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.refreshIcon();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.decorated) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getBackground());
            g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 15, 15);
            g2.setColor(Color.GRAY);
            g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 15, 15);
            g2.dispose();
        }
        super.paintComponent(g);
    }

    public boolean isDecorated() {
        return this.decorated;
    }

    public void setDecorated(boolean decorated) {
        this.decorated = decorated;
        this.repaint();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
        this.refreshIcon();
    }

    private void refreshIcon() {
        switch (this.style) {
            case 2: {
                this.setForeground(Color.GREEN);
                this.setIcon(new ImageIcon(this.getClass().getResource(QUESTION_ICON_PATH)));
                break;
            }
            case 3: {
                this.setForeground(Color.ORANGE);
                this.setIcon(new ImageIcon(this.getClass().getResource(WARNING_ICON_PATH)));
                break;
            }
            case 1: {
                this.setForeground(Color.BLUE);
                this.setIcon(new ImageIcon(this.getClass().getResource(INFORMATION_ICON_PATH)));
                break;
            }
            case 4: {
                this.setForeground(Color.RED);
                this.setIcon(new ImageIcon(this.getClass().getResource(ERROR_ICON_PATH)));
                break;
            }
            case 5: {
                URL url = this.customPath != null ? this.getClass().getResource(this.customPath) : null;
                this.setIcon(url != null ? new ImageIcon(url) : null);
                break;
            }
            default: {
                this.setForeground(Color.BLACK);
                this.setIcon(null);
            }
        }
    }
}

