/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AbstractAlchemistMoleculeEditor;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.common.UserSettings;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.SwingPropertyChangeSupport;

public class AlchemistMoleculeEditor
extends AbstractAlchemistMoleculeEditor {
    private JPanel sketchPanel = null;
    private JPanel buttonHolderPanel = null;
    private JButton applyEditButton = null;
    private JButton cancelEditButton = null;
    private JButton addMoleculeButton = null;
    private JButton editMoleculeButton = null;
    private JButton removeMoleculeButton = null;
    private final UserSettings sketchUserSettings = new UserSettings("AlchemistMoleculeEditor_Marvin.properties");
    private JPanel northPanel = null;
    private JToolBar toolBar = null;
    public static final String PROPERTY_KEY_EXAMPLE_EDITED = "ReactionExampleEditor_ExampleEdited";
    public static final String PROPERTY_KEY_EXAMPLE_ADDED = "ReactionExampleEditor_ExampleAdded";
    private static final long serialVersionUID = 3614400467166560723L;

    public AlchemistMoleculeEditor(int defaultRowNum, int defaultColNum, boolean isToolbarVisible, SwingPropertyChangeSupport notifier) {
        this(defaultRowNum, defaultColNum, 15, 15, isToolbarVisible, notifier);
    }

    public AlchemistMoleculeEditor(int defaultRowNum, int defaultColNum, int maxRowNum, int maxColNum, boolean isToolbarVisible, SwingPropertyChangeSupport notifier) {
        super(defaultRowNum, defaultColNum, maxRowNum, maxColNum, notifier, new MSketchPane());
        this.sketchUserSettings.setCheckerConfigFileName("AlchemistMoleculeEditor_MarvinSketch_checkerconfig.xml");
        this.sketch.setUserSettings(this.sketchUserSettings);
        this.isToolbarVisible = isToolbarVisible;
        this.initialize();
    }

    private void initialize() {
        if (this.isToolbarVisible) {
            this.add((Component)this.getNorthPanel(), "North");
        }
        this.holderPanel.add((Component)this.getSketchPanel(), this.getSketchPanel().getName());
    }

    private JPanel getSketchPanel() {
        if (this.sketchPanel == null) {
            this.sketchPanel = new JPanel();
            this.sketchPanel.setLayout(new BorderLayout());
            this.sketchPanel.setName("sketchPanel");
            this.sketchPanel.add((Component)this.sketch, "Center");
            this.sketch.setMol(new Molecule());
            if (this.isToolbarVisible) {
                this.sketchPanel.add((Component)this.getButtonHolderPanel(), "South");
            }
        }
        return this.sketchPanel;
    }

    private JPanel getButtonHolderPanel() {
        if (this.buttonHolderPanel == null) {
            this.buttonHolderPanel = new JPanel();
            this.buttonHolderPanel.setOpaque(false);
            this.buttonHolderPanel.setLayout(new BoxLayout(this.buttonHolderPanel, 0));
            this.applyEditButton = new JButton(this.APPLY_MOLECULE_EDIT_ACTION);
            this.applyEditButton.setText("Apply");
            this.cancelEditButton = new JButton(this.CANCEL_MOLECULE_EDIT_ACTION);
            this.cancelEditButton.setText("Cancel");
            this.buttonHolderPanel.add(this.applyEditButton);
            this.buttonHolderPanel.add(this.cancelEditButton);
        }
        return this.buttonHolderPanel;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            this.northPanel.setLayout(new BorderLayout());
            this.northPanel.add((Component)this.getToolBar(), "North");
            this.northPanel.add((Component)this.getTopPanel(), "Center");
        }
        return this.northPanel;
    }

    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getAddMoleculeButton());
            this.toolBar.add(this.getRemoveMoleculeButton());
            this.toolBar.add(this.getEditMoleculeButton());
            this.toolBar.setFloatable(false);
            this.toolBar.setRollover(true);
            this.toolBar.setBorder(null);
        }
        return this.toolBar;
    }

    @Override
    protected void showEditor() {
        ((CardLayout)this.holderPanel.getLayout()).show(this.holderPanel, this.sketchPanel.getName());
        if (this.isToolbarVisible) {
            this.getNorthPanel().setVisible(false);
        }
        if (this.notifier != null) {
            this.notifier.firePropertyChange("Alchemist_Enable", true, false);
        }
        this.setEnabled(false);
    }

    @Override
    protected void hideEditor() {
        ((CardLayout)this.holderPanel.getLayout()).show(this.holderPanel, this.view.getName());
        if (this.isToolbarVisible) {
            this.getNorthPanel().setVisible(true);
        }
        if (this.notifier != null) {
            this.notifier.firePropertyChange("Alchemist_Enable", false, true);
        }
        this.setEnabled(true);
    }

    private JButton getAddMoleculeButton() {
        if (this.addMoleculeButton == null) {
            this.addMoleculeButton = new JButton(this.ADD_MOLECULE_ACTION);
            this.ADD_MOLECULE_ACTION.putValue("ShortDescription", "Add a molecule to the list");
        }
        return this.addMoleculeButton;
    }

    private JButton getEditMoleculeButton() {
        if (this.editMoleculeButton == null) {
            this.editMoleculeButton = new JButton(this.EDIT_MOLECULE_ACTION);
            this.EDIT_MOLECULE_ACTION.putValue("ShortDescription", "Edit the selected molecule");
        }
        return this.editMoleculeButton;
    }

    private JButton getRemoveMoleculeButton() {
        if (this.removeMoleculeButton == null) {
            this.removeMoleculeButton = new JButton(this.REMOVE_MOLECULE_ACTION);
            this.REMOVE_MOLECULE_ACTION.putValue("ShortDescription", "Removes the selected molecule from the list");
        }
        return this.removeMoleculeButton;
    }

    @Override
    public void close() {
        try {
            this.sketchUserSettings.save("Save");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }
}

