/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.marvin.MolPrinter;
import chemaxon.struc.Molecule;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AlchemistMoleculePainter {
    public static final int DEFAULT_DISPLAY_OPTIONS;
    public static final int HIDE_IMPLICIT_HYDROGENS;
    public static final int EXTRA_DISPLAY_OPTIONS_NOT_SET = -1;
    public static final int DISPLAY_OPTIONS_NOT_SET = -2;

    public static void drawMolecule(Molecule molecule, Graphics g) {
        AlchemistMoleculePainter.drawMolecule(0, 0, molecule, g);
    }

    public static void drawMolecule(int x, int y, Molecule molecule, Graphics g) {
        AlchemistMoleculePainter.drawMolecule(x, y, molecule, g, 200, 200);
    }

    public static void drawMolecule(Molecule molecule, Graphics g, int width, int height) {
        AlchemistMoleculePainter.drawMolecule(0, 0, molecule, g, width, height);
    }

    public static void drawMolecule(Molecule molecule, Graphics g, int width, int height, int dispOpts, int dispOptsExt) {
        AlchemistMoleculePainter.drawMolecule(0, 0, molecule, g, width, height, dispOpts, dispOptsExt);
    }

    public static void drawMolecule(int x, int y, Molecule molecule, Graphics g, int width, int height) {
        AlchemistMoleculePainter.drawMolecule(x, y, molecule, g, new Dimension(width, height));
    }

    public static void drawMolecule(int x, int y, Molecule molecule, Graphics g, int width, int height, int dispOpts, int dispOptsExt) {
        AlchemistMoleculePainter.drawMolecule(x, y, molecule, g, new Dimension(width, height), dispOpts, dispOptsExt);
    }

    public static void drawMolecule(Molecule molecule, Graphics g, Dimension size) {
        AlchemistMoleculePainter.drawMolecule(0, 0, molecule, g, size);
    }

    public static void drawMolecule(Molecule molecule, Graphics g, Dimension size, int dispOpts) {
        AlchemistMoleculePainter.drawMolecule(0, 0, molecule, g, size, dispOpts);
    }

    public static void drawMolecule(Molecule molecule, Graphics g, Dimension size, int dispOpts, int dispOptsExt) {
        AlchemistMoleculePainter.drawMolecule(0, 0, molecule, g, size, dispOpts, dispOptsExt);
    }

    public static void drawMolecule(int x, int y, Molecule molecule, Graphics g, Dimension size) {
        AlchemistMoleculePainter.drawMolecule(x, y, molecule, g, size, DEFAULT_DISPLAY_OPTIONS);
    }

    public static void drawMolecule(int x, int y, Molecule molecule, Graphics g, Dimension size, int dispOpts) {
        AlchemistMoleculePainter.drawMolecule(molecule, g, size, dispOpts, -1);
    }

    public static void drawMolecule(int x, int y, Molecule molecule, Graphics g, Dimension size, int dispOpts, int dispOptsExt) {
        Molecule mol = molecule;
        if (mol.getDim() == 0) {
            mol = molecule.cloneMolecule();
            mol.clean(2, null);
        }
        MolPrinter mPrinter = new MolPrinter(mol);
        mPrinter.setScale(mPrinter.maxScale(size));
        if (dispOpts != -2) {
            mPrinter.setDispopts(dispOpts);
        } else {
            mPrinter.setDispopts(DEFAULT_DISPLAY_OPTIONS);
        }
        if (dispOptsExt != -1) {
            mPrinter.setDispoptsExt(dispOptsExt);
        }
        AlchemistMoleculePainter.drawMolecule(x, y, mPrinter, g, size);
    }

    public static void drawMolecule(int x, int y, MolPrinter printer, Graphics g, Dimension size) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(x, y);
        printer.paint(g2, new Rectangle(size));
        g2.dispose();
    }

    static {
        MolPrinter printer = new MolPrinter();
        printer.setImplicitH("hetero");
        printer.setDispopts(printer.getDispopts() | 0x1000);
        DEFAULT_DISPLAY_OPTIONS = printer.getDispopts();
        printer = new MolPrinter();
        printer.setImplicitH("off");
        printer.setDispopts(printer.getDispopts() | 0x1000);
        HIDE_IMPLICIT_HYDROGENS = printer.getDispopts();
    }
}

