/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AlchemistSpinBox
extends JPanel {
    private static final long serialVersionUID = 6551641768720523287L;
    public static final String PROPERTY_KEY_VALUE = "AlchemistSpinBox_Value";
    private int value = 0;
    private int minimum = 0;
    private int maximum = 0;
    private int direction = 0;
    private int repeatDelay = 500;
    private JTextField textField = null;
    private JPanel incButton = null;
    private JPanel decButton = null;
    private final Timer repeatTimer = new Timer(this.repeatDelay, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlchemistSpinBox.this.direction < 0) {
                AlchemistSpinBox.this.DEC_ACTION.actionPerformed(null);
                if (AlchemistSpinBox.this.value <= AlchemistSpinBox.this.minimum) {
                    AlchemistSpinBox.this.repeatTimer.stop();
                }
            } else {
                AlchemistSpinBox.this.INC_ACTION.actionPerformed(null);
                if (AlchemistSpinBox.this.value >= AlchemistSpinBox.this.maximum) {
                    AlchemistSpinBox.this.repeatTimer.stop();
                }
            }
        }
    });
    private final AbstractAction INC_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6773561200313180736L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int old = AlchemistSpinBox.this.value;
            if (AlchemistSpinBox.this.value < AlchemistSpinBox.this.maximum) {
                AlchemistSpinBox.this.value++;
            }
            if (old != AlchemistSpinBox.this.value) {
                AlchemistSpinBox.this.getTextField().setText(String.valueOf(AlchemistSpinBox.this.value));
                AlchemistSpinBox.this.firePropertyChange(AlchemistSpinBox.PROPERTY_KEY_VALUE, old, AlchemistSpinBox.this.value);
            }
            AlchemistSpinBox.this.INC_ACTION.setEnabled(AlchemistSpinBox.this.value < AlchemistSpinBox.this.maximum);
            AlchemistSpinBox.this.DEC_ACTION.setEnabled(AlchemistSpinBox.this.value > AlchemistSpinBox.this.minimum);
            AlchemistSpinBox.this.incButton.repaint();
            AlchemistSpinBox.this.decButton.repaint();
        }
    };
    private final AbstractAction DEC_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 637921909495969893L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int old = AlchemistSpinBox.this.value;
            if (AlchemistSpinBox.this.value > AlchemistSpinBox.this.minimum) {
                AlchemistSpinBox.this.value--;
            }
            if (old != AlchemistSpinBox.this.value) {
                AlchemistSpinBox.this.getTextField().setText(String.valueOf(AlchemistSpinBox.this.value));
                AlchemistSpinBox.this.firePropertyChange(AlchemistSpinBox.PROPERTY_KEY_VALUE, old, AlchemistSpinBox.this.value);
            }
            AlchemistSpinBox.this.INC_ACTION.setEnabled(AlchemistSpinBox.this.value < AlchemistSpinBox.this.maximum);
            AlchemistSpinBox.this.DEC_ACTION.setEnabled(AlchemistSpinBox.this.value > AlchemistSpinBox.this.minimum);
            AlchemistSpinBox.this.incButton.repaint();
            AlchemistSpinBox.this.decButton.repaint();
        }
    };

    public AlchemistSpinBox(int initial, int minimum, int maximum) {
        if (initial < minimum || initial > maximum || minimum > maximum) {
            throw new IllegalArgumentException();
        }
        this.value = initial;
        this.minimum = minimum;
        this.maximum = maximum;
        this.initialize();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < this.minimum || value > this.maximum) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        this.getTextField().setText(String.valueOf(this.value));
        this.INC_ACTION.setEnabled(value < this.maximum);
        this.DEC_ACTION.setEnabled(value > this.minimum);
        this.incButton.repaint();
        this.decButton.repaint();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        if (minimum > this.maximum) {
            throw new IllegalArgumentException();
        }
        this.minimum = minimum;
        if (this.value < minimum) {
            this.setValue(minimum);
        }
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        if (this.minimum > maximum) {
            throw new IllegalArgumentException();
        }
        this.maximum = maximum;
        if (this.value > maximum) {
            this.setValue(maximum);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints textConstraint = new GridBagConstraints();
        textConstraint.gridx = 0;
        textConstraint.gridy = 0;
        textConstraint.gridheight = 2;
        textConstraint.weightx = 1.0;
        textConstraint.fill = 2;
        GridBagConstraints incConstraint = new GridBagConstraints();
        incConstraint.gridx = 1;
        incConstraint.gridy = 0;
        GridBagConstraints decConstraint = new GridBagConstraints();
        decConstraint.gridx = 1;
        decConstraint.gridy = 1;
        this.add((Component)this.getTextField(), textConstraint);
        this.add((Component)this.getIncButton(), incConstraint);
        this.add((Component)this.getDecButton(), decConstraint);
        this.INC_ACTION.setEnabled(this.value < this.maximum);
        this.DEC_ACTION.setEnabled(this.value > this.minimum);
    }

    private int getMaxWidth(FontMetrics fontMet) {
        int[] widths = fontMet.getWidths();
        int max = 0;
        for (int i = 48; i < 57; ++i) {
            if (max >= widths[i]) continue;
            max = widths[i];
        }
        if (this.minimum < 0) {
            max *= Math.max(String.valueOf(this.maximum).length(), String.valueOf(this.minimum * -1).length());
            max += widths[45];
        } else {
            max *= Math.max(String.valueOf(this.maximum).length(), String.valueOf(this.minimum).length());
        }
        return max;
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.setText(String.valueOf(this.value));
            this.textField.setHorizontalAlignment(4);
            int width = this.getMaxWidth(this.textField.getFontMetrics(this.textField.getFont())) + this.textField.getInsets().left + this.textField.getInsets().right;
            this.textField.setPreferredSize(new Dimension(width, this.textField.getPreferredSize().height));
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    try {
                        int val = Integer.parseInt(AlchemistSpinBox.this.textField.getText());
                        if (val >= AlchemistSpinBox.this.minimum && val <= AlchemistSpinBox.this.maximum) {
                            AlchemistSpinBox.this.value = val;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }
            });
            this.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    AlchemistSpinBox.this.textField.setText(String.valueOf(AlchemistSpinBox.this.value));
                }
            });
        }
        return this.textField;
    }

    private JPanel getIncButton() {
        if (this.incButton == null) {
            this.incButton = new JPanel(){
                private static final long serialVersionUID = -9137456612493816450L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (AlchemistSpinBox.this.INC_ACTION.isEnabled()) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(AlchemistSpinBox.this.incButton.getForeground());
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.fillPolygon(new int[]{5, 2, 8}, new int[]{2, 8, 8}, 3);
                        g2.dispose();
                    }
                }
            };
            this.incButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AlchemistSpinBox.this.INC_ACTION.actionPerformed(null);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    AlchemistSpinBox.this.direction = 1;
                    AlchemistSpinBox.this.repeatTimer.start();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AlchemistSpinBox.this.repeatTimer.stop();
                }
            });
            this.incButton.setPreferredSize(new Dimension(10, 10));
        }
        return this.incButton;
    }

    private JPanel getDecButton() {
        if (this.decButton == null) {
            this.decButton = new JPanel(){
                private static final long serialVersionUID = -9044238840378378672L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (AlchemistSpinBox.this.DEC_ACTION.isEnabled()) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(AlchemistSpinBox.this.decButton.getForeground());
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.fillPolygon(new int[]{5, 2, 8}, new int[]{8, 2, 2}, 3);
                        g2.dispose();
                    }
                }
            };
            this.decButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AlchemistSpinBox.this.DEC_ACTION.actionPerformed(null);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    AlchemistSpinBox.this.direction = -1;
                    AlchemistSpinBox.this.repeatTimer.start();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AlchemistSpinBox.this.repeatTimer.stop();
                }
            });
            this.decButton.setPreferredSize(new Dimension(10, 10));
        }
        return this.decButton;
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setRepeatDelay(int repeatDelay) {
        this.repeatDelay = repeatDelay;
    }

    @Override
    public void setToolTipText(String text) {
        this.getTextField().setToolTipText(text);
    }

    public void setIncToolTipText(String text) {
        this.getIncButton().setToolTipText(text);
    }

    public void setDecToolTipText(String text) {
        this.getDecButton().setToolTipText(text);
    }
}

