/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class AlchemistWaitPanel
extends JPanel {
    private static final long serialVersionUID = -7381714533289285787L;
    public static final int FLAT_BAR = 0;
    public static final int SHADED_BAR = 1;
    public static final int EDGED_BAR = 2;
    public static final int BEAM_BAR = 3;
    public static final int BRICK_BAR = 4;
    private static final float[] wheelThetas = new float[]{0.0f, 0.5235988f, 1.0471976f, 1.5707964f, 2.0943952f, 2.6179938f, (float)Math.PI, 3.6651914f, 4.1887903f, 4.712389f, 5.2359877f, 5.7595863f};
    private int[] wheelColors = new int[]{1068807348, 0x4FB4B4B4, 1605678260, 1874113716, 2142549172, -1883982668, -1615547212, -1347111756, -1078676300, -810240844, -541805388, -273369932};
    private static final int[] BAR_GAUGE_3D_EFFECT_COLORS = new int[]{0, 0x32000000};
    private static final int[] BAR_GAUGE_BEAM_EFFECT_COLOR = new int[]{0, 0x46000000, -1778384896};
    private static final int[] BAR_PULSE_COLOR = new int[]{0xFFFFFF, -922746881};
    private int barBackgroundColor = 0;
    private final int[] barGaugeColors = new int[]{-8355712, -4144960};
    private int maxWheelSize = 150;
    private int minWheelSize = 25;
    private int barHeight = 24;
    private int wheelSize = 0;
    private int candybarStripeCount = 0;
    private int candyOffset = 0;
    private int pulseOffset = 0;
    private float barVAlgin = 0.5f;
    private boolean skipWheel = true;
    private GradientPaint barGaugeShadePaint = new GradientPaint(0.0f, 0.0f, new Color(BAR_GAUGE_3D_EFFECT_COLORS[0], true), 0.0f, this.barHeight, new Color(BAR_GAUGE_3D_EFFECT_COLORS[1], true));
    private GradientPaint barGaugeBeam1Paint = new GradientPaint(0.0f, 0.0f, new Color(BAR_GAUGE_BEAM_EFFECT_COLOR[0], true), 0.0f, this.barHeight / 2, new Color(BAR_GAUGE_BEAM_EFFECT_COLOR[1], true));
    private GradientPaint barGaugeBeam2Paint = new GradientPaint(0.0f, this.barHeight / 2, new Color(BAR_GAUGE_BEAM_EFFECT_COLOR[2], true), 0.0f, this.barHeight, new Color(BAR_GAUGE_BEAM_EFFECT_COLOR[1], true));
    private GradientPaint barGaugePaint = new GradientPaint(0.0f, 0.0f, new Color(this.barGaugeColors[0], true), 0.0f, 0.0f, new Color(this.barGaugeColors[1], true));
    private GradientPaint barPulse1Paint = new GradientPaint(0.0f, 0.0f, new Color(BAR_PULSE_COLOR[0], true), this.barHeight / 2, 0.0f, new Color(BAR_PULSE_COLOR[1], true));
    private GradientPaint barPulse2Paint = new GradientPaint(this.barHeight / 2, 0.0f, new Color(BAR_PULSE_COLOR[1], true), this.barHeight, 0.0f, new Color(BAR_PULSE_COLOR[0], true));
    private final Rectangle barRect = new Rectangle(0, 0, 0, 0);
    private final Point wheelTopLeft = new Point(0, 0);
    private Image backgroundImage = null;
    private boolean wheelVisible;
    private boolean barVisible;
    private boolean barPulsing;
    private int barStyle = 1;
    private float progress = -1.0f;
    private boolean timerStatusBeforeHide = true;
    private static final int REFRESH_TIMER_INTERVAL = 50;
    private final Timer animationTimer = new Timer(50, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlchemistWaitPanel.this.wheelVisible) {
                AlchemistWaitPanel.this.skipWheel = !AlchemistWaitPanel.this.skipWheel;
                if (AlchemistWaitPanel.this.skipWheel) {
                    AlchemistWaitPanel.this.recalculateWheel();
                }
            }
            if (AlchemistWaitPanel.this.barVisible && AlchemistWaitPanel.this.progress == -1.0f) {
                AlchemistWaitPanel.this.recalculateCandy();
            }
            if (AlchemistWaitPanel.this.barVisible && AlchemistWaitPanel.this.barPulsing) {
                AlchemistWaitPanel.this.recalculatePulse();
            }
            AlchemistWaitPanel.this.repaint();
        }
    });

    public AlchemistWaitPanel() {
        this(false, true);
    }

    public AlchemistWaitPanel(boolean barVisible, boolean wheelVisible) {
        this.wheelVisible = wheelVisible;
        this.barVisible = barVisible;
        this.barPulsing = false;
        if (!barVisible && !wheelVisible) {
            this.timerStatusBeforeHide = false;
        }
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (AlchemistWaitPanel.this.isAnimating()) {
                    AlchemistWaitPanel.this.setPaused(true);
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                AlchemistWaitPanel.this.repositionDrawings();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                AlchemistWaitPanel.this.setPaused(false);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                AlchemistWaitPanel.this.setPaused(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (AlchemistWaitPanel.this.isAnimating()) {
                    AlchemistWaitPanel.this.setPaused(true);
                }
            }
        });
        this.repositionDrawings();
    }

    public void start() {
        this.animationTimer.start();
    }

    public void stop() {
        this.animationTimer.stop();
    }

    public boolean isAnimating() {
        return this.animationTimer.isRunning();
    }

    private void setPaused(boolean pause) {
        if (pause) {
            this.timerStatusBeforeHide = this.animationTimer.isRunning();
            this.animationTimer.stop();
        } else if (this.timerStatusBeforeHide) {
            this.animationTimer.restart();
        }
    }

    private void recalculateWheel() {
        int tmp = this.wheelColors[this.wheelColors.length - 1];
        for (int i = this.wheelColors.length - 1; i > 0; --i) {
            this.wheelColors[i] = this.wheelColors[i - 1];
        }
        this.wheelColors[0] = tmp;
        this.repaint();
    }

    private void recalculateCandy() {
        ++this.candyOffset;
        this.candyOffset %= 2 * this.barHeight;
        this.repaint();
    }

    private void recalculatePulse() {
        this.pulseOffset += this.barRect.width / 16;
        this.pulseOffset %= 4 * this.barRect.width;
        this.repaint();
    }

    private void repositionDrawings() {
        float bound = Math.min(this.getWidth(), this.getHeight());
        Point center = new Point(this.getWidth() / 2, this.getHeight() / 2);
        this.wheelSize = Math.min(this.maxWheelSize, Math.max(this.minWheelSize, (int)(bound * 0.75f)));
        this.wheelTopLeft.x = center.x - this.wheelSize / 2;
        this.wheelTopLeft.y = center.y - this.wheelSize / 2;
        this.barRect.height = this.barHeight;
        this.barRect.width = (int)((float)this.getWidth() * 0.75f);
        this.barRect.x = center.x - this.barRect.width / 2;
        this.barRect.y = this.barVAlgin == 0.0f ? this.barHeight : (this.barVAlgin == 1.0f ? this.getHeight() - this.barRect.height * 2 : center.y - this.barRect.height / 2);
        this.barGaugePaint = new GradientPaint(0.0f, 0.0f, new Color(this.barGaugeColors[0], true), this.barRect.width, 0.0f, new Color(this.barGaugeColors[1], true));
        this.candybarStripeCount = (int)Math.ceil((float)this.barRect.width / (float)this.barRect.height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.backgroundImage != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.drawImage(this.backgroundImage, 0, 0, null);
            g2.dispose();
        }
        Graphics2D gWheel = null;
        Graphics gBar = null;
        if (this.isAnimating() || !this.barPulsing && this.barVisible) {
            if (this.wheelVisible) {
                gWheel = (Graphics2D)g.create();
                gWheel.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gWheel.translate(this.wheelTopLeft.x, this.wheelTopLeft.y);
            }
            if (this.barVisible) {
                gBar = (Graphics2D)g.create();
                ((Graphics2D)gBar).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)gBar).translate(this.barRect.x, this.barRect.y);
            }
        }
        if (gWheel != null) {
            for (int i = 0; i < 12; ++i) {
                Graphics2D gTick = (Graphics2D)gWheel.create();
                gTick.rotate(wheelThetas[i], this.wheelSize / 2, this.wheelSize / 2);
                gTick.setColor(new Color(this.wheelColors[i % this.wheelColors.length], true));
                gTick.fillRoundRect(this.wheelSize / 2 - this.wheelSize / 32, 0, this.wheelSize / 16, this.wheelSize / 4, this.wheelSize / 16, this.wheelSize / 16);
                gTick.dispose();
            }
            gWheel.dispose();
        }
        if (gBar != null) {
            Graphics2D gGauge;
            Graphics2D gBarBackground = (Graphics2D)gBar.create();
            gBarBackground.setColor(new Color(this.barBackgroundColor, true));
            gBarBackground.fillRect(0, 0, this.barRect.width, this.barRect.height);
            gBarBackground.dispose();
            if (this.progress >= 0.0f && this.progress <= 1.0f) {
                if (this.barStyle == 4) {
                    gGauge = (Graphics2D)gBar.create();
                    gGauge.clipRect(0, 0, this.barRect.width, this.barRect.height);
                    int length = (int)((float)(this.candybarStripeCount + 1) * this.progress);
                    for (int i = 0; i < length; ++i) {
                        Graphics2D gBrick = (Graphics2D)gGauge.create();
                        gBrick.setPaint(this.barGaugePaint);
                        gBrick.fillRect(i * (this.barRect.height - 2) + 3, 3, this.barRect.height - 5, this.barRect.height - 5);
                        gBrick.dispose();
                    }
                    gGauge.dispose();
                } else {
                    gGauge = (Graphics2D)gBar.create();
                    gGauge.setPaint(this.barGaugePaint);
                    gGauge.fillRect(0, 0, (int)((float)this.barRect.width * this.progress), this.barRect.height);
                    gGauge.dispose();
                }
                if (this.barPulsing && this.pulseOffset - this.barRect.width + this.barRect.height > 0 && this.pulseOffset - this.barRect.width < this.barRect.width) {
                    Graphics2D gPulse = (Graphics2D)gBar.create();
                    gPulse.clipRect(0, 0, (int)((float)this.barRect.width * this.progress), this.barRect.height);
                    gPulse.translate(this.pulseOffset - this.barRect.width, 0);
                    gPulse.setPaint(this.barPulse1Paint);
                    gPulse.fillRect(0, 0, this.barRect.height / 2, this.barRect.height);
                    gPulse.setPaint(this.barPulse2Paint);
                    gPulse.fillRect(this.barRect.height / 2, 0, this.barRect.height / 2, this.barRect.height);
                    gPulse.dispose();
                }
            } else {
                gGauge = (Graphics2D)gBar.create();
                gGauge.clipRect(0, 0, this.barRect.width, this.barRect.height);
                for (int i = -1; i < this.candybarStripeCount + 1; i += 2) {
                    Graphics2D gStripe = (Graphics2D)gGauge.create();
                    gStripe.shear(-0.5, 0.0);
                    gStripe.setPaint(this.barGaugePaint);
                    gStripe.fillRect(i * this.barRect.height + this.candyOffset, 0, this.barRect.height, this.barRect.height);
                    gStripe.dispose();
                }
                gGauge.dispose();
            }
            Graphics2D gBarEffect = (Graphics2D)gBar.create();
            switch (this.barStyle) {
                case 1: {
                    gBarEffect.setPaint(this.barGaugeShadePaint);
                    gBarEffect.fillRect(0, 0, this.barRect.width, this.barRect.height);
                    break;
                }
                case 3: {
                    gBarEffect.setPaint(this.barGaugeBeam1Paint);
                    gBarEffect.fillRect(0, 0, this.barRect.width, this.barRect.height / 2);
                    gBarEffect.setPaint(this.barGaugeBeam2Paint);
                    gBarEffect.fillRect(0, this.barRect.height / 2, this.barRect.width, this.barRect.height / 2);
                    break;
                }
                case 2: {
                    if (this.progress == -1.0f) break;
                    gBarEffect.setColor(new Color(BAR_GAUGE_3D_EFFECT_COLORS[0], true));
                    gBarEffect.fillRect(0, 0, this.barRect.width, this.barRect.height);
                    gBarEffect.setColor(new Color(BAR_GAUGE_3D_EFFECT_COLORS[1], true));
                    gBarEffect.fillRect(2, 2, (int)((float)this.barRect.width * this.progress) - 3, this.barRect.height - 3);
                }
            }
            gBarEffect.dispose();
            gBar.drawRect(0, 0, this.barRect.width, this.barRect.height);
            gBar.dispose();
        }
    }

    public int getMaxWheelSize() {
        return this.maxWheelSize;
    }

    public void setMaxWheelSize(int maxWeelSize) {
        this.maxWheelSize = maxWeelSize;
        this.repositionDrawings();
    }

    public int getMinWheelSize() {
        return this.minWheelSize;
    }

    public void setMinWheelSize(int minWheelSize) {
        this.minWheelSize = minWheelSize;
        this.repositionDrawings();
    }

    public boolean isWheelVisible() {
        return this.wheelVisible;
    }

    public void setWheelVisible(boolean visible) {
        this.wheelVisible = visible;
        this.repositionDrawings();
    }

    public boolean isBarVisible() {
        return this.barVisible;
    }

    public void setBarVisible(boolean visible) {
        this.barVisible = visible;
        this.repositionDrawings();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.repaint();
    }

    public boolean isBarPulsing() {
        return this.barPulsing;
    }

    public void setBarPulsing(boolean barPulsing) {
        this.barPulsing = barPulsing;
    }

    public Color[] getWheelColors() {
        Color[] ret = new Color[this.wheelColors.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Color(this.wheelColors[i], true);
        }
        return ret;
    }

    public void setWheelColors(Color[] wheelColors) {
        this.wheelColors = new int[wheelColors.length];
        for (int i = 0; i < wheelColors.length; ++i) {
            this.wheelColors[i] = wheelColors[i].getRGB();
        }
        this.repaint();
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.repaint();
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
        this.barGaugeShadePaint = new GradientPaint(0.0f, 0.0f, new Color(BAR_GAUGE_3D_EFFECT_COLORS[0], true), 0.0f, barHeight, new Color(BAR_GAUGE_3D_EFFECT_COLORS[1], true));
        this.barGaugeBeam1Paint = new GradientPaint(0.0f, 0.0f, new Color(BAR_GAUGE_BEAM_EFFECT_COLOR[0], true), 0.0f, barHeight / 2, new Color(BAR_GAUGE_BEAM_EFFECT_COLOR[1], true));
        this.barGaugeBeam2Paint = new GradientPaint(0.0f, barHeight / 2, new Color(BAR_GAUGE_BEAM_EFFECT_COLOR[2], true), 0.0f, barHeight, new Color(BAR_GAUGE_BEAM_EFFECT_COLOR[1], true));
        this.barPulse1Paint = new GradientPaint(0.0f, 0.0f, new Color(BAR_PULSE_COLOR[0], true), barHeight / 2, 0.0f, new Color(BAR_PULSE_COLOR[1], true));
        this.barPulse2Paint = new GradientPaint(barHeight / 2, 0.0f, new Color(BAR_PULSE_COLOR[1], true), barHeight, 0.0f, new Color(BAR_PULSE_COLOR[0], true));
        this.repositionDrawings();
    }

    public Color getBarBackgroundColor() {
        return new Color(this.barBackgroundColor, true);
    }

    public void setBarBackgroundColor(Color barBackgroundColor) {
        this.barBackgroundColor = barBackgroundColor.getRGB();
        this.repaint();
    }

    public void setBarColor(Color color) {
        this.setBarColor(color, color);
    }

    public void setBarColor(Color lowColor, Color highColor) {
        this.barGaugeColors[0] = lowColor.getRGB();
        this.barGaugeColors[1] = highColor.getRGB();
        this.repaint();
    }

    public Color getBarLowColor() {
        return new Color(this.barGaugeColors[0], true);
    }

    public Color getBarHighColor() {
        return new Color(this.barGaugeColors[1], true);
    }

    public int getBarStyle() {
        return this.barStyle;
    }

    public void setBarStyle(int barStyle) {
        this.barStyle = barStyle;
        this.repaint();
    }

    public void setBarVAlign(float align) {
        this.barVAlgin = align;
    }

    public float getBarVAlign() {
        return this.barVAlgin;
    }
}

