/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class MoleculeListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final Molecule EMPTY = new Molecule();
    private static final Color FOCUS_SELECTION_COLOR = new Color(838861055, true);
    private boolean selected = false;
    private boolean hasFocus = false;
    private Molecule molecule = EMPTY;
    private final JList assignedList;
    private int markWidth = 20;
    private static final long serialVersionUID = -1798448947968101596L;

    public MoleculeListCellRenderer(JList list) {
        this.assignedList = list;
        this.assignedList.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Rectangle rect = MoleculeListCellRenderer.this.assignedList.getVisibleRect();
                Dimension dim = new Dimension(rect.width - rect.x, rect.height - rect.y);
                MoleculeListCellRenderer.this.assignedList.setFixedCellWidth(dim.width);
                MoleculeListCellRenderer.this.assignedList.setFixedCellHeight(dim.height);
                MoleculeListCellRenderer.this.markWidth = Math.min(dim.width, dim.height) / 4;
            }
        });
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.molecule = value instanceof Molecule ? (Molecule)value : EMPTY;
        this.selected = isSelected;
        this.hasFocus = cellHasFocus;
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        AlchemistMoleculePainter.drawMolecule(this.molecule, g, new Dimension(this.assignedList.getFixedCellWidth(), this.assignedList.getFixedCellHeight()));
        if (this.selected) {
            int leftBegin = 0;
            int leftEnd = this.markWidth;
            int rightEnd = this.getWidth() - this.markWidth;
            int rightBegin = this.getWidth();
            int topBegin = 0;
            int topEnd = this.markWidth;
            int bottomBegin = this.getHeight();
            int bottomEnd = this.getHeight() - this.markWidth;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(Color.BLUE);
            g2.fillRect(leftBegin, topBegin, leftEnd, topBegin + 2);
            g2.fillRect(leftBegin, topBegin, leftBegin + 2, topEnd);
            g2.fillRect(leftBegin, bottomEnd, leftBegin + 2, bottomBegin);
            g2.fillRect(leftBegin, bottomBegin - 2, leftEnd, bottomBegin);
            g2.fillRect(rightEnd, topBegin, rightBegin, topBegin + 2);
            g2.fillRect(rightBegin - 2, topBegin, rightBegin, topEnd);
            g2.fillRect(rightEnd, bottomBegin - 2, rightBegin, bottomBegin);
            g2.fillRect(rightBegin - 2, bottomEnd, rightBegin, bottomBegin);
            g2.dispose();
            if (this.hasFocus) {
                Graphics2D g3 = (Graphics2D)g.create();
                g3.setColor(FOCUS_SELECTION_COLOR);
                g3.fillRect(0, 0, this.getWidth(), this.getHeight());
                g3.dispose();
            }
        }
    }
}

