/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ScrollableCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -6001312178682303639L;
    private static final Font VALUE_FONT = new Font("MS Sans Serif", 0, 12);
    private final JTextArea textArea = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane(this.textArea);

    public ScrollableCellEditor() {
        super(new JTextField());
        this.textArea.setFont(VALUE_FONT);
        this.textArea.getActionMap().put("stopEditing", new AbstractAction("stopEditing"){
            private static final long serialVersionUID = 955799096918931771L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollableCellEditor.this.stopCellEditing();
            }
        });
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.editorComponent = this.scrollPane;
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = -5393029065355998792L;

            @Override
            public void setValue(Object value) {
                ScrollableCellEditor.this.textArea.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return ScrollableCellEditor.this.textArea.getText();
            }
        };
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.scrollPane.setSize(table.getColumn(table.getColumnName(column)).getWidth(), 100);
        table.setRowHeight(row, 100);
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }
}

