/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AbstractAlchemistMoleculeView;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;

public class SimpleAlchemistMoleculeView
extends AbstractAlchemistMoleculeView {
    private static final long serialVersionUID = 6429374294058734448L;
    private boolean useCustomLabel = false;
    private final Map<Integer, String> customLabels = new HashMap<Integer, String>();

    public void setUseCustomLabel(boolean useCustomLabel) {
        this.useCustomLabel = useCustomLabel;
        this.view.putClientProperty("MoleculeTableCellRenderer_IsCustomLabelVisible", useCustomLabel);
    }

    public boolean isUseCustomLabel() {
        return this.useCustomLabel;
    }

    public SimpleAlchemistMoleculeView(int rowNum, int colNum) {
        super(rowNum, colNum);
        this.initialize();
    }

    public SimpleAlchemistMoleculeView(int rowNum, int colNum, boolean isMoleculeLabelVisible) {
        super(rowNum, colNum, isMoleculeLabelVisible);
        this.initialize();
    }

    public SimpleAlchemistMoleculeView(int rowNum, int colNum, boolean isMoleculeLabelVisible, boolean isUseCustomLabel) {
        super(rowNum, colNum, isUseCustomLabel);
        this.useCustomLabel = isUseCustomLabel;
        this.initialize();
    }

    public void setMolecule(int rowIndex, int columnIndex, Molecule molecule) {
        if (rowIndex >= 0 && columnIndex >= 0 && rowIndex <= this.rowNum - 1 && columnIndex <= this.colNum - 1) {
            this.dataModel.setValueAt(molecule, rowIndex, columnIndex);
        }
    }

    public Molecule getMolecule(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && columnIndex >= 0 && rowIndex <= this.rowNum - 1 && columnIndex <= this.colNum - 1) {
            if (this.dataModel.getValueAt(rowIndex, columnIndex) instanceof Molecule) {
                return (Molecule)this.dataModel.getValueAt(rowIndex, columnIndex);
            }
            return null;
        }
        return null;
    }

    private void initialize() {
        this.view.setCellSelectionEnabled(false);
        this.view.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.view.putClientProperty("MoleculeTableCellRenderer_IsCustomLabelVisible", this.useCustomLabel);
        this.view.putClientProperty("MoleculeTableCellRenderer_CurrentRowNum", 0);
        this.view.putClientProperty("MoleculeTableCellRenderer_CustomLabels", this.customLabels);
    }

    public void setMoleculeBackground(Color color) {
        this.view.setBackground(color);
    }

    public void setMoleculeLabel(int rowIndex, int columnIndex, String label) {
        if (rowIndex >= 0 && columnIndex >= 0 && rowIndex <= this.rowNum - 1 && columnIndex <= this.colNum - 1) {
            this.customLabels.put(rowIndex * this.colNum + columnIndex, label);
        }
    }
}

